/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.postgres;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.resource.ResourceUpgradeReport;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.core.pluginapi.upgrade.ResourceUpgradeContext;
import org.rhq.core.pluginapi.upgrade.ResourceUpgradeFacet;
import org.rhq.plugins.database.DatabasePluginUtil;
import org.rhq.plugins.postgres.PostgresDatabaseComponent;

public class PostgresTableDiscoveryComponent
implements ResourceDiscoveryComponent<PostgresDatabaseComponent>,
ResourceUpgradeFacet<PostgresDatabaseComponent> {
    private static final Log LOG = LogFactory.getLog(PostgresTableDiscoveryComponent.class);
    private static final String DISCOVERY_QUERY = "select schemaname, relname from pg_stat_user_tables";
    private static final String UPGRADE_QUERY = "select schemaname from pg_stat_user_tables where relname = ?";
    static final String SCHEMA_SEPARATOR = ".";
    @Deprecated
    public static final String TABLE_NAMES_QUERY = "select relname from pg_stat_user_tables";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<PostgresDatabaseComponent> context) throws Exception {
        ResultSet resultSet;
        Statement statement;
        Connection connection;
        HashSet<DiscoveredResourceDetails> discoveredTables;
        block6: {
            PostgresDatabaseComponent postgresDatabaseComponent = (PostgresDatabaseComponent)context.getParentResourceComponent();
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Discovering postgres tables for " + postgresDatabaseComponent.getDatabaseName() + "..."));
            }
            discoveredTables = new HashSet<DiscoveredResourceDetails>();
            connection = null;
            statement = null;
            resultSet = null;
            try {
                connection = postgresDatabaseComponent.getPooledConnectionProvider().getPooledConnection();
                statement = connection.createStatement();
                resultSet = statement.executeQuery(DISCOVERY_QUERY);
                while (resultSet.next()) {
                    String schemaName = resultSet.getString(1);
                    String tableName = resultSet.getString(2);
                    discoveredTables.add(new DiscoveredResourceDetails(context.getResourceType(), this.createNewResourceKey(schemaName, tableName), this.createNewResourceName(schemaName, tableName), null, null, this.createNewPluginConfiguration(schemaName, tableName), null));
                }
                if (!LOG.isTraceEnabled()) break block6;
                LOG.trace((Object)("Found " + discoveredTables.size() + " tables in database " + postgresDatabaseComponent.getDatabaseName()));
            }
            catch (SQLException e) {
                block7: {
                    try {
                        if (!LOG.isDebugEnabled()) break block7;
                        LOG.debug((Object)("Could not find tables in database " + postgresDatabaseComponent.getDatabaseName()), (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        DatabasePluginUtil.safeClose((Connection)connection, statement, resultSet);
                        throw throwable;
                    }
                }
                DatabasePluginUtil.safeClose((Connection)connection, (Statement)statement, resultSet);
            }
        }
        DatabasePluginUtil.safeClose((Connection)connection, (Statement)statement, (ResultSet)resultSet);
        return discoveredTables;
    }

    private String createNewResourceKey(String schemaName, String tableName) {
        return schemaName + SCHEMA_SEPARATOR + tableName;
    }

    private String createNewResourceName(String schemaName, String tableName) {
        return "public".equalsIgnoreCase(schemaName) ? tableName : schemaName + SCHEMA_SEPARATOR + tableName;
    }

    private Configuration createNewPluginConfiguration(String schemaName, String tableName) {
        Configuration newPluginConfig = new Configuration();
        newPluginConfig.setSimpleValue("schemaName", schemaName);
        newPluginConfig.setSimpleValue("tableName", tableName);
        return newPluginConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceUpgradeReport upgrade(ResourceUpgradeContext<PostgresDatabaseComponent> upgradeContext) {
        ResultSet resultSet;
        PreparedStatement statement;
        Connection connection;
        String tableName;
        String schemaName;
        block8: {
            ResourceUpgradeReport resourceUpgradeReport;
            block7: {
                String inventoriedResourceKey = upgradeContext.getResourceKey();
                if (inventoriedResourceKey.contains(SCHEMA_SEPARATOR)) {
                    return null;
                }
                schemaName = null;
                tableName = inventoriedResourceKey;
                connection = null;
                statement = null;
                resultSet = null;
                connection = ((PostgresDatabaseComponent)upgradeContext.getParentResourceComponent()).getPooledConnectionProvider().getPooledConnection();
                statement = connection.prepareStatement(UPGRADE_QUERY);
                statement.setString(1, inventoriedResourceKey);
                resultSet = statement.executeQuery();
                if (resultSet.next()) break block7;
                LOG.warn((Object)("Could not upgrade " + upgradeContext.getResourceDetails() + ". The table was not found in the dabatase"));
                ResourceUpgradeReport resourceUpgradeReport2 = null;
                DatabasePluginUtil.safeClose((Connection)connection, (Statement)statement, (ResultSet)resultSet);
                return resourceUpgradeReport2;
            }
            try {
                schemaName = resultSet.getString(1);
                if (!resultSet.next()) break block8;
                HashSet<String> allSchemas = new HashSet<String>();
                allSchemas.add(schemaName);
                allSchemas.add(resultSet.getString(1));
                while (resultSet.next()) {
                    allSchemas.add(resultSet.getString(1));
                }
                LOG.warn((Object)("Could not upgrade " + upgradeContext.getResourceDetails() + ". The table was found in more than one schema: " + allSchemas));
                resourceUpgradeReport = null;
            }
            catch (SQLException e) {
                block9: {
                    try {
                        if (!LOG.isDebugEnabled()) break block9;
                        LOG.debug((Object)("Exception while upgrading " + upgradeContext.getResourceDetails()), (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        DatabasePluginUtil.safeClose((Connection)connection, statement, resultSet);
                        throw throwable;
                    }
                }
                DatabasePluginUtil.safeClose((Connection)connection, (Statement)statement, resultSet);
            }
            DatabasePluginUtil.safeClose((Connection)connection, (Statement)statement, (ResultSet)resultSet);
            return resourceUpgradeReport;
        }
        DatabasePluginUtil.safeClose((Connection)connection, (Statement)statement, (ResultSet)resultSet);
        ResourceUpgradeReport report = new ResourceUpgradeReport();
        report.setNewResourceKey(this.createNewResourceKey(schemaName, tableName));
        report.setNewPluginConfiguration(this.createNewPluginConfiguration(schemaName, tableName));
        return report;
    }
}

