/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.postgres;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.core.util.jdbc.JDBCUtil;
import org.rhq.plugins.postgres.PostgresDatabaseComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostgresTableDiscoveryComponent
implements ResourceDiscoveryComponent<PostgresDatabaseComponent> {
    private static final Log log = LogFactory.getLog(PostgresTableDiscoveryComponent.class);
    public static final String TABLE_NAMES_QUERY = "select relname from pg_stat_user_tables";

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<PostgresDatabaseComponent> context) throws Exception {
        log.debug((Object)("Discovering postgres tables for " + ((PostgresDatabaseComponent)context.getParentResourceComponent()).getDatabaseName()));
        HashSet<DiscoveredResourceDetails> discoveredTables = new HashSet<DiscoveredResourceDetails>();
        Connection connection = ((PostgresDatabaseComponent)context.getParentResourceComponent()).getConnection();
        if (connection == null) {
            return discoveredTables;
        }
        ResultSet resultSet = null;
        Statement statement = connection.createStatement();
        resultSet = statement.executeQuery(TABLE_NAMES_QUERY);
        while (resultSet.next()) {
            String tableName = resultSet.getString(1);
            DiscoveredResourceDetails service = new DiscoveredResourceDetails(context.getResourceType(), tableName, tableName, null, null, null, null);
            service.getPluginConfiguration().put((Property)new PropertySimple("tableName", (Object)tableName));
            discoveredTables.add(service);
        }
        JDBCUtil.safeClose((Statement)statement, (ResultSet)resultSet);
        return discoveredTables;
    }
}

