/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.navigation.group;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletResponse;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.resource.flyweight.AutoGroupCompositeFlyweight;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.enterprise.gui.navigation.group.ResourceGroupTreeNode;
import org.rhq.enterprise.gui.navigation.group.ResourceGroupTreeStateAdvisor;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.resource.cluster.ClusterKey;
import org.rhq.enterprise.server.resource.cluster.ClusterManagerLocal;
import org.rhq.enterprise.server.resource.group.ResourceGroupManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;
import org.richfaces.component.UITree;
import org.richfaces.component.html.HtmlTree;
import org.richfaces.component.state.TreeState;
import org.richfaces.component.state.TreeStateAdvisor;
import org.richfaces.event.NodeExpandedEvent;
import org.richfaces.event.NodeSelectedEvent;
import org.richfaces.model.TreeRowKey;

/*
 * Exception performing whole class analysis ignored.
 */
public class ResourceGroupTreeStateAdvisor
implements TreeStateAdvisor {
    private CurrentSelection currentSelection;
    private Set<ResourceGroupTreeNode> openNodes = new HashSet();

    private CurrentSelection getCurrentSelection() {
        int selectedGroupId = ResourceGroupTreeStateAdvisor.getSelectedGroupId();
        if (this.currentSelection == null || this.currentSelection.resourceGroup.getId() != selectedGroupId) {
            ResourceGroupManagerLocal groupManager = LookupUtil.getResourceGroupManager();
            this.currentSelection = new CurrentSelection(null);
            this.currentSelection.resourceGroup = groupManager.getResourceGroupById(EnterpriseFacesContextUtility.getSubject(), selectedGroupId, null);
            if (!this.currentSelection.resourceGroup.isVisible()) {
                this.currentSelection.clusterKey = ClusterKey.valueOf((String)this.currentSelection.resourceGroup.getClusterKey());
            }
        }
        return this.currentSelection;
    }

    private static int getSelectedGroupId() {
        String groupId = FacesContextUtility.getOptionalRequestParameter((String)"groupId");
        return Integer.parseInt(groupId);
    }

    public void changeExpandListener(NodeExpandedEvent e) {
        HtmlTree tree = (HtmlTree)e.getComponent();
        TreeState state = (TreeState)tree.getComponentState();
        if (state.getSelectedNode() != null) {
            boolean closingParent = false;
            TreeRowKey key = (TreeRowKey)tree.getRowKey();
            ResourceGroupTreeNode node = (ResourceGroupTreeNode)tree.getRowData((Object)key);
            ResourceGroupTreeNode selectedNode = (ResourceGroupTreeNode)tree.getRowData((Object)state.getSelectedNode());
            for (ResourceGroupTreeNode traverseCheckNode = selectedNode.getParent(); traverseCheckNode != null; traverseCheckNode = traverseCheckNode.getParent()) {
                if (!node.equals((Object)traverseCheckNode)) continue;
                closingParent = true;
                break;
            }
            if (closingParent) {
                if (this.redirectTo(node)) {
                    state.setSelected(key);
                    this.openNodes.remove(node);
                    tree.setBypassUpdates(true);
                } else if (!this.redirectTo(selectedNode)) {
                    FacesContext.getCurrentInstance().addMessage("leftNavTreeForm:leftNavTree", new FacesMessage(FacesMessage.SEVERITY_WARN, "Failed to re-expand node that shouldn't be collapsed.", null));
                }
            } else if (this.openNodes.contains(node)) {
                this.openNodes.remove(node);
            } else {
                this.openNodes.add(node);
            }
        }
    }

    public Boolean adviseNodeOpened(UITree tree) {
        TreeRowKey key = (TreeRowKey)tree.getRowKey();
        if (key != null) {
            boolean setOpenStates;
            ResourceGroupTreeNode node = (ResourceGroupTreeNode)tree.getRowData((Object)key);
            if (node.getParent() == null) {
                return true;
            }
            CurrentSelection currentSelection = this.getCurrentSelection();
            boolean bl = setOpenStates = !tree.isBypassUpdates();
            if (this.preopen(node, currentSelection, setOpenStates)) {
                return true;
            }
            return this.openNodes.contains(node);
        }
        return null;
    }

    private boolean preopen(ResourceGroupTreeNode resourceTreeNode, CurrentSelection currentSelection, boolean setOpenState) {
        ResourceGroup currentGroup = currentSelection.resourceGroup;
        ClusterKey selectedClusterKey = currentSelection.clusterKey;
        boolean ret = false;
        for (ResourceGroupTreeNode child : resourceTreeNode.getChildren()) {
            if (child.getData() instanceof ClusterKey) {
                if (((ClusterKey)child.getData()).equals((Object)selectedClusterKey)) {
                    ret = true;
                    break;
                }
            } else if (child.getData() instanceof ResourceGroup && currentGroup.getId() == ((ResourceGroup)child.getData()).getId()) {
                ret = true;
                break;
            }
            if (!this.preopen(child, currentSelection, setOpenState)) continue;
            ret = true;
            break;
        }
        if (setOpenState && ret) {
            this.openNodes.add(resourceTreeNode);
        }
        return ret;
    }

    public void nodeSelectListener(NodeSelectedEvent e) {
        HtmlTree tree = (HtmlTree)e.getComponent();
        TreeState state = (TreeState)tree.getComponentState();
        TreeRowKey key = (TreeRowKey)tree.getRowKey();
        ResourceGroupTreeNode node = (ResourceGroupTreeNode)tree.getRowData((Object)key);
        if (node != null && !this.redirectTo(node)) {
            state.setSelected(e.getOldSelection());
        }
    }

    public Boolean adviseNodeSelected(UITree tree) {
        CurrentSelection currentSelection = this.getCurrentSelection();
        ResourceGroupTreeNode node = (ResourceGroupTreeNode)tree.getRowData(tree.getRowKey());
        if (node.getData() instanceof ResourceGroup) {
            return currentSelection.resourceGroup.getId() == ((ResourceGroup)node.getData()).getId();
        }
        if (node.getData() instanceof ClusterKey) {
            ClusterKey key = (ClusterKey)node.getData();
            if (currentSelection.clusterKey != null && currentSelection.clusterKey.equals((Object)key)) {
                return true;
            }
        }
        return false;
    }

    private boolean redirectTo(ResourceGroupTreeNode node) {
        HttpServletResponse response = (HttpServletResponse)FacesContextUtility.getFacesContext().getExternalContext().getResponse();
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        String path = "";
        if (node.getData() instanceof ClusterKey) {
            ClusterManagerLocal clusterManager = LookupUtil.getClusterManager();
            ResourceGroup group = clusterManager.createAutoClusterBackingGroup(subject, (ClusterKey)node.getData(), true);
            path = "/rhq/group/inventory/view.xhtml";
            path = path + "?groupId=" + group.getId() + "&parentGroupId=" + ((ClusterKey)node.getData()).getClusterGroupId();
        } else {
            if (node.getData() instanceof AutoGroupCompositeFlyweight) {
                FacesContext.getCurrentInstance().addMessage("leftNavGroupTreeForm:leftNavGroupTree", new FacesMessage(FacesMessage.SEVERITY_WARN, "No cluster autogroup views available", null));
                return false;
            }
            if (node.getData() instanceof ResourceGroup) {
                path = "/rhq/group/inventory/view.xhtml";
                path = path + "?groupId=" + ((ResourceGroup)node.getData()).getId();
            }
        }
        try {
            response.sendRedirect(path);
            return true;
        }
        catch (IOException ioe) {
            FacesContext.getCurrentInstance().addMessage("leftNavGroupTreeForm:leftNavGroupTree", new FacesMessage(FacesMessage.SEVERITY_WARN, "Unable to browse to selected group view: " + ioe.getMessage(), null));
            return false;
        }
    }
}

