/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.ha;

import javax.faces.application.FacesMessage;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.cloud.AffinityGroup;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.cloud.AffinityGroupManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class ViewAffinityGroupDetailsUIBean {
    public static final String MANAGED_BEAN_NAME = "ViewAffinityGroupDetailsUIBean";
    private static final String CREATE_MODE = "create";
    private AffinityGroupManagerLocal affinityGroupManager = LookupUtil.getAffinityGroupManager();
    private AffinityGroup affinityGroup;

    public ViewAffinityGroupDetailsUIBean() {
        if (this.getMode().equals(CREATE_MODE)) {
            this.affinityGroup = new AffinityGroup("");
        } else {
            Subject subject = EnterpriseFacesContextUtility.getSubject();
            int affinityGroupId = (Integer)FacesContextUtility.getRequiredRequestParameter((String)"affinityGroupId", Integer.class);
            this.affinityGroup = this.affinityGroupManager.getById(subject, affinityGroupId);
        }
    }

    public String getMode() {
        return FacesContextUtility.getRequiredRequestParameter((String)"mode");
    }

    public AffinityGroup getAffinityGroup() {
        return this.affinityGroup;
    }

    public String edit() {
        return "edit";
    }

    public String save() {
        try {
            Subject subject = EnterpriseFacesContextUtility.getSubject();
            this.affinityGroupManager.update(subject, this.getAffinityGroup());
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)"The affinity group has been updated.");
        }
        catch (Exception e) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)("Error: " + e.getMessage()));
            return "edit";
        }
        return "success";
    }

    public String createNew() {
        try {
            Subject subject = EnterpriseFacesContextUtility.getSubject();
            this.affinityGroupManager.create(subject, this.getAffinityGroup());
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)"The affinity group has been created.");
        }
        catch (Exception e) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)("Error: " + e.getMessage()));
            return "createFailure";
        }
        return "createSuccess";
    }

    public String cancelEdit() {
        return "success";
    }

    public String cancelCreate() {
        return "cancelCreate";
    }
}

