/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.test;

import java.util.ArrayList;
import java.util.List;
import javax.faces.event.ValueChangeEvent;
import javax.faces.model.SelectItem;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Scope(value=ScopeType.PAGE)
@Name(value="TestConditionalFormUIBean")
public class TestConditionalFormUIBean {
    private String currentType = "";
    private String currentItem = "";
    private String favoriteCharacter = "";
    private String result;
    public List<SelectItem> firstList = new ArrayList();
    public List<SelectItem> secondList = new ArrayList();
    public List<SelectItem> thirdList = new ArrayList();
    private static final String[] FRUITS = new String[]{"Banana", "Cranberry", "Blueberry", "Orange"};
    private static final String[] VEGETABLES = new String[]{"Potatoes", "Broccoli", "Garlic", "Carrot"};
    private boolean debug = true;

    public TestConditionalFormUIBean() {
        this.init();
    }

    public void init() {
        this.firstList.add(new SelectItem((Object)"none", "Select..."));
        this.firstList.add(new SelectItem((Object)"fruits", "Fruits"));
        this.firstList.add(new SelectItem((Object)"vegetables", "Vegetables"));
    }

    public List<SelectItem> getFirstList() {
        this.debug("getFirstList() -> " + this.prettyPrint(this.firstList));
        return this.firstList;
    }

    public List<SelectItem> getSecondList() {
        this.debug("getSecondList() -> " + this.prettyPrint(this.secondList));
        return this.secondList;
    }

    public List<SelectItem> getThirdList() {
        this.debug("getThirdList() -> " + this.prettyPrint(this.thirdList));
        return this.thirdList;
    }

    private String prettyPrint(List<SelectItem> list) {
        StringBuilder results = new StringBuilder();
        boolean first = true;
        for (SelectItem nextItem : list) {
            if (first) {
                first = false;
            } else {
                results.append(", ");
            }
            results.append(nextItem.getValue() + ":" + nextItem.getLabel());
        }
        return results.toString();
    }

    private boolean noEffect(ValueChangeEvent event) {
        Object oldValue = event.getOldValue();
        if (event.getNewValue() == null) {
            this.debug("noEffect: nothing selected");
            return true;
        }
        Object newValue = event.getNewValue();
        if (oldValue != null && newValue != null && oldValue.equals(newValue)) {
            this.debug("nothing changed");
            return true;
        }
        this.debug("noEffect: change detected");
        return false;
    }

    public void currentTypeChanged(ValueChangeEvent event) {
        String[] currentItems;
        this.debug("currentTypeChanged: event fired");
        if (this.noEffect(event)) {
            return;
        }
        this.secondList.clear();
        String selectedCurrentType = (String)event.getNewValue();
        if (selectedCurrentType.equals("none")) {
            currentItems = new String[]{};
        } else {
            this.secondList.add(new SelectItem((Object)"none", "Select..."));
            currentItems = selectedCurrentType.equals("fruits") ? FRUITS : VEGETABLES;
        }
        for (int i = 0; i < currentItems.length; ++i) {
            SelectItem item = new SelectItem((Object)currentItems[i]);
            this.secondList.add(item);
        }
        this.debug("currentTypeChanged: clearing thirdList, nulling-out result");
        this.thirdList.clear();
        this.result = null;
    }

    public void currentItemChanged(ValueChangeEvent event) {
        this.debug("currentItemChanged: event fired");
        if (this.noEffect(event)) {
            return;
        }
        this.thirdList.clear();
        this.thirdList.add(new SelectItem((Object)"none", "Select..."));
        String selectedCurrentItem = (String)event.getNewValue();
        if (!selectedCurrentItem.equals("none")) {
            for (char nextChar : selectedCurrentItem.toCharArray()) {
                SelectItem item = new SelectItem((Object)Character.valueOf(nextChar));
                this.thirdList.add(item);
            }
        }
        this.debug("currentItemChanged: nulling-out result");
        this.result = null;
    }

    public void currentCharChanged(ValueChangeEvent event) {
        this.debug("currentCharChanged: event fired");
        if (this.noEffect(event)) {
            return;
        }
        this.result = null;
        String selectedCurrentChar = (String)event.getNewValue();
        if (!selectedCurrentChar.equals("none")) {
            this.result = this.getCurrentType() + " : " + this.getCurrentItem() + " : " + selectedCurrentChar;
        }
    }

    public String getCurrentType() {
        this.debug("getCurrentType() -> " + this.currentType);
        return this.currentType;
    }

    public void setCurrentType(String currentType) {
        this.debug("setCurrentType(" + currentType + ")");
        this.currentType = currentType;
    }

    public String getCurrentItem() {
        this.debug("getCurrentItem() -> " + this.currentItem);
        return this.currentItem;
    }

    public void setCurrentItem(String currentItem) {
        this.debug("setCurrentItem(" + currentItem + ")");
        this.currentItem = currentItem;
    }

    public String getFavoriteCharacter() {
        this.debug("getFavoriteCharacter() -> " + this.favoriteCharacter);
        return this.favoriteCharacter;
    }

    public void setFavoriteCharacter(String favoriteCharacter) {
        this.debug("setFavoriteCharacter(" + favoriteCharacter + ")");
        this.favoriteCharacter = favoriteCharacter;
    }

    public String getResult() {
        this.debug("getResult() -> " + this.result);
        return this.result;
    }

    public void setResult(String result) {
        this.debug("setResult(" + result + ")");
        this.result = result;
    }

    private void debug(String message) {
        if (this.debug) {
            System.out.println(message);
        }
    }
}

