/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.legacy.taglib;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.TagSupport;
import org.rhq.enterprise.server.system.SystemManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class LicenseExpirationTag
extends TagSupport {
    private static long lastRead = 0L;
    private static String expiration = null;
    public static final long MILLIS_IN_DAY = 86400000L;
    public static final long WARN_EXPIRE_DAYS = 30L;
    public static final long REFRESH_MILLIS = 3600000L;
    public static final SimpleDateFormat DFORMAT = new SimpleDateFormat("MMMM dd, yyyy");
    public static final String PREFIX = "<tr>\n  <td colspan=\"9\" class=\"FooterRegular\">";
    public static final String SUFFIX = " <a href=\"http://www.jboss.com\">Contact JBoss</a> to renew your license!</td>\n</tr>";

    private String loadExpiration() {
        long now = System.currentTimeMillis();
        if (expiration != null && now - lastRead < 3600000L) {
            return expiration;
        }
        SystemManagerLocal systemManager = LookupUtil.getSystemManager();
        Date expiresDate = systemManager.getExpiration();
        if (expiresDate == null) {
            return "";
        }
        long numDays = (expiresDate.getTime() - now) / 86400000L;
        if (numDays > 30L) {
            return "";
        }
        if (numDays <= 0L) {
            return "<tr>\n  <td colspan=\"9\" class=\"FooterRegular\">LICENSE EXPIRES TODAY! <a href=\"http://www.jboss.com\">Contact JBoss</a> to renew your license!</td>\n</tr>";
        }
        return "<tr>\n  <td colspan=\"9\" class=\"FooterRegular\">LICENSE EXPIRES IN " + numDays + " DAYS (on " + DFORMAT.format(expiresDate) + ")" + SUFFIX;
    }

    public final int doStartTag() throws JspException {
        try {
            this.pageContext.getOut().write(this.loadExpiration());
        }
        catch (IOException e) {
            throw new JspTagException(e.toString());
        }
        return 0;
    }
}

