/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.inventory.group;

import java.util.Map;
import javax.faces.application.FacesMessage;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.resource.group.GroupCategory;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.core.gui.configuration.propset.ConfigurationSet;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.enterprise.gui.inventory.group.GroupPluginConfigurationUtility;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.configuration.ConfigurationManagerLocal;
import org.rhq.enterprise.server.configuration.ConfigurationUpdateStillInProgressException;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGroupPluginConfigurationUIBean {
    private ConfigurationManagerLocal configurationManager = LookupUtil.getConfigurationManager();
    private ResourceManagerLocal resourceManager = LookupUtil.getResourceManager();
    private ResourceGroup group;
    private Map<Integer, Configuration> pluginConfigurations;
    private ConfigurationSet configurationSet;

    protected void loadConfigurations() {
        try {
            this.group = this.loadGroup();
            this.pluginConfigurations = this.configurationManager.getPluginConfigurationsForCompatibleGroup(EnterpriseFacesContextUtility.getSubject(), this.group.getId());
        }
        catch (ConfigurationUpdateStillInProgressException updateException) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_WARN, (String)"Configuration update is currently in progress. Please wait a few moments and refresh the page.");
            return;
        }
        catch (Exception e) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"Failed to load group plugin configuration.", (Throwable)e);
            e.printStackTrace();
            return;
        }
        this.configurationSet = GroupPluginConfigurationUtility.buildConfigurationSet((Subject)EnterpriseFacesContextUtility.getSubject(), (ResourceGroup)this.group, (Map)this.pluginConfigurations);
        this.configurationSet.mask();
    }

    private ResourceGroup loadGroup() throws Exception {
        ResourceGroup group;
        try {
            group = EnterpriseFacesContextUtility.getResourceGroup();
        }
        catch (Exception e) {
            throw new Exception("No group is associated with this request ('groupId' request parameter is not set).");
        }
        if (group.getGroupCategory() != GroupCategory.COMPATIBLE) {
            throw new Exception("Group with id " + group.getId() + " is not a compatible group.");
        }
        return group;
    }

    public ConfigurationManagerLocal getConfigurationManager() {
        return this.configurationManager;
    }

    public ResourceManagerLocal getResourceManager() {
        return this.resourceManager;
    }

    public ResourceGroup getGroup() {
        return this.group;
    }

    public Map<Integer, Configuration> getPluginConfigurations() {
        return this.pluginConfigurations;
    }

    public ConfigurationSet getConfigurationSet() {
        return this.configurationSet;
    }
}

