/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.common.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.util.List;
import org.rhq.core.domain.measurement.composite.MeasurementDataNumericHighLowComposite;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.util.LookupUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SparklineUIBean {
    private int scheduleId;

    public void paint(Graphics2D g2d, Object obj) {
        String[] keys = ((String)obj).split(":");
        int resourceId = Integer.parseInt(keys[0]);
        int scheduleDefId = Integer.parseInt(keys[1]);
        List data = this.getData(resourceId, scheduleDefId);
        double min = Double.MAX_VALUE;
        double max = -2.147483648E9;
        for (MeasurementDataNumericHighLowComposite d : data) {
            if (d.getLowValue() < min) {
                min = d.getLowValue();
            }
            if (!(d.getHighValue() > max)) continue;
            max = d.getHighValue();
        }
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        double heightScale = max - min != 0.0 ? 18.0 / (max - min) : 0.0;
        int i = 1;
        g2d.setStroke(new BasicStroke(0.6f));
        Polygon p = new Polygon();
        p.addPoint(0, 18);
        for (MeasurementDataNumericHighLowComposite d : data) {
            if (!Double.isNaN(d.getValue())) {
                p.addPoint(i, 18 - (int)(heightScale * (d.getValue() - min)));
            }
            ++i;
        }
        p.addPoint(60, 18);
        g2d.setPaint(new GradientPaint(0.0f, 18.0f, Color.lightGray, 0.0f, 0.0f, Color.darkGray));
        g2d.fillPolygon(p);
        g2d.setColor(Color.lightGray);
        g2d.drawPolygon(p);
    }

    private List<MeasurementDataNumericHighLowComposite> getData(int resourceId, int scheduleDefId) {
        List dl = LookupUtil.getMeasurementDataManager().findDataForResource(EnterpriseFacesContextUtility.getSubject(), resourceId, new int[]{scheduleDefId}, System.currentTimeMillis() - 28800000L, System.currentTimeMillis(), 60);
        List data = (List)dl.get(0);
        return data;
    }
}

