/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.authentication;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.tiles.actions.TilesAction;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.criteria.SubjectCriteria;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.gui.authentication.LogonForm;
import org.rhq.enterprise.gui.legacy.WebUser;
import org.rhq.enterprise.gui.legacy.util.SessionUtils;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class AuthenticateUserAction
extends TilesAction {
    private static final String URL_REGISTER = "/admin/user/UserAdmin.do?mode=register";
    private static final String URL_DASHBOARD = "/";

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward af;
        Log log = LogFactory.getLog((String)AuthenticateUserAction.class.getName());
        HttpSession session = request.getSession(true);
        LogonForm logonForm = (LogonForm)form;
        ServletContext ctx = this.getServlet().getServletContext();
        WebUser webUser = null;
        HashMap<String, Boolean> userGlobalPermissionsMap = new HashMap<String, Boolean>();
        boolean needsRegistration = false;
        try {
            SubjectManagerLocal subjectManager = LookupUtil.getSubjectManager();
            Subject subject = subjectManager.login(logonForm.getJ_username(), logonForm.getJ_password());
            Integer sessionId = subject.getSessionId();
            log.debug((Object)("Logged in as [" + logonForm.getJ_username() + "] with session id [" + sessionId + "]"));
            if (subject.getId() == 0) {
                needsRegistration = true;
            }
            boolean usingLDAP = AuthenticateUserAction.usingLDAPAuthentication((ServletContext)ctx);
            boolean hasPrincipal = false;
            if (usingLDAP) {
                hasPrincipal = subjectManager.isUserWithPrincipal(logonForm.getJ_username());
                if (!hasPrincipal && needsRegistration) {
                    SubjectCriteria subjectCriteria = new SubjectCriteria();
                    subjectCriteria.setCaseSensitive(false);
                    subjectCriteria.setStrict(true);
                    subjectCriteria.addFilterName(logonForm.getJ_username());
                    subjectCriteria.fetchRoles(true);
                    subjectCriteria.fetchConfiguration(true);
                    PageList subjectsLocated = LookupUtil.getSubjectManager().findSubjectsByCriteria(LookupUtil.getSubjectManager().getOverlord(), subjectCriteria);
                    if (!subjectsLocated.isEmpty()) {
                        Subject ldapSubject = (Subject)subjectsLocated.get(0);
                        String msg = "Located existing ldap account with different case for [" + ldapSubject.getName() + "]. " + "Attempting to authenticate with that account instead.";
                        log.info((Object)msg);
                        subject = subjectManager.login(ldapSubject.getName(), logonForm.getJ_password());
                        sessionId = subject.getSessionId();
                        log.debug((Object)("Logged in as [" + ldapSubject.getName() + "] with session id [" + sessionId + "]"));
                        needsRegistration = false;
                    }
                }
            } else {
                hasPrincipal = true;
            }
            if (!needsRegistration) {
                subject = subjectManager.loadUserConfiguration(Integer.valueOf(subject.getId()));
                subject.setSessionId(sessionId);
                if (subject.getUserConfiguration() == null) {
                    subject.setUserConfiguration((Configuration)ctx.getAttribute("userPrefs"));
                    subject = subjectManager.updateSubject(subject, subject);
                    subject.setSessionId(sessionId);
                }
                Set all_permissions = LookupUtil.getAuthorizationManager().getExplicitGlobalPermissions(subject);
                for (Permission permission : all_permissions) {
                    userGlobalPermissionsMap.put(permission.toString(), Boolean.TRUE);
                }
            }
            webUser = new WebUser(subject, hasPrincipal);
        }
        catch (Exception e) {
            String msg = e.getMessage().toLowerCase();
            if (msg.indexOf("username") >= 0 || msg.indexOf("password") >= 0) {
                request.setAttribute("loginStatus", (Object)"login.info.bad");
            } else {
                log.error((Object)"Could not log into the web application", (Throwable)e);
                request.setAttribute("loginStatus", (Object)"login.bad.backend");
            }
            return mapping.findForward("bad");
        }
        if (needsRegistration) {
            log.debug((Object)("LDAP registration required for user [" + logonForm.getJ_username() + "]"));
            af = new ActionForward("/admin/user/UserAdmin.do?mode=register");
        } else {
            String url = this.getBookmarkedUrl(session);
            if (url == null || url.equals("/Logout.do")) {
                url = "/";
            }
            if (url.toLowerCase().indexOf("ajax") != -1) {
                url = webUser.getWebPreferences().getLastVisitedURL(2);
                log.info((Object)("Bypassing partial-page with " + url));
            }
            af = new ActionForward(url);
        }
        af.setRedirect(true);
        session.invalidate();
        session = request.getSession(true);
        SessionUtils.setWebUser((HttpSession)session, (WebUser)webUser);
        session.setAttribute("useroperations", userGlobalPermissionsMap);
        if (needsRegistration) {
            session.setAttribute("password", (Object)logonForm.getJ_password());
        }
        AuthenticateUserAction.updateMonitoringEnabled((ServletContext)ctx);
        return af;
    }

    private String getBookmarkedUrl(HttpSession session) {
        String val = (String)session.getAttribute("forwardURL");
        if (val == null || val.length() == 0) {
            return null;
        }
        StringBuffer url = new StringBuffer(val);
        Map parameters = (Map)session.getAttribute("forwardParams");
        if (parameters != null && !parameters.isEmpty()) {
            String sep = "?";
            for (String key : parameters.keySet()) {
                String value = (String)parameters.get(key);
                url.append(sep).append(key).append("=").append(value);
                if (!sep.equals("?")) continue;
                sep = "&";
            }
        }
        return url.toString();
    }

    public static boolean usingLDAPAuthentication(ServletContext context) throws Exception {
        String provider = (String)context.getAttribute("jaas-provider");
        if (provider == null) {
            provider = LookupUtil.getSystemManager().getSystemConfiguration().getProperty("CAM_JAAS_PROVIDER");
            context.setAttribute("jaas-provider", (Object)provider);
        }
        return provider != null && provider.equals("LDAP");
    }

    public static boolean updateMonitoringEnabled(ServletContext context) {
        boolean enabled = LookupUtil.getSystemManager().isMonitoringEnabled();
        context.setAttribute("monitorEnabled", (Object)enabled);
        return enabled;
    }
}

