/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.admin.plugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.TreeMap;
import javax.faces.application.FacesMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.plugin.AbstractPlugin;
import org.rhq.core.domain.plugin.Plugin;
import org.rhq.core.domain.plugin.PluginKey;
import org.rhq.core.domain.plugin.PluginStatusType;
import org.rhq.core.domain.plugin.ServerPlugin;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.core.gui.util.StringUtility;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.core.util.stream.StreamUtil;
import org.rhq.enterprise.gui.admin.plugin.InstalledPluginsSessionUIBean;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.authz.PermissionException;
import org.rhq.enterprise.server.core.plugin.PluginDeploymentScannerMBean;
import org.rhq.enterprise.server.plugin.ServerPluginsLocal;
import org.rhq.enterprise.server.resource.metadata.ResourceMetadataManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;
import org.richfaces.event.UploadEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstalledPluginsUIBean {
    private final Log log = LogFactory.getLog(InstalledPluginsUIBean.class);
    public static final String MANAGED_BEAN_NAME = InstalledPluginsUIBean.class.getSimpleName();
    private ResourceMetadataManagerLocal resourceMetadataManagerBean = LookupUtil.getResourceMetadataManager();
    private ServerPluginsLocal serverPluginsBean = LookupUtil.getServerPlugins();

    public void restartMasterPluginContainer() {
        this.hasPermission();
        try {
            Subject subject = EnterpriseFacesContextUtility.getSubject();
            this.serverPluginsBean.restartMasterPluginContainer(subject);
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)"Master plugin container has been restarted.");
        }
        catch (Exception e) {
            this.processException("Failed to restart the master plugin container", e);
        }
    }

    public Collection<Plugin> getInstalledAgentPlugins() {
        this.hasPermission();
        List plugins = this.resourceMetadataManagerBean.getPlugins();
        plugins = this.sort(plugins);
        return plugins;
    }

    public Collection<ServerPlugin> getInstalledServerPlugins() {
        this.hasPermission();
        InstalledPluginsSessionUIBean session = (InstalledPluginsSessionUIBean)FacesContextUtility.getManagedBean(InstalledPluginsSessionUIBean.class);
        List plugins = session.isShowAllServerPlugins() ? this.serverPluginsBean.getAllServerPlugins() : this.serverPluginsBean.getServerPlugins();
        plugins = this.sort(plugins);
        return plugins;
    }

    public void scan() {
        this.hasPermission();
        try {
            PluginDeploymentScannerMBean scanner = LookupUtil.getPluginDeploymentScanner();
            scanner.scanAndRegister();
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)"Done scanning for updated plugins.");
        }
        catch (Exception e) {
            this.processException("Failed to scan for updated plugins", e);
        }
    }

    public void fileUploadListener(UploadEvent event) {
        this.hasPermission();
        try {
            File uploadedPlugin = event.getUploadItem().getFile();
            String newPluginFilename = event.getUploadItem().getFileName();
            if (newPluginFilename != null) {
                if ((newPluginFilename = newPluginFilename.replace('\\', '/')).length() > 2 && newPluginFilename.charAt(1) == ':') {
                    newPluginFilename = newPluginFilename.substring(2);
                }
                newPluginFilename = new File(newPluginFilename).getName();
            }
            this.log.info((Object)("A new plugin [" + newPluginFilename + "] has been uploaded to [" + uploadedPlugin + "]"));
            if (uploadedPlugin == null || !uploadedPlugin.exists()) {
                throw new FileNotFoundException("The uploaded plugin file [" + uploadedPlugin + "] does not exist!");
            }
            File installDir = LookupUtil.getCoreServer().getInstallDir();
            File dir = new File(installDir, "plugins");
            File pluginFile = new File(dir, newPluginFilename);
            FileOutputStream fos = new FileOutputStream(pluginFile);
            FileInputStream fis = new FileInputStream(uploadedPlugin);
            StreamUtil.copy((InputStream)fis, (OutputStream)fos);
            this.log.info((Object)("A new plugin has been deployed [" + pluginFile + "]. A scan is required now in order to register it."));
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)("New plugin uploaded: " + newPluginFilename));
        }
        catch (Exception e) {
            this.processException("Failed to process uploaded plugin", e);
        }
    }

    public void enableAgentPlugins() {
        List allSelectedPlugins = this.getSelectedAgentPlugins();
        ArrayList<String> selectedPluginNames = new ArrayList<String>();
        ArrayList<Plugin> pluginsToEnable = new ArrayList<Plugin>();
        for (Plugin selectedPlugin : allSelectedPlugins) {
            if (selectedPlugin.isEnabled() || selectedPlugin.getStatus() != PluginStatusType.INSTALLED) continue;
            selectedPluginNames.add(selectedPlugin.getDisplayName());
            pluginsToEnable.add(selectedPlugin);
        }
        if (selectedPluginNames.isEmpty()) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)"No disabled plugins were selected. Nothing to enable");
            return;
        }
        try {
            Subject subject = EnterpriseFacesContextUtility.getSubject();
            this.resourceMetadataManagerBean.enablePlugins(subject, this.getIds(pluginsToEnable));
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)("Enabled server plugins: " + selectedPluginNames));
        }
        catch (Exception e) {
            this.processException("Failed to enable agent plugins", e);
        }
    }

    public void disableAgentPlugins() {
        List allSelectedPlugins = this.getSelectedAgentPlugins();
        ArrayList<String> selectedPluginNames = new ArrayList<String>();
        ArrayList<Plugin> pluginsToDisable = new ArrayList<Plugin>();
        for (Plugin selectedPlugin : allSelectedPlugins) {
            if (!selectedPlugin.isEnabled()) continue;
            selectedPluginNames.add(selectedPlugin.getDisplayName());
            pluginsToDisable.add(selectedPlugin);
        }
        if (selectedPluginNames.isEmpty()) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)"No enabled plugins were selected. Nothing to disable");
            return;
        }
        try {
            Subject subject = EnterpriseFacesContextUtility.getSubject();
            this.resourceMetadataManagerBean.disablePlugins(subject, this.getIds(pluginsToDisable));
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)("Disabled plugins: " + selectedPluginNames));
        }
        catch (Exception e) {
            this.processException("Failed to disable agent plugins", e);
        }
    }

    public void enableServerPlugins() {
        List allSelectedPlugins = this.getSelectedServerPlugins();
        ArrayList<String> selectedPluginNames = new ArrayList<String>();
        ArrayList<ServerPlugin> pluginsToEnable = new ArrayList<ServerPlugin>();
        for (ServerPlugin selectedPlugin : allSelectedPlugins) {
            if (selectedPlugin.isEnabled() || selectedPlugin.getStatus() != PluginStatusType.INSTALLED) continue;
            selectedPluginNames.add(selectedPlugin.getDisplayName());
            pluginsToEnable.add(selectedPlugin);
        }
        if (selectedPluginNames.isEmpty()) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)"No disabled plugins were selected. Nothing to enable");
            return;
        }
        try {
            Subject subject = EnterpriseFacesContextUtility.getSubject();
            List enabled = this.serverPluginsBean.enableServerPlugins(subject, this.getIds(pluginsToEnable));
            if (enabled.size() == pluginsToEnable.size()) {
                FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)("Enabled server plugins: " + selectedPluginNames));
            } else {
                ArrayList<String> enabledPlugins = new ArrayList<String>();
                ArrayList<String> failedPlugins = new ArrayList<String>();
                for (ServerPlugin pluginToEnable : pluginsToEnable) {
                    PluginKey key = PluginKey.createServerPluginKey((String)pluginToEnable.getType(), (String)pluginToEnable.getName());
                    if (enabled.contains(key)) {
                        enabledPlugins.add(pluginToEnable.getDisplayName());
                        continue;
                    }
                    failedPlugins.add(pluginToEnable.getDisplayName());
                }
                if (enabledPlugins.size() > 0) {
                    FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)("Enabled server plugins: " + enabledPlugins));
                }
                if (failedPlugins.size() > 0) {
                    FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)("Failed to enable server plugins: " + failedPlugins));
                }
            }
        }
        catch (Exception e) {
            this.processException("Failed to enable server plugins", e);
        }
    }

    public void disableServerPlugins() {
        List allSelectedPlugins = this.getSelectedServerPlugins();
        ArrayList<String> selectedPluginNames = new ArrayList<String>();
        ArrayList<ServerPlugin> pluginsToDisable = new ArrayList<ServerPlugin>();
        for (ServerPlugin selectedPlugin : allSelectedPlugins) {
            if (!selectedPlugin.isEnabled()) continue;
            selectedPluginNames.add(selectedPlugin.getDisplayName());
            pluginsToDisable.add(selectedPlugin);
        }
        if (selectedPluginNames.isEmpty()) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)"No enabled plugins were selected. Nothing to disable");
            return;
        }
        try {
            Subject subject = EnterpriseFacesContextUtility.getSubject();
            this.serverPluginsBean.disableServerPlugins(subject, this.getIds(pluginsToDisable));
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)("Disabled server plugins: " + selectedPluginNames));
        }
        catch (Exception e) {
            this.processException("Failed to disable server plugins", e);
        }
    }

    public void undeployServerPlugins() {
        List allSelectedPlugins = this.getSelectedServerPlugins();
        ArrayList<String> selectedPluginNames = new ArrayList<String>();
        ArrayList<ServerPlugin> pluginsToUndeploy = new ArrayList<ServerPlugin>();
        for (ServerPlugin selectedPlugin : allSelectedPlugins) {
            if (selectedPlugin.getStatus() != PluginStatusType.INSTALLED) continue;
            selectedPluginNames.add(selectedPlugin.getDisplayName());
            pluginsToUndeploy.add(selectedPlugin);
        }
        if (selectedPluginNames.isEmpty()) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)"No deployed plugins were selected. Nothing to undeploy");
            return;
        }
        try {
            Subject subject = EnterpriseFacesContextUtility.getSubject();
            this.serverPluginsBean.undeployServerPlugins(subject, this.getIds(pluginsToUndeploy));
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)("Undeployed server plugins: " + selectedPluginNames));
        }
        catch (Exception e) {
            this.processException("Failed to undeploy server plugins", e);
        }
    }

    public void purgeServerPlugins() {
        List allSelectedPlugins = this.getSelectedServerPlugins();
        ArrayList<String> selectedPluginNames = new ArrayList<String>();
        for (ServerPlugin selectedPlugin : allSelectedPlugins) {
            selectedPluginNames.add(selectedPlugin.getDisplayName());
        }
        if (selectedPluginNames.isEmpty()) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)"No plugins were selected. Nothing to purge");
            return;
        }
        try {
            Subject subject = EnterpriseFacesContextUtility.getSubject();
            this.serverPluginsBean.purgeServerPlugins(subject, this.getIds(allSelectedPlugins));
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)("Purged server plugins: " + selectedPluginNames));
        }
        catch (Exception e) {
            this.processException("Failed to undeploy server plugins", e);
        }
    }

    private List<Integer> getIds(List<? extends AbstractPlugin> plugins) {
        ArrayList<Integer> ids = new ArrayList<Integer>(plugins.size());
        for (AbstractPlugin abstractPlugin : plugins) {
            ids.add(abstractPlugin.getId());
        }
        return ids;
    }

    private List<Plugin> getSelectedAgentPlugins() {
        Integer[] integerItems = this.getSelectedPluginIds();
        List<Integer> ids = Arrays.asList(integerItems);
        List plugins = this.resourceMetadataManagerBean.getAllPluginsById(ids);
        return plugins;
    }

    private List<ServerPlugin> getSelectedServerPlugins() {
        Integer[] integerItems = this.getSelectedPluginIds();
        List<Integer> ids = Arrays.asList(integerItems);
        List plugins = this.serverPluginsBean.getAllServerPluginsById(ids);
        return plugins;
    }

    private Integer[] getSelectedPluginIds() {
        String[] stringItems = FacesContextUtility.getRequest().getParameterValues("selectedPlugin");
        if (stringItems == null || stringItems.length == 0) {
            return new Integer[0];
        }
        Integer[] integerItems = StringUtility.getIntegerArray((String[])stringItems);
        return integerItems;
    }

    private void hasPermission() {
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        if (!LookupUtil.getAuthorizationManager().hasGlobalPermission(subject, Permission.MANAGE_SETTINGS)) {
            throw new PermissionException("User [" + subject.getName() + "] does not have the proper permissions to view or manage plugins");
        }
    }

    private void processException(String errMsg, Exception e) {
        this.log.error((Object)(errMsg + ". Cause: " + ThrowableUtil.getAllMessages((Throwable)e)));
        FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)errMsg, (Throwable)e);
    }

    private <T extends AbstractPlugin> List<T> sort(List<T> plugins) {
        TreeMap<String, AbstractPlugin> map = new TreeMap<String, AbstractPlugin>();
        for (AbstractPlugin plugin : plugins) {
            map.put(plugin.getName(), plugin);
        }
        return new ArrayList(map.values());
    }
}

