﻿

/* decorators.js */
Timeline.SpanHighlightDecorator=function(A){this._unit=("unit" in A)?A.unit:SimileAjax.NativeDateUnit;
this._startDate=(typeof A.startDate=="string")?this._unit.parseFromObject(A.startDate):A.startDate;
this._endDate=(typeof A.endDate=="string")?this._unit.parseFromObject(A.endDate):A.endDate;
this._startLabel=A.startLabel;
this._endLabel=A.endLabel;
this._color=A.color;
this._cssClass=("cssClass" in A)?A.cssClass:null;
this._opacity=("opacity" in A)?A.opacity:100;
};
Timeline.SpanHighlightDecorator.prototype.initialize=function(B,A){this._band=B;
this._timeline=A;
this._layerDiv=null;
};
Timeline.SpanHighlightDecorator.prototype.paint=function(){if(this._layerDiv!=null){this._band.removeLayerDiv(this._layerDiv);
}this._layerDiv=this._band.createLayerDiv(10);
this._layerDiv.setAttribute("name","span-highlight-decorator");
this._layerDiv.style.display="none";
var F=this._band.getMinDate();
var C=this._band.getMaxDate();
if(this._unit.compare(this._startDate,C)<0&&this._unit.compare(this._endDate,F)>0){F=this._unit.later(F,this._startDate);
C=this._unit.earlier(C,this._endDate);
var D=this._band.dateToPixelOffset(F);
var K=this._band.dateToPixelOffset(C);
var I=this._timeline.getDocument();
var H=function(){var L=I.createElement("table");
L.insertRow(0).insertCell(0);
return L;
};
var B=I.createElement("div");
B.className="timeline-highlight-decorator";
if(this._cssClass){B.className+=" "+this._cssClass;
}if(this._opacity<100){SimileAjax.Graphics.setOpacity(B,this._opacity);
}this._layerDiv.appendChild(B);
var J=H();
J.className="timeline-highlight-label timeline-highlight-label-start";
var G=J.rows[0].cells[0];
G.innerHTML=this._startLabel;
if(this._cssClass){G.className="label_"+this._cssClass;
}this._layerDiv.appendChild(J);
var A=H();
A.className="timeline-highlight-label timeline-highlight-label-end";
var E=A.rows[0].cells[0];
E.innerHTML=this._endLabel;
if(this._cssClass){E.className="label_"+this._cssClass;
}this._layerDiv.appendChild(A);
if(this._timeline.isHorizontal()){B.style.left=D+"px";
B.style.width=(K-D)+"px";
J.style.right=(this._band.getTotalViewLength()-D)+"px";
J.style.width=(this._startLabel.length)+"em";
A.style.left=K+"px";
A.style.width=(this._endLabel.length)+"em";
}else{B.style.top=D+"px";
B.style.height=(K-D)+"px";
J.style.bottom=D+"px";
J.style.height="1.5px";
A.style.top=K+"px";
A.style.height="1.5px";
}}this._layerDiv.style.display="block";
};
Timeline.SpanHighlightDecorator.prototype.softPaint=function(){};
Timeline.PointHighlightDecorator=function(A){this._unit=("unit" in A)?A.unit:SimileAjax.NativeDateUnit;
this._date=(typeof A.date=="string")?this._unit.parseFromObject(A.date):A.date;
this._width=("width" in A)?A.width:10;
this._color=A.color;
this._cssClass=("cssClass" in A)?A.cssClass:"";
this._opacity=("opacity" in A)?A.opacity:100;
};
Timeline.PointHighlightDecorator.prototype.initialize=function(B,A){this._band=B;
this._timeline=A;
this._layerDiv=null;
};
Timeline.PointHighlightDecorator.prototype.paint=function(){if(this._layerDiv!=null){this._band.removeLayerDiv(this._layerDiv);
}this._layerDiv=this._band.createLayerDiv(10);
this._layerDiv.setAttribute("name","span-highlight-decorator");
this._layerDiv.style.display="none";
var C=this._band.getMinDate();
var E=this._band.getMaxDate();
if(this._unit.compare(this._date,E)<0&&this._unit.compare(this._date,C)>0){var B=this._band.dateToPixelOffset(this._date);
var A=B-Math.round(this._width/2);
var D=this._timeline.getDocument();
var F=D.createElement("div");
F.className="timeline-highlight-point-decorator";
F.className+=" "+this._cssClass;
if(this._opacity<100){SimileAjax.Graphics.setOpacity(F,this._opacity);
}this._layerDiv.appendChild(F);
if(this._timeline.isHorizontal()){F.style.left=A+"px";
}else{F.style.top=A+"px";
}}this._layerDiv.style.display="block";
};
Timeline.PointHighlightDecorator.prototype.softPaint=function(){};


/* detailed-painter.js */
Timeline.DetailedEventPainter=function(A){this._params=A;
this._onSelectListeners=[];
this._filterMatcher=null;
this._highlightMatcher=null;
this._frc=null;
this._eventIdToElmt={};
};
Timeline.DetailedEventPainter.prototype.initialize=function(B,A){this._band=B;
this._timeline=A;
this._backLayer=null;
this._eventLayer=null;
this._lineLayer=null;
this._highlightLayer=null;
this._eventIdToElmt=null;
};
Timeline.DetailedEventPainter.prototype.addOnSelectListener=function(A){this._onSelectListeners.push(A);
};
Timeline.DetailedEventPainter.prototype.removeOnSelectListener=function(B){for(var A=0;
A<this._onSelectListeners.length;
A++){if(this._onSelectListeners[A]==B){this._onSelectListeners.splice(A,1);
break;
}}};
Timeline.DetailedEventPainter.prototype.getFilterMatcher=function(){return this._filterMatcher;
};
Timeline.DetailedEventPainter.prototype.setFilterMatcher=function(A){this._filterMatcher=A;
};
Timeline.DetailedEventPainter.prototype.getHighlightMatcher=function(){return this._highlightMatcher;
};
Timeline.DetailedEventPainter.prototype.setHighlightMatcher=function(A){this._highlightMatcher=A;
};
Timeline.DetailedEventPainter.prototype.paint=function(){var B=this._band.getEventSource();
if(B==null){return ;
}this._eventIdToElmt={};
this._prepareForPainting();
var I=this._params.theme.event;
var G=Math.max(I.track.height,this._frc.getLineHeight());
var F={trackOffset:Math.round(this._band.getViewWidth()/2-G/2),trackHeight:G,trackGap:I.track.gap,trackIncrement:G+I.track.gap,icon:I.instant.icon,iconWidth:I.instant.iconWidth,iconHeight:I.instant.iconHeight,labelWidth:I.label.width};
var C=this._band.getMinDate();
var A=this._band.getMaxDate();
var J=(this._filterMatcher!=null)?this._filterMatcher:function(K){return true;
};
var E=(this._highlightMatcher!=null)?this._highlightMatcher:function(K){return -1;
};
var D=B.getEventReverseIterator(C,A);
while(D.hasNext()){var H=D.next();
if(J(H)){this.paintEvent(H,F,this._params.theme,E(H));
}}this._highlightLayer.style.display="block";
this._lineLayer.style.display="block";
this._eventLayer.style.display="block";
};
Timeline.DetailedEventPainter.prototype.softPaint=function(){};
Timeline.DetailedEventPainter.prototype._prepareForPainting=function(){var B=this._band;
if(this._backLayer==null){this._backLayer=this._band.createLayerDiv(0,"timeline-band-events");
this._backLayer.style.visibility="hidden";
var A=document.createElement("span");
A.className="timeline-event-label";
this._backLayer.appendChild(A);
this._frc=SimileAjax.Graphics.getFontRenderingContext(A);
}this._frc.update();
this._lowerTracks=[];
this._upperTracks=[];
if(this._highlightLayer!=null){B.removeLayerDiv(this._highlightLayer);
}this._highlightLayer=B.createLayerDiv(105,"timeline-band-highlights");
this._highlightLayer.style.display="none";
if(this._lineLayer!=null){B.removeLayerDiv(this._lineLayer);
}this._lineLayer=B.createLayerDiv(110,"timeline-band-lines");
this._lineLayer.style.display="none";
if(this._eventLayer!=null){B.removeLayerDiv(this._eventLayer);
}this._eventLayer=B.createLayerDiv(110,"timeline-band-events");
this._eventLayer.style.display="none";
};
Timeline.DetailedEventPainter.prototype.paintEvent=function(B,C,D,A){if(B.isInstant()){this.paintInstantEvent(B,C,D,A);
}else{this.paintDurationEvent(B,C,D,A);
}};
Timeline.DetailedEventPainter.prototype.paintInstantEvent=function(B,C,D,A){if(B.isImprecise()){this.paintImpreciseInstantEvent(B,C,D,A);
}else{this.paintPreciseInstantEvent(B,C,D,A);
}};
Timeline.DetailedEventPainter.prototype.paintDurationEvent=function(B,C,D,A){if(B.isImprecise()){this.paintImpreciseDurationEvent(B,C,D,A);
}else{this.paintPreciseDurationEvent(B,C,D,A);
}};
Timeline.DetailedEventPainter.prototype.paintPreciseInstantEvent=function(K,N,Q,O){var S=this._timeline.getDocument();
var J=K.getText();
var E=K.getStart();
var C=Math.round(this._band.dateToPixelOffset(E));
var A=Math.round(C+N.iconWidth/2);
var I=Math.round(C-N.iconWidth/2);
var G=this._frc.computeSize(J);
var D=this._findFreeTrackForSolid(A,C);
var B=this._paintEventIcon(K,D,I,N,Q);
var T=A+Q.event.label.offsetFromLine;
var P=D;
var F=this._getTrackData(D);
if(Math.min(F.solid,F.text)>=T+G.width){F.solid=I;
F.text=T;
}else{F.solid=I;
T=C+Q.event.label.offsetFromLine;
P=this._findFreeTrackForText(D,T+G.width,function(U){U.line=C-2;
});
this._getTrackData(P).text=I;
this._paintEventLine(K,C,D,P,N,Q);
}var R=Math.round(N.trackOffset+P*N.trackIncrement+N.trackHeight/2-G.height/2);
var M=this._paintEventLabel(K,J,T,R,G.width,G.height,Q);
var L=this;
var H=function(U,V,W){return L._onClickInstantEvent(B.elmt,V,K);
};
SimileAjax.DOM.registerEvent(B.elmt,"mousedown",H);
SimileAjax.DOM.registerEvent(M.elmt,"mousedown",H);
this._createHighlightDiv(O,B,Q);
this._eventIdToElmt[K.getID()]=B.elmt;
};
Timeline.DetailedEventPainter.prototype.paintImpreciseInstantEvent=function(N,Q,V,R){var X=this._timeline.getDocument();
var M=N.getText();
var H=N.getStart();
var S=N.getEnd();
var E=Math.round(this._band.dateToPixelOffset(H));
var B=Math.round(this._band.dateToPixelOffset(S));
var A=Math.round(E+Q.iconWidth/2);
var L=Math.round(E-Q.iconWidth/2);
var J=this._frc.computeSize(M);
var F=this._findFreeTrackForSolid(B,E);
var G=this._paintEventTape(N,F,E,B,V.event.instant.impreciseColor,V.event.instant.impreciseOpacity,Q,V);
var C=this._paintEventIcon(N,F,L,Q,V);
var I=this._getTrackData(F);
I.solid=L;
var W=A+V.event.label.offsetFromLine;
var D=W+J.width;
var T;
if(D<B){T=F;
}else{W=E+V.event.label.offsetFromLine;
D=W+J.width;
T=this._findFreeTrackForText(F,D,function(Y){Y.line=E-2;
});
this._getTrackData(T).text=L;
this._paintEventLine(N,E,F,T,Q,V);
}var U=Math.round(Q.trackOffset+T*Q.trackIncrement+Q.trackHeight/2-J.height/2);
var P=this._paintEventLabel(N,M,W,U,J.width,J.height,V);
var O=this;
var K=function(Y,Z,a){return O._onClickInstantEvent(C.elmt,Z,N);
};
SimileAjax.DOM.registerEvent(C.elmt,"mousedown",K);
SimileAjax.DOM.registerEvent(G.elmt,"mousedown",K);
SimileAjax.DOM.registerEvent(P.elmt,"mousedown",K);
this._createHighlightDiv(R,C,V);
this._eventIdToElmt[N.getID()]=C.elmt;
};
Timeline.DetailedEventPainter.prototype.paintPreciseDurationEvent=function(J,M,S,O){var T=this._timeline.getDocument();
var I=J.getText();
var D=J.getStart();
var P=J.getEnd();
var B=Math.round(this._band.dateToPixelOffset(D));
var A=Math.round(this._band.dateToPixelOffset(P));
var F=this._frc.computeSize(I);
var E=this._findFreeTrackForSolid(A);
var N=J.getColor();
N=N!=null?N:S.event.duration.color;
var C=this._paintEventTape(J,E,B,A,N,100,M,S);
var H=this._getTrackData(E);
H.solid=B;
var U=B+S.event.label.offsetFromLine;
var Q=this._findFreeTrackForText(E,U+F.width,function(V){V.line=B-2;
});
this._getTrackData(Q).text=B-2;
this._paintEventLine(J,B,E,Q,M,S);
var R=Math.round(M.trackOffset+Q*M.trackIncrement+M.trackHeight/2-F.height/2);
var L=this._paintEventLabel(J,I,U,R,F.width,F.height,S);
var K=this;
var G=function(V,W,X){return K._onClickDurationEvent(C.elmt,W,J);
};
SimileAjax.DOM.registerEvent(C.elmt,"mousedown",G);
SimileAjax.DOM.registerEvent(L.elmt,"mousedown",G);
this._createHighlightDiv(O,C,S);
this._eventIdToElmt[J.getID()]=C.elmt;
};
Timeline.DetailedEventPainter.prototype.paintImpreciseDurationEvent=function(L,P,W,S){var Z=this._timeline.getDocument();
var K=L.getText();
var D=L.getStart();
var Q=L.getLatestStart();
var T=L.getEnd();
var X=L.getEarliestEnd();
var B=Math.round(this._band.dateToPixelOffset(D));
var F=Math.round(this._band.dateToPixelOffset(Q));
var A=Math.round(this._band.dateToPixelOffset(T));
var G=Math.round(this._band.dateToPixelOffset(X));
var H=this._frc.computeSize(K);
var E=this._findFreeTrackForSolid(A);
var R=L.getColor();
R=R!=null?R:W.event.duration.color;
var O=this._paintEventTape(L,E,B,A,W.event.duration.impreciseColor,W.event.duration.impreciseOpacity,P,W);
var C=this._paintEventTape(L,E,F,G,R,100,P,W);
var J=this._getTrackData(E);
J.solid=B;
var Y=F+W.event.label.offsetFromLine;
var U=this._findFreeTrackForText(E,Y+H.width,function(a){a.line=F-2;
});
this._getTrackData(U).text=F-2;
this._paintEventLine(L,F,E,U,P,W);
var V=Math.round(P.trackOffset+U*P.trackIncrement+P.trackHeight/2-H.height/2);
var N=this._paintEventLabel(L,K,Y,V,H.width,H.height,W);
var M=this;
var I=function(a,b,c){return M._onClickDurationEvent(C.elmt,b,L);
};
SimileAjax.DOM.registerEvent(C.elmt,"mousedown",I);
SimileAjax.DOM.registerEvent(N.elmt,"mousedown",I);
this._createHighlightDiv(S,C,W);
this._eventIdToElmt[L.getID()]=C.elmt;
};
Timeline.DetailedEventPainter.prototype._findFreeTrackForSolid=function(B,A){for(var D=0;
true;
D++){if(D<this._lowerTracks.length){var C=this._lowerTracks[D];
if(Math.min(C.solid,C.text)>B&&(!(A)||C.line>A)){return D;
}}else{this._lowerTracks.push({solid:Number.POSITIVE_INFINITY,text:Number.POSITIVE_INFINITY,line:Number.POSITIVE_INFINITY});
return D;
}if(D<this._upperTracks.length){var C=this._upperTracks[D];
if(Math.min(C.solid,C.text)>B&&(!(A)||C.line>A)){return -1-D;
}}else{this._upperTracks.push({solid:Number.POSITIVE_INFINITY,text:Number.POSITIVE_INFINITY,line:Number.POSITIVE_INFINITY});
return -1-D;
}}};
Timeline.DetailedEventPainter.prototype._findFreeTrackForText=function(D,C,H){var F;
var G;
var B;
var J;
if(D<0){F=true;
B=-D;
G=this._findFreeUpperTrackForText(B,C);
J=-1-G;
}else{if(D>0){F=false;
B=D+1;
G=this._findFreeLowerTrackForText(B,C);
J=G;
}else{var A=this._findFreeUpperTrackForText(0,C);
var I=this._findFreeLowerTrackForText(1,C);
if(I-1<=A){F=false;
B=1;
G=I;
J=G;
}else{F=true;
B=0;
G=A;
J=-1-G;
}}}if(F){if(G==this._upperTracks.length){this._upperTracks.push({solid:Number.POSITIVE_INFINITY,text:Number.POSITIVE_INFINITY,line:Number.POSITIVE_INFINITY});
}for(var E=B;
E<G;
E++){H(this._upperTracks[E]);
}}else{if(G==this._lowerTracks.length){this._lowerTracks.push({solid:Number.POSITIVE_INFINITY,text:Number.POSITIVE_INFINITY,line:Number.POSITIVE_INFINITY});
}for(var E=B;
E<G;
E++){H(this._lowerTracks[E]);
}}return J;
};
Timeline.DetailedEventPainter.prototype._findFreeLowerTrackForText=function(A,C){for(;
A<this._lowerTracks.length;
A++){var B=this._lowerTracks[A];
if(Math.min(B.solid,B.text)>=C){break;
}}return A;
};
Timeline.DetailedEventPainter.prototype._findFreeUpperTrackForText=function(A,C){for(;
A<this._upperTracks.length;
A++){var B=this._upperTracks[A];
if(Math.min(B.solid,B.text)>=C){break;
}}return A;
};
Timeline.DetailedEventPainter.prototype._getTrackData=function(A){return(A<0)?this._upperTracks[-A-1]:this._lowerTracks[A];
};
Timeline.DetailedEventPainter.prototype._paintEventLine=function(I,C,F,A,G,D){var H=Math.round(G.trackOffset+F*G.trackIncrement+G.trackHeight/2);
var J=Math.round(Math.abs(A-F)*G.trackIncrement);
var E="1px solid "+D.event.label.lineColor;
var B=this._timeline.getDocument().createElement("div");
B.style.position="absolute";
B.style.left=C+"px";
B.style.width=D.event.label.offsetFromLine+"px";
B.style.height=J+"px";
if(F>A){B.style.top=(H-J)+"px";
B.style.borderTop=E;
}else{B.style.top=H+"px";
B.style.borderBottom=E;
}B.style.borderLeft=E;
this._lineLayer.appendChild(B);
};
Timeline.DetailedEventPainter.prototype._paintEventIcon=function(I,E,B,F,D){var H=I.getIcon();
H=H!=null?H:F.icon;
var J=F.trackOffset+E*F.trackIncrement+F.trackHeight/2;
var G=Math.round(J-F.iconHeight/2);
var C=SimileAjax.Graphics.createTranslucentImage(H);
var A=this._timeline.getDocument().createElement("div");
A.style.position="absolute";
A.style.left=B+"px";
A.style.top=G+"px";
A.appendChild(C);
A.style.cursor="pointer";
if(I._title!=null){A.title=I._title;
}this._eventLayer.appendChild(A);
return{left:B,top:G,width:F.iconWidth,height:F.iconHeight,elmt:A};
};
Timeline.DetailedEventPainter.prototype._paintEventLabel=function(H,I,B,F,A,J,D){var G=this._timeline.getDocument();
var K=G.createElement("div");
K.style.position="absolute";
K.style.left=B+"px";
K.style.width=A+"px";
K.style.top=F+"px";
K.style.height=J+"px";
K.style.backgroundColor=D.event.label.backgroundColor;
SimileAjax.Graphics.setOpacity(K,D.event.label.backgroundOpacity);
this._eventLayer.appendChild(K);
var E=G.createElement("div");
E.style.position="absolute";
E.style.left=B+"px";
E.style.width=A+"px";
E.style.top=F+"px";
E.innerHTML=I;
E.style.cursor="pointer";
if(H._title!=null){E.title=H._title;
}var C=H.getTextColor();
if(C==null){C=H.getColor();
}if(C!=null){E.style.color=C;
}this._eventLayer.appendChild(E);
return{left:B,top:F,width:A,height:J,elmt:E};
};
Timeline.DetailedEventPainter.prototype._paintEventTape=function(L,H,E,A,C,G,I,F){var B=A-E;
var D=F.event.tape.height;
var M=I.trackOffset+H*I.trackIncrement+I.trackHeight/2;
var J=Math.round(M-D/2);
var K=this._timeline.getDocument().createElement("div");
K.style.position="absolute";
K.style.left=E+"px";
K.style.width=B+"px";
K.style.top=J+"px";
K.style.height=D+"px";
K.style.backgroundColor=C;
K.style.overflow="hidden";
K.style.cursor="pointer";
if(L._title!=null){K.title=L._title;
}SimileAjax.Graphics.setOpacity(K,G);
this._eventLayer.appendChild(K);
return{left:E,top:J,width:B,height:D,elmt:K};
};
Timeline.DetailedEventPainter.prototype._createHighlightDiv=function(A,C,E){if(A>=0){var D=this._timeline.getDocument();
var G=E.event;
var B=G.highlightColors[Math.min(A,G.highlightColors.length-1)];
var F=D.createElement("div");
F.style.position="absolute";
F.style.overflow="hidden";
F.style.left=(C.left-2)+"px";
F.style.width=(C.width+4)+"px";
F.style.top=(C.top-2)+"px";
F.style.height=(C.height+4)+"px";
F.style.background=B;
this._highlightLayer.appendChild(F);
}};
Timeline.DetailedEventPainter.prototype._onClickInstantEvent=function(B,C,A){var D=SimileAjax.DOM.getPageCoordinates(B);
this._showBubble(D.left+Math.ceil(B.offsetWidth/2),D.top+Math.ceil(B.offsetHeight/2),A);
this._fireOnSelect(A.getID());
C.cancelBubble=true;
SimileAjax.DOM.cancelEvent(C);
return false;
};
Timeline.DetailedEventPainter.prototype._onClickDurationEvent=function(D,C,B){if("pageX" in C){var A=C.pageX;
var F=C.pageY;
}else{var E=SimileAjax.DOM.getPageCoordinates(D);
var A=C.offsetX+E.left;
var F=C.offsetY+E.top;
}this._showBubble(A,F,B);
this._fireOnSelect(B.getID());
C.cancelBubble=true;
SimileAjax.DOM.cancelEvent(C);
return false;
};
Timeline.DetailedEventPainter.prototype.showBubble=function(A){var B=this._eventIdToElmt[A.getID()];
if(B){var C=SimileAjax.DOM.getPageCoordinates(B);
this._showBubble(C.left+B.offsetWidth/2,C.top+B.offsetHeight/2,A);
}};
Timeline.DetailedEventPainter.prototype._showBubble=function(A,D,B){var C=document.createElement("div");
B.fillInfoBubble(C,this._params.theme,this._band.getLabeller());
SimileAjax.WindowManager.cancelPopups();
SimileAjax.Graphics.createBubbleForContentAndPoint(C,A,D,this._params.theme.event.bubble.width);
};
Timeline.DetailedEventPainter.prototype._fireOnSelect=function(B){for(var A=0;
A<this._onSelectListeners.length;
A++){this._onSelectListeners[A](B);
}};


/* ether-painters.js */
Timeline.GregorianEtherPainter=function(A){this._params=A;
this._theme=A.theme;
this._unit=A.unit;
this._multiple=("multiple" in A)?A.multiple:1;
};
Timeline.GregorianEtherPainter.prototype.initialize=function(C,B){this._band=C;
this._timeline=B;
this._backgroundLayer=C.createLayerDiv(0);
this._backgroundLayer.setAttribute("name","ether-background");
this._backgroundLayer.className="timeline-ether-bg";
this._markerLayer=null;
this._lineLayer=null;
var D=("align" in this._params&&this._params.align!=undefined)?this._params.align:this._theme.ether.interval.marker[B.isHorizontal()?"hAlign":"vAlign"];
var A=("showLine" in this._params)?this._params.showLine:this._theme.ether.interval.line.show;
this._intervalMarkerLayout=new Timeline.EtherIntervalMarkerLayout(this._timeline,this._band,this._theme,D,A);
this._highlight=new Timeline.EtherHighlight(this._timeline,this._band,this._theme,this._backgroundLayer);
};
Timeline.GregorianEtherPainter.prototype.setHighlight=function(A,B){this._highlight.position(A,B);
};
Timeline.GregorianEtherPainter.prototype.paint=function(){if(this._markerLayer){this._band.removeLayerDiv(this._markerLayer);
}this._markerLayer=this._band.createLayerDiv(100);
this._markerLayer.setAttribute("name","ether-markers");
this._markerLayer.style.display="none";
if(this._lineLayer){this._band.removeLayerDiv(this._lineLayer);
}this._lineLayer=this._band.createLayerDiv(1);
this._lineLayer.setAttribute("name","ether-lines");
this._lineLayer.style.display="none";
var C=this._band.getMinDate();
var F=this._band.getMaxDate();
var B=this._band.getTimeZone();
var E=this._band.getLabeller();
SimileAjax.DateTime.roundDownToInterval(C,this._unit,B,this._multiple,this._theme.firstDayOfWeek);
var D=this;
var A=function(G){for(var H=0;
H<D._multiple;
H++){SimileAjax.DateTime.incrementByInterval(G,D._unit);
}};
while(C.getTime()<F.getTime()){this._intervalMarkerLayout.createIntervalMarker(C,E,this._unit,this._markerLayer,this._lineLayer);
A(C);
}this._markerLayer.style.display="block";
this._lineLayer.style.display="block";
};
Timeline.GregorianEtherPainter.prototype.softPaint=function(){};
Timeline.GregorianEtherPainter.prototype.zoom=function(A){if(A!=0){this._unit+=A;
}};
Timeline.HotZoneGregorianEtherPainter=function(G){this._params=G;
this._theme=G.theme;
this._zones=[{startTime:Number.NEGATIVE_INFINITY,endTime:Number.POSITIVE_INFINITY,unit:G.unit,multiple:1}];
for(var E=0;
E<G.zones.length;
E++){var B=G.zones[E];
var D=SimileAjax.DateTime.parseGregorianDateTime(B.start).getTime();
var F=SimileAjax.DateTime.parseGregorianDateTime(B.end).getTime();
for(var C=0;
C<this._zones.length&&F>D;
C++){var A=this._zones[C];
if(D<A.endTime){if(D>A.startTime){this._zones.splice(C,0,{startTime:A.startTime,endTime:D,unit:A.unit,multiple:A.multiple});
C++;
A.startTime=D;
}if(F<A.endTime){this._zones.splice(C,0,{startTime:D,endTime:F,unit:B.unit,multiple:(B.multiple)?B.multiple:1});
C++;
A.startTime=F;
D=F;
}else{A.multiple=B.multiple;
A.unit=B.unit;
D=A.endTime;
}}}}};
Timeline.HotZoneGregorianEtherPainter.prototype.initialize=function(C,B){this._band=C;
this._timeline=B;
this._backgroundLayer=C.createLayerDiv(0);
this._backgroundLayer.setAttribute("name","ether-background");
this._backgroundLayer.className="timeline-ether-bg";
this._markerLayer=null;
this._lineLayer=null;
var D=("align" in this._params&&this._params.align!=undefined)?this._params.align:this._theme.ether.interval.marker[B.isHorizontal()?"hAlign":"vAlign"];
var A=("showLine" in this._params)?this._params.showLine:this._theme.ether.interval.line.show;
this._intervalMarkerLayout=new Timeline.EtherIntervalMarkerLayout(this._timeline,this._band,this._theme,D,A);
this._highlight=new Timeline.EtherHighlight(this._timeline,this._band,this._theme,this._backgroundLayer);
};
Timeline.HotZoneGregorianEtherPainter.prototype.setHighlight=function(A,B){this._highlight.position(A,B);
};
Timeline.HotZoneGregorianEtherPainter.prototype.paint=function(){if(this._markerLayer){this._band.removeLayerDiv(this._markerLayer);
}this._markerLayer=this._band.createLayerDiv(100);
this._markerLayer.setAttribute("name","ether-markers");
this._markerLayer.style.display="none";
if(this._lineLayer){this._band.removeLayerDiv(this._lineLayer);
}this._lineLayer=this._band.createLayerDiv(1);
this._lineLayer.setAttribute("name","ether-lines");
this._lineLayer.style.display="none";
var D=this._band.getMinDate();
var A=this._band.getMaxDate();
var K=this._band.getTimeZone();
var I=this._band.getLabeller();
var B=this;
var L=function(N,M){for(var O=0;
O<M.multiple;
O++){SimileAjax.DateTime.incrementByInterval(N,M.unit);
}};
var C=0;
while(C<this._zones.length){if(D.getTime()<this._zones[C].endTime){break;
}C++;
}var E=this._zones.length-1;
while(E>=0){if(A.getTime()>this._zones[E].startTime){break;
}E--;
}for(var H=C;
H<=E;
H++){var G=this._zones[H];
var J=new Date(Math.max(D.getTime(),G.startTime));
var F=new Date(Math.min(A.getTime(),G.endTime));
SimileAjax.DateTime.roundDownToInterval(J,G.unit,K,G.multiple,this._theme.firstDayOfWeek);
SimileAjax.DateTime.roundUpToInterval(F,G.unit,K,G.multiple,this._theme.firstDayOfWeek);
while(J.getTime()<F.getTime()){this._intervalMarkerLayout.createIntervalMarker(J,I,G.unit,this._markerLayer,this._lineLayer);
L(J,G);
}}this._markerLayer.style.display="block";
this._lineLayer.style.display="block";
};
Timeline.HotZoneGregorianEtherPainter.prototype.softPaint=function(){};
Timeline.HotZoneGregorianEtherPainter.prototype.zoom=function(B){if(B!=0){for(var A=0;
A<this._zones.length;
++A){if(this._zones[A]){this._zones[A].unit+=B;
}}}};
Timeline.YearCountEtherPainter=function(A){this._params=A;
this._theme=A.theme;
this._startDate=SimileAjax.DateTime.parseGregorianDateTime(A.startDate);
this._multiple=("multiple" in A)?A.multiple:1;
};
Timeline.YearCountEtherPainter.prototype.initialize=function(C,B){this._band=C;
this._timeline=B;
this._backgroundLayer=C.createLayerDiv(0);
this._backgroundLayer.setAttribute("name","ether-background");
this._backgroundLayer.className="timeline-ether-bg";
this._markerLayer=null;
this._lineLayer=null;
var D=("align" in this._params)?this._params.align:this._theme.ether.interval.marker[B.isHorizontal()?"hAlign":"vAlign"];
var A=("showLine" in this._params)?this._params.showLine:this._theme.ether.interval.line.show;
this._intervalMarkerLayout=new Timeline.EtherIntervalMarkerLayout(this._timeline,this._band,this._theme,D,A);
this._highlight=new Timeline.EtherHighlight(this._timeline,this._band,this._theme,this._backgroundLayer);
};
Timeline.YearCountEtherPainter.prototype.setHighlight=function(A,B){this._highlight.position(A,B);
};
Timeline.YearCountEtherPainter.prototype.paint=function(){if(this._markerLayer){this._band.removeLayerDiv(this._markerLayer);
}this._markerLayer=this._band.createLayerDiv(100);
this._markerLayer.setAttribute("name","ether-markers");
this._markerLayer.style.display="none";
if(this._lineLayer){this._band.removeLayerDiv(this._lineLayer);
}this._lineLayer=this._band.createLayerDiv(1);
this._lineLayer.setAttribute("name","ether-lines");
this._lineLayer.style.display="none";
var B=new Date(this._startDate.getTime());
var F=this._band.getMaxDate();
var E=this._band.getMinDate().getUTCFullYear()-this._startDate.getUTCFullYear();
B.setUTCFullYear(this._band.getMinDate().getUTCFullYear()-E%this._multiple);
var C=this;
var A=function(G){for(var H=0;
H<C._multiple;
H++){SimileAjax.DateTime.incrementByInterval(G,SimileAjax.DateTime.YEAR);
}};
var D={labelInterval:function(G,I){var H=G.getUTCFullYear()-C._startDate.getUTCFullYear();
return{text:H,emphasized:H==0};
}};
while(B.getTime()<F.getTime()){this._intervalMarkerLayout.createIntervalMarker(B,D,SimileAjax.DateTime.YEAR,this._markerLayer,this._lineLayer);
A(B);
}this._markerLayer.style.display="block";
this._lineLayer.style.display="block";
};
Timeline.YearCountEtherPainter.prototype.softPaint=function(){};
Timeline.QuarterlyEtherPainter=function(A){this._params=A;
this._theme=A.theme;
this._startDate=SimileAjax.DateTime.parseGregorianDateTime(A.startDate);
};
Timeline.QuarterlyEtherPainter.prototype.initialize=function(C,B){this._band=C;
this._timeline=B;
this._backgroundLayer=C.createLayerDiv(0);
this._backgroundLayer.setAttribute("name","ether-background");
this._backgroundLayer.className="timeline-ether-bg";
this._markerLayer=null;
this._lineLayer=null;
var D=("align" in this._params)?this._params.align:this._theme.ether.interval.marker[B.isHorizontal()?"hAlign":"vAlign"];
var A=("showLine" in this._params)?this._params.showLine:this._theme.ether.interval.line.show;
this._intervalMarkerLayout=new Timeline.EtherIntervalMarkerLayout(this._timeline,this._band,this._theme,D,A);
this._highlight=new Timeline.EtherHighlight(this._timeline,this._band,this._theme,this._backgroundLayer);
};
Timeline.QuarterlyEtherPainter.prototype.setHighlight=function(A,B){this._highlight.position(A,B);
};
Timeline.QuarterlyEtherPainter.prototype.paint=function(){if(this._markerLayer){this._band.removeLayerDiv(this._markerLayer);
}this._markerLayer=this._band.createLayerDiv(100);
this._markerLayer.setAttribute("name","ether-markers");
this._markerLayer.style.display="none";
if(this._lineLayer){this._band.removeLayerDiv(this._lineLayer);
}this._lineLayer=this._band.createLayerDiv(1);
this._lineLayer.setAttribute("name","ether-lines");
this._lineLayer.style.display="none";
var B=new Date(0);
var E=this._band.getMaxDate();
B.setUTCFullYear(Math.max(this._startDate.getUTCFullYear(),this._band.getMinDate().getUTCFullYear()));
B.setUTCMonth(this._startDate.getUTCMonth());
var C=this;
var A=function(F){F.setUTCMonth(F.getUTCMonth()+3);
};
var D={labelInterval:function(F,H){var G=(4+(F.getUTCMonth()-C._startDate.getUTCMonth())/3)%4;
if(G!=0){return{text:"Q"+(G+1),emphasized:false};
}else{return{text:"Y"+(F.getUTCFullYear()-C._startDate.getUTCFullYear()+1),emphasized:true};
}}};
while(B.getTime()<E.getTime()){this._intervalMarkerLayout.createIntervalMarker(B,D,SimileAjax.DateTime.YEAR,this._markerLayer,this._lineLayer);
A(B);
}this._markerLayer.style.display="block";
this._lineLayer.style.display="block";
};
Timeline.QuarterlyEtherPainter.prototype.softPaint=function(){};
Timeline.EtherIntervalMarkerLayout=function(M,L,C,E,H){var A=M.isHorizontal();
if(A){if(E=="Top"){this.positionDiv=function(O,N){O.style.left=N+"px";
O.style.top="0px";
};
}else{this.positionDiv=function(O,N){O.style.left=N+"px";
O.style.bottom="0px";
};
}}else{if(E=="Left"){this.positionDiv=function(O,N){O.style.top=N+"px";
O.style.left="0px";
};
}else{this.positionDiv=function(O,N){O.style.top=N+"px";
O.style.right="0px";
};
}}var D=C.ether.interval.marker;
var I=C.ether.interval.line;
var B=C.ether.interval.weekend;
var K=(A?"h":"v")+E;
var G=D[K+"Styler"];
var J=D[K+"EmphasizedStyler"];
var F=SimileAjax.DateTime.gregorianUnitLengths[SimileAjax.DateTime.DAY];
this.createIntervalMarker=function(T,a,b,c,Q){var U=Math.round(L.dateToPixelOffset(T));
if(H&&b!=SimileAjax.DateTime.WEEK){var V=M.getDocument().createElement("div");
V.className="timeline-ether-lines";
if(I.opacity<100){SimileAjax.Graphics.setOpacity(V,I.opacity);
}if(A){V.style.left=U+"px";
}else{V.style.top=U+"px";
}Q.appendChild(V);
}if(b==SimileAjax.DateTime.WEEK){var N=C.firstDayOfWeek;
var W=new Date(T.getTime()+(6-N-7)*F);
var Z=new Date(W.getTime()+2*F);
var X=Math.round(L.dateToPixelOffset(W));
var S=Math.round(L.dateToPixelOffset(Z));
var R=Math.max(1,S-X);
var P=M.getDocument().createElement("div");
P.className="timeline-ether-weekends";
if(B.opacity<100){SimileAjax.Graphics.setOpacity(P,B.opacity);
}if(A){P.style.left=X+"px";
P.style.width=R+"px";
}else{P.style.top=X+"px";
P.style.height=R+"px";
}Q.appendChild(P);
}var Y=a.labelInterval(T,b);
var O=M.getDocument().createElement("div");
O.innerHTML=Y.text;
O.className="timeline-date-label";
if(Y.emphasized){O.className+=" timeline-date-label-em";
}this.positionDiv(O,U);
c.appendChild(O);
return O;
};
};
Timeline.EtherHighlight=function(C,E,D,B){var A=C.isHorizontal();
this._highlightDiv=null;
this._createHighlightDiv=function(){if(this._highlightDiv==null){this._highlightDiv=C.getDocument().createElement("div");
this._highlightDiv.setAttribute("name","ether-highlight");
this._highlightDiv.className="timeline-ether-highlight";
var F=D.ether.highlightOpacity;
if(F<100){SimileAjax.Graphics.setOpacity(this._highlightDiv,F);
}B.appendChild(this._highlightDiv);
}};
this.position=function(F,I){this._createHighlightDiv();
var J=Math.round(E.dateToPixelOffset(F));
var H=Math.round(E.dateToPixelOffset(I));
var G=Math.max(H-J,3);
if(A){this._highlightDiv.style.left=J+"px";
this._highlightDiv.style.width=G+"px";
this._highlightDiv.style.height=(E.getViewWidth()-4)+"px";
}else{this._highlightDiv.style.top=J+"px";
this._highlightDiv.style.height=G+"px";
this._highlightDiv.style.width=(E.getViewWidth()-4)+"px";
}};
};


/* ethers.js */
Timeline.LinearEther=function(A){this._params=A;
this._interval=A.interval;
this._pixelsPerInterval=A.pixelsPerInterval;
};
Timeline.LinearEther.prototype.initialize=function(B,A){this._band=B;
this._timeline=A;
this._unit=A.getUnit();
if("startsOn" in this._params){this._start=this._unit.parseFromObject(this._params.startsOn);
}else{if("endsOn" in this._params){this._start=this._unit.parseFromObject(this._params.endsOn);
this.shiftPixels(-this._timeline.getPixelLength());
}else{if("centersOn" in this._params){this._start=this._unit.parseFromObject(this._params.centersOn);
this.shiftPixels(-this._timeline.getPixelLength()/2);
}else{this._start=this._unit.makeDefaultValue();
this.shiftPixels(-this._timeline.getPixelLength()/2);
}}}};
Timeline.LinearEther.prototype.setDate=function(A){this._start=this._unit.cloneValue(A);
};
Timeline.LinearEther.prototype.shiftPixels=function(B){var A=this._interval*B/this._pixelsPerInterval;
this._start=this._unit.change(this._start,A);
};
Timeline.LinearEther.prototype.dateToPixelOffset=function(A){var B=this._unit.compare(A,this._start);
return this._pixelsPerInterval*B/this._interval;
};
Timeline.LinearEther.prototype.pixelOffsetToDate=function(B){var A=B*this._interval/this._pixelsPerInterval;
return this._unit.change(this._start,A);
};
Timeline.LinearEther.prototype.zoom=function(D){var B=0;
var A=this._band._zoomIndex;
var C=A;
if(D&&(A>0)){C=A-1;
}if(!D&&(A<(this._band._zoomSteps.length-1))){C=A+1;
}this._band._zoomIndex=C;
this._interval=SimileAjax.DateTime.gregorianUnitLengths[this._band._zoomSteps[C].unit];
this._pixelsPerInterval=this._band._zoomSteps[C].pixelsPerInterval;
B=this._band._zoomSteps[C].unit-this._band._zoomSteps[A].unit;
return B;
};
Timeline.HotZoneEther=function(A){this._params=A;
this._interval=A.interval;
this._pixelsPerInterval=A.pixelsPerInterval;
this._theme=A.theme;
};
Timeline.HotZoneEther.prototype.initialize=function(H,I){this._band=H;
this._timeline=I;
this._unit=I.getUnit();
this._zones=[{startTime:Number.NEGATIVE_INFINITY,endTime:Number.POSITIVE_INFINITY,magnify:1}];
var B=this._params;
for(var D=0;
D<B.zones.length;
D++){var G=B.zones[D];
var E=this._unit.parseFromObject(G.start);
var F=this._unit.parseFromObject(G.end);
for(var C=0;
C<this._zones.length&&this._unit.compare(F,E)>0;
C++){var A=this._zones[C];
if(this._unit.compare(E,A.endTime)<0){if(this._unit.compare(E,A.startTime)>0){this._zones.splice(C,0,{startTime:A.startTime,endTime:E,magnify:A.magnify});
C++;
A.startTime=E;
}if(this._unit.compare(F,A.endTime)<0){this._zones.splice(C,0,{startTime:E,endTime:F,magnify:G.magnify*A.magnify});
C++;
A.startTime=F;
E=F;
}else{A.magnify*=G.magnify;
E=A.endTime;
}}}}if("startsOn" in this._params){this._start=this._unit.parseFromObject(this._params.startsOn);
}else{if("endsOn" in this._params){this._start=this._unit.parseFromObject(this._params.endsOn);
this.shiftPixels(-this._timeline.getPixelLength());
}else{if("centersOn" in this._params){this._start=this._unit.parseFromObject(this._params.centersOn);
this.shiftPixels(-this._timeline.getPixelLength()/2);
}else{this._start=this._unit.makeDefaultValue();
this.shiftPixels(-this._timeline.getPixelLength()/2);
}}}};
Timeline.HotZoneEther.prototype.setDate=function(A){this._start=this._unit.cloneValue(A);
};
Timeline.HotZoneEther.prototype.shiftPixels=function(A){this._start=this.pixelOffsetToDate(A);
};
Timeline.HotZoneEther.prototype.dateToPixelOffset=function(A){return this._dateDiffToPixelOffset(this._start,A);
};
Timeline.HotZoneEther.prototype.pixelOffsetToDate=function(A){return this._pixelOffsetToDate(A,this._start);
};
Timeline.HotZoneEther.prototype.zoom=function(D){var B=0;
var A=this._band._zoomIndex;
var C=A;
if(D&&(A>0)){C=A-1;
}if(!D&&(A<(this._band._zoomSteps.length-1))){C=A+1;
}this._band._zoomIndex=C;
this._interval=SimileAjax.DateTime.gregorianUnitLengths[this._band._zoomSteps[C].unit];
this._pixelsPerInterval=this._band._zoomSteps[C].pixelsPerInterval;
B=this._band._zoomSteps[C].unit-this._band._zoomSteps[A].unit;
return B;
};
Timeline.HotZoneEther.prototype._dateDiffToPixelOffset=function(I,D){var B=this._getScale();
var H=I;
var C=D;
var A=0;
if(this._unit.compare(H,C)<0){var G=0;
while(G<this._zones.length){if(this._unit.compare(H,this._zones[G].endTime)<0){break;
}G++;
}while(this._unit.compare(H,C)<0){var E=this._zones[G];
var F=this._unit.earlier(C,E.endTime);
A+=(this._unit.compare(F,H)/(B/E.magnify));
H=F;
G++;
}}else{var G=this._zones.length-1;
while(G>=0){if(this._unit.compare(H,this._zones[G].startTime)>0){break;
}G--;
}while(this._unit.compare(H,C)>0){var E=this._zones[G];
var F=this._unit.later(C,E.startTime);
A+=(this._unit.compare(F,H)/(B/E.magnify));
H=F;
G--;
}}return A;
};
Timeline.HotZoneEther.prototype._pixelOffsetToDate=function(H,C){var G=this._getScale();
var E=C;
if(H>0){var F=0;
while(F<this._zones.length){if(this._unit.compare(E,this._zones[F].endTime)<0){break;
}F++;
}while(H>0){var A=this._zones[F];
var D=G/A.magnify;
if(A.endTime==Number.POSITIVE_INFINITY){E=this._unit.change(E,H*D);
H=0;
}else{var B=this._unit.compare(A.endTime,E)/D;
if(B>H){E=this._unit.change(E,H*D);
H=0;
}else{E=A.endTime;
H-=B;
}}F++;
}}else{var F=this._zones.length-1;
while(F>=0){if(this._unit.compare(E,this._zones[F].startTime)>0){break;
}F--;
}H=-H;
while(H>0){var A=this._zones[F];
var D=G/A.magnify;
if(A.startTime==Number.NEGATIVE_INFINITY){E=this._unit.change(E,-H*D);
H=0;
}else{var B=this._unit.compare(E,A.startTime)/D;
if(B>H){E=this._unit.change(E,-H*D);
H=0;
}else{E=A.startTime;
H-=B;
}}F--;
}}return E;
};
Timeline.HotZoneEther.prototype._getScale=function(){return this._interval/this._pixelsPerInterval;
};


/* labellers.js */
Timeline.GregorianDateLabeller=function(A,B){this._locale=A;
this._timeZone=B;
};
Timeline.GregorianDateLabeller.monthNames=[];
Timeline.GregorianDateLabeller.dayNames=[];
Timeline.GregorianDateLabeller.labelIntervalFunctions=[];
Timeline.GregorianDateLabeller.getMonthName=function(B,A){return Timeline.GregorianDateLabeller.monthNames[A][B];
};
Timeline.GregorianDateLabeller.prototype.labelInterval=function(A,C){var B=Timeline.GregorianDateLabeller.labelIntervalFunctions[this._locale];
if(B==null){B=Timeline.GregorianDateLabeller.prototype.defaultLabelInterval;
}return B.call(this,A,C);
};
Timeline.GregorianDateLabeller.prototype.labelPrecise=function(A){return SimileAjax.DateTime.removeTimeZoneOffset(A,this._timeZone).toUTCString();
};
Timeline.GregorianDateLabeller.prototype.defaultLabelInterval=function(B,F){var C;
var E=false;
B=SimileAjax.DateTime.removeTimeZoneOffset(B,this._timeZone);
switch(F){case SimileAjax.DateTime.MILLISECOND:C=B.getUTCMilliseconds();
break;
case SimileAjax.DateTime.SECOND:C=B.getUTCSeconds();
break;
case SimileAjax.DateTime.MINUTE:var A=B.getUTCMinutes();
if(A==0){C=B.getUTCHours()+":00";
E=true;
}else{C=A;
}break;
case SimileAjax.DateTime.HOUR:C=B.getUTCHours()+"hr";
break;
case SimileAjax.DateTime.DAY:C=Timeline.GregorianDateLabeller.getMonthName(B.getUTCMonth(),this._locale)+" "+B.getUTCDate();
break;
case SimileAjax.DateTime.WEEK:C=Timeline.GregorianDateLabeller.getMonthName(B.getUTCMonth(),this._locale)+" "+B.getUTCDate();
break;
case SimileAjax.DateTime.MONTH:var A=B.getUTCMonth();
if(A!=0){C=Timeline.GregorianDateLabeller.getMonthName(A,this._locale);
break;
}case SimileAjax.DateTime.YEAR:case SimileAjax.DateTime.DECADE:case SimileAjax.DateTime.CENTURY:case SimileAjax.DateTime.MILLENNIUM:var D=B.getUTCFullYear();
if(D>0){C=B.getUTCFullYear();
}else{C=(1-D)+"BC";
}E=(F==SimileAjax.DateTime.MONTH)||(F==SimileAjax.DateTime.DECADE&&D%100==0)||(F==SimileAjax.DateTime.CENTURY&&D%1000==0);
break;
default:C=B.toUTCString();
}return{text:C,emphasized:E};
};


/* original-painter.js */
Timeline.OriginalEventPainter=function(A){this._params=A;
this._onSelectListeners=[];
this._filterMatcher=null;
this._highlightMatcher=null;
this._frc=null;
this._eventIdToElmt={};
};
Timeline.OriginalEventPainter.prototype.initialize=function(B,A){this._band=B;
this._timeline=A;
this._backLayer=null;
this._eventLayer=null;
this._lineLayer=null;
this._highlightLayer=null;
this._eventIdToElmt=null;
};
Timeline.OriginalEventPainter.prototype.addOnSelectListener=function(A){this._onSelectListeners.push(A);
};
Timeline.OriginalEventPainter.prototype.removeOnSelectListener=function(B){for(var A=0;
A<this._onSelectListeners.length;
A++){if(this._onSelectListeners[A]==B){this._onSelectListeners.splice(A,1);
break;
}}};
Timeline.OriginalEventPainter.prototype.getFilterMatcher=function(){return this._filterMatcher;
};
Timeline.OriginalEventPainter.prototype.setFilterMatcher=function(A){this._filterMatcher=A;
};
Timeline.OriginalEventPainter.prototype.getHighlightMatcher=function(){return this._highlightMatcher;
};
Timeline.OriginalEventPainter.prototype.setHighlightMatcher=function(A){this._highlightMatcher=A;
};
Timeline.OriginalEventPainter.prototype.paint=function(){var B=this._band.getEventSource();
if(B==null){return ;
}this._eventIdToElmt={};
this._prepareForPainting();
var I=this._params.theme.event;
var G=Math.max(I.track.height,I.tape.height+this._frc.getLineHeight());
var F={trackOffset:I.track.gap,trackHeight:G,trackGap:I.track.gap,trackIncrement:G+I.track.gap,icon:I.instant.icon,iconWidth:I.instant.iconWidth,iconHeight:I.instant.iconHeight,labelWidth:I.label.width};
var C=this._band.getMinDate();
var A=this._band.getMaxDate();
var J=(this._filterMatcher!=null)?this._filterMatcher:function(K){return true;
};
var E=(this._highlightMatcher!=null)?this._highlightMatcher:function(K){return -1;
};
var D=B.getEventReverseIterator(C,A);
while(D.hasNext()){var H=D.next();
if(J(H)){this.paintEvent(H,F,this._params.theme,E(H));
}}this._highlightLayer.style.display="block";
this._lineLayer.style.display="block";
this._eventLayer.style.display="block";
};
Timeline.OriginalEventPainter.prototype.softPaint=function(){};
Timeline.OriginalEventPainter.prototype._prepareForPainting=function(){var B=this._band;
if(this._backLayer==null){this._backLayer=this._band.createLayerDiv(0,"timeline-band-events");
this._backLayer.style.visibility="hidden";
var A=document.createElement("span");
A.className="timeline-event-label";
this._backLayer.appendChild(A);
this._frc=SimileAjax.Graphics.getFontRenderingContext(A);
}this._frc.update();
this._tracks=[];
if(this._highlightLayer!=null){B.removeLayerDiv(this._highlightLayer);
}this._highlightLayer=B.createLayerDiv(105,"timeline-band-highlights");
this._highlightLayer.style.display="none";
if(this._lineLayer!=null){B.removeLayerDiv(this._lineLayer);
}this._lineLayer=B.createLayerDiv(110,"timeline-band-lines");
this._lineLayer.style.display="none";
if(this._eventLayer!=null){B.removeLayerDiv(this._eventLayer);
}this._eventLayer=B.createLayerDiv(115,"timeline-band-events");
this._eventLayer.style.display="none";
};
Timeline.OriginalEventPainter.prototype.paintEvent=function(B,C,D,A){if(B.isInstant()){this.paintInstantEvent(B,C,D,A);
}else{this.paintDurationEvent(B,C,D,A);
}};
Timeline.OriginalEventPainter.prototype.paintInstantEvent=function(B,C,D,A){if(B.isImprecise()){this.paintImpreciseInstantEvent(B,C,D,A);
}else{this.paintPreciseInstantEvent(B,C,D,A);
}};
Timeline.OriginalEventPainter.prototype.paintDurationEvent=function(B,C,D,A){if(B.isImprecise()){this.paintImpreciseDurationEvent(B,C,D,A);
}else{this.paintPreciseDurationEvent(B,C,D,A);
}};
Timeline.OriginalEventPainter.prototype.paintPreciseInstantEvent=function(J,N,P,O){var S=this._timeline.getDocument();
var I=J.getText();
var E=J.getStart();
var C=Math.round(this._band.dateToPixelOffset(E));
var A=Math.round(C+N.iconWidth/2);
var H=Math.round(C-N.iconWidth/2);
var F=this._frc.computeSize(I);
var T=A+P.event.label.offsetFromLine;
var D=T+F.width;
var R=D;
var L=this._findFreeTrack(R);
var Q=Math.round(N.trackOffset+L*N.trackIncrement+N.trackHeight/2-F.height/2);
var B=this._paintEventIcon(J,L,H,N,P);
var M=this._paintEventLabel(J,I,T,Q,F.width,F.height,P);
var K=this;
var G=function(U,V,W){return K._onClickInstantEvent(B.elmt,V,J);
};
SimileAjax.DOM.registerEvent(B.elmt,"mousedown",G);
SimileAjax.DOM.registerEvent(M.elmt,"mousedown",G);
this._createHighlightDiv(O,B,P);
this._eventIdToElmt[J.getID()]=B.elmt;
this._tracks[L]=H;
};
Timeline.OriginalEventPainter.prototype.paintImpreciseInstantEvent=function(L,P,T,Q){var V=this._timeline.getDocument();
var K=L.getText();
var G=L.getStart();
var R=L.getEnd();
var D=Math.round(this._band.dateToPixelOffset(G));
var B=Math.round(this._band.dateToPixelOffset(R));
var A=Math.round(D+P.iconWidth/2);
var J=Math.round(D-P.iconWidth/2);
var H=this._frc.computeSize(K);
var W=A+T.event.label.offsetFromLine;
var E=W+H.width;
var U=Math.max(E,B);
var N=this._findFreeTrack(U);
var S=Math.round(P.trackOffset+N*P.trackIncrement+P.trackHeight/2-H.height/2);
var C=this._paintEventIcon(L,N,J,P,T);
var O=this._paintEventLabel(L,K,W,S,H.width,H.height,T);
var F=this._paintEventTape(L,N,D,B,T.event.instant.impreciseColor,T.event.instant.impreciseOpacity,P,T);
var M=this;
var I=function(X,Y,Z){return M._onClickInstantEvent(C.elmt,Y,L);
};
SimileAjax.DOM.registerEvent(C.elmt,"mousedown",I);
SimileAjax.DOM.registerEvent(F.elmt,"mousedown",I);
SimileAjax.DOM.registerEvent(O.elmt,"mousedown",I);
this._createHighlightDiv(Q,C,T);
this._eventIdToElmt[L.getID()]=C.elmt;
this._tracks[N]=J;
};
Timeline.OriginalEventPainter.prototype.paintPreciseDurationEvent=function(I,M,Q,O){var T=this._timeline.getDocument();
var H=I.getText();
var E=I.getStart();
var P=I.getEnd();
var B=Math.round(this._band.dateToPixelOffset(E));
var A=Math.round(this._band.dateToPixelOffset(P));
var F=this._frc.computeSize(H);
var U=B;
var C=U+F.width;
var S=Math.max(C,A);
var K=this._findFreeTrack(S);
var R=Math.round(M.trackOffset+K*M.trackIncrement+Q.event.tape.height);
var N=I.getColor();
N=N!=null?N:Q.event.duration.color;
var D=this._paintEventTape(I,K,B,A,N,100,M,Q);
var L=this._paintEventLabel(I,H,U,R,F.width,F.height,Q);
var J=this;
var G=function(V,W,X){return J._onClickDurationEvent(D.elmt,W,I);
};
SimileAjax.DOM.registerEvent(D.elmt,"mousedown",G);
SimileAjax.DOM.registerEvent(L.elmt,"mousedown",G);
this._createHighlightDiv(O,D,Q);
this._eventIdToElmt[I.getID()]=D.elmt;
this._tracks[K]=B;
};
Timeline.OriginalEventPainter.prototype.paintImpreciseDurationEvent=function(K,P,V,S){var Y=this._timeline.getDocument();
var J=K.getText();
var E=K.getStart();
var Q=K.getLatestStart();
var T=K.getEnd();
var X=K.getEarliestEnd();
var B=Math.round(this._band.dateToPixelOffset(E));
var F=Math.round(this._band.dateToPixelOffset(Q));
var A=Math.round(this._band.dateToPixelOffset(T));
var G=Math.round(this._band.dateToPixelOffset(X));
var H=this._frc.computeSize(J);
var Z=F;
var C=Z+H.width;
var W=Math.max(C,A);
var M=this._findFreeTrack(W);
var U=Math.round(P.trackOffset+M*P.trackIncrement+V.event.tape.height);
var R=K.getColor();
R=R!=null?R:V.event.duration.color;
var O=this._paintEventTape(K,M,B,A,V.event.duration.impreciseColor,V.event.duration.impreciseOpacity,P,V);
var D=this._paintEventTape(K,M,F,G,R,100,P,V);
var N=this._paintEventLabel(K,J,Z,U,H.width,H.height,V);
var L=this;
var I=function(a,b,c){return L._onClickDurationEvent(D.elmt,b,K);
};
SimileAjax.DOM.registerEvent(D.elmt,"mousedown",I);
SimileAjax.DOM.registerEvent(N.elmt,"mousedown",I);
this._createHighlightDiv(S,D,V);
this._eventIdToElmt[K.getID()]=D.elmt;
this._tracks[M]=B;
};
Timeline.OriginalEventPainter.prototype._findFreeTrack=function(A){for(var C=0;
C<this._tracks.length;
C++){var B=this._tracks[C];
if(B>A){break;
}}return C;
};
Timeline.OriginalEventPainter.prototype._paintEventIcon=function(I,E,B,F,D){var H=I.getIcon();
H=H!=null?H:F.icon;
var J=F.trackOffset+E*F.trackIncrement+F.trackHeight/2;
var G=Math.round(J-F.iconHeight/2);
var C=SimileAjax.Graphics.createTranslucentImage(H);
var A=this._timeline.getDocument().createElement("div");
A.className="timeline-event-icon";
A.style.left=B+"px";
A.style.top=G+"px";
A.appendChild(C);
if(I._title!=null){A.title=I._title;
}this._eventLayer.appendChild(A);
return{left:B,top:G,width:F.iconWidth,height:F.iconHeight,elmt:A};
};
Timeline.OriginalEventPainter.prototype._paintEventLabel=function(I,J,B,G,A,K,E){var H=this._timeline.getDocument();
var F=H.createElement("div");
F.className="timeline-event-label";
F.style.left=B+"px";
F.style.width=A+"px";
F.style.top=G+"px";
F.innerHTML=J;
if(I._title!=null){F.title=I._title;
}var D=I.getTextColor();
if(D==null){D=I.getColor();
}if(D!=null){F.style.color=D;
}var C=I.getClassName();
if(C){F.className+=" "+C;
}this._eventLayer.appendChild(F);
return{left:B,top:G,width:A,height:K,elmt:F};
};
Timeline.OriginalEventPainter.prototype._paintEventTape=function(L,H,E,A,C,G,I,F){var B=A-E;
var D=F.event.tape.height;
var J=I.trackOffset+H*I.trackIncrement;
var K=this._timeline.getDocument().createElement("div");
K.className="timeline-event-tape";
K.style.left=E+"px";
K.style.width=B+"px";
K.style.top=J+"px";
if(L._title!=null){K.title=L._title;
}SimileAjax.Graphics.setOpacity(K,G);
this._eventLayer.appendChild(K);
return{left:E,top:J,width:B,height:D,elmt:K};
};
Timeline.OriginalEventPainter.prototype._createHighlightDiv=function(A,C,E){if(A>=0){var D=this._timeline.getDocument();
var G=E.event;
var B=G.highlightColors[Math.min(A,G.highlightColors.length-1)];
var F=D.createElement("div");
F.style.position="absolute";
F.style.overflow="hidden";
F.style.left=(C.left-2)+"px";
F.style.width=(C.width+4)+"px";
F.style.top=(C.top-2)+"px";
F.style.height=(C.height+4)+"px";
this._highlightLayer.appendChild(F);
}};
Timeline.OriginalEventPainter.prototype._onClickInstantEvent=function(B,C,A){var D=SimileAjax.DOM.getPageCoordinates(B);
this._showBubble(D.left+Math.ceil(B.offsetWidth/2),D.top+Math.ceil(B.offsetHeight/2),A);
this._fireOnSelect(A.getID());
C.cancelBubble=true;
SimileAjax.DOM.cancelEvent(C);
return false;
};
Timeline.OriginalEventPainter.prototype._onClickDurationEvent=function(D,C,B){if("pageX" in C){var A=C.pageX;
var F=C.pageY;
}else{var E=SimileAjax.DOM.getPageCoordinates(D);
var A=C.offsetX+E.left;
var F=C.offsetY+E.top;
}this._showBubble(A,F,B);
this._fireOnSelect(B.getID());
C.cancelBubble=true;
SimileAjax.DOM.cancelEvent(C);
return false;
};
Timeline.OriginalEventPainter.prototype.showBubble=function(A){var B=this._eventIdToElmt[A.getID()];
if(B){var C=SimileAjax.DOM.getPageCoordinates(B);
this._showBubble(C.left+B.offsetWidth/2,C.top+B.offsetHeight/2,A);
}};
Timeline.OriginalEventPainter.prototype._showBubble=function(A,D,B){var C=document.createElement("div");
B.fillInfoBubble(C,this._params.theme,this._band.getLabeller());
SimileAjax.WindowManager.cancelPopups();
SimileAjax.Graphics.createBubbleForContentAndPoint(C,A,D,this._params.theme.event.bubble.width);
};
Timeline.OriginalEventPainter.prototype._fireOnSelect=function(B){for(var A=0;
A<this._onSelectListeners.length;
A++){this._onSelectListeners[A](B);
}};


/* overview-painter.js */
Timeline.OverviewEventPainter=function(A){this._params=A;
this._onSelectListeners=[];
this._filterMatcher=null;
this._highlightMatcher=null;
};
Timeline.OverviewEventPainter.prototype.initialize=function(B,A){this._band=B;
this._timeline=A;
this._eventLayer=null;
this._highlightLayer=null;
};
Timeline.OverviewEventPainter.prototype.addOnSelectListener=function(A){this._onSelectListeners.push(A);
};
Timeline.OverviewEventPainter.prototype.removeOnSelectListener=function(B){for(var A=0;
A<this._onSelectListeners.length;
A++){if(this._onSelectListeners[A]==B){this._onSelectListeners.splice(A,1);
break;
}}};
Timeline.OverviewEventPainter.prototype.getFilterMatcher=function(){return this._filterMatcher;
};
Timeline.OverviewEventPainter.prototype.setFilterMatcher=function(A){this._filterMatcher=A;
};
Timeline.OverviewEventPainter.prototype.getHighlightMatcher=function(){return this._highlightMatcher;
};
Timeline.OverviewEventPainter.prototype.setHighlightMatcher=function(A){this._highlightMatcher=A;
};
Timeline.OverviewEventPainter.prototype.paint=function(){var B=this._band.getEventSource();
if(B==null){return ;
}this._prepareForPainting();
var H=this._params.theme.event;
var F={trackOffset:H.overviewTrack.offset,trackHeight:H.overviewTrack.height,trackGap:H.overviewTrack.gap,trackIncrement:H.overviewTrack.height+H.overviewTrack.gap};
var C=this._band.getMinDate();
var A=this._band.getMaxDate();
var I=(this._filterMatcher!=null)?this._filterMatcher:function(J){return true;
};
var E=(this._highlightMatcher!=null)?this._highlightMatcher:function(J){return -1;
};
var D=B.getEventReverseIterator(C,A);
while(D.hasNext()){var G=D.next();
if(I(G)){this.paintEvent(G,F,this._params.theme,E(G));
}}this._highlightLayer.style.display="block";
this._eventLayer.style.display="block";
};
Timeline.OverviewEventPainter.prototype.softPaint=function(){};
Timeline.OverviewEventPainter.prototype._prepareForPainting=function(){var A=this._band;
this._tracks=[];
if(this._highlightLayer!=null){A.removeLayerDiv(this._highlightLayer);
}this._highlightLayer=A.createLayerDiv(105,"timeline-band-highlights");
this._highlightLayer.style.display="none";
if(this._eventLayer!=null){A.removeLayerDiv(this._eventLayer);
}this._eventLayer=A.createLayerDiv(110,"timeline-band-events");
this._eventLayer.style.display="none";
};
Timeline.OverviewEventPainter.prototype.paintEvent=function(B,C,D,A){if(B.isInstant()){this.paintInstantEvent(B,C,D,A);
}else{this.paintDurationEvent(B,C,D,A);
}};
Timeline.OverviewEventPainter.prototype.paintInstantEvent=function(C,F,G,B){var A=C.getStart();
var H=Math.round(this._band.dateToPixelOffset(A));
var D=C.getColor();
D=D!=null?D:G.event.duration.color;
var E=this._paintEventTick(C,H,D,100,F,G);
this._createHighlightDiv(B,E,G);
};
Timeline.OverviewEventPainter.prototype.paintDurationEvent=function(K,J,I,D){var A=K.getLatestStart();
var C=K.getEarliestEnd();
var B=Math.round(this._band.dateToPixelOffset(A));
var E=Math.round(this._band.dateToPixelOffset(C));
var H=0;
for(;
H<this._tracks.length;
H++){if(E<this._tracks[H]){break;
}}this._tracks[H]=E;
var G=K.getColor();
G=G!=null?G:I.event.duration.color;
var F=this._paintEventTape(K,H,B,E,G,100,J,I);
this._createHighlightDiv(D,F,I);
};
Timeline.OverviewEventPainter.prototype._paintEventTape=function(K,B,C,J,D,F,G,E){var H=G.trackOffset+B*G.trackIncrement;
var A=J-C;
var L=G.trackHeight;
var I=this._timeline.getDocument().createElement("div");
I.className="timeline-small-event-tape";
I.style.left=C+"px";
I.style.width=A+"px";
I.style.top=H+"px";
if(F<100){SimileAjax.Graphics.setOpacity(I,F);
}this._eventLayer.appendChild(I);
return{left:C,top:H,width:A,height:L,elmt:I};
};
Timeline.OverviewEventPainter.prototype._paintEventTick=function(J,B,D,F,G,E){var K=E.event.overviewTrack.tickHeight;
var H=G.trackOffset-K;
var A=1;
var I=this._timeline.getDocument().createElement("div");
I.className="timeline-small-event-icon";
I.style.left=B+"px";
I.style.top=H+"px";
var C=J.getClassName();
if(C){I.className+=" small-"+C;
}if(F<100){SimileAjax.Graphics.setOpacity(I,F);
}this._eventLayer.appendChild(I);
return{left:B,top:H,width:A,height:K,elmt:I};
};
Timeline.OverviewEventPainter.prototype._createHighlightDiv=function(A,C,E){if(A>=0){var D=this._timeline.getDocument();
var G=E.event;
var B=G.highlightColors[Math.min(A,G.highlightColors.length-1)];
var F=D.createElement("div");
F.style.position="absolute";
F.style.overflow="hidden";
F.style.left=(C.left-1)+"px";
F.style.width=(C.width+2)+"px";
F.style.top=(C.top-1)+"px";
F.style.height=(C.height+2)+"px";
F.style.background=B;
this._highlightLayer.appendChild(F);
}};
Timeline.OverviewEventPainter.prototype.showBubble=function(A){};


/* sources.js */
Timeline.DefaultEventSource=function(A){this._events=(A instanceof Object)?A:new SimileAjax.EventIndex();
this._listeners=[];
};
Timeline.DefaultEventSource.prototype.addListener=function(A){this._listeners.push(A);
};
Timeline.DefaultEventSource.prototype.removeListener=function(B){for(var A=0;
A<this._listeners.length;
A++){if(this._listeners[A]==B){this._listeners.splice(A,1);
break;
}}};
Timeline.DefaultEventSource.prototype.loadXML=function(F,A){var B=this._getBaseURL(A);
var G=F.documentElement.getAttribute("wiki-url");
var K=F.documentElement.getAttribute("wiki-section");
var D=F.documentElement.getAttribute("date-time-format");
var E=this._events.getUnit().getParser(D);
var C=F.documentElement.firstChild;
var H=false;
while(C!=null){if(C.nodeType==1){var J="";
if(C.firstChild!=null&&C.firstChild.nodeType==3){J=C.firstChild.nodeValue;
}var I=new Timeline.DefaultEventSource.Event(C.getAttribute("id"),E(C.getAttribute("start")),E(C.getAttribute("end")),E(C.getAttribute("latestStart")),E(C.getAttribute("earliestEnd")),C.getAttribute("isDuration")!="true",C.getAttribute("title"),J,this._resolveRelativeURL(C.getAttribute("image"),B),this._resolveRelativeURL(C.getAttribute("link"),B),this._resolveRelativeURL(C.getAttribute("icon"),B),C.getAttribute("color"),C.getAttribute("textColor"),C.getAttribute("classname"));
I._node=C;
I.getProperty=function(L){return this._node.getAttribute(L);
};
I.setWikiInfo(G,K);
this._events.add(I);
H=true;
}C=C.nextSibling;
}if(H){this._fire("onAddMany",[]);
}};
Timeline.DefaultEventSource.prototype.loadJSON=function(F,B){var C=this._getBaseURL(B);
var I=false;
if(F&&F.events){var H=("wikiURL" in F)?F.wikiURL:null;
var K=("wikiSection" in F)?F.wikiSection:null;
var D=("dateTimeFormat" in F)?F.dateTimeFormat:null;
var G=this._events.getUnit().getParser(D);
for(var E=0;
E<F.events.length;
E++){var A=F.events[E];
var J=new Timeline.DefaultEventSource.Event(("id" in A)?A.id:undefined,G(A.start),G(A.end),G(A.latestStart),G(A.earliestEnd),A.isDuration||false,A.title,A.description,this._resolveRelativeURL(A.image,C),this._resolveRelativeURL(A.link,C),this._resolveRelativeURL(A.icon,C),A.color,A.textColor,A.classname);
J._obj=A;
J.getProperty=function(L){return this._obj[L];
};
J.setWikiInfo(H,K);
this._events.add(J);
I=true;
}}if(I){this._fire("onAddMany",[]);
}};
Timeline.DefaultEventSource.prototype.loadSPARQL=function(G,A){var C=this._getBaseURL(A);
var E="iso8601";
var F=this._events.getUnit().getParser(E);
if(G==null){return ;
}var D=G.documentElement.firstChild;
while(D!=null&&(D.nodeType!=1||D.nodeName!="results")){D=D.nextSibling;
}var I=null;
var L=null;
if(D!=null){I=D.getAttribute("wiki-url");
L=D.getAttribute("wiki-section");
D=D.firstChild;
}var J=false;
while(D!=null){if(D.nodeType==1){var B={};
var H=D.firstChild;
while(H!=null){if(H.nodeType==1&&H.firstChild!=null&&H.firstChild.nodeType==1&&H.firstChild.firstChild!=null&&H.firstChild.firstChild.nodeType==3){B[H.getAttribute("name")]=H.firstChild.firstChild.nodeValue;
}H=H.nextSibling;
}if(B["start"]==null&&B["date"]!=null){B["start"]=B["date"];
}var K=new Timeline.DefaultEventSource.Event(B["id"],F(B["start"]),F(B["end"]),F(B["latestStart"]),F(B["earliestEnd"]),B["isDuration"]!="true",B["title"],B["description"],this._resolveRelativeURL(B["image"],C),this._resolveRelativeURL(B["link"],C),this._resolveRelativeURL(B["icon"],C),B["color"],B["textColor"],B["classname"]);
K._bindings=B;
K.getProperty=function(M){return this._bindings[M];
};
K.setWikiInfo(I,L);
this._events.add(K);
J=true;
}D=D.nextSibling;
}if(J){this._fire("onAddMany",[]);
}};
Timeline.DefaultEventSource.prototype.add=function(A){this._events.add(A);
this._fire("onAddOne",[A]);
};
Timeline.DefaultEventSource.prototype.addMany=function(B){for(var A=0;
A<B.length;
A++){this._events.add(B[A]);
}this._fire("onAddMany",[]);
};
Timeline.DefaultEventSource.prototype.clear=function(){this._events.removeAll();
this._fire("onClear",[]);
};
Timeline.DefaultEventSource.prototype.getEvent=function(A){return this._events.getEvent(A);
};
Timeline.DefaultEventSource.prototype.getEventIterator=function(A,B){return this._events.getIterator(A,B);
};
Timeline.DefaultEventSource.prototype.getEventReverseIterator=function(A,B){return this._events.getReverseIterator(A,B);
};
Timeline.DefaultEventSource.prototype.getAllEventIterator=function(){return this._events.getAllIterator();
};
Timeline.DefaultEventSource.prototype.getCount=function(){return this._events.getCount();
};
Timeline.DefaultEventSource.prototype.getEarliestDate=function(){return this._events.getEarliestDate();
};
Timeline.DefaultEventSource.prototype.getLatestDate=function(){return this._events.getLatestDate();
};
Timeline.DefaultEventSource.prototype._fire=function(B,A){for(var C=0;
C<this._listeners.length;
C++){var D=this._listeners[C];
if(B in D){try{D[B].apply(D,A);
}catch(E){SimileAjax.Debug.exception(E);
}}}};
Timeline.DefaultEventSource.prototype._getBaseURL=function(A){if(A.indexOf("://")<0){var C=this._getBaseURL(document.location.href);
if(A.substr(0,1)=="/"){A=C.substr(0,C.indexOf("/",C.indexOf("://")+3))+A;
}else{A=C+A;
}}var B=A.lastIndexOf("/");
if(B<0){return"";
}else{return A.substr(0,B+1);
}};
Timeline.DefaultEventSource.prototype._resolveRelativeURL=function(A,B){if(A==null||A==""){return A;
}else{if(A.indexOf("://")>0){return A;
}else{if(A.substr(0,1)=="/"){return B.substr(0,B.indexOf("/",B.indexOf("://")+3))+A;
}else{return B+A;
}}}};
Timeline.DefaultEventSource.Event=function(A,B,H,J,I,C,O,N,E,L,K,G,M,F,D){A=(A)?A.trim():"";
this._id=A.length>0?A:("e"+Math.floor(Math.random()*1000000));
this._instant=C||(H==null);
this._start=B;
this._end=(H!=null)?H:B;
this._latestStart=(J!=null)?J:(C?this._end:this._start);
this._earliestEnd=(I!=null)?I:(C?this._start:this._end);
this._text=SimileAjax.HTML.deEntify(O);
this._description=SimileAjax.HTML.deEntify(N);
this._image=(E!=null&&E!="")?E:null;
this._link=(L!=null&&L!="")?L:null;
this._title=(F!=null)?F:null;
this._icon=(K!=null&&K!="")?K:null;
this._color=(G!=null&&G!="")?G:null;
this._textColor=(M!=null&&M!="")?M:null;
this._classname=(D!=null&&D!="")?D:null;
this._wikiURL=null;
this._wikiSection=null;
};
Timeline.DefaultEventSource.Event.prototype={getID:function(){return this._id;
},isInstant:function(){return this._instant;
},isImprecise:function(){return this._start!=this._latestStart||this._end!=this._earliestEnd;
},getStart:function(){return this._start;
},getEnd:function(){return this._end;
},getLatestStart:function(){return this._latestStart;
},getEarliestEnd:function(){return this._earliestEnd;
},getText:function(){return this._text;
},getDescription:function(){return this._description;
},getImage:function(){return this._image;
},getLink:function(){return this._link;
},getIcon:function(){return this._icon;
},getColor:function(){return this._color;
},getTextColor:function(){return this._textColor;
},getClassName:function(){return this._classname;
},getProperty:function(A){return null;
},getWikiURL:function(){return this._wikiURL;
},getWikiSection:function(){return this._wikiSection;
},setWikiInfo:function(B,A){this._wikiURL=B;
this._wikiSection=A;
},fillDescription:function(A){A.innerHTML=this._description;
},fillWikiInfo:function(D){if(this._wikiURL!=null&&this._wikiSection!=null){var C=this.getProperty("wikiID");
if(C==null||C.length==0){C=this.getText();
}C=C.replace(/\s/g,"_");
var B=this._wikiURL+this._wikiSection.replace(/\s/g,"_")+"/"+C;
var A=document.createElement("a");
A.href=B;
A.target="new";
A.innerHTML=Timeline.strings[Timeline.clientLocale].wikiLinkLabel;
D.appendChild(document.createTextNode("["));
D.appendChild(A);
D.appendChild(document.createTextNode("]"));
}else{D.style.display="none";
}},fillTime:function(A,B){if(this._instant){if(this.isImprecise()){A.appendChild(A.ownerDocument.createTextNode(B.labelPrecise(this._start)));
A.appendChild(A.ownerDocument.createElement("br"));
A.appendChild(A.ownerDocument.createTextNode(B.labelPrecise(this._end)));
}else{A.appendChild(A.ownerDocument.createTextNode(B.labelPrecise(this._start)));
}}else{if(this.isImprecise()){A.appendChild(A.ownerDocument.createTextNode(B.labelPrecise(this._start)+" ~ "+B.labelPrecise(this._latestStart)));
A.appendChild(A.ownerDocument.createElement("br"));
A.appendChild(A.ownerDocument.createTextNode(B.labelPrecise(this._earliestEnd)+" ~ "+B.labelPrecise(this._end)));
}else{A.appendChild(A.ownerDocument.createTextNode(B.labelPrecise(this._start)));
A.appendChild(A.ownerDocument.createElement("br"));
A.appendChild(A.ownerDocument.createTextNode(B.labelPrecise(this._end)));
}}},fillInfoBubble:function(A,D,K){var L=A.ownerDocument;
var J=this.getText();
var H=this.getLink();
var C=this.getImage();
if(C!=null){var E=L.createElement("img");
E.src=C;
D.event.bubble.imageStyler(E);
A.appendChild(E);
}var M=L.createElement("div");
var B=L.createTextNode(J);
if(H!=null){var I=L.createElement("a");
I.href=H;
I.appendChild(B);
M.appendChild(I);
}else{M.appendChild(B);
}D.event.bubble.titleStyler(M);
A.appendChild(M);
var N=L.createElement("div");
this.fillDescription(N);
D.event.bubble.bodyStyler(N);
A.appendChild(N);
var G=L.createElement("div");
this.fillTime(G,K);
D.event.bubble.timeStyler(G);
A.appendChild(G);
var F=L.createElement("div");
this.fillWikiInfo(F);
D.event.bubble.wikiStyler(F);
A.appendChild(F);
}};


/* themes.js */
Timeline.ClassicTheme=new Object();
Timeline.ClassicTheme.implementations=[];
Timeline.ClassicTheme.create=function(A){if(A==null){A=Timeline.getDefaultLocale();
}var B=Timeline.ClassicTheme.implementations[A];
if(B==null){B=Timeline.ClassicTheme._Impl;
}return new B();
};
Timeline.ClassicTheme._Impl=function(){this.firstDayOfWeek=0;
this.ether={backgroundColors:[],highlightOpacity:50,interval:{line:{show:true,opacity:25},weekend:{opacity:30},marker:{hAlign:"Bottom",vAlign:"Right"}}};
this.event={track:{height:10,gap:2},overviewTrack:{offset:20,tickHeight:6,height:2,gap:1},tape:{height:4},instant:{icon:Timeline.urlPrefix+"images/dull-blue-circle.png",iconWidth:10,iconHeight:10,impreciseOpacity:20},duration:{impreciseOpacity:20},label:{backgroundOpacity:50,offsetFromLine:3},highlightColors:[],bubble:{width:250,height:125,titleStyler:function(A){A.className="timeline-event-bubble-title";
},bodyStyler:function(A){A.className="timeline-event-bubble-body";
},imageStyler:function(A){A.className="timeline-event-bubble-image";
},wikiStyler:function(A){A.className="timeline-event-bubble-wiki";
},timeStyler:function(A){A.className="timeline-event-bubble-time";
}}};
this.zoom=true;
};


/* timeline.js */
Timeline.strings={};
Timeline.getDefaultLocale=function(){return Timeline.clientLocale;
};
Timeline.create=function(C,B,A,D){return new Timeline._Impl(C,B,A,D);
};
Timeline.HORIZONTAL=0;
Timeline.VERTICAL=1;
Timeline._defaultTheme=null;
Timeline.createBandInfo=function(D){var E=("theme" in D)?D.theme:Timeline.getDefaultTheme();
var B=("eventSource" in D)?D.eventSource:null;
var F=new Timeline.LinearEther({centersOn:("date" in D)?D.date:new Date(),interval:SimileAjax.DateTime.gregorianUnitLengths[D.intervalUnit],pixelsPerInterval:D.intervalPixels,theme:E});
var G=new Timeline.GregorianEtherPainter({unit:D.intervalUnit,multiple:("multiple" in D)?D.multiple:1,theme:E,align:("align" in D)?D.align:undefined});
var I={showText:("showEventText" in D)?D.showEventText:true,theme:E};
if("eventPainterParams" in D){for(var A in D.eventPainterParams){I[A]=D.eventPainterParams[A];
}}if("trackHeight" in D){I.trackHeight=D.trackHeight;
}if("trackGap" in D){I.trackGap=D.trackGap;
}var H=("overview" in D&&D.overview)?"overview":("layout" in D?D.layout:"original");
var C;
if("eventPainter" in D){C=new D.eventPainter(I);
}else{switch(H){case"overview":C=new Timeline.OverviewEventPainter(I);
break;
case"detailed":C=new Timeline.DetailedEventPainter(I);
break;
default:C=new Timeline.OriginalEventPainter(I);
}}return{width:D.width,eventSource:B,timeZone:("timeZone" in D)?D.timeZone:0,ether:F,etherPainter:G,eventPainter:C,theme:E,zoomIndex:("zoomIndex" in D)?D.zoomIndex:0,zoomSteps:("zoomSteps" in D)?D.zoomSteps:null};
};
Timeline.createHotZoneBandInfo=function(D){var E=("theme" in D)?D.theme:Timeline.getDefaultTheme();
var B=("eventSource" in D)?D.eventSource:null;
var F=new Timeline.HotZoneEther({centersOn:("date" in D)?D.date:new Date(),interval:SimileAjax.DateTime.gregorianUnitLengths[D.intervalUnit],pixelsPerInterval:D.intervalPixels,zones:D.zones,theme:E});
var G=new Timeline.HotZoneGregorianEtherPainter({unit:D.intervalUnit,zones:D.zones,theme:E,align:("align" in D)?D.align:undefined});
var I={showText:("showEventText" in D)?D.showEventText:true,theme:E};
if("eventPainterParams" in D){for(var A in D.eventPainterParams){I[A]=D.eventPainterParams[A];
}}if("trackHeight" in D){I.trackHeight=D.trackHeight;
}if("trackGap" in D){I.trackGap=D.trackGap;
}var H=("overview" in D&&D.overview)?"overview":("layout" in D?D.layout:"original");
var C;
if("eventPainter" in D){C=new D.eventPainter(I);
}else{switch(H){case"overview":C=new Timeline.OverviewEventPainter(I);
break;
case"detailed":C=new Timeline.DetailedEventPainter(I);
break;
default:C=new Timeline.OriginalEventPainter(I);
}}return{width:D.width,eventSource:B,timeZone:("timeZone" in D)?D.timeZone:0,ether:F,etherPainter:G,eventPainter:C,theme:E,zoomIndex:("zoomIndex" in D)?D.zoomIndex:0,zoomSteps:("zoomSteps" in D)?D.zoomSteps:null};
};
Timeline.getDefaultTheme=function(){if(Timeline._defaultTheme==null){Timeline._defaultTheme=Timeline.ClassicTheme.create(Timeline.getDefaultLocale());
}return Timeline._defaultTheme;
};
Timeline.setDefaultTheme=function(A){Timeline._defaultTheme=A;
};
Timeline.loadXML=function(A,C){var D=function(G,E,F){alert("Failed to load data xml from "+A+"\n"+G);
};
var B=function(F){var E=F.responseXML;
if(!E.documentElement&&F.responseStream){E.load(F.responseStream);
}C(E,A);
};
SimileAjax.XmlHttp.get(A,D,B);
};
Timeline.loadJSON=function(url,f){var fError=function(statusText,status,xmlhttp){alert("Failed to load json data from "+url+"\n"+statusText);
};
var fDone=function(xmlhttp){f(eval("("+xmlhttp.responseText+")"),url);
};
SimileAjax.XmlHttp.get(url,fError,fDone);
};
Timeline._Impl=function(C,B,A,D){SimileAjax.WindowManager.initialize();
this._containerDiv=C;
this._bandInfos=B;
this._orientation=A==null?Timeline.HORIZONTAL:A;
this._unit=(D!=null)?D:SimileAjax.NativeDateUnit;
this._initialize();
};
Timeline._Impl.prototype.dispose=function(){for(var A=0;
A<this._bands.length;
A++){this._bands[A].dispose();
}this._bands=null;
this._bandInfos=null;
this._containerDiv.innerHTML="";
};
Timeline._Impl.prototype.getBandCount=function(){return this._bands.length;
};
Timeline._Impl.prototype.getBand=function(A){return this._bands[A];
};
Timeline._Impl.prototype.layout=function(){this._distributeWidths();
};
Timeline._Impl.prototype.paint=function(){for(var A=0;
A<this._bands.length;
A++){this._bands[A].paint();
}};
Timeline._Impl.prototype.getDocument=function(){return this._containerDiv.ownerDocument;
};
Timeline._Impl.prototype.addDiv=function(A){this._containerDiv.appendChild(A);
};
Timeline._Impl.prototype.removeDiv=function(A){this._containerDiv.removeChild(A);
};
Timeline._Impl.prototype.isHorizontal=function(){return this._orientation==Timeline.HORIZONTAL;
};
Timeline._Impl.prototype.isVertical=function(){return this._orientation==Timeline.VERTICAL;
};
Timeline._Impl.prototype.getPixelLength=function(){return this._orientation==Timeline.HORIZONTAL?this._containerDiv.offsetWidth:this._containerDiv.offsetHeight;
};
Timeline._Impl.prototype.getPixelWidth=function(){return this._orientation==Timeline.VERTICAL?this._containerDiv.offsetWidth:this._containerDiv.offsetHeight;
};
Timeline._Impl.prototype.getUnit=function(){return this._unit;
};
Timeline._Impl.prototype.loadXML=function(B,D){var A=this;
var E=function(H,F,G){alert("Failed to load data xml from "+B+"\n"+H);
A.hideLoadingMessage();
};
var C=function(G){try{var F=G.responseXML;
if(!F.documentElement&&G.responseStream){F.load(G.responseStream);
}D(F,B);
}finally{A.hideLoadingMessage();
}};
this.showLoadingMessage();
window.setTimeout(function(){SimileAjax.XmlHttp.get(B,E,C);
},0);
};
Timeline._Impl.prototype.loadJSON=function(url,f){var tl=this;
var fError=function(statusText,status,xmlhttp){alert("Failed to load json data from "+url+"\n"+statusText);
tl.hideLoadingMessage();
};
var fDone=function(xmlhttp){try{f(eval("("+xmlhttp.responseText+")"),url);
}finally{tl.hideLoadingMessage();
}};
this.showLoadingMessage();
window.setTimeout(function(){SimileAjax.XmlHttp.get(url,fError,fDone);
},0);
};
Timeline._Impl.prototype._initialize=function(){var H=this._containerDiv;
var E=H.ownerDocument;
H.className=H.className.split(" ").concat("timeline-container").join(" ");
var B=(this.isHorizontal())?"horizontal":"vertical";
H.className+=" timeline-"+B;
while(H.firstChild){H.removeChild(H.firstChild);
}var A=SimileAjax.Graphics.createTranslucentImage(Timeline.urlPrefix+(this.isHorizontal()?"images/copyright-vertical.png":"images/copyright.png"));
A.className="timeline-copyright";
A.title="Timeline (c) SIMILE - http://simile.mit.edu/timeline/";
SimileAjax.DOM.registerEvent(A,"click",function(){window.location="http://simile.mit.edu/timeline/";
});
H.appendChild(A);
this._bands=[];
for(var C=0;
C<this._bandInfos.length;
C++){var G=new Timeline._Band(this,this._bandInfos[C],C);
this._bands.push(G);
}this._distributeWidths();
for(var C=0;
C<this._bandInfos.length;
C++){var F=this._bandInfos[C];
if("syncWith" in F){this._bands[C].setSyncWithBand(this._bands[F.syncWith],("highlight" in F)?F.highlight:false);
}}var D=SimileAjax.Graphics.createMessageBubble(E);
D.containerDiv.className="timeline-message-container";
H.appendChild(D.containerDiv);
D.contentDiv.className="timeline-message";
D.contentDiv.innerHTML="<img src='"+Timeline.urlPrefix+"images/progress-running.gif' /> Loading...";
this.showLoadingMessage=function(){D.containerDiv.style.display="block";
};
this.hideLoadingMessage=function(){D.containerDiv.style.display="none";
};
};
Timeline._Impl.prototype._distributeWidths=function(){var B=this.getPixelLength();
var A=this.getPixelWidth();
var D=0;
for(var E=0;
E<this._bands.length;
E++){var I=this._bands[E];
var J=this._bandInfos[E];
var F=J.width;
var H=F.indexOf("%");
if(H>0){var G=parseInt(F.substr(0,H));
var C=G*A/100;
}else{var C=parseInt(F);
}I.setBandShiftAndWidth(D,C);
I.setViewLength(B);
D+=C;
}};
Timeline._Impl.prototype.zoom=function(G,B,F,D){var C=new RegExp("^timeline-band-([0-9]+)$");
var E=null;
var A=C.exec(D.id);
if(A){E=parseInt(A[1]);
}if(E!=null){this._bands[E].zoom(G,B,F,D);
}this.paint();
};
Timeline._Band=function(E,F,B){this._timeline=E;
this._bandInfo=F;
this._index=B;
this._locale=("locale" in F)?F.locale:Timeline.getDefaultLocale();
this._timeZone=("timeZone" in F)?F.timeZone:0;
this._labeller=("labeller" in F)?F.labeller:(("createLabeller" in E.getUnit())?E.getUnit().createLabeller(this._locale,this._timeZone):new Timeline.GregorianDateLabeller(this._locale,this._timeZone));
this._theme=F.theme;
this._zoomIndex=("zoomIndex" in F)?F.zoomIndex:0;
this._zoomSteps=("zoomSteps" in F)?F.zoomSteps:null;
this._dragging=false;
this._changing=false;
this._originalScrollSpeed=5;
this._scrollSpeed=this._originalScrollSpeed;
this._onScrollListeners=[];
var A=this;
this._syncWithBand=null;
this._syncWithBandHandler=function(G){A._onHighlightBandScroll();
};
this._selectorListener=function(G){A._onHighlightBandScroll();
};
var D=this._timeline.getDocument().createElement("div");
D.className="timeline-band-input";
this._timeline.addDiv(D);
this._keyboardInput=document.createElement("input");
this._keyboardInput.type="text";
D.appendChild(this._keyboardInput);
SimileAjax.DOM.registerEventWithObject(this._keyboardInput,"keydown",this,"_onKeyDown");
SimileAjax.DOM.registerEventWithObject(this._keyboardInput,"keyup",this,"_onKeyUp");
this._div=this._timeline.getDocument().createElement("div");
this._div.id="timeline-band-"+B;
this._div.className="timeline-band timeline-band-"+B;
this._timeline.addDiv(this._div);
SimileAjax.DOM.registerEventWithObject(this._div,"mousedown",this,"_onMouseDown");
SimileAjax.DOM.registerEventWithObject(this._div,"mousemove",this,"_onMouseMove");
SimileAjax.DOM.registerEventWithObject(this._div,"mouseup",this,"_onMouseUp");
SimileAjax.DOM.registerEventWithObject(this._div,"mouseout",this,"_onMouseOut");
SimileAjax.DOM.registerEventWithObject(this._div,"dblclick",this,"_onDblClick");
if(SimileAjax.Platform.browser.isFirefox){SimileAjax.DOM.registerEventWithObject(this._div,"DOMMouseScroll",this,"_onMouseScroll");
}else{SimileAjax.DOM.registerEventWithObject(this._div,"mousewheel",this,"_onMouseScroll");
}this._innerDiv=this._timeline.getDocument().createElement("div");
this._innerDiv.className="timeline-band-inner";
this._div.appendChild(this._innerDiv);
this._ether=F.ether;
F.ether.initialize(this,E);
this._etherPainter=F.etherPainter;
F.etherPainter.initialize(this,E);
this._eventSource=F.eventSource;
if(this._eventSource){this._eventListener={onAddMany:function(){A._onAddMany();
},onClear:function(){A._onClear();
}};
this._eventSource.addListener(this._eventListener);
}this._eventPainter=F.eventPainter;
F.eventPainter.initialize(this,E);
this._decorators=("decorators" in F)?F.decorators:[];
for(var C=0;
C<this._decorators.length;
C++){this._decorators[C].initialize(this,E);
}};
Timeline._Band.SCROLL_MULTIPLES=5;
Timeline._Band.prototype.dispose=function(){this.closeBubble();
if(this._eventSource){this._eventSource.removeListener(this._eventListener);
this._eventListener=null;
this._eventSource=null;
}this._timeline=null;
this._bandInfo=null;
this._labeller=null;
this._ether=null;
this._etherPainter=null;
this._eventPainter=null;
this._decorators=null;
this._onScrollListeners=null;
this._syncWithBandHandler=null;
this._selectorListener=null;
this._div=null;
this._innerDiv=null;
this._keyboardInput=null;
};
Timeline._Band.prototype.addOnScrollListener=function(A){this._onScrollListeners.push(A);
};
Timeline._Band.prototype.removeOnScrollListener=function(B){for(var A=0;
A<this._onScrollListeners.length;
A++){if(this._onScrollListeners[A]==B){this._onScrollListeners.splice(A,1);
break;
}}};
Timeline._Band.prototype.setSyncWithBand=function(B,A){if(this._syncWithBand){this._syncWithBand.removeOnScrollListener(this._syncWithBandHandler);
}this._syncWithBand=B;
this._syncWithBand.addOnScrollListener(this._syncWithBandHandler);
this._highlight=A;
this._positionHighlight();
};
Timeline._Band.prototype.getLocale=function(){return this._locale;
};
Timeline._Band.prototype.getTimeZone=function(){return this._timeZone;
};
Timeline._Band.prototype.getLabeller=function(){return this._labeller;
};
Timeline._Band.prototype.getIndex=function(){return this._index;
};
Timeline._Band.prototype.getEther=function(){return this._ether;
};
Timeline._Band.prototype.getEtherPainter=function(){return this._etherPainter;
};
Timeline._Band.prototype.getEventSource=function(){return this._eventSource;
};
Timeline._Band.prototype.getEventPainter=function(){return this._eventPainter;
};
Timeline._Band.prototype.layout=function(){this.paint();
};
Timeline._Band.prototype.paint=function(){this._etherPainter.paint();
this._paintDecorators();
this._paintEvents();
};
Timeline._Band.prototype.softLayout=function(){this.softPaint();
};
Timeline._Band.prototype.softPaint=function(){this._etherPainter.softPaint();
this._softPaintDecorators();
this._softPaintEvents();
};
Timeline._Band.prototype.setBandShiftAndWidth=function(A,D){var C=this._keyboardInput.parentNode;
var B=A+Math.floor(D/2);
if(this._timeline.isHorizontal()){this._div.style.top=A+"px";
this._div.style.height=D+"px";
C.style.top=B+"px";
C.style.left="-1em";
}else{this._div.style.left=A+"px";
this._div.style.width=D+"px";
C.style.left=B+"px";
C.style.top="-1em";
}};
Timeline._Band.prototype.getViewWidth=function(){if(this._timeline.isHorizontal()){return this._div.offsetHeight;
}else{return this._div.offsetWidth;
}};
Timeline._Band.prototype.setViewLength=function(A){this._viewLength=A;
this._recenterDiv();
this._onChanging();
};
Timeline._Band.prototype.getViewLength=function(){return this._viewLength;
};
Timeline._Band.prototype.getTotalViewLength=function(){return Timeline._Band.SCROLL_MULTIPLES*this._viewLength;
};
Timeline._Band.prototype.getViewOffset=function(){return this._viewOffset;
};
Timeline._Band.prototype.getMinDate=function(){return this._ether.pixelOffsetToDate(this._viewOffset);
};
Timeline._Band.prototype.getMaxDate=function(){return this._ether.pixelOffsetToDate(this._viewOffset+Timeline._Band.SCROLL_MULTIPLES*this._viewLength);
};
Timeline._Band.prototype.getMinVisibleDate=function(){return this._ether.pixelOffsetToDate(0);
};
Timeline._Band.prototype.getMaxVisibleDate=function(){return this._ether.pixelOffsetToDate(this._viewLength);
};
Timeline._Band.prototype.getCenterVisibleDate=function(){return this._ether.pixelOffsetToDate(this._viewLength/2);
};
Timeline._Band.prototype.setMinVisibleDate=function(A){if(!this._changing){this._moveEther(Math.round(-this._ether.dateToPixelOffset(A)));
}};
Timeline._Band.prototype.setMaxVisibleDate=function(A){if(!this._changing){this._moveEther(Math.round(this._viewLength-this._ether.dateToPixelOffset(A)));
}};
Timeline._Band.prototype.setCenterVisibleDate=function(A){if(!this._changing){this._moveEther(Math.round(this._viewLength/2-this._ether.dateToPixelOffset(A)));
}};
Timeline._Band.prototype.dateToPixelOffset=function(A){return this._ether.dateToPixelOffset(A)-this._viewOffset;
};
Timeline._Band.prototype.pixelOffsetToDate=function(A){return this._ether.pixelOffsetToDate(A+this._viewOffset);
};
Timeline._Band.prototype.createLayerDiv=function(D,B){var C=this._timeline.getDocument().createElement("div");
C.className="timeline-band-layer"+(typeof B=="string"?(" "+B):"");
C.style.zIndex=D;
this._innerDiv.appendChild(C);
var A=this._timeline.getDocument().createElement("div");
A.className="timeline-band-layer-inner";
if(SimileAjax.Platform.browser.isIE){A.style.cursor="move";
}else{A.style.cursor="-moz-grab";
}C.appendChild(A);
return A;
};
Timeline._Band.prototype.removeLayerDiv=function(A){this._innerDiv.removeChild(A.parentNode);
};
Timeline._Band.prototype.scrollToCenter=function(B,C){var A=this._ether.dateToPixelOffset(B);
if(A<-this._viewLength/2){this.setCenterVisibleDate(this.pixelOffsetToDate(A+this._viewLength));
}else{if(A>3*this._viewLength/2){this.setCenterVisibleDate(this.pixelOffsetToDate(A-this._viewLength));
}}this._autoScroll(Math.round(this._viewLength/2-this._ether.dateToPixelOffset(B)),C);
};
Timeline._Band.prototype.showBubbleForEvent=function(C){var A=this.getEventSource().getEvent(C);
if(A){var B=this;
this.scrollToCenter(A.getStart(),function(){B._eventPainter.showBubble(A);
});
}};
Timeline._Band.prototype.zoom=function(F,A,E,C){if(!this._theme.zoom||!this._zoomSteps){return ;
}A+=this._viewOffset;
var D=this._ether.pixelOffsetToDate(A);
var B=this._ether.zoom(F);
this._etherPainter.zoom(B);
this._moveEther(Math.round(-this._ether.dateToPixelOffset(D)));
this._moveEther(A);
};
Timeline._Band.prototype._onMouseDown=function(B,A,C){this.closeBubble();
this._dragging=true;
this._dragX=A.clientX;
this._dragY=A.clientY;
};
Timeline._Band.prototype._onMouseMove=function(D,A,E){if(this._dragging){var C=A.clientX-this._dragX;
var B=A.clientY-this._dragY;
this._dragX=A.clientX;
this._dragY=A.clientY;
this._moveEther(this._timeline.isHorizontal()?C:B);
this._positionHighlight();
}};
Timeline._Band.prototype._onMouseUp=function(B,A,C){this._dragging=false;
this._keyboardInput.focus();
};
Timeline._Band.prototype._onMouseOut=function(B,A,D){var C=SimileAjax.DOM.getEventRelativeCoordinates(A,B);
C.x+=this._viewOffset;
if(C.x<0||C.x>B.offsetWidth||C.y<0||C.y>B.offsetHeight){this._dragging=false;
}};
Timeline._Band.prototype._onMouseScroll=function(C,A,D){var B=new Date();
B=B.getTime();
if(!this._lastScrollTime||((B-this._lastScrollTime)>50)){this._lastScrollTime=B;
var G=0;
if(A.wheelDelta){G=A.wheelDelta/120;
}else{if(A.detail){G=-A.detail/3;
}}var E=SimileAjax.DOM.getEventRelativeCoordinates(A,C);
if(G!=0){var F;
if(G>0){F=true;
}if(G<0){F=false;
}this._timeline.zoom(F,E.x,E.y,C);
}}if(A.stopPropagation){A.stopPropagation();
}A.cancelBubble=true;
if(A.preventDefault){A.preventDefault();
}A.returnValue=false;
};
Timeline._Band.prototype._onDblClick=function(B,A,D){var C=SimileAjax.DOM.getEventRelativeCoordinates(A,B);
var E=C.x-(this._viewLength/2-this._viewOffset);
this._autoScroll(-E);
};
Timeline._Band.prototype._onKeyDown=function(B,A,C){if(!this._dragging){switch(A.keyCode){case 27:break;
case 37:case 38:this._scrollSpeed=Math.min(50,Math.abs(this._scrollSpeed*1.05));
this._moveEther(this._scrollSpeed);
break;
case 39:case 40:this._scrollSpeed=-Math.min(50,Math.abs(this._scrollSpeed*1.05));
this._moveEther(this._scrollSpeed);
break;
default:return true;
}this.closeBubble();
SimileAjax.DOM.cancelEvent(A);
return false;
}return true;
};
Timeline._Band.prototype._onKeyUp=function(B,A,C){if(!this._dragging){this._scrollSpeed=this._originalScrollSpeed;
switch(A.keyCode){case 35:this.setCenterVisibleDate(this._eventSource.getLatestDate());
break;
case 36:this.setCenterVisibleDate(this._eventSource.getEarliestDate());
break;
case 33:this._autoScroll(this._timeline.getPixelLength());
break;
case 34:this._autoScroll(-this._timeline.getPixelLength());
break;
default:return true;
}this.closeBubble();
SimileAjax.DOM.cancelEvent(A);
return false;
}return true;
};
Timeline._Band.prototype._autoScroll=function(D,C){var A=this;
var B=SimileAjax.Graphics.createAnimation(function(E,F){A._moveEther(F);
},0,D,1000,C);
B.run();
};
Timeline._Band.prototype._moveEther=function(A){this.closeBubble();
this._viewOffset+=A;
this._ether.shiftPixels(-A);
if(this._timeline.isHorizontal()){this._div.style.left=this._viewOffset+"px";
}else{this._div.style.top=this._viewOffset+"px";
}if(this._viewOffset>-this._viewLength*0.5||this._viewOffset<-this._viewLength*(Timeline._Band.SCROLL_MULTIPLES-1.5)){this._recenterDiv();
}else{this.softLayout();
}this._onChanging();
};
Timeline._Band.prototype._onChanging=function(){this._changing=true;
this._fireOnScroll();
this._setSyncWithBandDate();
this._changing=false;
};
Timeline._Band.prototype._fireOnScroll=function(){for(var A=0;
A<this._onScrollListeners.length;
A++){this._onScrollListeners[A](this);
}};
Timeline._Band.prototype._setSyncWithBandDate=function(){if(this._syncWithBand){var A=this._ether.pixelOffsetToDate(this.getViewLength()/2);
this._syncWithBand.setCenterVisibleDate(A);
}};
Timeline._Band.prototype._onHighlightBandScroll=function(){if(this._syncWithBand){var A=this._syncWithBand.getCenterVisibleDate();
var B=this._ether.dateToPixelOffset(A);
this._moveEther(Math.round(this._viewLength/2-B));
if(this._highlight){this._etherPainter.setHighlight(this._syncWithBand.getMinVisibleDate(),this._syncWithBand.getMaxVisibleDate());
}}};
Timeline._Band.prototype._onAddMany=function(){this._paintEvents();
};
Timeline._Band.prototype._onClear=function(){this._paintEvents();
};
Timeline._Band.prototype._positionHighlight=function(){if(this._syncWithBand){var A=this._syncWithBand.getMinVisibleDate();
var B=this._syncWithBand.getMaxVisibleDate();
if(this._highlight){this._etherPainter.setHighlight(A,B);
}}};
Timeline._Band.prototype._recenterDiv=function(){this._viewOffset=-this._viewLength*(Timeline._Band.SCROLL_MULTIPLES-1)/2;
if(this._timeline.isHorizontal()){this._div.style.left=this._viewOffset+"px";
this._div.style.width=(Timeline._Band.SCROLL_MULTIPLES*this._viewLength)+"px";
}else{this._div.style.top=this._viewOffset+"px";
this._div.style.height=(Timeline._Band.SCROLL_MULTIPLES*this._viewLength)+"px";
}this.layout();
};
Timeline._Band.prototype._paintEvents=function(){this._eventPainter.paint();
};
Timeline._Band.prototype._softPaintEvents=function(){this._eventPainter.softPaint();
};
Timeline._Band.prototype._paintDecorators=function(){for(var A=0;
A<this._decorators.length;
A++){this._decorators[A].paint();
}};
Timeline._Band.prototype._softPaintDecorators=function(){for(var A=0;
A<this._decorators.length;
A++){this._decorators[A].softPaint();
}};
Timeline._Band.prototype.closeBubble=function(){SimileAjax.WindowManager.cancelPopups();
};


/* units.js */
Timeline.NativeDateUnit=new Object();
Timeline.NativeDateUnit.createLabeller=function(A,B){return new Timeline.GregorianDateLabeller(A,B);
};
Timeline.NativeDateUnit.makeDefaultValue=function(){return new Date();
};
Timeline.NativeDateUnit.cloneValue=function(A){return new Date(A.getTime());
};
Timeline.NativeDateUnit.getParser=function(A){if(typeof A=="string"){A=A.toLowerCase();
}return(A=="iso8601"||A=="iso 8601")?Timeline.DateTime.parseIso8601DateTime:Timeline.DateTime.parseGregorianDateTime;
};
Timeline.NativeDateUnit.parseFromObject=function(A){return Timeline.DateTime.parseGregorianDateTime(A);
};
Timeline.NativeDateUnit.toNumber=function(A){return A.getTime();
};
Timeline.NativeDateUnit.fromNumber=function(A){return new Date(A);
};
Timeline.NativeDateUnit.compare=function(D,C){var B,A;
if(typeof D=="object"){B=D.getTime();
}else{B=Number(D);
}if(typeof C=="object"){A=C.getTime();
}else{A=Number(C);
}return B-A;
};
Timeline.NativeDateUnit.earlier=function(B,A){return Timeline.NativeDateUnit.compare(B,A)<0?B:A;
};
Timeline.NativeDateUnit.later=function(B,A){return Timeline.NativeDateUnit.compare(B,A)>0?B:A;
};
Timeline.NativeDateUnit.change=function(A,B){return new Date(A.getTime()+B);
};
