/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.legacy.taglib;

import java.text.MessageFormat;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.util.RequestUtils;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.gui.legacy.Constants;

/*
 * Exception performing whole class analysis ignored.
 */
public class Pagination
extends TagSupport {
    private static final Log log = LogFactory.getLog(Pagination.class);
    private String path;
    private JspWriter out;
    private PageList pageList;
    private String action;
    private boolean includeFirstLast = false;
    private boolean includePreviousNext = true;
    private String postfix = "";
    private int currentPage;
    private int totalPages;
    private int pageSize;

    public void release() {
        super.release();
        this.out = null;
        this.path = null;
        this.pageList = null;
        this.action = null;
    }

    public final int doStartTag() throws JspException {
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        JspWriter out = this.pageContext.getOut();
        if (this.pageList.size() == this.pageList.getTotalSize()) {
            return 0;
        }
        this.path = request.getContextPath();
        if (this.pageList.getPageControl() == null) {
            log.error((Object)"PageLists must have valid pageControls");
        }
        this.currentPage = this.pageList.getPageControl().getPageNumber() + 1;
        this.totalPages = this.pageSize == -1 ? 1 : (int)Math.ceil((double)this.pageList.getTotalSize() / (double)this.pageList.getPageControl().getPageSize());
        this.pageSize = this.pageList.getPageControl().getPageSize();
        try {
            out.write(this.createPagination());
        }
        catch (Exception e) {
            throw new JspException("could not generate output ", (Throwable)e);
        }
        return 0;
    }

    protected String createPagination() throws Exception {
        StringBuffer output = new StringBuffer();
        int sets = this.determineSets();
        output.append("<table border=\"0\" class=\"ToolbarContent\" >");
        output.append("<tr>");
        if (sets > 1) {
            output.append("<td align=\"right\" nowrap><b>");
            output.append(RequestUtils.message((PageContext)this.pageContext, null, null, (String)"ListToolbar.ListSetLabel", null));
            output.append("</b></td>");
            output.append("<td>");
            output.append(this.createSetListSelect(sets));
            output.append("</select>");
            output.append("</td>");
            output.append("<td><img src=");
            output.append(this.path);
            output.append(" \"/images/spacer.gif\" height=\"1\" width=\"10\" border=\"0\"></td>");
        }
        output.append("<td>");
        output.append(this.createDots(sets));
        output.append("</td>");
        output.append("</tr>");
        output.append("</table>");
        return output.toString();
    }

    protected String createSetListSelect(int sets) {
        StringBuffer msg = new StringBuffer();
        msg.append("<select name=\"").append("pn").append(this.postfix).append("\" size=\"1\" onchange=\"goToSelectLocation(this, '").append("pn").append(this.postfix).append("',  '").append(this.getAction()).append("');\">");
        for (int i = 0; i < sets; ++i) {
            int set = i * Constants.MAX_PAGES;
            msg.append("<option value=\"").append(set).append("\" ");
            if (this.currentPage >= set) {
                msg.append(" selected=\"selected\" ");
            }
            int display = i + 1;
            msg.append(">").append(display).append("</option>");
        }
        return msg.toString();
    }

    protected String createDots(int sets) {
        this.setAction(Pagination.removeExistingPaginationParams((String)this.getAction(), (String)this.postfix));
        int index = this.getAction().indexOf(63);
        String separator = index == -1 ? "?" : "&";
        MessageFormat form = new MessageFormat(this.getAction() + separator + "pn" + this.postfix + "={0}");
        int currentPage = this.pageList.getPageControl().getPageNumber();
        int pageCount = this.determinePageCount();
        int startPage = 0;
        int endPage = Constants.MAX_PAGES;
        int currentSet = currentPage / Constants.MAX_PAGES;
        if (sets >= 1 && (endPage = (startPage = currentSet * Constants.MAX_PAGES) + Constants.MAX_PAGES) > pageCount) {
            endPage = pageCount;
        }
        if (pageCount == 1 || pageCount == 0) {
            return "&nbsp;";
        }
        if (currentPage < Constants.MAX_PAGES && pageCount < endPage) {
            endPage = pageCount;
        }
        StringBuffer msg = new StringBuffer();
        StringBuffer pagMsg = new StringBuffer();
        pagMsg.append("&").append("sc" + this.postfix).append("=").append(this.pageList.getPageControl().getPrimarySortColumn()).append("&").append("so" + this.postfix).append("=").append(this.pageList.getPageControl().getPrimarySortOrder()).append("&").append("ps" + this.postfix).append("=").append(this.pageSize);
        if (currentPage == startPage) {
            msg.append("<td><img src=\"").append(this.path).append("/images/tbb_pageleft_gray.gif\" width=\"13\" height=\"16\" border=\"0\"/></td>");
        } else {
            Object[] objs = new Object[]{new Integer(currentPage - 1)};
            Object[] v1 = new Object[]{new Integer(1)};
            msg.append("<td><a href=\"").append(form.format(objs)).append(pagMsg.toString()).append("\">").append("<img src=\"").append(this.path).append("/images/tbb_pageleft.gif\" width=\"13\" height=\"16\" border=\"0\"/></a></td>");
        }
        int displayNumber = startPage;
        for (int i = startPage; i < endPage; ++i) {
            ++displayNumber;
            if (i == currentPage) {
                msg.append("<td>").append(displayNumber).append("</td>");
                continue;
            }
            Object[] v = new Object[]{new Integer(i)};
            msg.append("<td><a href=\"").append(form.format(v)).append(pagMsg.toString()).append("\">").append(displayNumber).append("</a></td>");
        }
        if (currentPage == endPage - 1) {
            msg.append("<td><img src=\"").append(this.path).append("/images/tbb_pageright_gray.gif\" width=\"13\" height=\"16\" border=\"0\"/></td>");
        } else {
            Object[] objs = new Object[]{new Integer(currentPage + 1)};
            Object[] v1 = new Object[]{new Integer(pageCount)};
            msg.append("<td><a href=\"").append(form.format(objs)).append(pagMsg.toString()).append("\"><img src=\"").append(this.path).append("/images/tbb_pageright.gif\" width=\"13\" height=\"16\" border=\"0\"/></a></td>");
        }
        return msg.toString();
    }

    public static String removeExistingPaginationParams(String originalActionString, String postfix) {
        int index = originalActionString.indexOf(63);
        if (index == -1) {
            return originalActionString;
        }
        String mainActionString = originalActionString.substring(0, index + 1);
        String queryParametersString = originalActionString.substring(index + 1);
        log.debug((Object)"Original query parameters");
        Pagination.alphaPrintParams((String)queryParametersString);
        String[] queryParametersArray = queryParametersString.split("&");
        StringBuilder newParameterString = new StringBuilder();
        for (int i = 0; i < queryParametersArray.length; ++i) {
            String currentParam = queryParametersArray[i];
            if (currentParam.startsWith("sc" + postfix) || currentParam.startsWith("so" + postfix) || currentParam.startsWith("ps" + postfix) || currentParam.startsWith("pn" + postfix)) continue;
            if (newParameterString.length() != 0) {
                newParameterString.append("&");
            }
            newParameterString.append(currentParam);
        }
        String newActionString = mainActionString + newParameterString.toString();
        log.debug((Object)"New query parameters");
        Pagination.alphaPrintParams((String)newParameterString.toString());
        return newActionString;
    }

    private static void alphaPrintParams(String value) {
        Object[] parameters = value.split("&");
        Arrays.sort(parameters);
        for (Object param : parameters) {
            log.debug((Object)("\t" + (String)param));
        }
        log.debug((Object)"\n");
    }

    private int determineSets() {
        int pageCount = this.determinePageCount();
        int div = pageCount / Constants.MAX_PAGES;
        int mod = pageCount % Constants.MAX_PAGES;
        int sets = mod == 0 ? div : div + 1;
        return sets;
    }

    private int getPageCount() {
        return (int)Math.ceil((double)this.pageList.getTotalSize() / (double)this.pageList.getPageControl().getPageSize());
    }

    private int determinePageCount() {
        int pageCount = 0;
        int size = this.pageList.getTotalSize();
        if (size == 0) {
            return 1;
        }
        int div = size / this.pageSize;
        int mod = size % this.pageSize;
        pageCount = mod == 0 ? div : div + 1;
        return pageCount;
    }

    public int doEndTag() throws JspException {
        this.release();
        return 6;
    }

    public PageList getPageList() {
        return this.pageList;
    }

    public void setPageList(PageList pageList) {
        this.pageList = pageList;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public boolean isIncludeFirstLast() {
        return this.includeFirstLast;
    }

    public void setIncludeFirstLast(boolean includeFirstLast) {
        this.includeFirstLast = includeFirstLast;
    }

    public boolean isIncludePreviousNext() {
        return this.includePreviousNext;
    }

    public void setIncludePreviousNext(boolean includePreviousNext) {
        this.includePreviousNext = includePreviousNext;
    }

    public String getPostfix() {
        return this.postfix;
    }

    public void setPostfix(String postfix) {
        this.postfix = postfix;
    }
}

