/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.legacy.action.resource.inventory;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.tiles.ComponentContext;
import org.apache.struts.tiles.actions.TilesAction;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.resource.InventoryStatus;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.gui.legacy.WebUser;
import org.rhq.enterprise.gui.legacy.util.RequestUtils;
import org.rhq.enterprise.gui.legacy.util.SessionUtils;
import org.rhq.enterprise.server.authz.PermissionException;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class ViewResourceAction
extends TilesAction {
    private final Log log = LogFactory.getLog(ViewResourceAction.class);

    public ActionForward execute(ComponentContext context, ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Resource resource = (Resource)request.getAttribute("Resource");
        if (resource == null) {
            RequestUtils.setError((HttpServletRequest)request, (String)"resource.platform.error.PlatformNotFound");
            return null;
        }
        this.log.info((Object)("Viewing resource " + resource + "..."));
        WebUser webUser = SessionUtils.getWebUser((HttpSession)request.getSession());
        Subject subject = webUser.getSubject();
        try {
            ResourceManagerLocal resourceManager = LookupUtil.getResourceManager();
            PageList childServers = resourceManager.findChildResourcesByCategoryAndInventoryStatus(subject, resource, ResourceCategory.SERVER, InventoryStatus.COMMITTED, PageControl.getUnlimitedInstance());
            request.setAttribute("ChildServers", (Object)childServers);
            PageList childServices = resourceManager.findChildResourcesByCategoryAndInventoryStatus(subject, resource, ResourceCategory.SERVICE, InventoryStatus.COMMITTED, PageControl.getUnlimitedInstance());
            request.setAttribute("ChildServices", (Object)childServices);
        }
        catch (PermissionException e) {
            RequestUtils.setError((HttpServletRequest)request, (String)"resource.platform.inventory.error.ViewServersPermission");
        }
        return null;
    }
}

