/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.legacy.action.resource.common.monitor.alerts.config.condition;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.validator.GenericValidator;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMessage;
import org.rhq.core.domain.alert.AlertCondition;
import org.rhq.core.domain.alert.AlertConditionCategory;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.measurement.MeasurementDefinition;
import org.rhq.core.domain.measurement.MeasurementUnits;
import org.rhq.core.domain.measurement.composite.MeasurementNumericValueAndUnits;
import org.rhq.core.domain.measurement.util.MeasurementConversionException;
import org.rhq.core.server.MeasurementConverter;
import org.rhq.core.server.MeasurementParser;
import org.rhq.core.util.NumberUtil;
import org.rhq.enterprise.gui.legacy.action.resource.common.monitor.alerts.config.ConditionBean;
import org.rhq.enterprise.gui.legacy.action.resource.common.monitor.alerts.config.condition.ConditionBeanConverterValidator;
import org.rhq.enterprise.server.measurement.MeasurementDefinitionManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class CallTimeDataConverterValidator
implements ConditionBeanConverterValidator {
    public static final String DOUBLE_REGEX = "[0-9,.]+";
    public static final String TYPE_ABS = "absolute";
    public static final String TYPE_CHG = "changed";
    private MeasurementDefinitionManagerLocal definitionManager = LookupUtil.getMeasurementDefinitionManager();

    public void exportProperties(Subject subject, ConditionBean fromBean, AlertCondition toCondition) {
        MeasurementDefinition definition = this.definitionManager.getMeasurementDefinition(subject, fromBean.getCallTimeMetricId().intValue());
        toCondition.setMeasurementDefinition(definition);
        if (fromBean.getThresholdType().equals(TYPE_ABS)) {
            MeasurementNumericValueAndUnits valueAndUnits = MeasurementParser.parse((String)fromBean.getCtAbsoluteValue(), (MeasurementUnits)definition.getUnits());
            toCondition.setThreshold(valueAndUnits.getValue());
            toCondition.setCategory(AlertConditionCategory.THRESHOLD);
            toCondition.setOption(fromBean.getCalltimeAbsOption());
            toCondition.setComparator(fromBean.getCalltimeComparator());
            toCondition.setName(fromBean.getCalltimeAbsPattern());
        } else if (fromBean.getThresholdType().equals(TYPE_CHG)) {
            MeasurementNumericValueAndUnits percentage = MeasurementParser.parse((String)fromBean.getCtPercentage(), (MeasurementUnits)MeasurementUnits.PERCENTAGE);
            toCondition.setThreshold(percentage.getValue());
            toCondition.setCategory(AlertConditionCategory.CHANGE);
            toCondition.setOption(fromBean.getCalltimeChgOption());
            toCondition.setName(fromBean.getCalltimeChgPattern());
            toCondition.setComparator(fromBean.getCalltimeChgOp());
        }
    }

    public void importProperties(Subject subject, AlertCondition fromCondition, ConditionBean toBean) {
        MeasurementDefinition definition = fromCondition.getMeasurementDefinition();
        toBean.setCallTimeMetricName(definition.getDisplayName());
        toBean.setCallTimeMetricId(Integer.valueOf(definition.getId()));
        toBean.setTrigger(this.getTriggerName());
        if (fromCondition.getCategory() == AlertConditionCategory.THRESHOLD) {
            toBean.setThresholdType(TYPE_ABS);
            toBean.setCalltimeAbsOption(fromCondition.getOption());
            toBean.setCalltimeAbsPattern(fromCondition.getName());
            try {
                String formattedValue = MeasurementConverter.format((Double)fromCondition.getThreshold(), (MeasurementUnits)definition.getUnits(), (boolean)true);
                toBean.setCtAbsoluteValue(formattedValue);
            }
            catch (MeasurementConversionException mce) {
                toBean.setCtAbsoluteValue("Conversion Error");
            }
            toBean.setCalltimeComparator(fromCondition.getComparator());
            toBean.setPercentageComparator(null);
        } else if (fromCondition.getCategory() == AlertConditionCategory.CHANGE) {
            toBean.setThresholdType(TYPE_CHG);
            toBean.setCalltimeChgOption(fromCondition.getOption());
            toBean.setCalltimeChgPattern(fromCondition.getName());
            toBean.setCalltimeChgOp(fromCondition.getComparator());
            Double threshold = MeasurementUnits.scaleUp((Double)fromCondition.getThreshold(), (MeasurementUnits)MeasurementUnits.PERCENTAGE);
            toBean.setCtPercentage(MeasurementConverter.format((Double)threshold, (MeasurementUnits)MeasurementUnits.NONE, (boolean)true));
            toBean.setCalltimeComparator(null);
        }
    }

    public boolean validate(ConditionBean bean, ActionErrors errors, int index) {
        if (bean.getCallTimeMetricId() <= 0) {
            ActionMessage err = new ActionMessage("alert.config.error.NoMetricSelected");
            errors.add("condition[" + index + "].callTimeMetricId", err);
            return false;
        }
        if (bean.getThresholdType().equals(TYPE_ABS)) {
            if (!GenericValidator.matchRegexp((String)bean.getCtAbsoluteValue(), (String)DOUBLE_REGEX)) {
                ActionMessage err = new ActionMessage("errors.double", (Object)"AbsoluteValue");
                errors.add("condition[" + index + "].ctAbsoluteValue", err);
                return false;
            }
            if (bean.getCalltimeAbsPattern() != null) {
                try {
                    Pattern p = Pattern.compile(bean.getCalltimeAbsPattern());
                }
                catch (PatternSyntaxException e) {
                    ActionMessage err = new ActionMessage("alert.config.error.CalltimePatternError");
                    errors.add("condition[" + index + "].calltimeAbsPattern", err);
                }
            }
        } else if (bean.getThresholdType().equals(TYPE_CHG)) {
            if (!GenericValidator.matchRegexp((String)bean.getCtPercentage(), (String)DOUBLE_REGEX)) {
                ActionMessage err = new ActionMessage("errors.double", (Object)"Percentage");
                errors.add("condition[" + index + "].ctPercentage", err);
                return false;
            }
            double percentage = NumberUtil.stringAsNumber((String)bean.getCtPercentage()).doubleValue();
            if (!GenericValidator.isInRange((double)percentage, (double)0.0, (double)1000.0)) {
                ActionMessage err = new ActionMessage("errors.range", (Object)String.valueOf(percentage), (Object)String.valueOf(0.0), (Object)String.valueOf(1000.0));
                errors.add("condition[" + index + "].ctPercentage", err);
                return false;
            }
            if (bean.getCalltimeChgPattern() != null) {
                try {
                    Pattern p = Pattern.compile(bean.getCalltimeChgPattern());
                }
                catch (PatternSyntaxException e) {
                    ActionMessage err = new ActionMessage("alert.config.error.CalltimePatternError");
                    errors.add("condition[" + index + "].calltimeChgPattern", err);
                }
            }
        }
        return true;
    }

    public String getTriggerName() {
        return "onCallTime";
    }
}

