/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.discovery;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.model.DataModel;
import javax.faces.model.SelectItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.resource.InventoryStatus;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.composite.DisambiguationReport;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.core.util.IntExtractor;
import org.rhq.enterprise.gui.common.framework.PagedDataTableUIBean;
import org.rhq.enterprise.gui.common.paging.PageControlView;
import org.rhq.enterprise.gui.discovery.AutoDiscoveryQueueUIBean;
import org.rhq.enterprise.gui.discovery.AutoDiscoverySessionUIBean;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.discovery.DiscoveryBossLocal;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class AutoDiscoveryQueueUIBean
extends PagedDataTableUIBean {
    private final Log log = LogFactory.getLog(AutoDiscoveryQueueUIBean.class);
    public static final String MANAGED_BEAN_NAME = "AutoDiscoveryQueueUIBean";
    private DiscoveryBossLocal discoveryBoss = LookupUtil.getDiscoveryBoss();
    private ResourceManagerLocal resourceManager = LookupUtil.getResourceManager();
    private Map<DisambiguationReport<Resource>, List<DisambiguationReport<Resource>>> platformsAndServers = new HashMap();
    private static final IntExtractor<Resource> RESOURCE_ID_EXTRACTOR = new /* Unavailable Anonymous Inner Class!! */;

    public DataModel getDataModel() {
        if (this.dataModel == null) {
            this.dataModel = new AutoDiscoveryQueueDataModel(this, PageControlView.AutoDiscoveryPlatformList, "AutoDiscoveryQueueUIBean");
        }
        return this.dataModel;
    }

    public SelectItem[] getPageSizes() {
        return new SelectItem[]{new SelectItem((Object)"10", "10"), new SelectItem((Object)"25", "25"), new SelectItem((Object)"50", "50"), new SelectItem((Object)"75", "75"), new SelectItem((Object)"100", "100")};
    }

    public int getMinimumPageSize() {
        return 10;
    }

    public Map<DisambiguationReport<Resource>, List<DisambiguationReport<Resource>>> getPlatformsAndServers() {
        return this.platformsAndServers;
    }

    public String rebuildTable() {
        this.getExpandedPlatforms().clear();
        this.getSelectedResources().clear();
        return "sort";
    }

    public String importResources() {
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        int platformCount = 0;
        int serverCount = 0;
        try {
            Map selectedResources = this.getSelectedResources();
            ArrayList<DisambiguationReport> platform = new ArrayList<DisambiguationReport>(1);
            for (Map.Entry selected : selectedResources.entrySet()) {
                DisambiguationReport resource = this.findResource((Integer)selected.getKey());
                if (resource == null || !((Boolean)selected.getValue()).booleanValue() || !this.platformsAndServers.containsKey(resource)) continue;
                platform.clear();
                platform.add(resource);
                if (((Resource)resource.getOriginal()).getInventoryStatus() == InventoryStatus.NEW) {
                    ++platformCount;
                }
                List allServers = (List)this.platformsAndServers.get(resource);
                ArrayList<DisambiguationReport> servers = new ArrayList<DisambiguationReport>();
                for (DisambiguationReport server : allServers) {
                    if (!selectedResources.containsKey(((Resource)server.getOriginal()).getId()) || !((Boolean)selectedResources.get(((Resource)server.getOriginal()).getId())).booleanValue() || ((Resource)server.getOriginal()).getInventoryStatus() != InventoryStatus.NEW) continue;
                    ++serverCount;
                    servers.add(server);
                }
                this.log.debug((Object)("AIQueue import: platform=" + platform + "| servers=" + servers));
                this.discoveryBoss.updateInventoryStatus(subject, AutoDiscoveryQueueUIBean.getOriginals(platform), AutoDiscoveryQueueUIBean.getOriginals(servers), InventoryStatus.COMMITTED);
            }
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)("Imported [" + platformCount + "] platforms and [" + serverCount + "] servers."));
            this.getSelectedResources().clear();
        }
        catch (Exception e) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"Import failed.", (Throwable)e);
            this.log.error((Object)"Import failed", (Throwable)e);
        }
        return "success";
    }

    public String ignoreResources() {
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        int serverCount = 0;
        try {
            ArrayList platform = new ArrayList(1);
            Map selectedResources = this.getSelectedResources();
            for (Map.Entry selected : selectedResources.entrySet()) {
                DisambiguationReport resource = this.findResource((Integer)selected.getKey());
                if (resource == null || !((Boolean)selected.getValue()).booleanValue() || !this.platformsAndServers.containsKey(resource)) continue;
                List allServers = (List)this.platformsAndServers.get(resource);
                ArrayList<DisambiguationReport> servers = new ArrayList<DisambiguationReport>();
                for (DisambiguationReport server : allServers) {
                    if (!selectedResources.containsKey(((Resource)server.getOriginal()).getId()) || !((Boolean)selectedResources.get(((Resource)server.getOriginal()).getId())).booleanValue() || ((Resource)server.getOriginal()).getInventoryStatus() != InventoryStatus.NEW) continue;
                    ++serverCount;
                    servers.add(server);
                }
                this.log.debug((Object)("AIQueue ignore: platform=" + platform + "| servers=" + servers));
                this.discoveryBoss.updateInventoryStatus(subject, AutoDiscoveryQueueUIBean.getOriginals(platform), AutoDiscoveryQueueUIBean.getOriginals(servers), InventoryStatus.IGNORED);
            }
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)("Ignored [" + serverCount + "] servers."));
            this.getSelectedResources().clear();
        }
        catch (Exception e) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"Ignore failed.", (Throwable)e);
            this.log.error((Object)"Ignore failed", (Throwable)e);
        }
        return "success";
    }

    public String unignoreResources() {
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        int serverCount = 0;
        try {
            ArrayList platform = new ArrayList(1);
            Map selectedResources = this.getSelectedResources();
            for (Map.Entry selected : selectedResources.entrySet()) {
                DisambiguationReport resource = this.findResource((Integer)selected.getKey());
                if (resource == null || !((Boolean)selected.getValue()).booleanValue() || !this.platformsAndServers.containsKey(resource)) continue;
                if (((Resource)resource.getOriginal()).getInventoryStatus() != InventoryStatus.COMMITTED) {
                    FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_WARN, (String)("Cannot un-ignore servers from an uncommitted platform [" + ((Resource)resource.getOriginal()).getName() + "]. Aborting."));
                    break;
                }
                List allServers = (List)this.platformsAndServers.get(resource);
                ArrayList<DisambiguationReport> servers = new ArrayList<DisambiguationReport>();
                for (DisambiguationReport server : allServers) {
                    if (!selectedResources.containsKey(((Resource)server.getOriginal()).getId()) || !((Boolean)selectedResources.get(((Resource)server.getOriginal()).getId())).booleanValue() || ((Resource)server.getOriginal()).getInventoryStatus() != InventoryStatus.IGNORED) continue;
                    ++serverCount;
                    servers.add(server);
                }
                this.log.debug((Object)("AIQueue unignore: platform=" + platform + "| servers=" + servers));
                this.discoveryBoss.updateInventoryStatus(subject, AutoDiscoveryQueueUIBean.getOriginals(platform), AutoDiscoveryQueueUIBean.getOriginals(servers), InventoryStatus.NEW);
            }
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)("Un-ignored [" + serverCount + "] servers."));
            this.getSelectedResources().clear();
        }
        catch (Exception e) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"Un-ignore failed.", (Throwable)e);
            this.log.error((Object)"Unignore failed", (Throwable)e);
        }
        return "success";
    }

    private Map<Integer, Boolean> getSelectedResources() {
        return ((AutoDiscoverySessionUIBean)FacesContextUtility.getManagedBean(AutoDiscoverySessionUIBean.class)).getSelectedResources();
    }

    private Map<Integer, Boolean> getExpandedPlatforms() {
        return ((AutoDiscoverySessionUIBean)FacesContextUtility.getManagedBean(AutoDiscoverySessionUIBean.class)).getExpandedMap();
    }

    private DisambiguationReport<Resource> findResource(Integer id) {
        for (Map.Entry entry : this.platformsAndServers.entrySet()) {
            DisambiguationReport platform = (DisambiguationReport)entry.getKey();
            List servers = (List)entry.getValue();
            if (((Resource)platform.getOriginal()).getId() == id.intValue()) {
                return platform;
            }
            for (DisambiguationReport server : servers) {
                if (((Resource)server.getOriginal()).getId() != id.intValue()) continue;
                return server;
            }
        }
        return null;
    }

    private EnumSet<InventoryStatus> getShowNewIgnoreEnumSet() {
        AutoDiscoverySessionUIBean bean = (AutoDiscoverySessionUIBean)FacesContextUtility.getManagedBean(AutoDiscoverySessionUIBean.class);
        String showNewIgnore = bean.getShowNewIgnore();
        if ("BOTH".equals(showNewIgnore)) {
            return EnumSet.of(InventoryStatus.NEW, InventoryStatus.IGNORED);
        }
        if (InventoryStatus.NEW.name().equals(showNewIgnore)) {
            return EnumSet.of(InventoryStatus.NEW);
        }
        if (InventoryStatus.IGNORED.name().equals(showNewIgnore)) {
            return EnumSet.of(InventoryStatus.IGNORED);
        }
        return EnumSet.of(InventoryStatus.NEW);
    }

    private static <T> List<T> getOriginals(List<DisambiguationReport<T>> reports) {
        ArrayList<Object> ret = new ArrayList<Object>();
        for (DisambiguationReport<T> report : reports) {
            ret.add(report.getOriginal());
        }
        return ret;
    }

    static /* synthetic */ EnumSet access$000(AutoDiscoveryQueueUIBean x0) {
        return x0.getShowNewIgnoreEnumSet();
    }

    static /* synthetic */ Map access$100(AutoDiscoveryQueueUIBean x0) {
        return x0.platformsAndServers;
    }

    static /* synthetic */ DiscoveryBossLocal access$200(AutoDiscoveryQueueUIBean x0) {
        return x0.discoveryBoss;
    }

    static /* synthetic */ IntExtractor access$300() {
        return RESOURCE_ID_EXTRACTOR;
    }

    static /* synthetic */ ResourceManagerLocal access$400(AutoDiscoveryQueueUIBean x0) {
        return x0.resourceManager;
    }

    static /* synthetic */ Map access$500(AutoDiscoveryQueueUIBean x0) {
        return x0.getExpandedPlatforms();
    }
}

