/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.configuration.resource;

import java.io.File;
import org.jboss.seam.core.Events;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.RawConfiguration;
import org.rhq.core.util.MessageDigestGenerator;

public class RawConfigUIBean {
    private RawConfiguration originalRawConfiguration;
    private RawConfiguration rawConfiguration;
    private String errorMessage;

    public RawConfigUIBean(RawConfiguration rawConfiguration) {
        this.rawConfiguration = rawConfiguration;
        this.originalRawConfiguration = rawConfiguration.deepCopy(false);
    }

    public void setRawConfiguration(RawConfiguration rawConfiguration) {
        this.rawConfiguration = rawConfiguration;
    }

    public boolean isModified() {
        return !this.rawConfiguration.getSha256().equals(this.originalRawConfiguration.getSha256());
    }

    public String getContents() {
        return this.rawConfiguration.getContents();
    }

    public void setContents(String contents) {
        Configuration configuration = this.rawConfiguration.getConfiguration();
        configuration.removeRawConfiguration(this.rawConfiguration);
        String sha256 = new MessageDigestGenerator("SHA-256").calcDigestString(contents);
        this.rawConfiguration.setContents(contents, sha256);
        configuration.addRawConfiguration(this.rawConfiguration);
        this.fireRawConfigUpdateEvent();
    }

    public void undoEdit() {
        this.setContents(this.originalRawConfiguration.getContents());
    }

    private void fireRawConfigUpdateEvent() {
        Events.instance().raiseEvent("rawConfigUpdate", new Object[]{this});
    }

    public String getPath() {
        return this.rawConfiguration.getPath();
    }

    public String getFileName() {
        File file = new File(this.rawConfiguration.getPath());
        return file.getName();
    }

    public String getErrorLabel() {
        if (this.errorMessage == null) {
            return " ";
        }
        return "View Errors";
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String msg) {
        this.errorMessage = msg;
    }

    public String getFileDisplayName() {
        if (this.isModified()) {
            return "* " + this.getFileName();
        }
        return this.getFileName();
    }

    public String getIcon() {
        if (this.isModified()) {
            return "/images/star_on_24.png";
        }
        return "/images/blank.png";
    }
}

