/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.common.tabbar;

import java.io.IOException;
import java.util.LinkedHashMap;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import org.rhq.core.gui.util.FacesComponentUtility;
import org.rhq.core.gui.util.UrlUtility;
import org.rhq.enterprise.gui.common.tabbar.SubtabComponent;
import org.rhq.enterprise.gui.common.tabbar.TabBarComponent;
import org.rhq.enterprise.gui.common.tabbar.TabComponent;

public class TabRenderer
extends Renderer {
    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        TabComponent tab = (TabComponent)component;
        this.processAttributes(tab);
        tab.setParameters(FacesComponentUtility.getParameters((UIComponent)tab));
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("td", (UIComponent)tab);
        writer.writeAttribute("style", (Object)"vertical-align: bottom;", null);
        if (!tab.isSelected()) {
            writer.startElement("a", (UIComponent)tab);
            writer.writeAttribute("style", (Object)"text-decoration: none;", null);
            writer.writeAttribute("href", (Object)this.buildURL(tab), "url");
        }
        writer.startElement("div", (UIComponent)tab);
        if (!tab.isSelected()) {
            writer.writeAttribute("class", (Object)"tab-inactive tab-common", null);
            writer.writeAttribute("onmouseover", (Object)"this.className='tab-hover tab-common'", null);
            writer.writeAttribute("onmouseout", (Object)"this.className='tab-inactive tab-common'", null);
        } else {
            writer.writeAttribute("class", (Object)"tab-active tab-common", null);
        }
        String imageUrl = tab.getImage();
        if (imageUrl != null) {
            writer.startElement("img", (UIComponent)tab);
            writer.writeAttribute("src", (Object)imageUrl, null);
            writer.endElement("img");
            writer.write(" ");
        }
        if (tab.getDisplayName() != null) {
            writer.write(tab.getDisplayName().toLowerCase());
        } else {
            writer.write(tab.getName().toLowerCase());
        }
        writer.endElement("div");
        if (!tab.isSelected()) {
            writer.endElement("a");
        }
        writer.endElement("td");
        writer.startElement("td", (UIComponent)tab);
        writer.writeAttribute("style", (Object)"vertical-align: bottom;", null);
        writer.startElement("div", (UIComponent)tab);
        String styleClass = "tab-spacer";
        writer.writeAttribute("class", (Object)styleClass, null);
        writer.writeAttribute("style", (Object)"width: 2px;", null);
        writer.write(" ");
        writer.endElement("div");
        writer.endElement("td");
    }

    private void processAttributes(TabComponent tab) {
        if (tab.getName() == null) {
            throw new IllegalStateException("The 'tab' element requires a 'name' attribute.");
        }
        if (tab.getUrl() == null && tab.getChildCount() == 0) {
            throw new IllegalStateException("The 'tab' element requires a 'url' attribute when it has no child 'subtab' elements.");
        }
    }

    private String buildURL(TabComponent tab) {
        String url;
        SubtabComponent defaultSubtab = null;
        if (tab.getSubtabs().isEmpty()) {
            url = tab.getUrl();
        } else {
            defaultSubtab = tab.getDefaultSubtab();
            assert (defaultSubtab != null);
            url = defaultSubtab.getUrl();
        }
        TabBarComponent tabBar = (TabBarComponent)tab.getParent();
        LinkedHashMap parameters = new LinkedHashMap(tabBar.getParameters());
        parameters.putAll(tab.getParameters());
        if (defaultSubtab != null) {
            defaultSubtab.setParameters(FacesComponentUtility.getParameters((UIComponent)defaultSubtab));
            parameters.putAll(defaultSubtab.getParameters());
        }
        url = UrlUtility.addParametersToQueryString((String)url, parameters);
        url = FacesContext.getCurrentInstance().getExternalContext().encodeResourceURL(url);
        return url;
    }
}

