/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.common.framework;

import com.sun.facelets.FaceletViewHandler;
import java.io.IOException;
import java.util.Map;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.core.gui.util.FacesExpressionUtility;
import org.rhq.enterprise.server.util.HibernatePerformanceMonitor;

public class FaceletRedirectionViewHandler
extends FaceletViewHandler {
    private static Log log = LogFactory.getLog(FaceletRedirectionViewHandler.class);

    public FaceletRedirectionViewHandler(ViewHandler handler) {
        super(handler);
    }

    public String getActionURL(FacesContext facesContext, String viewId) {
        ValueExpression valueExpression = FacesExpressionUtility.createValueExpression((String)viewId, String.class);
        String actionURL = (String)FacesExpressionUtility.getValue((ValueExpression)valueExpression, String.class);
        return actionURL;
    }

    public void renderView(FacesContext context, UIViewRoot viewToRender) throws IOException, FacesException {
        long monitorId = HibernatePerformanceMonitor.get().start();
        super.renderView(context, viewToRender);
        HibernatePerformanceMonitor.get().stop(monitorId, "URL " + this.getURL(viewToRender));
    }

    private String getURL(UIViewRoot viewToRender) {
        StringBuilder results = new StringBuilder(viewToRender.getViewId());
        boolean first = true;
        for (Map.Entry urlParam : viewToRender.getAttributes().entrySet()) {
            if (first) {
                results.append('?');
                first = false;
            } else {
                results.append('&');
            }
            results.append((String)urlParam.getKey()).append("=").append(urlParam.getValue());
        }
        return results.toString();
    }

    protected void handleRenderException(FacesContext context, Exception ex) throws IOException, ELException, FacesException {
        try {
            if (context.getViewRoot().getViewId().equals("/rhq/common/error.xhtml")) {
                log.error((Object)"Redirected back to ourselves, there must be a problem with the error.xhtml page", (Throwable)ex);
                super.handleRenderException(context, ex);
                return;
            }
            FacesContext facesContext = FacesContext.getCurrentInstance();
            ExternalContext externalContext = facesContext.getExternalContext();
            Map sessionMap = externalContext.getSessionMap();
            sessionMap.put("GLOBAL_RENDER_ERROR", ex);
            FacesContextUtility.getResponse().sendRedirect("/rhq/common/error.xhtml");
        }
        catch (IOException ioe) {
            log.fatal((Object)"Could not process redirect to handle application error", (Throwable)ioe);
        }
    }
}

