/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.admin.plugin;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.faces.application.FacesMessage;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.web.RequestParameter;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.plugin.AbstractPlugin;
import org.rhq.core.domain.plugin.PluginKey;
import org.rhq.core.domain.plugin.ServerPlugin;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.plugin.ServerPluginsLocal;
import org.rhq.enterprise.server.plugin.pc.ControlResults;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.enterprise.server.xmlschema.ControlDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Scope(value=ScopeType.CONVERSATION)
@Name(value="ServerPluginControlUIBean")
public class ServerPluginControlUIBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final ServerPluginsLocal serverPluginsBean = LookupUtil.getServerPlugins();
    @In(value="plugin")
    private AbstractPlugin abstractPlugin;
    @RequestParameter
    private String control;
    private ServerPlugin serverPlugin;
    private String serverPluginType;
    private String serverPluginName;
    private PluginKey serverPluginKey;
    private List<ControlDefinition> serverPluginControlDefinitions;
    private Configuration params;
    private ControlResults results;

    @Create
    public void init() throws Exception {
        this.serverPlugin = (ServerPlugin)this.abstractPlugin;
        this.serverPluginType = this.serverPlugin.getType();
        this.serverPluginName = this.serverPlugin.getName();
        this.serverPluginKey = PluginKey.createServerPluginKey((String)this.serverPluginType, (String)this.serverPluginName);
        ArrayList defs = new ArrayList();
        if (this.getPermission()) {
            defs.addAll(this.serverPluginsBean.getServerPluginControlDefinitions(this.serverPluginKey));
        }
        this.serverPluginControlDefinitions = defs;
        this.setSelectedControl(this.control);
    }

    public PluginKey getServerPluginKey() {
        return this.serverPluginKey;
    }

    public ServerPlugin getServerPlugin() {
        return this.serverPlugin;
    }

    public void setSelectedControl(String controlName) {
        if (controlName != null) {
            this.control = controlName;
            this.params = this.getParamsDefinition() != null ? this.getParamsDefinition().getDefaultTemplate().createConfiguration() : null;
        } else {
            this.control = null;
            this.params = null;
        }
        this.results = null;
    }

    public List<String[]> getControls() throws Exception {
        if (this.serverPluginControlDefinitions == null) {
            return null;
        }
        ArrayList<String[]> items = new ArrayList<String[]>();
        for (ControlDefinition def : this.serverPluginControlDefinitions) {
            items.add(new String[]{def.getName(), def.getDisplayName(), def.getDescription()});
        }
        return items;
    }

    public Configuration getParamsConfiguration() {
        return this.params;
    }

    public ConfigurationDefinition getParamsDefinition() {
        if (this.serverPluginControlDefinitions != null) {
            for (ControlDefinition def : this.serverPluginControlDefinitions) {
                if (!def.getName().equals(this.control)) continue;
                ConfigurationDefinition paramsDef = def.getParameters();
                return paramsDef;
            }
        }
        return null;
    }

    public boolean getResultsAvailable() {
        return this.results != null;
    }

    public ConfigurationDefinition getResultsDefinition() {
        if (this.serverPluginControlDefinitions != null) {
            for (ControlDefinition def : this.serverPluginControlDefinitions) {
                if (!def.getName().equals(this.control)) continue;
                ConfigurationDefinition resultsDef = def.getResults();
                return resultsDef;
            }
        }
        return null;
    }

    public Configuration getResultsConfiguration() {
        return this.results != null ? this.results.getComplexResults() : null;
    }

    public String getResultsError() {
        return this.results != null ? this.results.getError() : null;
    }

    public String invokeControl() {
        try {
            this.results = this.serverPluginsBean.invokeServerPluginControl(this.serverPluginKey, this.control, this.getParamsConfiguration());
            if (this.results.isSuccess()) {
                FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)"Plugin invoked the control operation successfully");
            } else {
                FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)("Plugin reported an error: " + this.results.getError()));
            }
        }
        catch (Exception e) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"Failed to invoke the plugin control", (Throwable)e);
        }
        return "success";
    }

    public boolean getPermission() throws Exception {
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        return LookupUtil.getAuthorizationManager().hasGlobalPermission(subject, Permission.MANAGE_SETTINGS);
    }
}

