/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.admin.plugin;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.web.RequestParameter;
import org.rhq.core.domain.plugin.PluginKey;
import org.rhq.core.domain.plugin.ServerPlugin;
import org.rhq.enterprise.gui.admin.plugin.AbstractPluginConfigurationUIBean;
import org.rhq.enterprise.server.plugin.pc.ServerPluginType;
import org.richfaces.component.UITree;
import org.richfaces.component.html.HtmlTree;
import org.richfaces.event.NodeSelectedEvent;
import org.richfaces.model.TreeNode;
import org.richfaces.model.TreeNodeImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Scope(value=ScopeType.PAGE)
@Name(value="pluginConfigUIBean")
public class PluginConfigurationUIBean
extends AbstractPluginConfigurationUIBean
implements Serializable {
    @RequestParameter
    private String pluginName;
    private TreeNode root;

    public TreeNode getRoot() {
        return this.root;
    }

    @Create
    public void init() {
        this.checkPermission();
        this.createTree();
    }

    private void createTree() {
        this.root = new TreeNodeImpl();
        Map types = this.serverPluginsBean.getInstalledServerPluginsGroupedByType();
        for (ServerPluginType type : types.keySet()) {
            TreeNode typeNode = this.createTypeNode(type, (List)types.get(type));
            if (typeNode == null) continue;
            typeNode.setParent(this.root);
            this.root.addChild((Object)type, typeNode);
        }
    }

    private TreeNode createTypeNode(ServerPluginType type, List<PluginKey> plugins) {
        TreeNodeImpl typeNode = new TreeNodeImpl();
        typeNode.setData((Object)type);
        if (plugins != null && plugins.size() > 0) {
            for (PluginKey pluginKey : plugins) {
                TreeNode pluginNode = this.createPluginNode(pluginKey);
                pluginNode.setParent((TreeNode)typeNode);
                typeNode.addChild((Object)pluginKey, pluginNode);
            }
        }
        return typeNode;
    }

    private TreeNode createPluginNode(PluginKey pluginKey) {
        ServerPlugin plugin = this.serverPluginsBean.getServerPlugin(pluginKey);
        plugin = this.serverPluginsBean.getServerPluginRelationships(plugin);
        TreeNodeImpl pluginNode = new TreeNodeImpl();
        pluginNode.setData((Object)plugin);
        return pluginNode;
    }

    public boolean adviseOpened(UITree node) {
        return true;
    }

    public boolean adviseSelected(UITree node) {
        if (this.isServerPluginSelected(node)) {
            if (this.getPlugin() != null) {
                return node.getRowData() == this.getPlugin();
            }
            ServerPlugin plugin = (ServerPlugin)node.getRowData();
            if (plugin.getName().equals(this.pluginName)) {
                this.setPlugin(plugin);
                this.lookupConfigDefinitions();
                return true;
            }
        }
        return false;
    }

    public void processSelection(NodeSelectedEvent event) {
        HtmlTree node = (HtmlTree)event.getSource();
        if (this.isServerPluginSelected((UITree)node)) {
            this.setPlugin((ServerPlugin)node.getRowData());
            this.lookupConfigDefinitions();
            node.setSelected();
        }
    }

    private boolean isServerPluginSelected(UITree tree) {
        return tree.getRowData() instanceof ServerPlugin;
    }
}

