/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.platform;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.event.Event;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.plugins.platform.SyslogProcessor;

public class SyslogListenerEventLogDelegate
extends SyslogProcessor
implements Runnable {
    private final Log log = LogFactory.getLog(SyslogListenerEventLogDelegate.class);
    private String host;
    private int port;
    private ServerSocket serverSocket;
    private Thread thread;
    private boolean run = true;

    public SyslogListenerEventLogDelegate(ResourceContext resourceContext, PropertyMap logProperties) {
        super(resourceContext, logProperties, "port#" + SyslogListenerEventLogDelegate.getPortFromPropertyMap(logProperties));
        this.host = logProperties.getSimpleValue("logTrackingBindAddress", "127.0.0.1");
        this.port = SyslogListenerEventLogDelegate.getPortFromPropertyMap(logProperties);
        try {
            this.thread = new Thread((Runnable)this, "Syslog Listener-" + this.host + ':' + this.port);
            this.thread.setDaemon(true);
            this.serverSocket = new ServerSocket(this.port, 100, InetAddress.getByName(this.host));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed attempt to bind syslog listener.", e);
        }
        this.thread.start();
    }

    private static Integer getPortFromPropertyMap(PropertyMap logProperties) {
        return logProperties.getSimple("logTrackingPort").getIntegerValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.run) {
            try {
                Socket socket = this.serverSocket.accept();
                BufferedReader reader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                String line = reader.readLine();
                try {
                    while (this.run && line != null) {
                        Event e = this.convertLine(line);
                        if (e != null) {
                            this.getEventContext().publishEvent(e);
                        }
                        line = reader.readLine();
                    }
                }
                finally {
                    try {
                        socket.close();
                    }
                    catch (Throwable t) {
                        this.log.debug((Object)("Failed to close syslog input socket stream: " + t));
                    }
                }
            }
            catch (Exception e) {
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)("Failed to read syslog message: " + e));
            }
        }
    }

    public void shutdown() {
        this.run = false;
        this.thread.interrupt();
        try {
            this.serverSocket.close();
        }
        catch (Throwable t) {
            this.log.warn((Object)("Failed to close syslog listener server socket: " + t));
        }
    }
}

