/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.platform;

import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.hyperic.sigar.Cpu;
import org.hyperic.sigar.CpuInfo;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.pluginapi.util.ObjectUtil;
import org.rhq.core.system.CpuInformation;
import org.rhq.plugins.platform.PlatformComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CpuComponent
implements ResourceComponent<PlatformComponent>,
MeasurementFacet {
    private CpuInformation cpuInformation = null;
    private CpuEntry startCpuEntry = null;
    private Map<String, CpuEntry> cpuCache;

    public void start(ResourceContext<PlatformComponent> resourceContext) {
        if (resourceContext.getSystemInformation().isNative()) {
            this.cpuInformation = resourceContext.getSystemInformation().getCpu(Integer.parseInt(resourceContext.getResourceKey()));
            this.cpuCache = new HashMap<String, CpuEntry>();
            this.startCpuEntry = new CpuEntry(this.cpuInformation.getCpu());
        }
    }

    public void stop() {
    }

    public AvailabilityType getAvailability() {
        if (this.cpuInformation != null) {
            this.cpuInformation.refresh();
            return this.cpuInformation.isEnabled() ? AvailabilityType.UP : AvailabilityType.DOWN;
        }
        return AvailabilityType.UP;
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) {
        if (this.cpuInformation != null) {
            this.cpuInformation.refresh();
            Cpu cpu = null;
            CpuEntry currentCpu = null;
            CpuInfo cpuInfo = null;
            for (MeasurementScheduleRequest request : metrics) {
                Object o;
                String property = request.getName();
                if (property.startsWith("Cpu.")) {
                    Long longValue;
                    if (cpu == null) {
                        cpu = this.cpuInformation.getCpu();
                    }
                    if ((longValue = (Long)ObjectUtil.lookupAttributeProperty((Object)cpu, (String)(property = property.substring(property.indexOf(".") + 1)))) == null || longValue == -1L) continue;
                    report.addData(new MeasurementDataNumeric(request, Double.valueOf(longValue.doubleValue())));
                    continue;
                }
                if (property.startsWith("CpuPerc.")) {
                    CpuEntry previousCpu;
                    if (null == cpu) {
                        cpu = this.cpuInformation.getCpu();
                    }
                    if (null == currentCpu) {
                        currentCpu = new CpuEntry(cpu);
                    }
                    previousCpu = null == (previousCpu = (CpuEntry)this.cpuCache.put(property, currentCpu)) ? this.startCpuEntry : previousCpu;
                    Number num = null;
                    long deltaTime = currentCpu.getTimestamp() - previousCpu.getTimestamp();
                    if (deltaTime <= 2L * request.getInterval()) {
                        num = this.getPercentage(previousCpu.getCpu(), cpu, property);
                    }
                    if (num == null) continue;
                    report.addData(new MeasurementDataNumeric(request, Double.valueOf(num.doubleValue())));
                    continue;
                }
                if (property.startsWith("CpuInfo.")) {
                    Number num;
                    if (cpuInfo == null) {
                        cpuInfo = this.cpuInformation.getCpuInfo();
                    }
                    if ((num = (Number)ObjectUtil.lookupAttributeProperty((Object)cpuInfo, (String)(property = property.substring(property.indexOf(".") + 1)))) == null) continue;
                    report.addData(new MeasurementDataNumeric(request, Double.valueOf(num.doubleValue())));
                    continue;
                }
                if (!property.startsWith("CpuTrait.")) continue;
                if (cpuInfo == null) {
                    cpuInfo = this.cpuInformation.getCpuInfo();
                }
                if ((o = ObjectUtil.lookupAttributeProperty((Object)cpuInfo, (String)(property = property.substring(property.indexOf(".") + 1)))) == null) continue;
                String res = "model".equals(property) || "vendor".equals(property) ? (String)o : String.valueOf(o);
                report.addData(new MeasurementDataTrait(request, res));
            }
        }
    }

    private Number getPercentage(Cpu prev, Cpu curr, String property) {
        Double result = 0.0;
        double diff_user = curr.getUser() - prev.getUser();
        double diff_sys = curr.getSys() - prev.getSys();
        double diff_nice = curr.getNice() - prev.getNice();
        double diff_idle = curr.getIdle() - prev.getIdle();
        double diff_wait = curr.getWait() - prev.getWait();
        double diff_irq = curr.getIrq() - prev.getIrq();
        double diff_soft_irq = curr.getSoftIrq() - prev.getSoftIrq();
        double diff_stolen = curr.getStolen() - prev.getStolen();
        diff_user = diff_user < 0.0 ? 0.0 : diff_user;
        diff_sys = diff_sys < 0.0 ? 0.0 : diff_sys;
        diff_nice = diff_nice < 0.0 ? 0.0 : diff_nice;
        diff_idle = diff_idle < 0.0 ? 0.0 : diff_idle;
        diff_wait = diff_wait < 0.0 ? 0.0 : diff_wait;
        diff_irq = diff_irq < 0.0 ? 0.0 : diff_irq;
        diff_soft_irq = diff_soft_irq < 0.0 ? 0.0 : diff_soft_irq;
        diff_stolen = diff_stolen < 0.0 ? 0.0 : diff_stolen;
        double diff_total = diff_user + diff_sys + diff_nice + diff_idle + diff_wait + diff_irq + diff_soft_irq + diff_stolen;
        if ("idle".equals(property = property.substring(property.lastIndexOf(".") + 1, property.length()))) {
            result = diff_idle / diff_total;
        } else if ("sys".equals(property)) {
            result = diff_sys / diff_total;
        } else if ("user".equals(property)) {
            result = diff_user / diff_total;
        } else if ("wait".equals(property)) {
            result = diff_wait / diff_total;
        } else if ("nice".equals(property)) {
            result = diff_nice / diff_total;
        } else if ("irq".equals(property)) {
            result = diff_irq / diff_total;
        } else if ("softIrq".equals(property)) {
            result = diff_soft_irq / diff_total;
        } else if ("stolen".equals(property)) {
            result = diff_stolen / diff_total;
        }
        return result;
    }

    private class CpuEntry {
        private Cpu cpu;
        private long timestamp;

        public CpuEntry(Cpu cpu) {
            this.cpu = cpu;
            this.timestamp = System.currentTimeMillis();
        }

        public Cpu getCpu() {
            return this.cpu;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public String toString() {
            return "CPU-" + CpuComponent.this.cpuInformation.getCpuIndex() + "[" + new SimpleDateFormat("HH:mm:ss").format(this.timestamp) + "] = " + this.cpu;
        }
    }
}

