/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.netservices;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Set;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;

public class PingNetServiceComponent
implements ResourceComponent,
MeasurementFacet {
    public static final String CONFIG_ADDRESS = "address";
    private ResourceContext resourceContext;

    public void start(ResourceContext resourceContext) throws InvalidPluginConfigurationException, Exception {
        this.resourceContext = resourceContext;
        String addressString = resourceContext.getPluginConfiguration().getSimple(CONFIG_ADDRESS).getStringValue();
        try {
            InetAddress address = InetAddress.getByName(addressString);
        }
        catch (UnknownHostException uhe) {
            throw new InvalidPluginConfigurationException((Throwable)uhe);
        }
    }

    public void stop() {
    }

    public AvailabilityType getAvailability() {
        try {
            String addressString = this.resourceContext.getPluginConfiguration().getSimple(CONFIG_ADDRESS).getStringValue();
            InetAddress address = InetAddress.getByName(addressString);
            return address.isReachable(5000) ? AvailabilityType.UP : AvailabilityType.DOWN;
        }
        catch (Exception e) {
            return AvailabilityType.DOWN;
        }
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) throws Exception {
        String addressString = this.resourceContext.getPluginConfiguration().getSimple(CONFIG_ADDRESS).getStringValue();
        InetAddress address = InetAddress.getByName(addressString);
        for (MeasurementScheduleRequest request : metrics) {
            if (request.getName().equals("ipAddress")) {
                report.addData(new MeasurementDataTrait(request, address.getHostAddress()));
                continue;
            }
            if (request.getName().equals("hostName")) {
                report.addData(new MeasurementDataTrait(request, address.getCanonicalHostName()));
                continue;
            }
            if (!request.getName().equals("responseTime")) continue;
            long start = System.currentTimeMillis();
            address.isReachable(5000);
            report.addData(new MeasurementDataNumeric(request, Double.valueOf(System.currentTimeMillis() - start)));
        }
    }
}

