/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.installer;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import javax.faces.model.SelectItem;
import org.rhq.enterprise.installer.PropertyItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerProperties {
    public static final String PREFIX_PROP_DATABASE = "rhq.server.database.";
    public static final String PROP_DATABASE_TYPE = "rhq.server.database.type-mapping";
    public static final String PROP_DATABASE_CONNECTION_URL = "rhq.server.database.connection-url";
    public static final String PROP_DATABASE_DRIVER_CLASS = "rhq.server.database.driver-class";
    public static final String PROP_DATABASE_USERNAME = "rhq.server.database.user-name";
    public static final String PROP_DATABASE_PASSWORD = "rhq.server.database.password";
    public static final String PROP_DATABASE_XA_DS_CLASS = "rhq.server.database.xa-datasource-class";
    public static final String PROP_DATABASE_SERVER_NAME = "rhq.server.database.server-name";
    public static final String PROP_DATABASE_PORT = "rhq.server.database.port";
    public static final String PROP_DATABASE_DB_NAME = "rhq.server.database.db-name";
    public static final String PROP_DATABASE_HIBERNATE_DIALECT = "hibernate.dialect";
    public static final String PROP_QUARTZ_DRIVER_DELEGATE_CLASS = "rhq.server.quartz.driverDelegateClass";
    public static final String PROP_QUARTZ_SELECT_WITH_LOCK_SQL = "rhq.server.quartz.selectWithLockSQL";
    public static final String PROP_QUARTZ_LOCK_HANDLER_CLASS = "rhq.server.quartz.lockHandlerClass";
    public static final String PROP_SERVER_BIND_ADDRESS = "jboss.bind.address";
    public static final String PROP_HTTP_PORT = "rhq.server.startup.web.http.port";
    public static final String PROP_HTTPS_PORT = "rhq.server.startup.web.https.port";
    public static final String PROP_WEB_SERVICE_PORT = "rhq.server.startup.webservice.port";
    public static final String PROP_NAMING_SERVICE_PORT = "rhq.server.startup.namingservice.port";
    public static final String PROP_NAMING_SERVICE_RMI_PORT = "rhq.server.startup.namingservice.rmiport";
    public static final String PROP_JRMP_INVOKER_RMI_PORT = "rhq.server.startup.jrmpinvoker.rmiport";
    public static final String PROP_POOLED_INVOKER_RMI_PORT = "rhq.server.startup.pooledinvoker.rmiport";
    public static final String PROP_AJP_PORT = "rhq.server.startup.ajp.port";
    public static final String PROP_UNIFIED_INVOKER_PORT = "rhq.server.startup.unifiedinvoker.port";
    public static final String PROP_ASPECT_DEPLOYER_PORT = "rhq.server.startup.aspectdeployer.bind-port";
    public static final String PROP_TOMCAT_SECURITY_CLIENT_AUTH_MOD = "rhq.server.tomcat.security.client-auth-mode";
    public static final String PROP_TOMCAT_SECURITY_SSL_PROTOCOL = "rhq.server.tomcat.security.secure-socket-protocol";
    public static final String PROP_TOMCAT_SECURITY_ALGORITHM = "rhq.server.tomcat.security.algorithm";
    public static final String PROP_TOMCAT_SECURITY_KEYSTORE_ALIAS = "rhq.server.tomcat.security.keystore.alias";
    public static final String PROP_TOMCAT_SECURITY_KEYSTORE_FILENAME = "rhq.server.tomcat.security.keystore.file";
    public static final String PROP_TOMCAT_SECURITY_KEYSTORE_PASSWORD = "rhq.server.tomcat.security.keystore.password";
    public static final String PROP_TOMCAT_SECURITY_KEYSTORE_TYPE = "rhq.server.tomcat.security.keystore.type";
    public static final String PROP_TOMCAT_SECURITY_TRUSTSTORE_FILENAME = "rhq.server.tomcat.security.truststore.file";
    public static final String PROP_TOMCAT_SECURITY_TRUSTSTORE_PASSWORD = "rhq.server.tomcat.security.truststore.password";
    public static final String PROP_TOMCAT_SECURITY_TRUSTSTORE_TYPE = "rhq.server.tomcat.security.truststore.type";
    public static final String PROP_CONNECTOR_TRANSPORT = "rhq.communications.connector.transport";
    public static final String PROP_CONNECTOR_BIND_ADDRESS = "rhq.communications.connector.bind-address";
    public static final String PROP_CONNECTOR_BIND_PORT = "rhq.communications.connector.bind-port";
    public static final String PROP_CONNECTOR_TRANSPORT_PARAMS = "rhq.communications.connector.transport-params";
    public static final String PROP_AGENT_MULTICAST_DETECTOR_ENABLED = "rhq.communications.multicast-detector.enabled";
    public static final String PROP_AGENT_MULTICAST_DETECTOR_BIND_ADDRESS = "rhq.communications.multicast-detector.bind-address";
    public static final String PROP_AGENT_MULTICAST_DETECTOR_MULTICAST_ADDRESS = "rhq.communications.multicast-detector.multicast-address";
    public static final String PROP_AGENT_MULTICAST_DETECTOR_PORT = "rhq.communications.multicast-detector.port";
    public static final String PROP_SECURITY_SERVER_SECURE_SOCKET_PROTOCOL = "rhq.communications.connector.security.secure-socket-protocol";
    public static final String PROP_SECURITY_SERVER_KEYSTORE_FILE = "rhq.communications.connector.security.keystore.file";
    public static final String PROP_SECURITY_SERVER_KEYSTORE_ALGORITHM = "rhq.communications.connector.security.keystore.algorithm";
    public static final String PROP_SECURITY_SERVER_KEYSTORE_TYPE = "rhq.communications.connector.security.keystore.type";
    public static final String PROP_SECURITY_SERVER_KEYSTORE_PASSWORD = "rhq.communications.connector.security.keystore.password";
    public static final String PROP_SECURITY_SERVER_KEYSTORE_KEY_PASSWORD = "rhq.communications.connector.security.keystore.key-password";
    public static final String PROP_SECURITY_SERVER_KEYSTORE_ALIAS = "rhq.communications.connector.security.keystore.alias";
    public static final String PROP_SECURITY_SERVER_TRUSTSTORE_FILE = "rhq.communications.connector.security.truststore.file";
    public static final String PROP_SECURITY_SERVER_TRUSTSTORE_ALGORITHM = "rhq.communications.connector.security.truststore.algorithm";
    public static final String PROP_SECURITY_SERVER_TRUSTSTORE_TYPE = "rhq.communications.connector.security.truststore.type";
    public static final String PROP_SECURITY_SERVER_TRUSTSTORE_PASSWORD = "rhq.communications.connector.security.truststore.password";
    public static final String PROP_SECURITY_SERVER_CLIENT_AUTH_MODE = "rhq.communications.connector.security.client-auth-mode";
    public static final String PROP_SECURITY_CLIENT_SECURE_SOCKET_PROTOCOL = "rhq.server.client.security.secure-socket-protocol";
    public static final String PROP_SECURITY_CLIENT_KEYSTORE_FILE = "rhq.server.client.security.keystore.file";
    public static final String PROP_SECURITY_CLIENT_KEYSTORE_ALGORITHM = "rhq.server.client.security.keystore.algorithm";
    public static final String PROP_SECURITY_CLIENT_KEYSTORE_TYPE = "rhq.server.client.security.keystore.type";
    public static final String PROP_SECURITY_CLIENT_KEYSTORE_PASSWORD = "rhq.server.client.security.keystore.password";
    public static final String PROP_SECURITY_CLIENT_KEYSTORE_KEY_PASSWORD = "rhq.server.client.security.keystore.key-password";
    public static final String PROP_SECURITY_CLIENT_KEYSTORE_ALIAS = "rhq.server.client.security.keystore.alias";
    public static final String PROP_SECURITY_CLIENT_TRUSTSTORE_FILE = "rhq.server.client.security.truststore.file";
    public static final String PROP_SECURITY_CLIENT_TRUSTSTORE_ALGORITHM = "rhq.server.client.security.truststore.algorithm";
    public static final String PROP_SECURITY_CLIENT_TRUSTSTORE_TYPE = "rhq.server.client.security.truststore.type";
    public static final String PROP_SECURITY_CLIENT_TRUSTSTORE_PASSWORD = "rhq.server.client.security.truststore.password";
    public static final String PROP_SECURITY_CLIENT_SERVER_AUTH_MODE_ENABLED = "rhq.server.client.security.server-auth-mode-enabled";
    public static final String PROP_EMBEDDED_AGENT_ENABLED = "rhq.server.embedded-agent.enabled";
    public static final String PROP_EMBEDDED_AGENT_NAME = "rhq.server.embedded-agent.name";
    public static final String PROP_EMBEDDED_AGENT_DISABLE_NATIVE_SYSTEM = "rhq.server.embedded-agent.disable-native-system";
    public static final String PROP_EMBEDDED_AGENT_RESET_CONFIGURATION = "rhq.server.embedded-agent.reset-configuration";
    public static final String PROP_EMAIL_SMTP_HOST = "rhq.server.email.smtp-host";
    public static final String PROP_EMAIL_SMTP_PORT = "rhq.server.email.smtp-port";
    public static final String PROP_EMAIL_FROM_ADDRESS = "rhq.server.email.from-address";
    public static final String PROP_OPERATION_TIMEOUT = "rhq.server.operation-timeout";
    public static final String PROP_CONCURRENCY_LIMIT_WEBCONNS = "rhq.server.startup.web.max-connections";
    public static final String PROP_CONCURRENCY_LIMIT_GLOBAL = "rhq.communications.global-concurrency-limit";
    public static final String PROP_CONCURRENCY_LIMIT_INV_REPORT = "rhq.server.concurrency-limit.inventory-report";
    public static final String PROP_CONCURRENCY_LIMIT_AVAIL_REPORT = "rhq.server.concurrency-limit.availability-report";
    public static final String PROP_CONCURRENCY_LIMIT_INV_SYNC = "rhq.server.concurrency-limit.inventory-sync";
    public static final String PROP_CONCURRENCY_LIMIT_CONTENT_REPORT = "rhq.server.concurrency-limit.content-report";
    public static final String PROP_CONCURRENCY_LIMIT_CONTENT_DOWNLOAD = "rhq.server.concurrency-limit.content-download";
    public static final String PROP_CONCURRENCY_LIMIT_MEAS_REPORT = "rhq.server.concurrency-limit.measurement-report";
    public static final String PROP_CONCURRENCY_LIMIT_MEASSCHED_REQ = "rhq.server.concurrency-limit.measurement-schedule-request";
    public static final String PROP_HIGH_AVAILABILITY_NAME = "rhq.server.high-availability.name";
    public static final String PROP_MM_AT_START = "rhq.server.maintenance-mode-at-startup";
    public static final String PREFIX_PROP_AUTOINSTALL = "rhq.autoinstall.";
    public static final String PROP_AUTOINSTALL_ENABLE = "rhq.autoinstall.enabled";
    public static final String PROP_AUTOINSTALL_DB = "rhq.autoinstall.database";
    public static final String PROP_AUTOINSTALL_PUBLIC_ENDPOINT = "rhq.autoinstall.public-endpoint-address";
    public static final List<SelectItem> DATABASE_TYPES = new ArrayList();
    public static final List<SelectItem> CLIENT_AUTH_MODES;
    public static final List<SelectItem> TOMCAT_CLIENT_AUTH_MODES;
    private PropertyItem[] allPropertyItems = new PropertyItem[]{new PropertyItem("rhq.server.database.type-mapping", String.class, "propertyDatabaseType", "propertyDatabaseTypeHelp", false, false, false, DATABASE_TYPES), new PropertyItem("rhq.server.database.connection-url", String.class, "propertyDatabaseConnectionUrl", "propertyDatabaseConnectionUrlHelp", false, false, false), new PropertyItem("rhq.server.database.driver-class", String.class, "propertyDatabaseDriverClass", "propertyDatabaseDriverClassHelp", false, false, false), new PropertyItem("rhq.server.database.xa-datasource-class", String.class, "propertyDatabaseXADataSourceClass", "propertyDatabaseXADataSourceClassHelp", false, false, false), new PropertyItem("rhq.server.database.user-name", String.class, "propertyDatabaseUserName", "propertyDatabaseUserNameHelp", false, false, false), new PropertyItem("rhq.server.database.password", String.class, "propertyDatabasePassword", "propertyDatabasePasswordHelp", false, true, false), new PropertyItem("rhq.server.database.server-name", String.class, "", "", false, true, false, true), new PropertyItem("rhq.server.database.port", String.class, "", "", false, true, false, true), new PropertyItem("rhq.server.database.db-name", String.class, "", "", false, true, false, true), new PropertyItem("hibernate.dialect", String.class, "", "", false, true, false, true), new PropertyItem("rhq.server.quartz.driverDelegateClass", String.class, "", "", false, true, false, true), new PropertyItem("rhq.server.quartz.selectWithLockSQL", String.class, "", "", false, true, false, true), new PropertyItem("rhq.server.quartz.lockHandlerClass", String.class, "", "", false, true, false, true), new PropertyItem("jboss.bind.address", String.class, "propertyBindAddress", "propertyBindAddressHelp", true, false, false), new PropertyItem("rhq.server.startup.web.http.port", Integer.class, "propertyHttpPort", "propertyHttpPortHelp", true, false, false, true), new PropertyItem("rhq.server.startup.web.https.port", Integer.class, "propertyHttpsPort", "propertyHttpsPortHelp", true, false, false, true), new PropertyItem("rhq.server.startup.webservice.port", Integer.class, "propertyWebServicePort", "propertyWebServicePortHelp", true, false, true), new PropertyItem("rhq.server.startup.namingservice.port", Integer.class, "propertyNamingServicePort", "propertyNamingServicePortHelp", true, false, true), new PropertyItem("rhq.server.startup.namingservice.rmiport", Integer.class, "propertyNamingServiceRmiPort", "propertyNamingServiceRmiPortHelp", true, false, true), new PropertyItem("rhq.server.startup.jrmpinvoker.rmiport", Integer.class, "propertyJrmpInvokerRmiPort", "propertyJrmpInvokerRmiPortHelp", true, false, true), new PropertyItem("rhq.server.startup.pooledinvoker.rmiport", Integer.class, "propertyPooledInvokerRmiPort", "propertyPooledInvokerRmiPortHelp", true, false, true), new PropertyItem("rhq.server.startup.ajp.port", Integer.class, "propertyAjpPort", "propertyAjpPortHelp", true, false, true), new PropertyItem("rhq.server.startup.unifiedinvoker.port", Integer.class, "propertyUnifiedInvokerPort", "propertyUnifiedInvokerPortHelp", true, false, true), new PropertyItem("rhq.server.startup.aspectdeployer.bind-port", Integer.class, "propertyAspectDeployerPort", "propertyAspectDeployerPortHelp", true, false, true), new PropertyItem("rhq.server.tomcat.security.client-auth-mode", String.class, "propertyTomcatClientAuthMode", "propertyTomcatClientAuthModeHelp", true, false, true, TOMCAT_CLIENT_AUTH_MODES), new PropertyItem("rhq.server.tomcat.security.secure-socket-protocol", String.class, "propertyTomcatSslProtocol", "propertyTomcatSslProtocolHelp", true, false, true), new PropertyItem("rhq.server.tomcat.security.algorithm", String.class, "propertyTomcatAlgorithm", "propertyTomcatAlgorithmHelp", true, false, true), new PropertyItem("rhq.server.tomcat.security.keystore.file", String.class, "propertyTomcatKeystoreFilename", "propertyTomcatKeystoreFilenameHelp", true, false, true), new PropertyItem("rhq.server.tomcat.security.keystore.type", String.class, "propertyTomcatKeystoreType", "propertyTomcatKeystoreTypeHelp", true, false, true), new PropertyItem("rhq.server.tomcat.security.keystore.password", String.class, "propertyTomcatKeystorePassword", "propertyTomcatKeystorePasswordHelp", true, false, true), new PropertyItem("rhq.server.tomcat.security.keystore.alias", String.class, "propertyTomcatKeystoreAlias", "propertyTomcatKeystoreAliasHelp", true, false, true), new PropertyItem("rhq.server.tomcat.security.truststore.file", String.class, "propertyTomcatTruststoreFilename", "propertyTomcatTruststoreFilenameHelp", true, false, true), new PropertyItem("rhq.server.tomcat.security.truststore.type", String.class, "propertyTomcatTruststoreType", "propertyTomcatTruststoreTypeHelp", true, false, true), new PropertyItem("rhq.server.tomcat.security.truststore.password", String.class, "propertyTomcatTruststorePassword", "propertyTomcatTruststorePasswordHelp", true, false, true), new PropertyItem("rhq.communications.connector.transport", String.class, "propertyConnectorTransport", "propertyConnectorTransportHelp", false, false, true), new PropertyItem("rhq.communications.connector.bind-address", String.class, "propertyConnectorBindAddress", "propertyConnectorBindAddressHelp", false, false, true, true), new PropertyItem("rhq.communications.connector.bind-port", Integer.class, "propertyConnectorBindPort", "propertyConnectorBindPortHelp", false, false, true, true), new PropertyItem("rhq.communications.connector.transport-params", String.class, "propertyConnectorTransportParams", "propertyConnectorTransportParamsHelp", false, false, true), new PropertyItem("rhq.communications.multicast-detector.enabled", Boolean.class, "propertyAgentMulticastDetectorEnabled", "propertyAgentMulticastDetectorEnabledHelp", false, false, true), new PropertyItem("rhq.communications.multicast-detector.bind-address", String.class, "propertyAgentMulticastDetectorBindAddress", "propertyAgentMulticastDetectorBindAddressHelp", false, false, true), new PropertyItem("rhq.communications.multicast-detector.multicast-address", String.class, "propertyAgentMulticastDetectorMulticastAddress", "propertyAgentMulticastDetectorMulticastAddressHelp", false, false, true), new PropertyItem("rhq.communications.multicast-detector.port", Integer.class, "propertyAgentMulticastDetectorPort", "propertyAgentMulticastDetectorPortHelp", false, false, true), new PropertyItem("rhq.communications.connector.security.secure-socket-protocol", String.class, "propertySecurityServerSecureSocketProtocol", "propertySecurityServerSecureSocketProtocolHelp", false, false, true), new PropertyItem("rhq.communications.connector.security.keystore.file", String.class, "propertySecurityServerKeystoreFile", "propertySecurityServerKeystoreFileHelp", false, false, true), new PropertyItem("rhq.communications.connector.security.keystore.algorithm", String.class, "propertySecurityServerKeystoreAlgorithm", "propertySecurityServerKeystoreAlgorithmHelp", false, false, true), new PropertyItem("rhq.communications.connector.security.keystore.type", String.class, "propertySecurityServerKeystoreType", "propertySecurityServerKeystoreTypeHelp", false, false, true), new PropertyItem("rhq.communications.connector.security.keystore.password", String.class, "propertySecurityServerKeystorePassword", "propertySecurityServerKeystorePasswordHelp", false, true, true), new PropertyItem("rhq.communications.connector.security.keystore.key-password", String.class, "propertySecurityServerKeystoreKeyPassword", "propertySecurityServerKeystoreKeyPasswordHelp", false, true, true), new PropertyItem("rhq.communications.connector.security.keystore.alias", String.class, "propertySecurityServerKeystoreAlias", "propertySecurityServerKeystoreAliasHelp", false, false, true), new PropertyItem("rhq.communications.connector.security.truststore.file", String.class, "propertySecurityServerTruststoreFile", "propertySecurityServerTruststoreFileHelp", false, false, true), new PropertyItem("rhq.communications.connector.security.truststore.algorithm", String.class, "propertySecurityServerTruststoreAlgorithm", "propertySecurityServerTruststoreAlgorithmHelp", false, false, true), new PropertyItem("rhq.communications.connector.security.truststore.type", String.class, "propertySecurityServerTruststoreType", "propertySecurityServerTruststoreTypeHelp", false, false, true), new PropertyItem("rhq.communications.connector.security.truststore.password", String.class, "propertySecurityServerTruststorePassword", "propertySecurityServerTruststorePasswordHelp", false, true, true), new PropertyItem("rhq.communications.connector.security.client-auth-mode", String.class, "propertySecurityServerClientAuthMode", "propertySecurityServerClientAuthModeHelp", false, false, true, CLIENT_AUTH_MODES), new PropertyItem("rhq.server.client.security.secure-socket-protocol", String.class, "propertySecurityClientSecureSocketProtocol", "propertySecurityClientSecureSocketProtocolHelp", false, false, true), new PropertyItem("rhq.server.client.security.keystore.file", String.class, "propertySecurityClientKeystoreFile", "propertySecurityClientKeystoreFileHelp", false, false, true), new PropertyItem("rhq.server.client.security.keystore.algorithm", String.class, "propertySecurityClientKeystoreAlgorithm", "propertySecurityClientKeystoreAlgorithmHelp", false, false, true), new PropertyItem("rhq.server.client.security.keystore.type", String.class, "propertySecurityClientKeystoreType", "propertySecurityClientKeystoreTypeHelp", false, false, true), new PropertyItem("rhq.server.client.security.keystore.password", String.class, "propertySecurityClientKeystorePassword", "propertySecurityClientKeystorePasswordHelp", false, true, true), new PropertyItem("rhq.server.client.security.keystore.key-password", String.class, "propertySecurityClientKeystoreKeyPassword", "propertySecurityClientKeystoreKeyPasswordHelp", false, true, true), new PropertyItem("rhq.server.client.security.keystore.alias", String.class, "propertySecurityClientKeystoreAlias", "propertySecurityClientKeystoreAliasHelp", false, false, true), new PropertyItem("rhq.server.client.security.truststore.file", String.class, "propertySecurityClientTruststoreFile", "propertySecurityClientTruststoreFileHelp", false, false, true), new PropertyItem("rhq.server.client.security.truststore.algorithm", String.class, "propertySecurityClientTruststoreAlgorithm", "propertySecurityClientTruststoreAlgorithmHelp", false, false, true), new PropertyItem("rhq.server.client.security.truststore.type", String.class, "propertySecurityClientTruststoreType", "propertySecurityClientTruststoreTypeHelp", false, false, true), new PropertyItem("rhq.server.client.security.truststore.password", String.class, "propertySecurityClientTruststorePassword", "propertySecurityClientTruststorePasswordHelp", false, true, true), new PropertyItem("rhq.server.client.security.server-auth-mode-enabled", Boolean.class, "propertySecurityClientServerAuthModeEnabled", "propertySecurityClientServerAuthModeEnabledHelp", false, false, true), new PropertyItem("rhq.server.embedded-agent.enabled", Boolean.class, "propertyEmbeddedRHQAgentEnabled", "propertyEmbeddedRHQAgentEnabledHelp", false, false, false), new PropertyItem("rhq.server.embedded-agent.name", String.class, "propertyEmbeddedRHQAgentName", "propertyEmbeddedRHQAgentNameHelp", false, false, true), new PropertyItem("rhq.server.embedded-agent.disable-native-system", Boolean.class, "propertyEmbeddedRHQAgentDisableNativeSystem", "propertyEmbeddedRHQAgentDisableNativeSystemHelp", true, false, true), new PropertyItem("rhq.server.embedded-agent.reset-configuration", Boolean.class, "propertyEmbeddedRHQAgentResetConfiguration", "propertyEmbeddedRHQAgentResetConfigurationHelp", false, false, true), new PropertyItem("rhq.server.email.smtp-host", String.class, "propertyEmailSmtpHost", "propertyEmailSmtpHostHelp", false, false, false), new PropertyItem("rhq.server.email.smtp-port", Integer.class, "propertyEmailSmtpPort", "propertyEmailSmtpPortHelp", false, false, true), new PropertyItem("rhq.server.email.from-address", String.class, "propertyEmailFromAddress", "propertyEmailFromAddressHelp", false, false, false), new PropertyItem("rhq.server.operation-timeout", Integer.class, "propertyOperationTimeout", "propertyOperationTimeoutHelp", false, false, true), new PropertyItem("rhq.server.startup.web.max-connections", Integer.class, "propertyConcurrencyLimitWebConns", "propertyConcurrencyLimitWebConnsHelp", true, false, true), new PropertyItem("rhq.communications.global-concurrency-limit", Integer.class, "propertyConcurrencyLimitGlobal", "propertyConcurrencyLimitGlobalHelp", false, false, true), new PropertyItem("rhq.server.concurrency-limit.inventory-report", Integer.class, "propertyConcurrencyLimitInventoryReport", "propertyConcurrencyLimitInventoryReportHelp", false, false, true), new PropertyItem("rhq.server.concurrency-limit.availability-report", Integer.class, "propertyConcurrencyLimitAvailabilityReport", "propertyConcurrencyLimitAvailabilityReportHelp", false, false, true), new PropertyItem("rhq.server.concurrency-limit.inventory-sync", Integer.class, "propertyConcurrencyLimitInventorySync", "propertyConcurrencyLimitInventorySyncHelp", false, false, true), new PropertyItem("rhq.server.concurrency-limit.content-report", Integer.class, "propertyConcurrencyLimitContentReport", "propertyConcurrencyLimitContentReportHelp", false, false, true), new PropertyItem("rhq.server.concurrency-limit.content-download", Integer.class, "propertyConcurrencyLimitContentDownload", "propertyConcurrencyLimitContentDownloadHelp", false, false, true), new PropertyItem("rhq.server.concurrency-limit.measurement-report", Integer.class, "propertyConcurrencyLimitMeasurementReport", "propertyConcurrencyLimitMeasurementReportHelp", false, false, true), new PropertyItem("rhq.server.concurrency-limit.measurement-schedule-request", Integer.class, "propertyConcurrencyLimitMeasurementScheduleRequest", "propertyConcurrencyLimitMeasurementScheduleRequestHelp", false, false, true), new PropertyItem("rhq.server.high-availability.name", String.class, "propertyHighAvailabilityName", "propertyHighAvailabilityNameHelp", false, false, false, true), new PropertyItem("rhq.server.maintenance-mode-at-startup", Boolean.class, "propertyMaintenanceModeAtStart", "propertyMaintenanceModeAtStartHelp", false, false, true, false), new PropertyItem("rhq.autoinstall.enabled", Boolean.class, "", "", false, false, true, true), new PropertyItem("rhq.autoinstall.database", String.class, "", "", false, false, true, true), new PropertyItem("rhq.autoinstall.public-endpoint-address", String.class, "", "", false, false, true, true)};

    public List<PropertyItem> getPropertyItems() {
        return new ArrayList<PropertyItem>(Arrays.asList(this.allPropertyItems));
    }

    public static String getValidServerBindAddress(Properties props) {
        String bindAddr;
        try {
            bindAddr = props.getProperty(PROP_SERVER_BIND_ADDRESS, "0.0.0.0");
            if (bindAddr.trim().equals("0.0.0.0")) {
                bindAddr = InetAddress.getLocalHost().getHostAddress();
            }
        }
        catch (Exception e) {
            bindAddr = "127.0.0.1";
        }
        return bindAddr;
    }

    public static String getHttpPort(Properties props) {
        return props.getProperty(PROP_HTTP_PORT, "7080");
    }

    static {
        DATABASE_TYPES.add(new SelectItem((Object)"PostgreSQL", "PostgreSQL"));
        DATABASE_TYPES.add(new SelectItem((Object)"Oracle", "Oracle"));
        DATABASE_TYPES.add(new SelectItem((Object)"sqlserver", "MS SQL Server"));
        DATABASE_TYPES.add(new SelectItem((Object)"H2", "H2 (embedded)"));
        CLIENT_AUTH_MODES = new ArrayList();
        CLIENT_AUTH_MODES.add(new SelectItem((Object)"none"));
        CLIENT_AUTH_MODES.add(new SelectItem((Object)"want"));
        CLIENT_AUTH_MODES.add(new SelectItem((Object)"need"));
        TOMCAT_CLIENT_AUTH_MODES = new ArrayList();
        TOMCAT_CLIENT_AUTH_MODES.add(new SelectItem((Object)"false"));
        TOMCAT_CLIENT_AUTH_MODES.add(new SelectItem((Object)"want"));
        TOMCAT_CLIENT_AUTH_MODES.add(new SelectItem((Object)"true"));
    }
}

