/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.resource.cluster;

import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.authz.AuthorizationManagerLocal;
import org.rhq.enterprise.server.authz.PermissionException;
import org.rhq.enterprise.server.resource.cluster.ClusterKey;
import org.rhq.enterprise.server.resource.cluster.ClusterManagerLocal;
import org.rhq.enterprise.server.resource.group.ResourceGroupAlreadyExistsException;
import org.rhq.enterprise.server.resource.group.ResourceGroupManagerLocal;
import org.rhq.enterprise.server.resource.group.ResourceGroupUpdateException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Stateless
public class ClusterManagerBean
implements ClusterManagerLocal {
    private final Log log = LogFactory.getLog(ClusterManagerBean.class);
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;
    @EJB
    private ResourceGroupManagerLocal resourceGroupManager;
    @EJB
    private AuthorizationManagerLocal authorizationManager;
    @EJB
    private SubjectManagerLocal subjectManager;

    @Override
    public ResourceGroup createAutoClusterBackingGroup(Subject subject, ClusterKey clusterKey, boolean addResources) {
        ResourceGroup autoClusterBackingGroup = null;
        Query query = this.entityManager.createNamedQuery("ResourceGroup.findByClusterKey");
        query.setParameter("clusterKey", (Object)clusterKey.toString());
        ResourceType resourceType = (ResourceType)this.entityManager.find(ResourceType.class, (Object)ClusterKey.getResourceType(clusterKey));
        ResourceGroup resourceGroup = (ResourceGroup)this.entityManager.find(ResourceGroup.class, (Object)clusterKey.getClusterGroupId());
        if (!this.authorizationManager.canViewGroup(subject, clusterKey.getClusterGroupId())) {
            throw new PermissionException("You do not have permission to view child cluster groups of the group [" + resourceGroup.getName() + "]");
        }
        List<Resource> resources = null;
        try {
            autoClusterBackingGroup = (ResourceGroup)query.getSingleResult();
        }
        catch (NoResultException nre) {
            try {
                resources = this.getAutoClusterResources(subject, clusterKey);
                String name = null;
                if (resources.isEmpty()) {
                    name = "Group of " + resourceType.getName();
                } else {
                    for (Resource res : resources) {
                        if (name == null) {
                            name = res.getName();
                            continue;
                        }
                        if (name.equals(res.getName())) continue;
                        name = "Group of " + resourceType.getName();
                    }
                }
                autoClusterBackingGroup = new ResourceGroup(name, resourceType);
                autoClusterBackingGroup.setClusterKey(clusterKey.toString());
                autoClusterBackingGroup.setClusterResourceGroup(resourceGroup);
                autoClusterBackingGroup.setVisible(false);
                int id = this.resourceGroupManager.createResourceGroup(this.subjectManager.getOverlord(), autoClusterBackingGroup).getId();
                autoClusterBackingGroup = (ResourceGroup)this.entityManager.find(ResourceGroup.class, (Object)id);
            }
            catch (ResourceGroupAlreadyExistsException e) {
                this.log.error((Object)("Unexpected Error, group exists " + e));
                return null;
            }
        }
        if (addResources) {
            if (resources == null) {
                resources = this.getAutoClusterResources(subject, clusterKey);
            }
            int i = 0;
            int[] resourceIds = new int[resources.size()];
            for (Resource res : resources) {
                resourceIds[i++] = res.getId();
            }
            try {
                this.resourceGroupManager.ensureMembershipMatches(this.subjectManager.getOverlord(), autoClusterBackingGroup.getId(), resourceIds);
            }
            catch (ResourceGroupUpdateException e) {
                this.log.error((Object)("Could not add resources to group:" + e));
            }
        }
        return autoClusterBackingGroup;
    }

    @Override
    public ResourceGroup getAutoClusterBackingGroup(Subject subject, ClusterKey clusterKey) {
        ResourceGroup result = null;
        Query query = this.entityManager.createNamedQuery("ResourceGroup.findByClusterKey");
        query.setParameter("clusterKey", (Object)clusterKey.toString());
        try {
            result = (ResourceGroup)query.getSingleResult();
        }
        catch (NoResultException e) {
            result = null;
        }
        return result;
    }

    @Override
    public List<Resource> getAutoClusterResources(Subject subject, ClusterKey clusterKey) {
        String queryString = this.getClusterKeyQuery(clusterKey);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("getAutoClusterResources() generated query: " + queryString));
        }
        Query query = this.entityManager.createQuery(queryString);
        List rs = query.getResultList();
        return rs;
    }

    private String getClusterKeyQuery(ClusterKey clusterKey) {
        if (null == clusterKey) {
            return null;
        }
        if (0 == clusterKey.getDepth()) {
            return null;
        }
        StringBuilder query = new StringBuilder();
        this.buildQuery(query, clusterKey, clusterKey.getHierarchy());
        return query.toString();
    }

    private void buildQuery(StringBuilder query, ClusterKey clusterKey, List<ClusterKey.Node> nodes) {
        int size = nodes.size();
        ClusterKey.Node node = nodes.get(size - 1);
        String alias = "r" + size;
        query.append(" SELECT " + alias + " FROM Resource " + alias + " WHERE ");
        query.append(alias + ".resourceKey = '" + node.getResourceKey() + "' AND ");
        query.append(alias + ".resourceType = " + node.getResourceTypeId() + " AND ");
        query.append(alias + ".parentResource IN ( ");
        if (1 == size) {
            query.append("SELECT rgir FROM ResourceGroup rg JOIN rg.implicitResources rgir WHERE rg = " + clusterKey.getClusterGroupId());
        } else {
            this.buildQuery(query, clusterKey, nodes.subList(0, size - 1));
        }
        query.append(")");
    }
}

