/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugin.pc.content;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.content.ContentSource;
import org.rhq.core.domain.content.ContentSourceSyncResults;
import org.rhq.core.domain.content.ContentSourceType;
import org.rhq.core.domain.content.ContentSyncStatus;
import org.rhq.core.domain.content.Repo;
import org.rhq.core.domain.content.RepoSyncResults;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.util.progresswatch.ProgressWatcher;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.content.ContentSourceManagerLocal;
import org.rhq.enterprise.server.content.RepoManagerLocal;
import org.rhq.enterprise.server.content.metadata.ContentSourceMetadataManagerLocal;
import org.rhq.enterprise.server.plugin.pc.ServerPluginEnvironment;
import org.rhq.enterprise.server.plugin.pc.content.AdvisorySource;
import org.rhq.enterprise.server.plugin.pc.content.ContentProvider;
import org.rhq.enterprise.server.plugin.pc.content.ContentServerPluginManager;
import org.rhq.enterprise.server.plugin.pc.content.DistributionSource;
import org.rhq.enterprise.server.plugin.pc.content.InitializationException;
import org.rhq.enterprise.server.plugin.pc.content.PackageSource;
import org.rhq.enterprise.server.plugin.pc.content.RepoSource;
import org.rhq.enterprise.server.plugin.pc.content.SyncProgressWeight;
import org.rhq.enterprise.server.plugin.pc.content.SyncTracker;
import org.rhq.enterprise.server.plugin.pc.content.ThreadUtil;
import org.rhq.enterprise.server.plugin.pc.content.metadata.ContentSourcePluginMetadataManager;
import org.rhq.enterprise.server.plugin.pc.content.sync.AdvisorySourceSynchronizer;
import org.rhq.enterprise.server.plugin.pc.content.sync.DistributionSourceSynchronizer;
import org.rhq.enterprise.server.plugin.pc.content.sync.PackageSourceSynchronizer;
import org.rhq.enterprise.server.plugin.pc.content.sync.RepoSourceSynchronizer;
import org.rhq.enterprise.server.util.LookupUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentProviderManager {
    private static final Log log = LogFactory.getLog(ContentProviderManager.class);
    private ContentServerPluginManager pluginManager;
    private Map<ContentSource, ContentProvider> adapters;
    private final Object synchronizeContentSourceLock = new Object();

    public InputStream loadPackageBits(int contentSourceId, String location) throws Exception {
        ContentProvider adapter = this.getIsolatedContentProvider(contentSourceId);
        PackageSource packageSource = (PackageSource)((Object)adapter);
        InputStream inputStream = packageSource.getInputStream(location);
        if (inputStream == null) {
            throw new Exception("Adapter for content source [" + contentSourceId + "] failed to give us a stream to the package at location [" + location + "]");
        }
        return inputStream;
    }

    public InputStream loadDistributionFileBits(int contentSourceId, String location) throws Exception {
        ContentProvider adapter = this.getIsolatedContentProvider(contentSourceId);
        DistributionSource distSource = (DistributionSource)((Object)adapter);
        InputStream inputStream = distSource.getInputStream(location);
        if (inputStream == null) {
            throw new Exception("Adapter for content source [" + contentSourceId + "] failed to give us a stream to the distribution file at location [" + location + "]");
        }
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean synchronizeContentProvider(int contentSourceId) throws Exception {
        ContentSource contentSource;
        StringBuilder progress;
        ContentSourceSyncResults results;
        ContentProvider provider;
        ContentSourceManagerLocal contentSourceManager;
        block10: {
            contentSourceManager = LookupUtil.getContentSourceManager();
            provider = this.getIsolatedContentProvider(contentSourceId);
            results = null;
            SubjectManagerLocal subjMgr = LookupUtil.getSubjectManager();
            Subject overlord = subjMgr.getOverlord();
            progress = new StringBuilder();
            contentSource = contentSourceManager.getContentSource(overlord, contentSourceId);
            if (contentSource == null) {
                throw new Exception("Cannot sync a non-existing content source [" + contentSourceId + "]");
            }
            Object object = this.synchronizeContentSourceLock;
            synchronized (object) {
                progress.append(new Date()).append(": ");
                progress.append("Start synchronization of content source [").append(contentSource.getName()).append("]\n");
                progress.append(new Date()).append(": ");
                progress.append("Getting currently known list of packages...\n");
                results = new ContentSourceSyncResults(contentSource);
                results.setResults(progress.toString());
                results = contentSourceManager.persistContentSourceSyncResults(results);
            }
            if (results != null) break block10;
            log.info((Object)("Content source [" + contentSource.getName() + "] is already being synchronized - this sync request will be ignored."));
            boolean bl = false;
            Object var12_14 = null;
            if (results == null) return bl;
            results.setEndTime(Long.valueOf(System.currentTimeMillis()));
            contentSourceManager.mergeContentSourceSyncResults(results);
            return bl;
        }
        try {
            try {
                RepoSourceSynchronizer repoSourceSynchronizer = new RepoSourceSynchronizer(contentSource, provider);
                repoSourceSynchronizer.synchronizeCandidateRepos(progress);
                results.setStatus(ContentSyncStatus.SUCCESS);
                results.setResults(progress.toString());
            }
            catch (Throwable t) {
                if (results == null) throw new Exception("Failed to sync content source [" + contentSourceId + "]", t);
                ContentSourceSyncResults reloadedResults = contentSourceManager.getContentSourceSyncResults(results.getId());
                if (reloadedResults != null && (results = reloadedResults).getResults() != null) {
                    progress = new StringBuilder(results.getResults());
                }
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                t.printStackTrace(new PrintStream(baos));
                progress.append(new Date()).append(": ");
                progress.append("SYNCHRONIZATION ERROR - STACK TRACE FOLLOWS:\n");
                progress.append(baos.toString());
                results.setResults(progress.toString());
                results.setStatus(ContentSyncStatus.FAILURE);
                throw new Exception("Failed to sync content source [" + contentSourceId + "]", t);
            }
            Object var12_15 = null;
            if (results == null) return true;
        }
        catch (Throwable throwable) {
            Object var12_16 = null;
            if (results == null) throw throwable;
            results.setEndTime(Long.valueOf(System.currentTimeMillis()));
            contentSourceManager.mergeContentSourceSyncResults(results);
            throw throwable;
        }
        results.setEndTime(Long.valueOf(System.currentTimeMillis()));
        contentSourceManager.mergeContentSourceSyncResults(results);
        return true;
    }

    public boolean synchronizeRepo(int repoId) {
        log.debug((Object)"synchronizeRepo() :: start");
        RepoManagerLocal repoManager = LookupUtil.getRepoManagerLocal();
        SubjectManagerLocal subjectManager = LookupUtil.getSubjectManager();
        Subject overlord = subjectManager.getOverlord();
        Repo repo = repoManager.getRepo(overlord, repoId);
        if (repo == null) {
            throw new IllegalArgumentException("Invalid repository with id [" + repoId + "] specified for sync.");
        }
        StringBuilder progress = new StringBuilder();
        progress.append(new Date()).append(": ");
        progress.append("Start synchronization of Repository [").append(repo.getName()).append("]\n");
        progress.append(new Date()).append(": ");
        progress.append("Getting currently known list of content source packages...\n");
        SyncTracker tracker = new SyncTracker(new RepoSyncResults(repo), new ProgressWatcher());
        tracker.setResults(progress.toString());
        tracker.setRepoSyncResults(repoManager.persistRepoSyncResults(tracker.getRepoSyncResults()));
        log.debug((Object)"synchronizeRepo :: inProgress");
        tracker = this.updatePercentComplete(tracker, repoManager);
        if (tracker.getRepoSyncResults() == null) {
            log.info((Object)("Repository [" + repo.getName() + "] is already currently being synchronized - this sync request will be ignored."));
            return false;
        }
        boolean syncCancelled = false;
        try {
            DistributionSourceSynchronizer distroSourceSyncer;
            SyncProgressWeight sw;
            ContentProvider provider;
            ThreadUtil.checkInterrupted();
            for (ContentSource source : repo.getContentSources()) {
                try {
                    provider = this.getIsolatedContentProvider(source.getId());
                    sw = provider.getSyncProgressWeight();
                    PackageSourceSynchronizer packageSourceSynchronizer = new PackageSourceSynchronizer(repo, source, provider);
                    log.debug((Object)"synchronizeRepo :: synchronizePackageMetadata");
                    tracker = this.updateSyncStatus(tracker, ContentSyncStatus.PACKAGEMETADATA);
                    tracker = packageSourceSynchronizer.synchronizePackageMetadata(tracker);
                }
                catch (Exception e) {
                    this.processSyncException(e, tracker, repo, source, repoManager);
                }
            }
            ThreadUtil.checkInterrupted();
            for (ContentSource source : repo.getContentSources()) {
                provider = this.getIsolatedContentProvider(source.getId());
                sw = provider.getSyncProgressWeight();
                tracker.getProgressWatcher().addWork(sw.getPackageMetadataWeight());
                tracker.addAdvisoryMetadataWork(provider);
                tracker.getProgressWatcher().addWork(sw.getDistribtutionBitsWeight());
                tracker.getProgressWatcher().addWork(sw.getDistribtutionMetadataWeight());
                tracker.addPackageBitsWork(provider);
                tracker.getProgressWatcher().finishWork(sw.getPackageMetadataWeight());
            }
            tracker = this.updatePercentComplete(tracker, repoManager);
            for (ContentSource source : repo.getContentSources()) {
                try {
                    provider = this.getIsolatedContentProvider(source.getId());
                    if (provider instanceof PackageSource) {
                        PackageSourceSynchronizer packageSourceSyncer = new PackageSourceSynchronizer(repo, source, provider);
                        log.debug((Object)"synchronizeRepo :: synchronizePackageBits");
                        tracker = this.updateSyncStatus(tracker, ContentSyncStatus.PACKAGEBITS);
                        tracker = packageSourceSyncer.synchronizePackageBits(tracker, provider);
                        tracker = this.updatePercentComplete(tracker, repoManager);
                    }
                }
                catch (Exception e) {
                    this.processSyncException(e, tracker, repo, source, repoManager);
                }
                ThreadUtil.checkInterrupted();
            }
            log.debug((Object)"synchronizeRepo :: synchronizeDistributionMetadata");
            for (ContentSource source : repo.getContentSources()) {
                try {
                    provider = this.getIsolatedContentProvider(source.getId());
                    if (provider instanceof DistributionSource) {
                        distroSourceSyncer = new DistributionSourceSynchronizer(repo, source, provider);
                        tracker = this.updateSyncStatus(tracker, ContentSyncStatus.DISTROMETADATA);
                        tracker = distroSourceSyncer.synchronizeDistributionMetadata(tracker);
                        tracker = this.updatePercentComplete(tracker, repoManager);
                    }
                }
                catch (Exception e) {
                    this.processSyncException(e, tracker, repo, source, repoManager);
                }
                ThreadUtil.checkInterrupted();
            }
            log.debug((Object)"synchronizeRepo :: synchronizeDistributionBits");
            for (ContentSource source : repo.getContentSources()) {
                try {
                    provider = this.getIsolatedContentProvider(source.getId());
                    if (provider instanceof DistributionSource) {
                        distroSourceSyncer = new DistributionSourceSynchronizer(repo, source, provider);
                        tracker = this.updateSyncStatus(tracker, ContentSyncStatus.DISTROBITS);
                        tracker = distroSourceSyncer.synchronizeDistributionBits(tracker);
                        tracker = this.updatePercentComplete(tracker, repoManager);
                    }
                    ThreadUtil.checkInterrupted();
                }
                catch (Exception e) {
                    this.processSyncException(e, tracker, repo, source, repoManager);
                }
                ThreadUtil.checkInterrupted();
            }
            log.debug((Object)"synchronizeRepo :: synchronizeAdvisoryMetadata");
            for (ContentSource source : repo.getContentSources()) {
                try {
                    provider = this.getIsolatedContentProvider(source.getId());
                    if (provider instanceof AdvisorySource) {
                        tracker = this.updateSyncStatus(tracker, ContentSyncStatus.ADVISORYMETADATA);
                        AdvisorySourceSynchronizer advisorySourceSyncer = new AdvisorySourceSynchronizer(repo, source, provider);
                        tracker = advisorySourceSyncer.synchronizeAdvisoryMetadata(tracker);
                        tracker = this.updatePercentComplete(tracker, repoManager);
                    }
                }
                catch (Exception e) {
                    this.processSyncException(e, tracker, repo, source, repoManager);
                }
                ThreadUtil.checkInterrupted();
            }
            if (tracker.getRepoSyncResults().getStatus() != ContentSyncStatus.FAILURE) {
                tracker.getRepoSyncResults().setStatus(ContentSyncStatus.SUCCESS);
            }
            tracker = this.updateSyncStatus(tracker, tracker.getRepoSyncResults().getStatus());
            progress = new StringBuilder();
            progress.append("\n");
            progress.append(tracker.getRepoSyncResults().getResults());
            progress.append("\n");
            progress.append(new Date()).append(": ");
            progress.append("Repository [").append(repo.getName()).append("] ");
            progress.append("completed syncing with ");
            progress.append(tracker.getRepoSyncResults().getStatus() == ContentSyncStatus.FAILURE ? "one or more" : "no");
            progress.append(" errors.\n");
            tracker.setResults(progress.toString());
            log.debug((Object)("synchronizeRepo :: " + tracker.getRepoSyncResults().getStatus()));
        }
        catch (InterruptedException e) {
            RepoSyncResults recentResults = repoManager.getMostRecentSyncResults(overlord, repo.getId());
            log.debug((Object)("Caught InterruptedException during sync of repo with id [" + repoId + "]."));
            progress.append("\n ** Cancelled syncing **");
            tracker.setResults(progress.toString());
            tracker.getProgressWatcher().resetToZero();
            tracker = this.updatePercentComplete(tracker, repoManager);
            try {
                tracker = this.updateSyncStatus(tracker, ContentSyncStatus.CANCELLED);
            }
            catch (InterruptedException e1) {
                throw new RuntimeException("Unexpected InterruptedException", e1);
            }
            syncCancelled = true;
        }
        if (tracker.getRepoSyncResults() != null) {
            tracker.getRepoSyncResults().setEndTime(Long.valueOf(System.currentTimeMillis()));
            repoManager.mergeRepoSyncResults(tracker.getRepoSyncResults());
            log.debug((Object)"synchronizeRepo :: merging results.");
        }
        return !syncCancelled;
    }

    private SyncTracker updatePercentComplete(SyncTracker tracker, RepoManagerLocal repoManager) {
        tracker.getRepoSyncResults().setPercentComplete(new Long(tracker.getProgressWatcher().getPercentComplete()));
        tracker.setRepoSyncResults(repoManager.mergeRepoSyncResults(tracker.getRepoSyncResults()));
        return tracker;
    }

    private SyncTracker processSyncException(Exception e, SyncTracker tracker, Repo repo, ContentSource source, RepoManagerLocal repoManager) throws InterruptedException {
        if (e instanceof InterruptedException) {
            InterruptedException ie = (InterruptedException)e;
            throw ie;
        }
        StringBuilder progress = new StringBuilder();
        log.error((Object)("Error while synchronizing repo [" + repo + "] with content source [" + source + "]. Synchronization of the repo will continue for any other associated content sources."), (Throwable)e);
        RepoSyncResults reloadedResults = repoManager.getRepoSyncResults(tracker.getRepoSyncResults().getId());
        if (reloadedResults != null) {
            tracker.setRepoSyncResults(reloadedResults);
            if (tracker.getRepoSyncResults().getResults() != null) {
                progress = new StringBuilder(tracker.getRepoSyncResults().getResults());
            }
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        e.printStackTrace(new PrintStream(baos));
        progress.append(new Date()).append(": ");
        progress.append("SYNCHRONIZATION ERROR - STACK TRACE FOLLOWS:\n");
        progress.append(baos.toString());
        tracker.setResults(progress.toString());
        tracker.setStatus(ContentSyncStatus.FAILURE);
        return tracker;
    }

    private SyncTracker updateSyncStatus(SyncTracker tracker, ContentSyncStatus status) throws InterruptedException {
        int repoId;
        SubjectManagerLocal subjMgr;
        Subject overlord;
        RepoManagerLocal repoManager = LookupUtil.getRepoManagerLocal();
        RepoSyncResults cancelCheck = repoManager.getMostRecentSyncResults(overlord = (subjMgr = LookupUtil.getSubjectManager()).getOverlord(), repoId = tracker.getRepoId());
        if (cancelCheck.getStatus() == ContentSyncStatus.CANCELLING) {
            throw new InterruptedException();
        }
        RepoSyncResults results = tracker.getRepoSyncResults();
        results.setStatus(status);
        results = repoManager.mergeRepoSyncResults(results);
        tracker.setRepoSyncResults(results);
        return tracker;
    }

    public void testConnection(int contentSourceId) throws Exception {
        ContentProvider adapter = this.getIsolatedContentProvider(contentSourceId);
        adapter.testConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ContentSource> getAllContentSources() {
        Map<ContentSource, ContentProvider> map = this.adapters;
        synchronized (map) {
            return new HashSet<ContentSource>(this.adapters.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startAdapter(ContentSource contentSource) throws InitializationException {
        Map<ContentSource, ContentProvider> map = this.adapters;
        synchronized (map) {
            if (this.adapters.containsKey(contentSource)) {
                return;
            }
        }
        this.instantiateAdapter(contentSource);
        try {
            log.info((Object)("Initializing content source adapter for [" + contentSource + "] of type [" + contentSource.getContentSourceType() + "]"));
            ContentProvider adapter = this.getIsolatedContentSourceAdapter(contentSource);
            adapter.initialize(contentSource.getConfiguration());
        }
        catch (Exception e) {
            log.warn((Object)("Failed to initialize adapter for content source [" + contentSource.getName() + "]"));
            this.adapters.remove(contentSource);
            throw new InitializationException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void shutdownAdapter(ContentSource contentSource) {
        Map<ContentSource, ContentProvider> map = this.adapters;
        synchronized (map) {
            if (!this.adapters.containsKey(contentSource)) {
                return;
            }
        }
        try {
            try {
                log.info((Object)("Shutting down content source adapter for [" + contentSource + "] of type [" + contentSource.getContentSourceType() + "]"));
                ContentProvider adapter = this.getIsolatedContentSourceAdapter(contentSource);
                adapter.shutdown();
            }
            catch (Throwable t) {
                log.warn((Object)("Failed to shutdown adapter for content source [" + contentSource.getName() + "]"), t);
                Object var5_5 = null;
                this.adapters.remove(contentSource);
                return;
            }
            Object var5_4 = null;
            this.adapters.remove(contentSource);
            return;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.adapters.remove(contentSource);
            throw throwable;
        }
    }

    public void restartAdapter(ContentSource contentSource) throws Exception {
        this.shutdownAdapter(contentSource);
        this.startAdapter(contentSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContentProvider getIsolatedContentProvider(int contentProviderId) throws RuntimeException {
        Map<ContentSource, ContentProvider> map = this.adapters;
        synchronized (map) {
            for (ContentSource contentSource : this.adapters.keySet()) {
                if (contentSource.getId() != contentProviderId) continue;
                return this.getIsolatedContentSourceAdapter(contentSource);
            }
        }
        throw new RuntimeException("Content source ID [" + contentProviderId + "] doesn't exist; can't get adapter");
    }

    protected void initialize(ContentServerPluginManager pluginManager) {
        this.pluginManager = pluginManager;
        ContentSourceMetadataManagerLocal metadataManager = LookupUtil.getContentSourceMetadataManager();
        ContentSourceManagerLocal contentSourceManager = LookupUtil.getContentSourceManager();
        ContentSourcePluginMetadataManager pluginMetadataManager = this.pluginManager.getMetadataManager();
        Set<ContentSourceType> allTypes = pluginMetadataManager.getAllContentSourceTypes();
        metadataManager.registerTypes(allTypes);
        this.createInitialAdaptersMap();
        PageControl pc = PageControl.getUnlimitedInstance();
        Subject overlord = LookupUtil.getSubjectManager().getOverlord();
        PageList<ContentSource> contentSources = contentSourceManager.getAllContentSources(overlord, pc);
        if (contentSources != null) {
            for (ContentSource contentSource : contentSources) {
                try {
                    this.startAdapter(contentSource);
                }
                catch (Exception e) {
                    log.warn((Object)("Failed to start adapator for content source [" + contentSource + "]"));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdown() {
        HashMap<ContentSource, ContentProvider> adaptersCopy;
        Map<ContentSource, ContentProvider> map = this.adapters;
        synchronized (map) {
            adaptersCopy = new HashMap<ContentSource, ContentProvider>(this.adapters);
        }
        for (ContentSource contentSource : adaptersCopy.keySet()) {
            this.shutdownAdapter(contentSource);
        }
        map = this.adapters;
        synchronized (map) {
            this.adapters.clear();
        }
    }

    protected void createInitialAdaptersMap() {
        this.adapters = new HashMap<ContentSource, ContentProvider>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ContentProvider getIsolatedContentSourceAdapter(ContentSource contentSource) throws RuntimeException {
        ContentProvider adapter;
        Map<ContentSource, ContentProvider> map = this.adapters;
        synchronized (map) {
            adapter = this.adapters.get(contentSource);
        }
        if (adapter == null) {
            throw new RuntimeException("There is no adapter for content source [" + adapter + "]");
        }
        ServerPluginEnvironment env = this.pluginManager.getPluginEnvironment(contentSource.getContentSourceType());
        if (env == null) {
            throw new RuntimeException("There is no plugin env. for content source [" + contentSource + "]");
        }
        ClassLoader classLoader = env.getPluginClassLoader();
        IsolatedInvocationHandler handler = new IsolatedInvocationHandler(adapter, classLoader);
        ArrayList<Class<AdvisorySource>> ifacesList = new ArrayList<Class<AdvisorySource>>(1);
        ifacesList.add(ContentProvider.class);
        if (adapter instanceof RepoSource) {
            ifacesList.add(RepoSource.class);
        }
        if (adapter instanceof PackageSource) {
            ifacesList.add(PackageSource.class);
        }
        if (adapter instanceof DistributionSource) {
            ifacesList.add(DistributionSource.class);
        }
        if (adapter instanceof AdvisorySource) {
            ifacesList.add(AdvisorySource.class);
        }
        Class[] ifaces = ifacesList.toArray(new Class[ifacesList.size()]);
        return (ContentProvider)Proxy.newProxyInstance(classLoader, ifaces, (InvocationHandler)handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ContentProvider instantiateAdapter(ContentSource contentSource) {
        ContentProvider adapter = null;
        String apiClassName = "?";
        String pluginName = "?";
        try {
            ContentSourceType type = contentSource.getContentSourceType();
            apiClassName = type.getContentSourceApiClass();
            pluginName = this.pluginManager.getMetadataManager().getPluginNameFromContentSourceType(type);
            ServerPluginEnvironment pluginEnv = this.pluginManager.getPluginEnvironment(pluginName);
            ClassLoader pluginClassloader = pluginEnv.getPluginClassLoader();
            ClassLoader startingClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(pluginClassloader);
                Class<?> apiClass = Class.forName(apiClassName, true, pluginClassloader);
                if (ContentProvider.class.isAssignableFrom(apiClass)) {
                    adapter = (ContentProvider)apiClass.newInstance();
                } else {
                    log.warn((Object)("The API class [" + apiClassName + "] does not implement [" + ContentProvider.class.getName() + "] in plugin [" + pluginName + "]"));
                }
                Object var11_11 = null;
                Thread.currentThread().setContextClassLoader(startingClassLoader);
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                Thread.currentThread().setContextClassLoader(startingClassLoader);
                throw throwable;
            }
        }
        catch (Throwable t) {
            log.warn((Object)("Failed to create the API class [" + apiClassName + "] for plugin [" + pluginName + "]"), t);
        }
        if (adapter != null) {
            Map<ContentSource, ContentProvider> map = this.adapters;
            synchronized (map) {
                this.adapters.put(contentSource, adapter);
            }
        }
        return adapter;
    }

    private class IsolatedInvocationHandler
    implements InvocationHandler {
        private final Object instance;
        private final ClassLoader classLoader;

        public IsolatedInvocationHandler(Object obj, ClassLoader cl) {
            this.instance = obj;
            this.classLoader = cl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            ClassLoader startingClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.classLoader);
                Object object = method.invoke(this.instance, args);
                Object var7_6 = null;
                Thread.currentThread().setContextClassLoader(startingClassLoader);
                return object;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                Thread.currentThread().setContextClassLoader(startingClassLoader);
                throw throwable;
            }
        }
    }
}

