/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.operation;

import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.clientapi.server.operation.OperationServerService;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.operation.OperationHistory;
import org.rhq.core.domain.operation.OperationRequestStatus;
import org.rhq.core.domain.operation.ResourceOperationHistory;
import org.rhq.core.util.exception.ExceptionPackage;
import org.rhq.enterprise.server.operation.OperationManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class OperationServerServiceImpl
implements OperationServerService {
    private static final Log LOG = LogFactory.getLog(OperationServerServiceImpl.class);

    public void operationFailed(String jobId, Configuration result, ExceptionPackage error, long invocationTime, long completionTime) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Operation invocation [" + jobId + "] failed with error [" + error + "] " + this.getFromStartToEndTimestampString(invocationTime, completionTime)));
        }
        try {
            Subject superuser = LookupUtil.getSubjectManager().getOverlord();
            OperationManagerLocal operationManager = LookupUtil.getOperationManager();
            ResourceOperationHistory history = null;
            history = (ResourceOperationHistory)operationManager.getOperationHistoryByJobId(superuser, jobId);
            if (history.getStatus() != OperationRequestStatus.INPROGRESS) {
                LOG.debug((Object)("Was told an operation failed but, curiously, it was not in progress: job-id=[" + jobId + "], op-history=[" + history + "]"));
            }
            if (error != null) {
                history.setErrorMessage(error.getStackTraceString());
            } else {
                history.setErrorMessage("Failed for an unknown reason at " + new Date(completionTime));
            }
            history.setResults(result);
            history.setStatus(OperationRequestStatus.FAILURE);
            operationManager.updateOperationHistory(superuser, (OperationHistory)history);
            operationManager.checkForCompletedGroupOperation(history.getId());
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to update history from failed operation, jobId=[" + jobId + "]. Cause: " + e), (Throwable)e);
            LOG.error((Object)("The failed operation [" + jobId + "] had an error of: " + (error != null ? error.getStackTraceString() : "?")));
        }
    }

    public void operationSucceeded(String jobId, Configuration result, long invocationTime, long completionTime) {
        LOG.debug((Object)("Operation invocation [" + jobId + "] succeeded " + this.getFromStartToEndTimestampString(invocationTime, completionTime)));
        try {
            Subject superuser = LookupUtil.getSubjectManager().getOverlord();
            OperationManagerLocal operationManager = LookupUtil.getOperationManager();
            ResourceOperationHistory history = (ResourceOperationHistory)operationManager.getOperationHistoryByJobId(superuser, jobId);
            if (history.getStatus() != OperationRequestStatus.INPROGRESS) {
                LOG.debug((Object)("Was told an operation succeeded but, curiously, it was not in progress: job-id=[" + jobId + "], op-history=[" + history + "]"));
            }
            history.setErrorMessage(null);
            history.setResults(result);
            history.setStatus(OperationRequestStatus.SUCCESS);
            operationManager.updateOperationHistory(superuser, (OperationHistory)history);
            operationManager.checkForCompletedGroupOperation(history.getId());
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to update history from successful operation, jobId=[" + jobId + "]. Cause: " + e), (Throwable)e);
            LOG.error((Object)("The successful operation [" + jobId + "] had results of: " + result));
        }
    }

    public void operationTimedOut(String jobId, long invocationTime, long timeoutTime) {
        LOG.debug((Object)("Operation invocation [" + jobId + "] failed due to a timeout " + this.getFromStartToEndTimestampString(invocationTime, timeoutTime)));
        try {
            Subject superuser = LookupUtil.getSubjectManager().getOverlord();
            OperationManagerLocal operationManager = LookupUtil.getOperationManager();
            OperationHistory history = operationManager.getOperationHistoryByJobId(superuser, jobId);
            if (history.getStatus() == OperationRequestStatus.INPROGRESS) {
                history.setErrorMessage("Timed out");
                history.setStatus(OperationRequestStatus.FAILURE);
                operationManager.updateOperationHistory(superuser, history);
                operationManager.checkForCompletedGroupOperation(history.getId());
            } else {
                LOG.warn((Object)("Was told to timeout an operation history but it was not in progress: job-id=[" + jobId + "], op-history=[" + history + "]"));
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to update history from timed out operation, jobId=[" + jobId + "]. Cause: " + e), (Throwable)e);
        }
    }

    private String getFromStartToEndTimestampString(long startTime, long endTime) {
        Date startDate = new Date(startTime);
        Date endDate = new Date(endTime);
        return "(from " + startDate + " to " + endDate + ")";
    }
}

