/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.measurement;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.clientapi.server.measurement.MeasurementServerService;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.ResourceMeasurementScheduleRequest;
import org.rhq.core.util.collection.ArrayUtils;
import org.rhq.enterprise.server.measurement.MeasurementDataManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementScheduleManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MeasurementServerServiceImpl
implements MeasurementServerService {
    private Log log = LogFactory.getLog(MeasurementServerServiceImpl.class);

    public void mergeMeasurementReport(MeasurementReport report) {
        long start = System.currentTimeMillis();
        MeasurementDataManagerLocal dataManager = LookupUtil.getMeasurementDataManager();
        dataManager.mergeMeasurementReport(report);
        long time = System.currentTimeMillis() - start;
        if (time >= 10000L) {
            this.log.info((Object)("Performance: measurement merge [" + report.getDataCount() + "] timing (" + time + ")ms"));
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Performance: measurement merge [" + report.getDataCount() + "] timing (" + time + ")ms"));
        }
    }

    public Set<ResourceMeasurementScheduleRequest> getLatestSchedulesForResourceIds(Set<Integer> resourceIds, boolean getChildSchedules) {
        MeasurementScheduleManagerLocal measurementScheduleManager = LookupUtil.getMeasurementScheduleManager();
        long start = System.currentTimeMillis();
        Set<ResourceMeasurementScheduleRequest> results = measurementScheduleManager.findSchedulesForResourceAndItsDescendants(ArrayUtils.unwrapCollection(resourceIds), getChildSchedules);
        long time = System.currentTimeMillis() - start;
        if (time >= 10000L) {
            this.log.info((Object)("Performance: get measurement schedules timing: resourceCount/scheduleCount/millis=" + resourceIds.size() + '/' + results.size() + '/' + time));
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Performance: get measurement schedules timing: resourceCount/scheduleCount/millis=" + resourceIds.size() + '/' + results.size() + '/' + time));
        }
        return results;
    }

    public Set<ResourceMeasurementScheduleRequest> getLatestSchedulesForResourceId(int resourceId, boolean getChildSchedules) {
        HashSet<Integer> resourceIdSet = new HashSet<Integer>();
        resourceIdSet.add(resourceId);
        return this.getLatestSchedulesForResourceIds(resourceIdSet, getChildSchedules);
    }
}

