/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.common;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.BasicAction;
import com.arjuna.ats.arjuna.coordinator.CheckedAction;
import java.lang.reflect.Method;
import java.util.Hashtable;
import javax.interceptor.AroundInvoke;
import javax.interceptor.InvocationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.enterprise.server.common.InterruptOnTransactionTimeout;

public class TransactionInterruptInterceptor {
    private static Log LOG = LogFactory.getLog(TransactionInterruptInterceptor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AroundInvoke
    public Object addCheckedActionToTransactionManager(InvocationContext invocation_context) throws Exception {
        BasicAction currentTx = null;
        CheckedAction previousCheckedAction = null;
        try {
            currentTx = BasicAction.Current();
            if (currentTx != null) {
                Method method = invocation_context.getMethod();
                InterruptOnTransactionTimeout anno = method.getAnnotation(InterruptOnTransactionTimeout.class);
                boolean interrupt = anno != null ? anno.value() : false;
                TransactionInterruptCheckedAction newCheckedAction = new TransactionInterruptCheckedAction(interrupt);
                previousCheckedAction = currentTx.setCheckedAction((CheckedAction)newCheckedAction);
            }
        }
        catch (Throwable t) {
            LOG.warn((Object)("Failure - if the transaction is aborted, its threads cannot be notified. Cause: " + ThrowableUtil.getAllMessages((Throwable)t)));
        }
        try {
            Object object = invocation_context.proceed();
            return object;
        }
        finally {
            if (currentTx != null && previousCheckedAction != null) {
                try {
                    currentTx.setCheckedAction(previousCheckedAction);
                }
                catch (Exception e) {}
            }
        }
    }

    public class TransactionInterruptCheckedAction
    extends CheckedAction {
        private final boolean interruptThreads;

        public TransactionInterruptCheckedAction(boolean interrupt) {
            this.interruptThreads = interrupt;
        }

        public synchronized void check(boolean isCommit, Uid actUid, Hashtable list) {
            try {
                boolean interrupt = this.interruptThreads && !isCommit;
                String template = "Transaction [" + actUid + "] is " + (isCommit ? "committing" : "aborting") + " with active thread [{0}]. interrupting=[" + interrupt + ']';
                for (Object item : list.values()) {
                    Thread thread = (Thread)item;
                    String logMsg = template.replace("{0}", thread.getName());
                    if (LOG.isInfoEnabled()) {
                        try {
                            Throwable t = new Throwable("STACK TRACE OF ACTIVE THREAD IN TERMINATING TRANSACTION");
                            t.setStackTrace(thread.getStackTrace());
                            LOG.info((Object)logMsg, t);
                        }
                        catch (Exception e) {
                            LOG.warn((Object)logMsg);
                        }
                    } else {
                        LOG.warn((Object)logMsg);
                    }
                    if (!interrupt) continue;
                    thread.interrupt();
                }
            }
            catch (Exception e) {
                LOG.warn((Object)(((Object)((Object)this)).getClass() + ": check failed"), (Throwable)e);
            }
        }
    }
}

