/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.deployment;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.spi.Extension;
import org.jboss.as.weld.WeldModuleResourceLoader;
import org.jboss.as.weld.deployment.BeanDeploymentArchiveImpl;
import org.jboss.as.weld.services.bootstrap.ProxyServicesImpl;
import org.jboss.modules.Module;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.bootstrap.api.helpers.SimpleServiceRegistry;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.BeansXml;
import org.jboss.weld.bootstrap.spi.Deployment;
import org.jboss.weld.bootstrap.spi.Metadata;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.serialization.spi.ProxyServices;

public class WeldDeployment
implements Deployment {
    public static final String ADDITIONAL_CLASSES_BDA_SUFFIX = ".additionalClasses";
    private final Set<BeanDeploymentArchiveImpl> beanDeploymentArchives;
    private final BeanDeploymentArchiveImpl additionalBeanDeploymentArchive;
    private final Set<Metadata<Extension>> extensions;
    private final ServiceRegistry serviceRegistry;
    private final Module module;
    private final Set<ClassLoader> subDeploymentClassLoaders;
    private final Map<String, BeanDeploymentArchiveImpl> beanDeploymentsByClassName;

    public WeldDeployment(Set<BeanDeploymentArchiveImpl> beanDeploymentArchives, Collection<Metadata<Extension>> extensions, Module module, Set<ClassLoader> subDeploymentClassLoaders) {
        this.subDeploymentClassLoaders = new HashSet<ClassLoader>(subDeploymentClassLoaders);
        this.additionalBeanDeploymentArchive = new BeanDeploymentArchiveImpl(Collections.<String>emptySet(), BeansXml.EMPTY_BEANS_XML, module, this.getClass().getName() + ADDITIONAL_CLASSES_BDA_SUFFIX);
        this.beanDeploymentArchives = new HashSet<BeanDeploymentArchiveImpl>(beanDeploymentArchives);
        this.extensions = new HashSet<Metadata<Extension>>(extensions);
        this.serviceRegistry = new SimpleServiceRegistry();
        this.beanDeploymentsByClassName = new HashMap<String, BeanDeploymentArchiveImpl>();
        this.module = module;
        this.serviceRegistry.add(ProxyServices.class, (Service)new ProxyServicesImpl(module));
        this.serviceRegistry.add(ResourceLoader.class, (Service)new WeldModuleResourceLoader(module));
        for (BeanDeploymentArchiveImpl bda : beanDeploymentArchives) {
            bda.addBeanDeploymentArchive(this.additionalBeanDeploymentArchive);
            for (String className : bda.getBeanClasses()) {
                this.beanDeploymentsByClassName.put(className, bda);
            }
        }
        this.additionalBeanDeploymentArchive.addBeanDeploymentArchives(this.beanDeploymentArchives);
    }

    public Collection<BeanDeploymentArchive> getBeanDeploymentArchives() {
        return Collections.unmodifiableSet(new HashSet<BeanDeploymentArchiveImpl>(this.beanDeploymentArchives));
    }

    public Iterable<Metadata<Extension>> getExtensions() {
        return Collections.unmodifiableSet(this.extensions);
    }

    public ServiceRegistry getServices() {
        return this.serviceRegistry;
    }

    public synchronized BeanDeploymentArchive loadBeanDeploymentArchive(Class<?> beanClass) {
        if (this.beanDeploymentsByClassName.containsKey(beanClass.getName())) {
            return this.beanDeploymentsByClassName.get(beanClass.getName());
        }
        this.additionalBeanDeploymentArchive.addBeanClass(beanClass);
        this.beanDeploymentsByClassName.put(beanClass.getName(), this.additionalBeanDeploymentArchive);
        return this.additionalBeanDeploymentArchive;
    }

    public BeanDeploymentArchiveImpl getAdditionalBeanDeploymentArchive() {
        return this.additionalBeanDeploymentArchive;
    }

    public Module getModule() {
        return this.module;
    }

    public Set<ClassLoader> getSubDeploymentClassLoaders() {
        return Collections.unmodifiableSet(this.subDeploymentClassLoaders);
    }
}

