/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld;

import java.util.List;
import org.jboss.as.server.deployment.SetupAction;
import org.jboss.as.weld.SecurityActions;
import org.jboss.as.weld.WeldBootstrapService;
import org.jboss.as.weld.WeldLogger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class WeldStartService
implements Service<WeldStartService> {
    public static final ServiceName SERVICE_NAME = ServiceName.of((String[])new String[]{"WeldStartService"});
    private final InjectedValue<WeldBootstrapService> bootstrap = new InjectedValue();
    private final List<SetupAction> setupActions;
    private final ClassLoader classLoader;

    public WeldStartService(List<SetupAction> setupActions, ClassLoader classLoader) {
        this.setupActions = setupActions;
        this.classLoader = classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(StartContext context) throws StartException {
        ClassLoader oldTccl = SecurityActions.getContextClassLoader();
        try {
            for (SetupAction action : this.setupActions) {
                action.setup(null);
            }
            SecurityActions.setContextClassLoader(this.classLoader);
            ((WeldBootstrapService)this.bootstrap.getValue()).getBootstrap().startInitialization();
            ((WeldBootstrapService)this.bootstrap.getValue()).getBootstrap().deployBeans();
            ((WeldBootstrapService)this.bootstrap.getValue()).getBootstrap().validateBeans();
            ((WeldBootstrapService)this.bootstrap.getValue()).getBootstrap().endInitialization();
        }
        finally {
            for (SetupAction action : this.setupActions) {
                try {
                    action.teardown(null);
                }
                catch (Exception e) {
                    WeldLogger.DEPLOYMENT_LOGGER.exceptionClearingThreadState(e);
                }
            }
            SecurityActions.setContextClassLoader(oldTccl);
        }
    }

    public void stop(StopContext context) {
    }

    public WeldStartService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public InjectedValue<WeldBootstrapService> getBootstrap() {
        return this.bootstrap;
    }
}

