/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cmp.jdbc.metadata;

import java.lang.reflect.Method;
import java.util.Map;
import org.jboss.as.cmp.CmpMessages;
import org.jboss.as.cmp.jdbc.metadata.JDBCQueryMetaData;
import org.jboss.as.cmp.jdbc.metadata.JDBCReadAheadMetaData;

public final class JDBCDeclaredQueryMetaData
implements JDBCQueryMetaData {
    private final Method method;
    private final String additionalColumns;
    private final String from;
    private final String where;
    private final String order;
    private final String other;
    private final boolean distinct;
    private final String ejbName;
    private final String fieldName;
    private final String alias;
    private final JDBCReadAheadMetaData readAhead;
    private final boolean resultTypeMappingLocal;
    private final Class compiler;
    private final boolean lazyResultSetLoading;

    public JDBCDeclaredQueryMetaData(JDBCDeclaredQueryMetaData defaults, JDBCReadAheadMetaData readAhead, Class compiler, boolean lazyResultSetLoading) {
        this.method = defaults.getMethod();
        this.readAhead = readAhead;
        this.from = defaults.getFrom();
        this.where = defaults.getWhere();
        this.order = defaults.getOrder();
        this.other = defaults.getOther();
        this.resultTypeMappingLocal = defaults.isResultTypeMappingLocal();
        this.distinct = defaults.isSelectDistinct();
        this.ejbName = defaults.getEJBName();
        this.fieldName = defaults.getFieldName();
        this.alias = defaults.getAlias();
        this.additionalColumns = defaults.getAdditionalColumns();
        this.compiler = compiler;
        this.lazyResultSetLoading = lazyResultSetLoading;
    }

    public JDBCDeclaredQueryMetaData(boolean isResultTypeMappingLocal, Method method, JDBCReadAheadMetaData readAhead, Class compiler, boolean lazyResultSetLoading, Map<String, String> props) {
        this.compiler = compiler;
        this.lazyResultSetLoading = lazyResultSetLoading;
        this.method = method;
        this.readAhead = readAhead;
        this.from = props.get("from");
        this.where = props.get("where");
        this.order = props.get("order");
        this.other = props.get("other");
        this.resultTypeMappingLocal = isResultTypeMappingLocal;
        if (!props.isEmpty()) {
            boolean bl = this.distinct = props.get("distinct") != null;
            if (method.getName().startsWith("ejbSelect")) {
                this.ejbName = props.get("ejb-name");
                this.fieldName = props.get("field-name");
            } else {
                if (props.get("ejb-name") != null) {
                    throw CmpMessages.MESSAGES.declaredSqlElementNotAllowed("ejb-name");
                }
                if (props.get("field-name") != null) {
                    throw CmpMessages.MESSAGES.declaredSqlElementNotAllowed("field-name");
                }
                this.ejbName = null;
                this.fieldName = null;
            }
            this.alias = props.get("alias");
            this.additionalColumns = props.get("additional-columns");
        } else {
            if (method.getName().startsWith("ejbSelect")) {
                throw CmpMessages.MESSAGES.declaredSqlElementNotAllowed("select");
            }
            this.distinct = false;
            this.ejbName = null;
            this.fieldName = null;
            this.alias = null;
            this.additionalColumns = null;
        }
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    @Override
    public boolean isResultTypeMappingLocal() {
        return this.resultTypeMappingLocal;
    }

    @Override
    public JDBCReadAheadMetaData getReadAhead() {
        return this.readAhead;
    }

    public Class getQLCompilerClass() {
        return this.compiler;
    }

    public String getFrom() {
        return this.from;
    }

    public String getWhere() {
        return this.where;
    }

    public String getOrder() {
        return this.order;
    }

    public String getOther() {
        return this.other;
    }

    public boolean isSelectDistinct() {
        return this.distinct;
    }

    public String getEJBName() {
        return this.ejbName;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getAdditionalColumns() {
        return this.additionalColumns;
    }

    @Override
    public boolean isLazyResultSetLoading() {
        return this.lazyResultSetLoading;
    }

    public boolean equals(Object o) {
        if (o instanceof JDBCDeclaredQueryMetaData) {
            return ((JDBCDeclaredQueryMetaData)o).method.equals(this.method);
        }
        return false;
    }

    public int hashCode() {
        return this.method.hashCode();
    }

    public String toString() {
        return "[JDBCDeclaredQueryMetaData : method=" + this.method + "]";
    }

    private static String nullIfEmpty(String s) {
        if (s != null && s.trim().length() == 0) {
            s = null;
        }
        return s;
    }
}

