/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cmp.jdbc;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.ejb.FinderException;
import org.jboss.as.cmp.CmpMessages;
import org.jboss.as.cmp.context.CmpEntityBeanContext;
import org.jboss.as.cmp.jdbc.JDBCQueryCommand;
import org.jboss.as.cmp.jdbc.JDBCStoreManager;
import org.jboss.as.cmp.jdbc.ReadAheadCache;
import org.jboss.as.cmp.jdbc.metadata.JDBCReadAheadMetaData;
import org.jboss.as.ejb3.component.entity.EntityBeanComponentInstance;
import org.jboss.logging.Logger;

public final class JDBCCustomFinderQuery
implements JDBCQueryCommand {
    private final Logger log;
    private final Method finderMethod;
    private final JDBCReadAheadMetaData readAheadMetaData;
    private final ReadAheadCache readAheadCache;
    private final JDBCStoreManager manager;

    public JDBCCustomFinderQuery(JDBCStoreManager manager, Method finderMethod) {
        this.finderMethod = finderMethod;
        this.manager = manager;
        JDBCReadAheadMetaData readAheadMetaData = manager.getMetaData().getReadAhead();
        if (readAheadMetaData != null && readAheadMetaData.isOnLoad()) {
            this.readAheadCache = manager.getReadAheadCache();
            this.readAheadMetaData = readAheadMetaData;
        } else {
            this.readAheadCache = null;
            this.readAheadMetaData = null;
        }
        this.log = Logger.getLogger((String)(this.getClass().getName() + "." + manager.getMetaData().getName() + "." + finderMethod.getName()));
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Finder: Custom finder " + finderMethod.getName()));
        }
    }

    @Override
    public JDBCStoreManager getSelectManager() {
        return this.manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection execute(Method unused, Object[] args, CmpEntityBeanContext ctx, JDBCQueryCommand.EntityProxyFactory factory) throws FinderException {
        try {
            Object value;
            EntityBeanComponentInstance componentInstance = ctx.getComponent().getCache().get(ctx.getPrimaryKeyUnchecked());
            try {
                value = this.finderMethod.invoke((Object)componentInstance, args);
            }
            finally {
                ctx.getComponent().getCache().release(componentInstance, true);
            }
            if (value instanceof Enumeration) {
                Enumeration enumeration = (Enumeration)value;
                ArrayList<Object> result = new ArrayList<Object>();
                while (enumeration.hasMoreElements()) {
                    result.add(enumeration.nextElement());
                }
                this.cacheResults(result);
                return JDBCQueryCommand.EntityProxyFactory.Util.getEntityCollection(factory, result);
            }
            if (value instanceof Collection) {
                ArrayList<Object> result = value instanceof List ? (ArrayList<Object>)value : new ArrayList<Object>((Collection)value);
                this.cacheResults(result);
                return JDBCQueryCommand.EntityProxyFactory.Util.getEntityCollection(factory, result);
            }
            return Collections.singleton(value != null ? factory.getEntityObject(value) : null);
        }
        catch (IllegalAccessException e) {
            throw CmpMessages.MESSAGES.unableToAccessFinder(this.finderMethod.getName());
        }
        catch (IllegalArgumentException e) {
            throw CmpMessages.MESSAGES.illegalFinderArgument(this.finderMethod.getName());
        }
        catch (InvocationTargetException e) {
            Throwable ex = e.getTargetException();
            if (ex instanceof FinderException) {
                throw (FinderException)ex;
            }
            throw CmpMessages.MESSAGES.errorInvokingFinder(this.finderMethod.getName(), e);
        }
    }

    private void cacheResults(List listOfPKs) {
        if (this.readAheadCache != null) {
            this.readAheadCache.addFinderResults(listOfPKs, this.readAheadMetaData);
        }
    }
}

