/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.policies;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.HostDistance;
import com.datastax.driver.core.Query;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.google.common.collect.AbstractIterator;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public class DCAwareRoundRobinPolicy
implements LoadBalancingPolicy {
    private final ConcurrentMap<String, CopyOnWriteArrayList<Host>> perDcLiveHosts = new ConcurrentHashMap<String, CopyOnWriteArrayList<Host>>();
    private final AtomicInteger index = new AtomicInteger();
    private final String localDc;
    private final int usedHostsPerRemoteDc;
    private final boolean dontHopForLocalCL;

    public DCAwareRoundRobinPolicy(String localDc) {
        this(localDc, 0);
    }

    public DCAwareRoundRobinPolicy(String localDc, int usedHostsPerRemoteDc) {
        this(localDc, usedHostsPerRemoteDc, false);
    }

    public DCAwareRoundRobinPolicy(String localDc, int usedHostsPerRemoteDc, boolean allowRemoteDCsForLocalConsistencyLevel) {
        this.localDc = localDc;
        this.usedHostsPerRemoteDc = usedHostsPerRemoteDc;
        this.dontHopForLocalCL = !allowRemoteDCsForLocalConsistencyLevel;
    }

    @Override
    public void init(Cluster cluster, Collection<Host> hosts) {
        this.index.set(new Random().nextInt(Math.max(hosts.size(), 1)));
        for (Host host : hosts) {
            String dc = this.dc(host);
            CopyOnWriteArrayList prev = (CopyOnWriteArrayList)this.perDcLiveHosts.get(dc);
            if (prev == null) {
                this.perDcLiveHosts.put(dc, new CopyOnWriteArrayList<Host>(Collections.singletonList(host)));
                continue;
            }
            prev.addIfAbsent(host);
        }
    }

    private String dc(Host host) {
        String dc = host.getDatacenter();
        return dc == null ? this.localDc : dc;
    }

    private static CopyOnWriteArrayList<Host> cloneList(CopyOnWriteArrayList<Host> list) {
        return (CopyOnWriteArrayList)list.clone();
    }

    @Override
    public HostDistance distance(Host host) {
        String dc = this.dc(host);
        if (dc.equals(this.localDc)) {
            return HostDistance.LOCAL;
        }
        CopyOnWriteArrayList<Host> dcHosts = (CopyOnWriteArrayList<Host>)this.perDcLiveHosts.get(dc);
        if (dcHosts == null || this.usedHostsPerRemoteDc == 0) {
            return HostDistance.IGNORED;
        }
        return (dcHosts = DCAwareRoundRobinPolicy.cloneList(dcHosts)).subList(0, Math.min(dcHosts.size(), this.usedHostsPerRemoteDc)).contains(host) ? HostDistance.REMOTE : HostDistance.IGNORED;
    }

    @Override
    public Iterator<Host> newQueryPlan(final Query query) {
        CopyOnWriteArrayList localLiveHosts = (CopyOnWriteArrayList)this.perDcLiveHosts.get(this.localDc);
        final List hosts = localLiveHosts == null ? Collections.emptyList() : DCAwareRoundRobinPolicy.cloneList(localLiveHosts);
        final int startIdx = this.index.getAndIncrement();
        return new AbstractIterator<Host>(){
            private int idx;
            private int remainingLocal;
            private Iterator<String> remoteDcs;
            private List<Host> currentDcHosts;
            private int currentDcRemaining;
            {
                this.idx = startIdx;
                this.remainingLocal = hosts.size();
            }

            protected Host computeNext() {
                if (this.remainingLocal > 0) {
                    int c;
                    --this.remainingLocal;
                    if ((c = this.idx++ % hosts.size()) < 0) {
                        c += hosts.size();
                    }
                    return (Host)hosts.get(c);
                }
                if (this.currentDcHosts != null && this.currentDcRemaining > 0) {
                    int c;
                    --this.currentDcRemaining;
                    if ((c = this.idx++ % this.currentDcHosts.size()) < 0) {
                        c += this.currentDcHosts.size();
                    }
                    return this.currentDcHosts.get(c);
                }
                if (DCAwareRoundRobinPolicy.this.dontHopForLocalCL && query.getConsistencyLevel() != null && query.getConsistencyLevel().isDCLocal()) {
                    return (Host)this.endOfData();
                }
                if (this.remoteDcs == null) {
                    HashSet copy = new HashSet(DCAwareRoundRobinPolicy.this.perDcLiveHosts.keySet());
                    copy.remove(DCAwareRoundRobinPolicy.this.localDc);
                    this.remoteDcs = copy.iterator();
                }
                if (!this.remoteDcs.hasNext()) {
                    return (Host)this.endOfData();
                }
                String nextRemoteDc = this.remoteDcs.next();
                CopyOnWriteArrayList nextDcHosts = (CopyOnWriteArrayList)DCAwareRoundRobinPolicy.this.perDcLiveHosts.get(nextRemoteDc);
                if (nextDcHosts != null) {
                    CopyOnWriteArrayList dcHosts = DCAwareRoundRobinPolicy.cloneList(nextDcHosts);
                    this.currentDcHosts = dcHosts.subList(0, Math.min(dcHosts.size(), DCAwareRoundRobinPolicy.this.usedHostsPerRemoteDc));
                    this.currentDcRemaining = this.currentDcHosts.size();
                }
                return this.computeNext();
            }
        };
    }

    @Override
    public void onUp(Host host) {
        CopyOnWriteArrayList<Host> newMap;
        String dc = this.dc(host);
        CopyOnWriteArrayList<Host> dcHosts = (CopyOnWriteArrayList<Host>)this.perDcLiveHosts.get(dc);
        if (dcHosts == null && (dcHosts = this.perDcLiveHosts.putIfAbsent(dc, newMap = new CopyOnWriteArrayList<Host>(Collections.singletonList(host)))) == null) {
            return;
        }
        dcHosts.addIfAbsent(host);
    }

    @Override
    public void onDown(Host host) {
        CopyOnWriteArrayList dcHosts = (CopyOnWriteArrayList)this.perDcLiveHosts.get(this.dc(host));
        if (dcHosts != null) {
            dcHosts.remove(host);
        }
    }

    @Override
    public void onAdd(Host host) {
        this.onUp(host);
    }

    @Override
    public void onRemove(Host host) {
        this.onDown(host);
    }
}

