/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.exceptions;

import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.WriteType;
import com.datastax.driver.core.exceptions.DriverException;
import com.datastax.driver.core.exceptions.QueryTimeoutException;

public class WriteTimeoutException
extends QueryTimeoutException {
    private static final long serialVersionUID = 0L;
    private final WriteType writeType;

    public WriteTimeoutException(ConsistencyLevel consistency, WriteType writeType, int received, int required) {
        super(String.format("Cassandra timeout during write query at consistency %s (%d replica were required but only %d acknowledged the write)", new Object[]{consistency, required, received}), consistency, received, required);
        this.writeType = writeType;
    }

    private WriteTimeoutException(String msg, Throwable cause, ConsistencyLevel consistency, WriteType writeType, int received, int required) {
        super(msg, cause, consistency, received, required);
        this.writeType = writeType;
    }

    public WriteType getWriteType() {
        return this.writeType;
    }

    @Override
    public DriverException copy() {
        return new WriteTimeoutException(this.getMessage(), this, this.getConsistencyLevel(), this.getWriteType(), this.getReceivedAcknowledgements(), this.getRequiredAcknowledgements());
    }
}

