/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.module;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.jar.Manifest;
import org.jboss.as.server.ServerMessages;
import org.jboss.modules.AbstractResourceLoader;
import org.jboss.modules.ClassSpec;
import org.jboss.modules.IterableResourceLoader;
import org.jboss.modules.PackageSpec;
import org.jboss.modules.PathUtils;
import org.jboss.modules.Resource;
import org.jboss.modules.filter.PathFilter;
import org.jboss.modules.filter.PathFilters;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VFSUtils;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VirtualFileFilter;
import org.jboss.vfs.VirtualFileVisitor;
import org.jboss.vfs.VisitorAttributes;
import org.jboss.vfs.util.FilterVirtualFileVisitor;

public class VFSResourceLoader
extends AbstractResourceLoader
implements IterableResourceLoader {
    private final VirtualFile root;
    private final String rootName;
    private final Manifest manifest;
    private final URL rootUrl;

    public VFSResourceLoader(String rootName, VirtualFile root) throws IOException {
        this(rootName, root, false);
    }

    public VFSResourceLoader(String rootName, VirtualFile root, boolean usePhysicalCodeSource) throws IOException {
        this.root = root;
        this.rootName = rootName;
        this.manifest = VFSUtils.getManifest((VirtualFile)root);
        this.rootUrl = usePhysicalCodeSource ? VFSUtils.getRootURL((VirtualFile)root) : root.asFileURL();
    }

    public ClassSpec getClassSpec(String name) throws IOException {
        VirtualFile file = this.root.getChild(name);
        if (!file.exists()) {
            return null;
        }
        long size = file.getSize();
        ClassSpec spec = new ClassSpec();
        InputStream is = file.openStream();
        try {
            if (size <= Integer.MAX_VALUE) {
                int res;
                int castSize = (int)size;
                byte[] bytes = new byte[castSize];
                int a = 0;
                while ((res = is.read(bytes, a, castSize - a)) > 0) {
                    a += res;
                }
                is.close();
                spec.setBytes(bytes);
                spec.setCodeSource(new CodeSource(this.rootUrl, file.getCodeSigners()));
                ClassSpec classSpec = spec;
                return classSpec;
            }
            throw ServerMessages.MESSAGES.resourceTooLarge();
        }
        finally {
            VFSUtils.safeClose((Closeable)is);
        }
    }

    public PackageSpec getPackageSpec(String name) throws IOException {
        return VFSResourceLoader.getPackageSpec((String)name, (Manifest)this.manifest, (URL)this.rootUrl);
    }

    public String getLibrary(String name) {
        return null;
    }

    public String getRootName() {
        return this.rootName;
    }

    public PathFilter getExportFilter() {
        return PathFilters.acceptAll();
    }

    public Resource getResource(String name) {
        try {
            VirtualFile file = this.root.getChild(PathUtils.canonicalize((String)name));
            if (!file.exists()) {
                return null;
            }
            return new VFSEntryResource(file.getPathNameRelativeTo(this.root), file, file.toURL());
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getPaths() {
        ArrayList<String> index = new ArrayList<String>();
        VirtualFile indexFile = VFS.getChild((String)(this.root.getPathName() + ".index"));
        if (indexFile.exists()) {
            ArrayList<String> arrayList;
            BufferedReader r = new BufferedReader(new InputStreamReader(indexFile.openStream()));
            try {
                String s;
                while ((s = r.readLine()) != null) {
                    index.add(s.trim());
                }
                arrayList = index;
            }
            catch (Throwable throwable) {
                try {
                    r.close();
                    throw throwable;
                }
                catch (IOException e) {
                    index.clear();
                }
            }
            r.close();
            return arrayList;
        }
        FilterVirtualFileVisitor visitor = new FilterVirtualFileVisitor(new VirtualFileFilter(){

            public boolean accepts(VirtualFile file) {
                return file.isDirectory();
            }
        }, VisitorAttributes.RECURSE);
        try {
            this.root.visit((VirtualFileVisitor)visitor);
        }
        catch (IOException e) {
            index.clear();
        }
        index.add("");
        for (VirtualFile dir : visitor.getMatched()) {
            index.add(dir.getPathNameRelativeTo(this.root));
        }
        return index;
    }

    public Iterator<Resource> iterateResources(String startPath, boolean recursive) {
        Iterator children;
        VirtualFile child = this.root.getChild(startPath);
        if (startPath.length() > 1 && child == this.root) {
            return Collections.emptySet().iterator();
        }
        VirtualFileFilter filter = new VirtualFileFilter(){

            public boolean accepts(VirtualFile file) {
                return file.isFile();
            }
        };
        try {
            children = (recursive ? child.getChildrenRecursively(filter) : child.getChildren(filter)).iterator();
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        return new Iterator<Resource>(){

            @Override
            public boolean hasNext() {
                return children.hasNext();
            }

            @Override
            public Resource next() {
                URL fileURL;
                VirtualFile file = (VirtualFile)children.next();
                try {
                    fileURL = file.toURL();
                }
                catch (MalformedURLException ex) {
                    throw new IllegalStateException(ex);
                }
                return new VFSEntryResource(file.getPathNameRelativeTo(VFSResourceLoader.this.root), file, fileURL);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    static class VFSEntryResource
    implements Resource {
        private final String name;
        private final VirtualFile entry;
        private final URL resourceURL;

        VFSEntryResource(String name, VirtualFile entry, URL resourceURL) {
            this.name = name;
            this.entry = entry;
            this.resourceURL = resourceURL;
        }

        public String getName() {
            return this.name;
        }

        public URL getURL() {
            return this.resourceURL;
        }

        public InputStream openStream() throws IOException {
            return this.entry.openStream();
        }

        public long getSize() {
            long size = this.entry.getSize();
            return size == -1L ? 0L : size;
        }
    }
}

