/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server;

import java.io.File;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.MountType;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.server.services.security.VaultReaderException;
import org.jboss.dmr.ModelNode;
import org.jboss.invocation.proxy.MethodIdentifier;
import org.jboss.logging.Messages;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageBundle;
import org.jboss.logging.annotations.Param;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceNotFoundException;
import org.jboss.msc.service.StartException;
import org.jboss.vfs.VirtualFile;

@MessageBundle(projectCode="JBAS")
public interface ServerMessages {
    public static final ServerMessages MESSAGES = (ServerMessages)Messages.getBundle(ServerMessages.class);

    @Message(id=0, value="Usage: ./standalone.sh [args...]%nwhere args include:")
    public String argUsage();

    @Message(id=0, value="Name of the server configuration file to use (default is \"standalone.xml\") (Same as -c)")
    public String argServerConfig();

    @Message(id=0, value="Name of the server configuration file to use (default is \"standalone.xml\") (Same as --server-config)")
    public String argShortServerConfig();

    @Message(id=0, value="Name of the server configuration file to use. This differs from '--server-config' and '-c' in that the original file is never overwritten.")
    public String argReadOnlyServerConfig();

    @Message(id=0, value="Display this message and exit")
    public String argHelp();

    @Message(id=0, value="Load system properties from the given url")
    public String argProperties();

    @Message(id=0, value="Set a security property")
    public String argSecurityProperty();

    @Message(id=0, value="Set a system property")
    public String argSystem();

    @Message(id=0, value="Print version and exit")
    public String argVersion();

    @Message(id=0, value="Set system property jboss.bind.address to the given value")
    public String argPublicBindAddress();

    @Message(id=0, value="Set system property jboss.bind.address.<interface> to the given value")
    public String argInterfaceBindAddress();

    @Message(id=0, value="Set system property jboss.default.multicast.address to the given value")
    public String argDefaultMulticastAddress();

    @Message(id=0, value="Set the server's running type to ADMIN_ONLY causing it to open administrative interfaces and accept management requests but not start other runtime services or accept end user requests.")
    public String argAdminOnly();

    @Message(id=0, value="Activate debug mode with an optional argument to specify the port. Only works if the launch script supports it.")
    public String argDebugPort();

    @Message(id=15800, value="Value expected for option %s")
    public String valueExpectedForCommandLineOption(String var1);

    @Message(id=15801, value="Invalid option '%s'")
    public String invalidCommandLineOption(String var1);

    @Message(id=15802, value="Malformed URL '%s' provided for option '%s'")
    public String malformedCommandLineURL(String var1, String var2);

    @Message(id=15803, value="Unable to load properties from URL '%s'")
    public String unableToLoadProperties(URL var1);

    @Message(id=15804, value="Error initializing vault --  %s")
    public RuntimeException cannotCreateVault(@Param VaultReaderException var1, VaultReaderException var2);

    @Message(id=15805, value="Failed to connect to the host-controller")
    public StartException failedToConnectToHC(@Param Exception var1);

    @Message(id=15806, value="Connection request to the host-controller was cancelled")
    public StartException cancelledHCConnect();

    @Message(id=15807, value="hostControllerName must be null if the server is not in a managed domain")
    public IllegalArgumentException hostControllerNameNonNullInStandalone();

    @Message(id=15808, value="hostControllerName may not be null if the server is in a managed domain")
    public IllegalArgumentException hostControllerNameNullInDomain();

    @Message(id=15809, value="An IP address cannot be resolved using the given interface selection criteria. Failure was -- %s")
    public OperationFailedException cannotResolveInterface(Exception var1, @Param Exception var2);

    @Message(id=15810, value="failed to resolve interface %s")
    public StartException failedToResolveInterface(String var1);

    @Message(id=15811, value="Failed to start the http-interface service")
    public StartException failedToStartHttpManagementService(@Param Exception var1);

    @Message(id=15812, value="No deployment content with hash %s is available in the deployment content repository.")
    public OperationFailedException noSuchDeploymentContent(String var1);

    @Message(id=15813, value="No deployment with name %s found")
    public OperationFailedException noSuchDeployment(String var1);

    @Message(id=15814, value="Cannot use %s with the same value for parameters %s and %s. Use %s to redeploy the same content or %s to replace content with a new version with the same name.")
    public OperationFailedException cannotReplaceDeployment(String var1, String var2, String var3, String var4, String var5);

    @Message(id=15815, value="Deployment %s is already started")
    public OperationFailedException deploymentAlreadyStarted(String var1);

    @Message(id=15816, value="Missing configuration value for: %s")
    public IllegalStateException missingHomeDirConfiguration(String var1);

    @Message(id=15817, value="%n        %s is missing: %s")
    public String missingDependencies(ServiceName var1, String var2);

    @Message(id=15818, value="%s is required")
    public OperationFailedException attributeIsRequired(String var1);

    @Message(id=15819, value="%s is not allowed when %s are present")
    public OperationFailedException attributeNotAllowedWhenAlternativeIsPresent(String var1, List<String> var2);

    @Message(id=15820, value="%s is invalid")
    public OperationFailedException attributeIsInvalid(String var1);

    @Message(id=15821, value="Caught IOException reading uploaded deployment content")
    public OperationFailedException caughtIOExceptionUploadingContent(@Cause IOException var1);

    @Message(id=15822, value="Null stream at index [%d]")
    public OperationFailedException nullStreamAttachment(int var1);

    @Message(id=15823, value="'%s' is not a valid URL")
    public OperationFailedException invalidDeploymentURL(String var1, @Cause MalformedURLException var2);

    @Message(id=15824, value="Error obtaining input stream from URL '%s'")
    public OperationFailedException problemOpeningStreamFromDeploymentURL(String var1, @Cause IOException var2);

    @Message(id=15826, value="ServiceModuleLoader already started")
    public IllegalStateException serviceModuleLoaderAlreadyStarted();

    @Message(id=15827, value="ServiceModuleLoader already stopped")
    public IllegalStateException serviceModuleLoaderAlreadyStopped();

    @Message(id=15828, value="'%s' cannot be loaded from a ServiceModuleLoader as its name does not start with '%s'")
    public IllegalArgumentException missingModulePrefix(ModuleIdentifier var1, String var2);

    @Message(id=15829, value="Failed to read '%s'")
    public DeploymentUnitProcessingException failedToReadVirtualFile(VirtualFile var1, @Cause IOException var2);

    @Message(id=15830, value="Deployment root is required")
    public IllegalArgumentException deploymentRootRequired();

    @Message(id=15831, value="Sub-deployments require a parent deployment unit")
    public IllegalArgumentException subdeploymentsRequireParent();

    @Message(id=15832, value="No Module Identifier attached to deployment '%s'")
    public DeploymentUnitProcessingException noModuleIdentifier(String var1);

    @Message(id=15834, value="Failed to create VFSResourceLoader for root [%s]")
    public DeploymentUnitProcessingException failedToCreateVFSResourceLoader(String var1, @Cause IOException var2);

    @Message(id=15835, value="Failed to get file from remote repository")
    public RuntimeException failedToGetFileFromRemoteRepository(@Cause Throwable var1);

    @Message(id=15836, value="Unable to create local directory: %s")
    public IOException cannotCreateLocalDirectory(File var1);

    @Message(id=15837, value="Did not read the entire file. Missing: %d")
    public IOException didNotReadEntireFile(long var1);

    @Message(id=15838, value="No value was provided for argument %s%n")
    public String noArgValue(String var1);

    @Message(id=15839, value="Could not find the file repository connection to the host controller.")
    public IllegalStateException couldNotFindHcFileRepositoryConnection();

    @Message(id=15840, value="Only 'hash' is allowed for deployment addition for a domain mode server: %s")
    public IllegalStateException onlyHashAllowedForDeploymentAddInDomainServer(ModelNode var1);

    @Message(id=15841, value="Only 'hash' is allowed for deployment full replacement for a domain mode server: %s")
    public IllegalStateException onlyHashAllowedForDeploymentFullReplaceInDomainServer(ModelNode var1);

    @Message(id=15842, value="Unknown mount type %s")
    public IllegalArgumentException unknownMountType(MountType var1);

    @Message(id=15843, value="Failed to create temp file provider")
    public StartException failedCreatingTempProvider();

    @Message(id=15844, value="%s cannot be defined when either %s or %s is also defined")
    public OperationFailedException illegalCombinationOfHttpManagementInterfaceConfigurations(String var1, String var2, String var3);

    @Message(id=15845, value="System property %s cannot be set via the xml configuration file or from a management client; it's value must be known at initial process start so it can only set from the commmand line")
    public OperationFailedException systemPropertyNotManageable(String var1);

    @Message(id=15846, value="System property %s cannot be set after the server name has been set via the xml configuration file or from a management client")
    public OperationFailedException systemPropertyCannotOverrideServerName(String var1);

    @Message(id=15847, value="Unable to initialise a basic SSLContext '%s'")
    public IOException unableToInitialiseSSLContext(String var1);

    @Message(id=15848, value="Determined modules directory does not exist: %s")
    public IllegalStateException modulesDirectoryDoesNotExist(File var1);

    @Message(id=15849, value="Home directory does not exist: %s")
    public IllegalStateException homeDirectoryDoesNotExist(File var1);

    @Message(id=18700, value="Bundles directory does not exist: %s")
    public IllegalStateException bundlesDirectoryDoesNotExist(File var1);

    @Message(id=18701, value="Configuration directory does not exist: %s")
    public IllegalStateException configDirectoryDoesNotExist(File var1);

    @Message(id=18702, value="Server base directory does not exist: %s")
    public IllegalStateException serverBaseDirectoryDoesNotExist(File var1);

    @Message(id=18703, value="Server data directory is not a directory: %s")
    public IllegalStateException serverDataDirectoryIsNotDirectory(File var1);

    @Message(id=18704, value="Could not create server data directory: %s")
    public IllegalStateException couldNotCreateServerDataDirectory(File var1);

    @Message(id=18705, value="Server content directory is not a directory: %s")
    public IllegalStateException serverContentDirectoryIsNotDirectory(File var1);

    @Message(id=18706, value="Could not create server content directory: %s")
    public IllegalStateException couldNotCreateServerContentDirectory(File var1);

    @Message(id=18707, value="Log directory is not a directory: %s")
    public IllegalStateException logDirectoryIsNotADirectory(File var1);

    @Message(id=18708, value="Could not create log directory: %s")
    public IllegalStateException couldNotCreateLogDirectory(File var1);

    @Message(id=18709, value="Server temp directory does not exist: %s")
    public IllegalStateException serverTempDirectoryIsNotADirectory(File var1);

    @Message(id=18710, value="Could not create server temp directory: %s")
    public IllegalStateException couldNotCreateServerTempDirectory(File var1);

    @Message(id=18711, value="Controller temp directory does not exist: %s")
    public IllegalStateException controllerTempDirectoryIsNotADirectory(File var1);

    @Message(id=18712, value="Could not create server temp directory: %s")
    public IllegalStateException couldNotCreateControllerTempDirectory(File var1);

    @Message(id=18713, value="Domain base dir does not exist: %s")
    public IllegalStateException domainBaseDirDoesNotExist(File var1);

    @Message(id=18714, value="Domain config dir does not exist: %s")
    public IllegalStateException domainConfigDirDoesNotExist(File var1);

    @Message(id=18715, value="Server base directory is not a directory: %s")
    public IllegalStateException serverBaseDirectoryIsNotADirectory(File var1);

    @Message(id=18716, value="Could not create server base directory: %s")
    public IllegalStateException couldNotCreateServerBaseDirectory(File var1);

    @Message(id=18717, value="No deployment content with hash %s is available in the deployment content repository for deployment '%s'. This is a fatal boot error. To correct the problem, either restart with the --admin-only switch set and use the CLI to install the missing content or remove it from the configuration, or remove the deployment from the xml configuration file and restart.")
    public OperationFailedException noSuchDeploymentContentAtBoot(String var1, String var2);

    @Message(id=0, value="Configured system properties:")
    public String configuredSystemPropertiesLabel();

    @Message(id=0, value="VM Arguments: %s")
    public String vmArgumentsLabel(String var1);

    @Message(id=0, value="Configured system environment:")
    public String configuredSystemEnvironmentLabel();

    @Message(id=18718, value="VFS is not available from the configured module loader")
    public IllegalStateException vfsNotAvailable();

    @Message(id=18719, value="Server controller service was removed")
    public ServiceNotFoundException serverControllerServiceRemoved();

    @Message(id=18720, value="Root service was removed")
    public IllegalStateException rootServiceRemoved();

    @Message(id=18721, value="Cannot start server")
    public IllegalStateException cannotStartServer(@Cause Exception var1);

    @Message(id=18722, value="Naming context has not been set")
    public IllegalStateException namingContextHasNotBeenSet();

    @Message(id=18723, value="No directory called '%s' exists under '%s'")
    public IllegalArgumentException embeddedServerDirectoryNotFound(String var1, String var2);

    @Message(id=18724, value="-D%s=%s does not exist")
    public IllegalArgumentException propertySpecifiedFileDoesNotExist(String var1, String var2);

    @Message(id=18725, value="-D%s=%s is not a directory")
    public IllegalArgumentException propertySpecifiedFileIsNotADirectory(String var1, String var2);

    @Message(id=18726, value="Error copying '%s' to '%s'")
    public RuntimeException errorCopyingFile(String var1, String var2, @Cause IOException var3);

    @Message(id=18727, value="%s is null")
    public InvalidObjectException invalidObject(String var1);

    @Message(id=18728, value="portOffset is out of range")
    public InvalidObjectException invalidPortOffset();

    @Message(id=18729, value="Invalid '%s' value: %d, the maximum index is %d")
    public OperationFailedException invalidStreamIndex(String var1, int var2, int var3);

    @Message(id=18730, value="Cannot create input stream from URL '%s'")
    public OperationFailedException invalidStreamURL(@Cause Exception var1, String var2);

    @Message(id=18731, value="No bytes available at param %s")
    public OperationFailedException invalidStreamBytes(String var1);

    @Message(id=18732, value="Only 1 piece of content is current supported (AS7-431)")
    public OperationFailedException multipleContentItemsNotSupported();

    @Message(id=18733, value="Failed to process phase %s of %s")
    public StartException deploymentPhaseFailed(Phase var1, DeploymentUnit var2, @Cause Throwable var3);

    @Message(id=18734, value="Null initial deployment unit")
    public IllegalArgumentException nullInitialDeploymentUnit();

    @Message(id=18735, value="Attachment key is null")
    public IllegalArgumentException nullAttachmentKey();

    @Message(id=18736, value="Failed to index deployment root for annotations")
    public DeploymentUnitProcessingException deploymentIndexingFailed(@Cause Throwable var1);

    @Message(id=18737, value="No Seam Integration jar present: %s")
    public DeploymentUnitProcessingException noSeamIntegrationJarPresent(Module var1);

    @Message(id=18738, value="Failed to instantiate a %s")
    public DeploymentUnitProcessingException failedToInstantiateClassFileTransformer(String var1, @Cause Exception var2);

    @Message(id=18739, value="No deployment repository available.")
    public DeploymentUnitProcessingException noDeploymentRepositoryAvailable();

    @Message(id=18740, value="Failed to mount deployment content")
    public DeploymentUnitProcessingException deploymentMountFailed(@Cause IOException var1);

    @Message(id=18741, value="Failed to get manifest for deployment %s")
    public DeploymentUnitProcessingException failedToGetManifest(VirtualFile var1, @Cause IOException var2);

    @Message(id=18742, value="Invalid dependency: %s")
    public RuntimeException invalidDependency(String var1);

    @Message(id=18743, value="Cannot merge resource root for a different file. This: %s mergee: %s")
    public IllegalArgumentException cannotMergeResourceRoot(VirtualFile var1, VirtualFile var2);

    @Message(id=18744, value="Failed to create temp file provider")
    public RuntimeException failedToCreateTempFileProvider(@Cause IOException var1);

    @Message(id=18745, value="Resource is too large to be a valid class file")
    public IOException resourceTooLarge();

    @Message(id=18746, value="Sub deployment %s in jboss-deployment-structure.xml was not found. Available sub deployments: %s")
    public DeploymentUnitProcessingException subdeploymentNotFound(String var1, StringBuilder var2);

    @Message(id=18747, value="No jboss-deployment-structure.xml file found at %s")
    public DeploymentUnitProcessingException deploymentStructureFileNotFound(File var1);

    @Message(id=18748, value="Error loading jboss-deployment-structure.xml from %s")
    public DeploymentUnitProcessingException errorLoadingDeploymentStructureFile(String var1, @Cause XMLStreamException var2);

    @Message(id=18749, value="Sub deployment '%s' is listed twice in jboss-deployment-structure.xml")
    public XMLStreamException duplicateSubdeploymentListing(String var1);

    @Message(id=18750, value="Additional module name '%s' is not valid. Names must start with 'deployment.'")
    public XMLStreamException invalidModuleName(String var1);

    @Message(id=18751, value="External resource roots not supported, resource roots may not start with a '/' : %s")
    public XMLStreamException externalResourceRootsNotSupported(String var1);

    @Message(id=18752, value="Unexpected end of document")
    public XMLStreamException unexpectedEndOfDocument(@Param Location var1);

    @Message(id=18753, value="Missing one or more required attributes:%s")
    public XMLStreamException missingRequiredAttributes(String var1, @Param Location var2);

    @Message(id=18754, value="Unexpected content of type '%s', name is '%s', text is: '%s'")
    public XMLStreamException unexpectedContent(String var1, QName var2, String var3, @Param Location var4);

    @Message(id=18755, value="No method found with id: %s on class (or its super class) %s")
    public DeploymentUnitProcessingException noMethodFound(MethodIdentifier var1, Class<?> var2);

    @Message(id=18756, value="Method cannot be null")
    public IllegalArgumentException nullMethod();

    @Message(id=18757, value="Error getting reflective information for %s with ClassLoader %s")
    public RuntimeException errorGettingReflectiveInformation(Class<?> var1, ClassLoader var2, @Param Throwable var3);

    @Message(id=18758, value="External Module Service already started")
    public IllegalStateException externalModuleServiceAlreadyStarted();

    @Message(id=18759, value="Failed to load module: %s")
    public StartException failedToLoadModule(ModuleIdentifier var1, @Cause ModuleLoadException var2);

    @Message(id=18761, value="%s cannot be defined when %s is also defined")
    public OperationFailedException conflictingConfigs(String var1, String var2);

    @Message(id=18762, value="This operation is for internal use only")
    public OperationFailedException internalUseOnly();

    @Message(id=18763, value="Was not able to get root resource")
    public RuntimeException cannotGetRootResource();

    @Message(id=18764, value="Failed to resolve expression: %s")
    public IllegalStateException failedToResolveExpression(String var1);

    @Message(id=18765, value="Unexpected char seen: %s")
    public IllegalStateException unexpectedChar(String var1);

    @Message(id=18766, value="Incomplete expression: %s")
    public IllegalStateException incompleteExpression(String var1);

    @Message(id=18767, value="Failed to get multicast address for %s")
    public OperationFailedException failedToResolveMulticastAddress(@Cause UnknownHostException var1, String var2);

    @Message(id=18768, value="Failed to get multicast address for %s")
    public RuntimeException failedToResolveMulticastAddressForRollback(@Cause UnknownHostException var1, String var2);

    @Message(id=18769, value="Validation for %s is not implemented")
    public UnsupportedOperationException attributeValidationUnimplemented(String var1);

    @Message(id=18770, value="Cannot add more than one socket binding group. Add of '%s' attempted, but '%s' already exists")
    public OperationFailedException cannotAddMoreThanOneSocketBindingGroupForServer(PathAddress var1, PathAddress var2);

    @Message(id=18771, value="Can't use both --server-config and --initial-server-config")
    public IllegalArgumentException cannotHaveBothInitialServerConfigAndServerConfig();

    @Message(id=18772, value="Duplicate namespace %s in jboss-all.xml")
    public XMLStreamException duplicateJBossXmlNamespace(QName var1, @Param Location var2);

    @Message(id=18773, value="Two different versions of the same namespaces are present in jboss-all.xml, %s and %s are both present")
    public DeploymentUnitProcessingException equivilentNamespacesInJBossXml(QName var1, QName var2);

    @Message(id=18774, value="Error loading jboss-all.xml from %s")
    public DeploymentUnitProcessingException errorLoadingJBossXmlFile(String var1, @Cause XMLStreamException var2);

    @Message(id=18775, value="Cannot obtain required module for: %s")
    public IllegalStateException nullModuleAttachment(DeploymentUnit var1);

    @Message(id=18776, value="Failed to get content for deployment overlay %s at %s")
    public DeploymentUnitProcessingException deploymentOverlayFailed(@Cause Exception var1, String var2, String var3);

    @Message(id=18777, value="Wildcard character * is only allowed at the beginning or end of the deployment name %s")
    public OperationFailedException wildcardOnlyAllowedAtStartOrEnd(String var1);

    @Message(id=18778, value="No deployment overlay content with hash %s is available in the deployment content repository for deployment overlay '%s' at location %s. This is a fatal boot error. To correct the problem, either restart with the --admin-only switch set and use the CLI to install the missing content or remove it from the configuration, or remove the deployment overlay from the xml configuration file and restart.")
    public OperationFailedException noSuchDeploymentOverlayContentAtBoot(String var1, String var2, String var3);

    @Message(id=18779, value="No deployment overlay content with hash %s is available in the deployment content repository.")
    public OperationFailedException noSuchDeploymentOverlayContent(String var1);

    @Message(id=18780, value="Failed to read file %s")
    public OperationFailedException failedToLoadFile(VirtualFile var1, @Cause IOException var2);

    @Message(id=18781, value="Cannot have more than one of %s")
    public OperationFailedException cannotHaveMoreThanOneManagedContentItem(Set<String> var1);

    @Message(id=18782, value="Unknown content item key: %s")
    public OperationFailedException unknownContentItemKey(String var1);

    @Message(id=18783, value="Cannot use %s when %s are used")
    public OperationFailedException cannotMixUnmanagedAndManagedContentItems(Set<String> var1, Set<String> var2);

    @Message(id=18784, value="Null '%s'")
    public OperationFailedException nullParameter(String var1);

    @Message(id=18785, value="There is already a deployment called %s with the same runtime name %s")
    public OperationFailedException runtimeNameMustBeUnique(String var1, String var2);

    @Message(id=18786, value="Multiple deployment unit processors registered with priority %s and class %s")
    public IllegalStateException duplicateDeploymentUnitProcessor(int var1, Class var2);
}

