/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7.util;

import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.map.ObjectMapper;
import org.rhq.modules.plugins.jbossas7.json.Result;

public final class PatchDetails {
    private static final Log LOG = LogFactory.getLog(PatchDetails.class);
    private final String id;
    private final Type type;
    private final Date appliedAt;

    public static List<PatchDetails> fromJSONArray(String patchHistoryList) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            List lst = (List)mapper.readValue(patchHistoryList, List.class);
            ArrayList<PatchDetails> result = new ArrayList<PatchDetails>(lst.size());
            for (Map patchDescr : lst) {
                result.add(PatchDetails.processJSONParseResult(patchDescr));
            }
            return result;
        }
        catch (IOException e) {
            LOG.warn((Object)("Failed to parse the patch history JSON: " + e.getMessage()));
            return Collections.emptyList();
        }
    }

    public static List<PatchDetails> fromHistory(String patchHistoryOutcome) {
        Result result;
        ObjectMapper mapper = new ObjectMapper();
        try {
            result = (Result)mapper.readValue(patchHistoryOutcome, Result.class);
        }
        catch (IOException e) {
            LOG.warn((Object)("Failed to parse the output of the 'patch history' command with message '" + e.getMessage() + "'. The output was:\n" + patchHistoryOutcome));
            return Collections.emptyList();
        }
        if (!result.isSuccess()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("'patch history' command didn't succeed: " + result));
            }
            return Collections.emptyList();
        }
        if (!(result.getResult() instanceof List)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Unexpected patch history results. Expected list but found " + (result.getResult() == null ? "null" : result.getResult().getClass().toString())));
            }
            return Collections.emptyList();
        }
        List patches = (List)result.getResult();
        if (patches.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<PatchDetails> ret = new ArrayList<PatchDetails>();
        for (Map patchDescr : patches) {
            ret.add(PatchDetails.processJSONParseResult(patchDescr));
        }
        return ret;
    }

    private static PatchDetails processJSONParseResult(Map<String, String> jsonParseResult) {
        String patchId = jsonParseResult.get("patch-id");
        Date appliedAt = null;
        Type type = Type.fromJsonValue(jsonParseResult.get("type"));
        try {
            DateFormat format = DateFormat.getDateTimeInstance(3, 3);
            appliedAt = format.parse(jsonParseResult.get("applied-at"));
        }
        catch (ParseException e) {
            LOG.info((Object)("Failed to parse the installation date of the patch " + patchId + ": '" + jsonParseResult.get("applied-at") + "' with error message: " + e.getMessage()));
        }
        return new PatchDetails(patchId, type, appliedAt);
    }

    public static List<PatchDetails> fromInfo(String patchInfoOutcome, String patchHistoryOutcome) {
        PatchDetails p;
        Result result;
        ObjectMapper mapper = new ObjectMapper();
        try {
            result = (Result)mapper.readValue(patchInfoOutcome, Result.class);
        }
        catch (IOException e) {
            LOG.warn((Object)("Failed to parse the output of the 'patch info' command with message '" + e.getMessage() + "'. The output was:\n" + patchInfoOutcome));
            return Collections.emptyList();
        }
        if (!result.isSuccess()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("'patch info' command didn't succeed: " + result));
            }
            return Collections.emptyList();
        }
        if (!(result.getResult() instanceof Map)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Unexpected patch history results. Expected map but found " + (result.getResult() == null ? "null" : result.getResult().getClass().toString())));
            }
            return Collections.emptyList();
        }
        List<PatchDetails> history = PatchDetails.fromHistory(patchHistoryOutcome);
        ArrayList<PatchDetails> ret = new ArrayList<PatchDetails>();
        Map resultMap = (Map)result.getResult();
        List oneOffs = (List)resultMap.get("patches");
        for (String id : oneOffs) {
            PatchDetails p2 = PatchDetails.findById(id, history);
            if (p2 == null) continue;
            ret.add(p2);
        }
        String cumulativePatchId = (String)resultMap.get("cumulative-patch-id");
        if (!"base".equals(cumulativePatchId) && (p = PatchDetails.findById(cumulativePatchId, history)) != null) {
            ret.add(p);
        }
        return ret;
    }

    private static PatchDetails findById(String patchId, List<PatchDetails> patchDetails) {
        for (PatchDetails p : patchDetails) {
            if (!patchId.equals(p.getId())) continue;
            return p;
        }
        return null;
    }

    public PatchDetails(String id, Type type, Date appliedAt) {
        this.id = id;
        this.type = type;
        this.appliedAt = appliedAt;
    }

    public String getId() {
        return this.id;
    }

    public Type getType() {
        return this.type;
    }

    public Date getAppliedAt() {
        return this.appliedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PatchDetails)) {
            return false;
        }
        PatchDetails that = (PatchDetails)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        DateFormat format = DateFormat.getDateTimeInstance(3, 3);
        return "{\n  \"patch-id\": \"" + this.id + "\",\n  \"type\": \"" + (Object)((Object)this.type) + "\",\n  \"applied-at\": \"" + format.format(this.appliedAt) + "\"\n}";
    }

    public static enum Type {
        CUMULATIVE,
        ONE_OFF;


        public static Type fromJsonValue(String value) {
            if ("one-off".equals(value)) {
                return ONE_OFF;
            }
            if ("cumulative".equals(value)) {
                return CUMULATIVE;
            }
            return null;
        }

        public String toString() {
            switch (this) {
                case CUMULATIVE: {
                    return "cumulative";
                }
                case ONE_OFF: {
                    return "one-off";
                }
            }
            throw new AssertionError((Object)"Non-exhaustive toString() implementation of PatchDetails.Type");
        }
    }
}

