/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7.patching;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Comparator;
import org.rhq.core.domain.bundle.BundleResourceDeployment;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.util.file.FileUtil;
import org.rhq.core.util.stream.StreamUtil;
import org.rhq.modules.plugins.jbossas7.helper.ServerPluginConfiguration;
import org.rhq.modules.plugins.jbossas7.patching.Result;

final class MetadataFiles {
    final File[] files;
    final File baseDir;

    private MetadataFiles(File baseDir, File[] files) {
        this.baseDir = baseDir;
        this.files = files;
    }

    boolean exists() {
        for (File f : this.files) {
            if (f.exists()) continue;
            return false;
        }
        return this.files.length > 0;
    }

    void delete() {
        FileUtil.purge((File)this.baseDir, (boolean)true);
        File destinationNameFile = this.getNameFile();
        destinationNameFile.delete();
        File activeFile = this.getActiveMarkerFile();
        if (activeFile.exists()) {
            activeFile.delete();
        }
    }

    static Result<MetadataFiles> forDeployment(BundleResourceDeployment rd, Configuration referencedConfiguration) {
        File destinationDir = MetadataFiles.baseDirFor(rd, referencedConfiguration);
        if (!destinationDir.exists() && !destinationDir.mkdirs()) {
            return Result.error("Failed to create metadata storage under " + destinationDir.getAbsolutePath());
        }
        Result<File[]> files = MetadataFiles.getDestinationFiles(destinationDir);
        if (files.failed()) {
            return Result.error(files.errorMessage);
        }
        return Result.with(new MetadataFiles(destinationDir, (File[])files.result));
    }

    static File baseDirFor(BundleResourceDeployment rd, Configuration referencedConfiguration) {
        File root = MetadataFiles.getMetadataRoot(referencedConfiguration);
        return MetadataFiles.baseDirFor(rd.getBundleDeployment().getDestination().getId(), root);
    }

    private static File baseDirFor(int destinationId, File metadataRoot) {
        return new File(metadataRoot, Integer.toString(destinationId));
    }

    static Result<MetadataFiles> getActive(Configuration referencedConfiguration) {
        File root = MetadataFiles.getMetadataRoot(referencedConfiguration);
        File activeDir = new File(root, "active");
        if (!activeDir.exists()) {
            return Result.with(null);
        }
        String[] files = activeDir.list();
        if (files == null || files.length == 0) {
            return Result.with(null);
        }
        int destinationId = Integer.parseInt(files[0]);
        File baseDir = MetadataFiles.baseDirFor(destinationId, root);
        Result<File[]> destFiles = MetadataFiles.getDestinationFiles(baseDir);
        if (destFiles.failed()) {
            return Result.error(destFiles.errorMessage);
        }
        return Result.with(new MetadataFiles(baseDir, (File[])destFiles.result));
    }

    public Result<Void> saveAsActive() {
        File activeDir = new File(this.baseDir.getParentFile(), "active");
        if (!activeDir.exists() && !activeDir.mkdirs()) {
            return Result.error("Failed to persist active destination");
        }
        File[] markers = activeDir.listFiles();
        if (markers == null) {
            return Result.error("Could not determine the previously active destination");
        }
        for (File f : markers) {
            if (f.delete()) continue;
            return Result.error("Could not clear the flag of previously active destination");
        }
        File activeFile = new File(activeDir, this.baseDir.getName());
        try {
            activeFile.createNewFile();
            return Result.with(null);
        }
        catch (IOException e) {
            return Result.error("Could not flag the destination as active: " + e.getMessage());
        }
    }

    public boolean isActive() {
        return this.getActiveMarkerFile().exists();
    }

    public File getNameFile() {
        return new File(this.baseDir.getParent(), this.baseDir.getName() + ".name");
    }

    public Result<Void> saveDestinationName(String name) {
        File destinationNameFile = this.getNameFile();
        if (!destinationNameFile.exists()) {
            StringReader nameRdr = new StringReader(name);
            try {
                PrintWriter nameWrt = new PrintWriter(destinationNameFile, "UTF-8");
                StreamUtil.copy((Reader)nameRdr, (Writer)nameWrt, (boolean)true);
            }
            catch (FileNotFoundException e) {
                return Result.error("Could to create the file for storing the name of the destination. " + e.getMessage());
            }
            catch (RuntimeException e) {
                return Result.error("Failed to store the name of the destination. " + e.getMessage());
            }
            catch (UnsupportedEncodingException e) {
                return Result.error("Could not write the destination name file. " + e.getMessage());
            }
        }
        return Result.with(null);
    }

    private File getActiveMarkerFile() {
        return new File(new File(this.baseDir.getParentFile(), "active"), this.baseDir.getName());
    }

    public int getDestinationId() {
        return Integer.parseInt(this.baseDir.getName());
    }

    public String getDestinationName() throws FileNotFoundException {
        FileInputStream rdr = new FileInputStream(this.getNameFile());
        ByteArrayOutputStream wrt = new ByteArrayOutputStream();
        StreamUtil.copy((InputStream)rdr, (OutputStream)wrt, (boolean)true);
        try {
            return wrt.toString("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return wrt.toString();
        }
    }

    private static File getMetadataRoot(Configuration referencedConfiguration) {
        ServerPluginConfiguration config = new ServerPluginConfiguration(referencedConfiguration);
        File installationDir = new File(config.getHomeDir(), ".installation");
        return new File(installationDir, ".rhq");
    }

    private static Result<File[]> getDestinationFiles(File destinationDir) {
        File[] files = destinationDir.listFiles();
        if (files == null) {
            return Result.error("Could not list files in the destination metadata directory " + destinationDir);
        }
        Arrays.sort(files, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return o2.getName().compareTo(o1.getName());
            }
        });
        return Result.with(files);
    }
}

