/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7.patching;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.rhq.core.domain.bundle.BundleResourceDeployment;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.util.stream.StreamUtil;
import org.rhq.modules.plugins.jbossas7.patching.MetadataFiles;
import org.rhq.modules.plugins.jbossas7.patching.Result;
import org.rhq.modules.plugins.jbossas7.util.PatchDetails;

final class BundleMetadata {
    final List<DeploymentMetadata> deployments;
    final MetadataFiles metadataFiles;

    private BundleMetadata(List<DeploymentMetadata> deployments, MetadataFiles files) {
        this.deployments = deployments;
        this.metadataFiles = files;
    }

    static Result<BundleMetadata> forDeployment(BundleResourceDeployment rd, Configuration referecenedConfiguration) {
        try {
            Result<MetadataFiles> files = MetadataFiles.forDeployment(rd, referecenedConfiguration);
            if (files.failed()) {
                return Result.error(files.errorMessage);
            }
            if (!((MetadataFiles)files.result).exists()) {
                return Result.error("The metadata for deployment " + rd + " not found.");
            }
            ArrayList<DeploymentMetadata> deployments = new ArrayList<DeploymentMetadata>();
            File[] fs = ((MetadataFiles)files.result).files;
            for (int i = 0; i < fs.length; ++i) {
                String addedJson = StreamUtil.slurp((Reader)new InputStreamReader(new FileInputStream(fs[i])));
                List<PatchDetails> addedPatches = PatchDetails.fromJSONArray(addedJson);
                deployments.add(new DeploymentMetadata(addedPatches, fs.length - i - 1));
            }
            return Result.with(new BundleMetadata(deployments, (MetadataFiles)files.result));
        }
        catch (IOException e) {
            return Result.error("Failed to read bundle metadata for " + rd + ": " + e.getMessage());
        }
    }

    MetadataFiles getMetadataFiles() {
        return this.metadataFiles;
    }

    static class DeploymentMetadata {
        final List<PatchDetails> applied;
        int deploymentIndex;

        private DeploymentMetadata(List<PatchDetails> applied, int deploymentIndex) {
            this.applied = applied;
            this.deploymentIndex = deploymentIndex;
        }

        static DeploymentMetadata from(List<PatchDetails> beforeDeployment, List<PatchDetails> afterDeployment) {
            ArrayList<PatchDetails> currentDeployment = new ArrayList<PatchDetails>();
            PatchDetails firstHistorical = beforeDeployment.isEmpty() ? null : beforeDeployment.get(0);
            for (PatchDetails p : afterDeployment) {
                if (p.equals(firstHistorical)) break;
                currentDeployment.add(p);
            }
            return new DeploymentMetadata(currentDeployment, -1);
        }

        Result<Void> persistAsNewState(BundleResourceDeployment rd, Configuration referencedConfiguration) {
            try {
                Result<MetadataFiles> files = MetadataFiles.forDeployment(rd, referencedConfiguration);
                if (files.failed()) {
                    return Result.error(files.errorMessage);
                }
                this.deploymentIndex = ((MetadataFiles)files.result).files.length;
                String fileNameBase = String.format("%06d-", this.deploymentIndex);
                String appliedPidsFileName = fileNameBase + "applied";
                StringReader rdr = new StringReader(this.applied.toString());
                PrintWriter wrt = new PrintWriter(new FileOutputStream(new File(((MetadataFiles)files.result).baseDir, appliedPidsFileName)));
                StreamUtil.copy((Reader)rdr, (Writer)wrt, (boolean)true);
                return Result.with(null);
            }
            catch (IOException e) {
                return Result.error("Failed to save bundle metadata for " + rd + ": " + e.getMessage());
            }
        }

        Result<Void> forget(BundleResourceDeployment rd, Configuration referencedConfiguration) {
            if (this.deploymentIndex < 0) {
                throw new IllegalStateException("Tried to forget deployment metadata without index set. This should not happen");
            }
            String fileNameBase = String.format("%06d-", this.deploymentIndex);
            String appliedPidsFileName = fileNameBase + "applied";
            File baseDir = MetadataFiles.baseDirFor(rd, referencedConfiguration);
            File applied = new File(baseDir, appliedPidsFileName);
            if (!applied.delete()) {
                return Result.error("Failed to delete the deployment metadata file '" + applied.getAbsolutePath() + "'.");
            }
            return Result.with(null);
        }
    }
}

