/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7.json;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.rhq.modules.plugins.jbossas7.json.PROPERTY_VALUE;

public class Address {
    private static final Pattern PATH_PATTERN = Pattern.compile("[,]+");
    private static final Pattern SEGMENT_PATTERN = Pattern.compile("=");
    List<PROPERTY_VALUE> path = new ArrayList<PROPERTY_VALUE>();

    public Address() {
    }

    public Address(String key, String value) {
        this();
        this.add(key, value);
    }

    public Address(Address other) {
        this();
        if (other != null && other.path != null) {
            this.path.addAll(other.path);
        }
    }

    Address(List<PROPERTY_VALUE> property_values) {
        this();
        if (property_values != null) {
            this.path.addAll(property_values);
        }
    }

    public Address(String path) {
        this();
        String[] components;
        if (path == null || path.isEmpty()) {
            return;
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        for (String component : components = PATH_PATTERN.split(path)) {
            String tmp = component.trim();
            if (!tmp.contains("=")) continue;
            PROPERTY_VALUE valuePair = this.pathFromSegment(tmp);
            this.path.add(valuePair);
        }
    }

    private PROPERTY_VALUE pathFromSegment(String segment) {
        String[] pair = SEGMENT_PATTERN.split(segment);
        return new PROPERTY_VALUE(pair[0], pair[1]);
    }

    public void add(String key, String value) {
        this.path.add(new PROPERTY_VALUE(key, value));
    }

    public void addSegment(String segment) {
        if (!segment.contains("=")) {
            throw new IllegalArgumentException("Segment [" + segment + "] contains no '='");
        }
        PROPERTY_VALUE pv = this.pathFromSegment(segment);
        this.path.add(pv);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Address{path: ");
        if (this.path != null) {
            Iterator<PROPERTY_VALUE> iterator = this.path.iterator();
            while (iterator.hasNext()) {
                PROPERTY_VALUE pv = iterator.next();
                builder.append(pv.getKey()).append('=').append(pv.getValue());
                if (!iterator.hasNext()) continue;
                builder.append(',');
            }
        } else {
            builder.append("-empty-");
        }
        builder.append('}');
        return builder.toString();
    }

    @JsonIgnore
    public String getPath() {
        StringBuilder builder = new StringBuilder();
        Iterator<PROPERTY_VALUE> iter = this.path.iterator();
        while (iter.hasNext()) {
            PROPERTY_VALUE val = iter.next();
            builder.append(val.getKey()).append('=').append(val.getValue());
            if (!iter.hasNext()) continue;
            builder.append(',');
        }
        return builder.toString();
    }

    public void add(Address address) {
        if (address != null && address.path != null) {
            this.path.addAll(address.path);
        }
    }

    @JsonIgnore
    public boolean isEmpty() {
        return this.path.isEmpty();
    }

    public int size() {
        return this.path.size();
    }

    public String get(int n) {
        PROPERTY_VALUE property_value = this.path.get(n);
        return property_value.getKey() + "=" + property_value.getValue();
    }

    public Address getParent() {
        Address tmp = new Address();
        int l = this.path.size();
        if (l < 1) {
            return tmp;
        }
        for (int i = 0; i < l - 1; ++i) {
            tmp.path.add(this.path.get(i));
        }
        return tmp;
    }
}

