/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7.helper;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;

public abstract class AdditionalJavaOpts {
    private static final String NEW_LINE = System.getProperty("line.separator");

    protected abstract String[] getSequence();

    protected abstract int getContentIndex();

    protected abstract char getEndOfSequenceCharacter();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(File configFile, String additionalJavaOptsContent) throws Exception {
        ArrayList<String> fileContent = new ArrayList<String>();
        BufferedReader br = new BufferedReader(new FileReader(configFile));
        try {
            String line = null;
            while ((line = br.readLine()) != null) {
                fileContent.add(line);
            }
        }
        finally {
            br.close();
        }
        if (fileContent.size() == 0) {
            return;
        }
        while (((String)fileContent.get(fileContent.size() - 1)).trim().isEmpty()) {
            fileContent.remove(fileContent.size() - 1);
        }
        additionalJavaOptsContent = additionalJavaOptsContent.replace(this.getEndOfSequenceCharacter() + "", "");
        String javaOptsNewContent = this.getSequence()[this.getContentIndex()] + additionalJavaOptsContent + this.getEndOfSequenceCharacter();
        boolean goodSequence = true;
        boolean identicalJavaOpts = false;
        int lineToUpdate = -1;
        int potentialSequenceStart = fileContent.size() - this.getSequence().length;
        for (int sequenceIndex = 0; sequenceIndex < this.getSequence().length; ++sequenceIndex) {
            if (!((String)fileContent.get(potentialSequenceStart + sequenceIndex)).trim().startsWith(this.getSequence()[sequenceIndex])) {
                goodSequence = false;
                break;
            }
            if (sequenceIndex != this.getContentIndex()) continue;
            if (((String)fileContent.get(potentialSequenceStart + sequenceIndex)).trim().equals(javaOptsNewContent)) {
                identicalJavaOpts = true;
            }
            lineToUpdate = potentialSequenceStart + sequenceIndex;
        }
        if (identicalJavaOpts) {
            return;
        }
        if (!goodSequence) {
            for (int index = 0; index < this.getSequence().length; ++index) {
                if (this.getContentIndex() == index) {
                    fileContent.add(this.getSequence()[index] + additionalJavaOptsContent + this.getEndOfSequenceCharacter());
                    continue;
                }
                fileContent.add(this.getSequence()[index]);
            }
        } else {
            fileContent.set(lineToUpdate, javaOptsNewContent);
        }
        BufferedWriter updatedConfigFile = new BufferedWriter(new FileWriter(configFile));
        try {
            for (String line : fileContent) {
                updatedConfigFile.write(line);
                updatedConfigFile.write(NEW_LINE);
            }
        }
        finally {
            updatedConfigFile.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String discover(File configFile) throws Exception {
        BufferedReader br = new BufferedReader(new FileReader(configFile));
        ArrayList<String> fileContent = new ArrayList<String>();
        try {
            String line = null;
            while ((line = br.readLine()) != null) {
                if (line.trim().isEmpty()) continue;
                fileContent.add(line);
            }
        }
        finally {
            br.close();
        }
        if (fileContent.size() == 0) {
            return null;
        }
        boolean goodSequence = true;
        int potentialSequenceStart = fileContent.size() - this.getSequence().length;
        String additionalJavaOptsValue = null;
        for (int sequenceIndex = 0; sequenceIndex < this.getSequence().length; ++sequenceIndex) {
            if (!((String)fileContent.get(potentialSequenceStart + sequenceIndex)).trim().startsWith(this.getSequence()[sequenceIndex])) {
                goodSequence = false;
                break;
            }
            if (sequenceIndex != this.getContentIndex()) continue;
            additionalJavaOptsValue = ((String)fileContent.get(potentialSequenceStart + sequenceIndex)).replace(this.getSequence()[sequenceIndex], "");
            additionalJavaOptsValue = additionalJavaOptsValue.substring(0, additionalJavaOptsValue.lastIndexOf(this.getEndOfSequenceCharacter()));
        }
        additionalJavaOptsValue = !goodSequence ? null : additionalJavaOptsValue.replace(this.getEndOfSequenceCharacter() + "", "");
        return additionalJavaOptsValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clean(File configFile) throws Exception {
        int lineNumber;
        String line;
        ArrayList<Integer> potentialLinesToClear = new ArrayList<Integer>();
        ArrayList potentialSequencesToClear = new ArrayList();
        BufferedReader br = new BufferedReader(new FileReader(configFile));
        try {
            line = null;
            lineNumber = -1;
            int lastPotentialLineToClear = -1;
            ArrayList<String> lastPotentialSequenceToClear = null;
            while ((line = br.readLine()) != null) {
                ++lineNumber;
                if (line.trim().startsWith(this.getSequence()[0])) {
                    lastPotentialLineToClear = lineNumber;
                    lastPotentialSequenceToClear = new ArrayList<String>();
                    potentialLinesToClear.add(lastPotentialLineToClear);
                    potentialSequencesToClear.add(lastPotentialSequenceToClear);
                }
                if (lastPotentialLineToClear == -1 || lineNumber >= lastPotentialLineToClear + this.getSequence().length) continue;
                lastPotentialSequenceToClear.add(line);
            }
        }
        finally {
            br.close();
        }
        if (potentialLinesToClear.size() == 0) {
            return;
        }
        ArrayList<Integer> linesToClear = new ArrayList<Integer>(potentialLinesToClear.size());
        for (int index = 0; index < potentialLinesToClear.size(); ++index) {
            List sequenceToCheck = (List)potentialSequencesToClear.get(index);
            if (sequenceToCheck.size() != this.getSequence().length) continue;
            boolean goodSequence = true;
            for (int sequenceIndex = 0; sequenceIndex < this.getSequence().length; ++sequenceIndex) {
                if (((String)sequenceToCheck.get(sequenceIndex)).trim().startsWith(this.getSequence()[sequenceIndex])) continue;
                goodSequence = false;
                break;
            }
            if (!goodSequence) continue;
            int startLineToClear = (Integer)potentialLinesToClear.get(index);
            for (int sequenceIndex = 0; sequenceIndex < this.getSequence().length; ++sequenceIndex) {
                linesToClear.add(startLineToClear + sequenceIndex);
            }
        }
        if (linesToClear.size() == 0) {
            return;
        }
        ByteArrayOutputStream cachedUpdatedFileContent = new ByteArrayOutputStream();
        BufferedWriter updatedFileContent = new BufferedWriter(new OutputStreamWriter(cachedUpdatedFileContent));
        String newLineSeparator = System.getProperty("line.separator");
        br = new BufferedReader(new FileReader(configFile));
        try {
            line = null;
            lineNumber = -1;
            while ((line = br.readLine()) != null) {
                if (!linesToClear.isEmpty() && ++lineNumber == (Integer)linesToClear.get(0)) {
                    linesToClear.remove(0);
                    continue;
                }
                updatedFileContent.write(line + newLineSeparator);
            }
        }
        finally {
            br.close();
            updatedFileContent.close();
        }
        FileOutputStream updatedConfigFile = new FileOutputStream(configFile);
        try {
            cachedUpdatedFileContent.writeTo(updatedConfigFile);
        }
        finally {
            updatedConfigFile.close();
        }
    }

    public static class WindowsConfiguration
    extends AdditionalJavaOpts {
        private final String[] sequence = new String[]{"rem ###  JAVA_OPTS (set via RHQ) - Start     ####################################", "rem ###  PLEASE DO NOT UPDATE OUTSIDE RHQ!!! ####################################", "set \"JAVA_OPTS_ADDITIONAL_RHQ=", "set \"JAVA_OPTS=%JAVA_OPTS% %JAVA_OPTS_ADDITIONAL_RHQ%\"", "rem ###  JAVA_OPTS (set via RHQ) - End       ####################################"};
        private final int contentIndex = 2;

        @Override
        public String[] getSequence() {
            return this.sequence;
        }

        @Override
        public int getContentIndex() {
            return 2;
        }

        @Override
        public char getEndOfSequenceCharacter() {
            return '\"';
        }
    }

    public static class LinuxConfiguration
    extends AdditionalJavaOpts {
        private final String[] sequence = new String[]{"##  JAVA_OPTS (set via RHQ) - Start     ######################################", "##  PLEASE DO NOT UPDATE OUTSIDE RHQ!!! ######################################", "JAVA_OPTS_ADDITIONAL_RHQ=\"", "JAVA_OPTS=\"$JAVA_OPTS $JAVA_OPTS_ADDITIONAL_RHQ\"", "##  JAVA_OPTS (set via RHQ) - End       ######################################"};
        private final int contentIndex = 2;

        @Override
        protected String[] getSequence() {
            return this.sequence;
        }

        @Override
        protected int getContentIndex() {
            return 2;
        }

        @Override
        protected char getEndOfSequenceCharacter() {
            return '\"';
        }
    }
}

