/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.resource.ResourceUpgradeReport;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.core.pluginapi.upgrade.ResourceUpgradeContext;
import org.rhq.core.pluginapi.upgrade.ResourceUpgradeFacet;
import org.rhq.modules.plugins.jbossas7.AbstractVersionedSubsystemDiscovery;
import org.rhq.modules.plugins.jbossas7.BaseComponent;

public class VersionedRuntimeDiscovery
extends AbstractVersionedSubsystemDiscovery
implements ResourceUpgradeFacet {
    private static final Log LOG = LogFactory.getLog(VersionedRuntimeDiscovery.class);
    private static final Pattern FORWARD_SLASH_PATTERN = Pattern.compile("/");
    private static final Pattern COMMA_PATTERN = Pattern.compile(",");

    @Override
    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<BaseComponent<?>> context) throws Exception {
        Set<DiscoveredResourceDetails> details = super.discoverResources(context);
        if (DISABLED || null == details || details.isEmpty()) {
            return details;
        }
        ArrayList<DiscoveredResourceDetails> updatedDetails = new ArrayList<DiscoveredResourceDetails>(details);
        HashMap<String, Integer> keyCount = new HashMap<String, Integer>(updatedDetails.size());
        details.clear();
        Configuration config = context.getDefaultPluginConfiguration();
        String configPath = config.getSimpleValue("path", "");
        boolean isType = configPath == null || configPath.isEmpty() || configPath.contains("=");
        for (DiscoveredResourceDetails discoveredResourceDetails : updatedDetails) {
            int n;
            BaseComponent parentComponent = (BaseComponent)context.getParentResourceComponent();
            String parentPath = null != parentComponent.getPath() ? parentComponent.getPath() : "";
            discoveredResourceDetails.setResourceVersion(parentPath.isEmpty() ? null : context.getParentResourceContext().getVersion());
            if (isType) {
                discoveredResourceDetails.setResourceKey(parentPath.isEmpty() ? configPath : parentComponent.key + "," + configPath);
                continue;
            }
            StringBuilder sb = new StringBuilder();
            String slash = "";
            for (String segment : FORWARD_SLASH_PATTERN.split(discoveredResourceDetails.getResourceName())) {
                MATCHER.reset(segment);
                if (MATCHER.matches()) {
                    sb.append(slash);
                    sb.append(MATCHER.group(1)).append(MATCHER.group(3));
                } else {
                    sb.append(slash);
                    sb.append(segment);
                }
                slash = "/";
            }
            discoveredResourceDetails.setResourceName(sb.toString());
            sb = new StringBuilder();
            String comma = "";
            for (String outerSegment : COMMA_PATTERN.split(discoveredResourceDetails.getResourceKey())) {
                sb.append(comma);
                comma = ",";
                slash = "";
                for (String segment : FORWARD_SLASH_PATTERN.split(outerSegment)) {
                    sb.append(slash);
                    slash = "/";
                    MATCHER.reset(segment);
                    if (MATCHER.matches()) {
                        sb.append(MATCHER.group(1)).append(MATCHER.group(3));
                        continue;
                    }
                    sb.append(segment);
                }
            }
            discoveredResourceDetails.setResourceKey(sb.toString());
            Integer count = (Integer)keyCount.get(discoveredResourceDetails.getResourceKey());
            String string = discoveredResourceDetails.getResourceKey();
            if (null == count) {
                n = 1;
            } else {
                count = count + 1;
                n = count;
            }
            keyCount.put(string, n);
        }
        for (Map.Entry entry : keyCount.entrySet()) {
            if ((Integer)entry.getValue() <= 1) continue;
            LOG.warn((Object)("Discovered multiple resources with resource key [" + (String)entry.getKey() + "].  This is not allowed and they will be removed from discovery.  This is typically caused by " + "having multiple versions of the same Deployment deployed.  To solve the problem either remove " + "all but one version of the problem deployment or disable versioned deployment handling by " + "setting -Drhq.as7.VersionedSubsystemDiscovery.pattern=disable for the agent."));
            Iterator<DiscoveredResourceDetails> i = updatedDetails.iterator();
            while (i.hasNext()) {
                DiscoveredResourceDetails detail = i.next();
                if (!detail.getResourceKey().equals(entry.getKey())) continue;
                i.remove();
            }
        }
        details.addAll(updatedDetails);
        return details;
    }

    public ResourceUpgradeReport upgrade(ResourceUpgradeContext inventoriedResource) {
        ResourceUpgradeReport result = null;
        if (DISABLED) {
            return result;
        }
        StringBuilder sb = new StringBuilder();
        String slash = "";
        boolean upgradeName = false;
        for (String segment : FORWARD_SLASH_PATTERN.split(inventoriedResource.getName())) {
            MATCHER.reset(segment);
            if (MATCHER.matches()) {
                upgradeName = true;
                sb.append(slash);
                sb.append(MATCHER.group(1)).append(MATCHER.group(3));
            } else {
                sb.append(slash);
                sb.append(segment);
            }
            slash = "/";
        }
        if (upgradeName) {
            if (null == result) {
                result = new ResourceUpgradeReport();
            }
            result.setForceGenericPropertyUpgrade(true);
            result.setNewName(sb.toString());
        }
        String parentVersion = inventoriedResource.getParentResourceContext().getVersion();
        String currentVersion = inventoriedResource.getVersion();
        if (currentVersion != parentVersion && (null == currentVersion && null != parentVersion || !currentVersion.equals(parentVersion))) {
            if (null == result) {
                result = new ResourceUpgradeReport();
            }
            result.setForceGenericPropertyUpgrade(true);
            result.setNewVersion(parentVersion);
        }
        sb = new StringBuilder();
        String comma = "";
        boolean upgradeKey = false;
        for (String outerSegment : COMMA_PATTERN.split(inventoriedResource.getResourceKey())) {
            sb.append(comma);
            comma = ",";
            slash = "";
            for (String segment : FORWARD_SLASH_PATTERN.split(outerSegment)) {
                sb.append(slash);
                slash = "/";
                MATCHER.reset(segment);
                if (MATCHER.matches()) {
                    upgradeKey = true;
                    sb.append(MATCHER.group(1)).append(MATCHER.group(3));
                    continue;
                }
                sb.append(segment);
            }
        }
        if (upgradeKey) {
            if (null == result) {
                result = new ResourceUpgradeReport();
            }
            result.setNewResourceKey(sb.toString());
        }
        if (null != result && LOG.isDebugEnabled()) {
            LOG.debug((Object)("Requesting upgrade: " + result));
        }
        return result;
    }
}

