/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.pluginapi.util.ProcessExecutionUtility;
import org.rhq.core.pluginapi.util.StartScriptConfiguration;
import org.rhq.core.system.OperatingSystemType;
import org.rhq.core.system.ProcessExecution;
import org.rhq.core.system.ProcessExecutionResults;
import org.rhq.core.system.SystemInfo;
import org.rhq.core.util.file.FileUtil;
import org.rhq.modules.plugins.jbossas7.AS7Mode;
import org.rhq.modules.plugins.jbossas7.ASConnection;
import org.rhq.modules.plugins.jbossas7.ASConnectionParams;
import org.rhq.modules.plugins.jbossas7.BaseServerComponent;
import org.rhq.modules.plugins.jbossas7.helper.ServerPluginConfiguration;
import org.rhq.modules.plugins.jbossas7.util.PropertyReplacer;

public final class ServerControl {
    private static final Log LOG = LogFactory.getLog(ServerControl.class);
    private static final long MAX_PROCESS_WAIT_TIME = 3600000L;
    private final ServerPluginConfiguration serverPluginConfig;
    private final Configuration pluginConfiguration;
    private final String startScriptPrefix;
    private final Map<String, String> startScriptEnv;
    private final AS7Mode serverMode;
    private final SystemInfo systemInfo;
    private long waitTime;
    private boolean killOnTimeout;

    private ServerControl(Configuration pluginConfiguration, AS7Mode serverMode, SystemInfo systemInfo) {
        this.pluginConfiguration = pluginConfiguration;
        this.serverMode = serverMode;
        this.systemInfo = systemInfo;
        this.serverPluginConfig = new ServerPluginConfiguration(pluginConfiguration);
        StartScriptConfiguration startScriptConfiguration = new StartScriptConfiguration(pluginConfiguration);
        this.startScriptPrefix = startScriptConfiguration.getStartScriptPrefix();
        this.startScriptEnv = startScriptConfiguration.getStartScriptEnv();
        for (String envVarName : this.startScriptEnv.keySet()) {
            String envVarValue = this.startScriptEnv.get(envVarName);
            envVarValue = PropertyReplacer.replacePropertyPatterns(envVarValue, pluginConfiguration);
            this.startScriptEnv.put(envVarName, envVarValue);
        }
    }

    public static ServerControl onServer(Configuration serverPluginConfig, AS7Mode serverMode, SystemInfo systemInfo) {
        return new ServerControl(serverPluginConfig, serverMode, systemInfo);
    }

    public ServerControl waitingFor(long milliseconds) {
        this.waitTime = milliseconds;
        return this;
    }

    public ServerControl killingOnTimeout(boolean kill) {
        this.killOnTimeout = kill;
        return this;
    }

    public Lifecycle lifecycle() {
        return new Lifecycle();
    }

    public Cli cli() {
        return new Cli();
    }

    private ProcessExecutionResults execute(String prefix, File executable, String ... args) {
        File homeDir = this.serverPluginConfig.getHomeDir();
        File startScriptFile = executable.isAbsolute() ? executable : new File(homeDir, executable.getPath());
        ProcessExecution processExecution = ProcessExecutionUtility.createProcessExecution((String)prefix, (File)startScriptFile);
        processExecution.setEnvironmentVariables(this.startScriptEnv);
        ArrayList<String> arguments = processExecution.getArguments();
        if (arguments == null) {
            arguments = new ArrayList<String>();
            processExecution.setArguments(arguments);
        }
        for (String arg : args) {
            if (arg == null) continue;
            arguments.add(arg);
        }
        processExecution.setWorkingDirectory(startScriptFile.getParent());
        processExecution.setCaptureOutput(true);
        processExecution.setWaitForCompletion(3600000L);
        processExecution.setKillOnTimeout(false);
        if (this.waitTime > 0L) {
            processExecution.setWaitForCompletion(this.waitTime);
        } else if (this.waitTime < 0L) {
            processExecution.setWaitForCompletion(0L);
        }
        processExecution.setKillOnTimeout(this.killOnTimeout);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("About to execute the following process: [" + processExecution + "]"));
        }
        return this.systemInfo.executeProcess(processExecution);
    }

    private class WinCliHelper {
        static final String JBOSS_CLI_WRAPPER_BAT = "jboss-cli-wrapper.bat";
        static final String CLI_WRAPPER = "cli-wrapper";
        static final String BAT = ".bat";
        final File executable;
        final String[] args;

        protected WinCliHelper(File executable, String ... args) {
            this.executable = executable;
            this.args = args;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ProcessExecutionResults execute() {
            String prefix = null;
            File windowsCliWrapper = null;
            try {
                windowsCliWrapper = File.createTempFile(CLI_WRAPPER, BAT);
                FileUtil.writeFile((InputStream)Cli.class.getClassLoader().getResourceAsStream(JBOSS_CLI_WRAPPER_BAT), (File)windowsCliWrapper);
                prefix = windowsCliWrapper.getAbsolutePath();
            }
            catch (IOException e) {
                LOG.warn((Object)"Could not create EAP CLI Wrapper. The CLI exit code may not be reported correctly", (Throwable)e);
            }
            try {
                ProcessExecutionResults processExecutionResults = ServerControl.this.execute(prefix, this.executable, this.args);
                return processExecutionResults;
            }
            finally {
                FileUtil.purge((File)windowsCliWrapper, (boolean)true);
            }
        }
    }

    public final class Cli {
        private boolean disconnected;

        Cli() {
            if (ServerControl.this.systemInfo.getOperatingSystemType() == OperatingSystemType.WINDOWS) {
                ServerControl.this.startScriptEnv.put("NOPAUSE", "1");
            }
        }

        public Cli disconnected(boolean disconnected) {
            this.disconnected = disconnected;
            return this;
        }

        public ProcessExecutionResults executeCliCommand(String commands) {
            String controller;
            File executable = new File("bin", ServerControl.this.serverMode.getCliScriptFileName());
            String connect = this.disconnected ? null : "--connect";
            commands = commands.replace('\n', ',');
            String user = this.disconnected ? null : "--user=" + ServerControl.this.serverPluginConfig.getUser();
            String password = this.disconnected ? null : "--password=" + ServerControl.this.serverPluginConfig.getPassword();
            String string = controller = this.disconnected ? null : "--controller=" + ServerControl.this.serverPluginConfig.getNativeHost() + ":" + ServerControl.this.serverPluginConfig.getNativePort();
            if (ServerControl.this.systemInfo.getOperatingSystemType() != OperatingSystemType.WINDOWS) {
                return ServerControl.this.execute(null, executable, new String[]{connect, commands, user, password, controller});
            }
            WinCliHelper cliHelper = new WinCliHelper(executable, connect, commands, user, password, controller);
            return cliHelper.execute();
        }

        public ProcessExecutionResults executeCliScript(File scriptFile) {
            String controller;
            File homeDir = ServerControl.this.serverPluginConfig.getHomeDir();
            File script = scriptFile;
            if (!script.isAbsolute()) {
                script = new File(homeDir, scriptFile.getPath());
            }
            File executable = new File("bin", ServerControl.this.serverMode.getCliScriptFileName());
            String connect = this.disconnected ? null : "--connect";
            String file = "--file=" + script.getAbsolutePath();
            String user = this.disconnected ? null : "--user=" + ServerControl.this.serverPluginConfig.getUser();
            String password = this.disconnected ? null : "--password=" + ServerControl.this.serverPluginConfig.getPassword();
            String string = controller = this.disconnected ? null : "--controller=" + ServerControl.this.serverPluginConfig.getNativeHost() + ":" + ServerControl.this.serverPluginConfig.getNativePort();
            if (ServerControl.this.systemInfo.getOperatingSystemType() != OperatingSystemType.WINDOWS) {
                return ServerControl.this.execute(null, executable, new String[]{connect, file, user, password, controller});
            }
            WinCliHelper cliHelper = new WinCliHelper(executable, connect, file, user, password, controller);
            return cliHelper.execute();
        }
    }

    public final class Lifecycle {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ProcessExecutionResults startServer() {
            StartScriptConfiguration startScriptConfiguration = new StartScriptConfiguration(ServerControl.this.pluginConfiguration);
            File startScriptFile = startScriptConfiguration.getStartScript();
            if (startScriptFile == null) {
                startScriptFile = new File("bin", ServerControl.this.serverMode.getStartScriptFileName());
            }
            List startScriptArgsL = startScriptConfiguration.getStartScriptArgs();
            String[] startScriptArgs = startScriptArgsL.toArray(new String[startScriptArgsL.size()]);
            for (int i = 0; i < startScriptArgs.length; ++i) {
                startScriptArgs[i] = PropertyReplacer.replacePropertyPatterns(startScriptArgs[i], ServerControl.this.pluginConfiguration);
            }
            long origWaitTime = ServerControl.this.waitTime;
            try {
                ServerControl.this.waitTime = -1L;
                ProcessExecutionResults processExecutionResults = ServerControl.this.execute(ServerControl.this.startScriptPrefix, startScriptFile, startScriptArgs);
                return processExecutionResults;
            }
            finally {
                ServerControl.this.waitTime = origWaitTime;
            }
        }

        public ProcessExecutionResults shutdownServer() {
            String command = "shutdown";
            if (ServerControl.this.serverMode == AS7Mode.DOMAIN) {
                ASConnection connection = new ASConnection(ASConnectionParams.createFrom(ServerControl.this.serverPluginConfig));
                String host = BaseServerComponent.findASDomainHostName(connection);
                command = command + " --host=" + host;
                connection.shutdown();
            }
            return ServerControl.this.cli().disconnected(false).executeCliCommand(command);
        }
    }
}

