/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

public enum JBossProductType {
    AS("AS", "JBoss AS 7", "JBoss Application Server 7", "AS"),
    EAP("EAP", "JBoss EAP 6", "JBoss Enterprise Application Platform 6", "EAP"),
    ISPN("ISPN", "Infinispan Server", "Infinispan Server", "Infinispan Server"),
    JDG("JDG", "JBoss JDG 6", "JBoss Data Grid 6", "Data Grid"),
    JPP("JPP", "JBoss JPP 6", "JBoss Portal Platform 6", "Portal Platform"),
    SOA("SOA-P", "JBoss SOA-P 6", "Red Hat JBoss Fuse Service Works", "Red Hat JBoss Fuse Service Works"),
    WILDFLY8("WildFly", "WildFly 8", "WildFly Application Server 8", "WildFly"),
    BRMS("BRMS", "JBoss BRMS", "Red Hat JBoss BRMS", "BRMS");

    public final String SHORT_NAME;
    public final String NAME;
    public final String FULL_NAME;
    public final String PRODUCT_NAME;

    private JBossProductType(String shortName, String name, String fullName, String productName) {
        this.SHORT_NAME = shortName;
        this.NAME = name;
        this.FULL_NAME = fullName;
        this.PRODUCT_NAME = productName;
    }

    @Deprecated
    public static JBossProductType determineJBossProductType(File homeDir) {
        return JBossProductType.determineJBossProductType(homeDir, "1.0");
    }

    public static JBossProductType determineJBossProductType(File homeDir, String apiVersion) {
        try {
            JBossProductType jBossProductType = JBossProductType.determineJBossProductTypeViaProductConfFile(homeDir);
            if (jBossProductType == null) {
                jBossProductType = apiVersion.startsWith("1") ? AS : WILDFLY8;
            }
            return jBossProductType;
        }
        catch (Exception e) {
            return JBossProductType.determineJBossProductTypeViaHomeDirName(homeDir);
        }
    }

    public static JBossProductType getValueByProductName(String productName) {
        for (JBossProductType productType : JBossProductType.values()) {
            if (!productType.PRODUCT_NAME.equals(productName)) continue;
            return productType;
        }
        throw new IllegalArgumentException("No product type with product-name '" + productName + "' is known.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static JBossProductType determineJBossProductTypeViaProductConfFile(File homeDir) throws Exception {
        File productConfFile = new File(homeDir, "bin/product.conf");
        if (!productConfFile.exists()) return null;
        Properties productConfProps = new Properties();
        FileInputStream inputStream = new FileInputStream(productConfFile);
        try {
            productConfProps.load(inputStream);
        }
        catch (IOException e) {
            throw new Exception("Failed to parse " + productConfFile + ".", e);
        }
        finally {
            inputStream.close();
        }
        String slot = productConfProps.getProperty("slot", "").trim();
        if (slot.isEmpty()) {
            throw new Exception("'slot' property not found in " + productConfFile + ".");
        }
        if (slot.equals("eap")) {
            return EAP;
        }
        if (slot.equals("ispn")) {
            return ISPN;
        }
        if (slot.equals("jdg")) {
            return JDG;
        }
        if (slot.equals("jpp")) {
            return JPP;
        }
        if (slot.equals("soa")) {
            return SOA;
        }
        if (!slot.equals("brms")) throw new RuntimeException("Unknown product type: " + slot);
        return BRMS;
    }

    private static JBossProductType determineJBossProductTypeViaHomeDirName(File homeDir) {
        JBossProductType productType;
        String homeDirName = homeDir.getName();
        if (homeDirName.contains("-as-")) {
            productType = AS;
        } else if (homeDirName.contains("wildfly")) {
            productType = WILDFLY8;
        } else if (homeDirName.contains("-eap-")) {
            productType = EAP;
        } else if (homeDirName.contains("infinispan-server")) {
            productType = ISPN;
        } else if (homeDirName.contains("-jdg-") || homeDirName.contains("datagrid-server")) {
            productType = JDG;
        } else if (homeDirName.contains("-jpp-")) {
            productType = JPP;
        } else {
            throw new RuntimeException("Failed to determine product type for JBoss product installed at [" + homeDir + "].");
        }
        return productType;
    }

    public String toString() {
        return this.NAME;
    }
}

