/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7;

import org.rhq.core.system.ProcessInfo;
import org.rhq.modules.plugins.jbossas7.AS7Mode;
import org.rhq.modules.plugins.jbossas7.BaseProcessDiscovery;
import org.rhq.modules.plugins.jbossas7.JBossProductType;
import org.rhq.modules.plugins.jbossas7.helper.HostPort;

public class HostControllerDiscovery
extends BaseProcessDiscovery {
    private static final String DOMAIN_BASE_DIR_SYSPROP = "jboss.domain.base.dir";
    private static final String DOMAIN_CONFIG_DIR_SYSPROP = "jboss.domain.config.dir";
    private static final String DOMAIN_LOG_DIR_SYSPROP = "jboss.domain.log.dir";

    @Override
    protected AS7Mode getMode() {
        return AS7Mode.DOMAIN;
    }

    @Override
    protected String getBaseDirSystemPropertyName() {
        return DOMAIN_BASE_DIR_SYSPROP;
    }

    @Override
    protected String getConfigDirSystemPropertyName() {
        return DOMAIN_CONFIG_DIR_SYSPROP;
    }

    @Override
    protected String getLogDirSystemPropertyName() {
        return DOMAIN_LOG_DIR_SYSPROP;
    }

    @Override
    protected String getDefaultBaseDirName() {
        return "domain";
    }

    @Override
    protected String getLogFileName() {
        return "host-controller.log";
    }

    @Override
    protected String buildDefaultResourceName(HostPort hostPort, HostPort managementHostPort, JBossProductType productType, String serverName) {
        String instanceType;
        boolean isDomainController = hostPort.isLocal;
        String string = instanceType = isDomainController ? "Domain Controller" : "Host Controller";
        if (serverName != null && !serverName.trim().isEmpty()) {
            return String.format("%s %s (%s %s:%d)", productType.SHORT_NAME, instanceType, serverName, managementHostPort.host, managementHostPort.port);
        }
        return String.format("%s %s (%s:%d)", productType.SHORT_NAME, instanceType, managementHostPort.host, managementHostPort.port);
    }

    @Override
    protected String buildDefaultResourceDescription(HostPort hostPort, JBossProductType productType) {
        boolean isDomainController = hostPort.isLocal;
        String prefix = isDomainController ? "Domain controller" : "Host controller";
        String suffix = isDomainController ? "domain" : "host";
        return String.format("%s for a %s %s", prefix, productType.FULL_NAME, suffix);
    }

    @Override
    protected ProcessInfo getPotentialStartScriptProcess(ProcessInfo serverProcess) {
        return serverProcess.getParentProcess().getParentProcess();
    }
}

