/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7;

import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.JsonNode;
import org.rhq.core.pluginapi.bundle.BundleHandoverRequest;
import org.rhq.core.pluginapi.bundle.BundleHandoverResponse;
import org.rhq.core.util.StringUtil;
import org.rhq.core.util.stream.StreamUtil;
import org.rhq.modules.plugins.jbossas7.ASConnection;
import org.rhq.modules.plugins.jbossas7.ASUploadConnection;

class HandoverContentUploader {
    private static final Log LOG = LogFactory.getLog(HandoverContentUploader.class);
    private final BundleHandoverRequest request;
    private final ASConnection asConnection;
    private String filename;
    private InputStream content;
    private String runtimeName;
    private BundleHandoverResponse failureResponse;
    private String hash;

    HandoverContentUploader(BundleHandoverRequest request, ASConnection asConnection) {
        this.request = request;
        this.asConnection = asConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean upload() {
        ASUploadConnection uploadConnection;
        OutputStream out;
        this.filename = this.request.getFilename();
        this.content = this.request.getContent();
        this.runtimeName = (String)this.request.getParams().get("runtimeName");
        if (StringUtil.isBlank((String)this.runtimeName)) {
            this.runtimeName = this.filename;
        }
        if ((out = (uploadConnection = new ASUploadConnection(this.asConnection, this.filename)).getOutputStream()) == null) {
            this.failureResponse = BundleHandoverResponse.failure((BundleHandoverResponse.FailureType)BundleHandoverResponse.FailureType.EXECUTION, (String)"An error occured while the agent was preparing for content download");
            return false;
        }
        try {
            StreamUtil.copy((InputStream)this.content, (OutputStream)out, (boolean)false);
        }
        finally {
            StreamUtil.safeClose((Closeable)this.content);
        }
        JsonNode uploadResult = uploadConnection.finishUpload();
        if (ASConnection.verbose) {
            LOG.info((Object)uploadResult);
        }
        if (ASUploadConnection.isErrorReply(uploadResult)) {
            this.failureResponse = BundleHandoverResponse.failure((BundleHandoverResponse.FailureType)BundleHandoverResponse.FailureType.EXECUTION, (String)ASUploadConnection.getFailureDescription(uploadResult));
            return false;
        }
        JsonNode resultNode = uploadResult.get("result");
        this.hash = resultNode.get("BYTES_VALUE").getTextValue();
        return true;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getRuntimeName() {
        return this.runtimeName;
    }

    public BundleHandoverResponse getFailureResponse() {
        return this.failureResponse;
    }

    public String getHash() {
        return this.hash;
    }
}

