/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.rhq.modules.plugins.jbossas7.ASConnection;
import org.rhq.modules.plugins.jbossas7.ASConnectionParams;
import org.rhq.modules.plugins.jbossas7.ASConnectionParamsBuilder;
import org.rhq.modules.plugins.jbossas7.json.Address;
import org.rhq.modules.plugins.jbossas7.json.ComplexResult;
import org.rhq.modules.plugins.jbossas7.json.Operation;

public class Domain2Descriptor {
    private static final String PLUGIN_NAME = "JBossAS7";
    private String[] properties = new String[]{"cpu", "mem", "heap", "sessions", "requests", "send-traffic", "receive-traffic", "busyness", "connection-pool"};
    private D2DMode mode = null;
    private boolean descriptorSegment = false;

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            Domain2Descriptor.usage();
            System.exit(1);
        }
        Domain2Descriptor d2d = new Domain2Descriptor();
        d2d.run(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(String[] args) {
        String arg;
        String user = null;
        String pass = null;
        int pos = 0;
        boolean optionFound = false;
        do {
            if ((arg = args[pos]).startsWith("-")) {
                if (arg.equals("-m")) {
                    this.mode = D2DMode.METRICS;
                } else if (arg.equals("-p")) {
                    this.mode = D2DMode.PROPERTIES;
                } else if (arg.equals("-o")) {
                    this.mode = D2DMode.OPERATION;
                } else if (arg.equals("-r")) {
                    this.mode = D2DMode.RECURSIVE;
                } else if (arg.equals("-rd")) {
                    this.mode = D2DMode.RECURSIVE;
                    this.descriptorSegment = true;
                } else if (arg.startsWith("-U")) {
                    String tmp = arg.substring(2);
                    if (!tmp.contains(":")) {
                        Domain2Descriptor.usage();
                    }
                    user = tmp.substring(0, tmp.indexOf(":"));
                    pass = tmp.substring(tmp.indexOf(":") + 1);
                } else {
                    Domain2Descriptor.usage();
                    return;
                }
                ++pos;
                optionFound = true;
                continue;
            }
            optionFound = false;
        } while (optionFound);
        String path = arg;
        String childType = null;
        if (args.length > pos + 1) {
            childType = args[pos + 1];
        }
        ASConnectionParams asConnectionParams = new ASConnectionParamsBuilder().setHost("localhost").setPort(9990).setUsername(user).setPassword(pass).createASConnectionParams();
        ASConnection conn = new ASConnection(asConnectionParams);
        try {
            ComplexResult res;
            Address address = new Address(path);
            Operation op = new Operation("read-resource-description", address);
            op.addAdditionalProperty("recursive", "true");
            if (this.mode == D2DMode.OPERATION) {
                op.addAdditionalProperty("operations", true);
            }
            if (this.mode == D2DMode.METRICS) {
                op.addAdditionalProperty("include-runtime", true);
            }
            if (this.mode == D2DMode.RECURSIVE) {
                op.addAdditionalProperty("operations", true);
                op.addAdditionalProperty("include-runtime", true);
            }
            if ((res = conn.executeComplex(op)) == null) {
                System.err.println("Got no result");
                return;
            }
            if (!res.isSuccess()) {
                System.err.println("Failure: " + res.getFailureDescription());
                return;
            }
            Object resMap = res.getResult();
            String what = this.mode == D2DMode.OPERATION ? "operations" : "attributes";
            Map attributesMap = null;
            if (childType != null) {
                Map childMap = (Map)resMap.get("children");
                Map typeMap = (Map)childMap.get(childType);
                if (typeMap == null) {
                    System.err.println("No child with type '" + childType + "' found");
                    return;
                }
                Map descriptionMap = (Map)typeMap.get("model-description");
                if (descriptionMap == null) {
                    System.err.println("No model description found");
                    return;
                }
                Map starMap = (Map)descriptionMap.get("*");
                if (starMap != null) {
                    attributesMap = (Map)starMap.get(what);
                } else {
                    Map classicMap = (Map)descriptionMap.get("classic");
                    attributesMap = (Map)classicMap.get(what);
                }
            } else {
                attributesMap = (Map)resMap.get(what);
            }
            if (this.mode == D2DMode.OPERATION) {
                Set strings = attributesMap.keySet();
                Object[] keys = strings.toArray(new String[strings.size()]);
                Arrays.sort(keys);
                for (Object key : keys) {
                    if (this.isExcludedOperation((String)key)) continue;
                    Map value = (Map)attributesMap.get(key);
                    this.createOperation((String)key, value);
                }
            } else if (this.mode == D2DMode.RECURSIVE) {
                String legend = "Key: - property, -M metric,* req'd, + operation, [] child node.";
                StringBuilder tree = new StringBuilder(path + " ->\t" + legend + " \n");
                if (!this.descriptorSegment) {
                    System.out.print(tree);
                    this.listPropertiesAndChildren(3, (Map<String, Object>)resMap);
                } else {
                    System.out.println(this.generateSegment(path, 0));
                    this.listPropertiesAndChildren(3, (Map<String, Object>)resMap);
                    System.out.println("</service>\n");
                }
            } else {
                this.createProperties(this.mode, attributesMap, 0, false);
            }
        }
        finally {
            conn.shutdown();
        }
    }

    private StringBuilder generateSegment(String path, int indent) {
        StringBuilder segment = new StringBuilder();
        if (path != null && !path.trim().isEmpty()) {
            String terminal;
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            String[] elements = path.split(",");
            String node = terminal = elements[elements.length - 1];
            StringBuilder serviceElement = this.generateService(node, indent, true);
            System.out.print(serviceElement);
        }
        return segment;
    }

    private StringBuilder generateService(String terminal, int indent, boolean isRoot) {
        int childIndent = indent + 3;
        String node = terminal;
        String[] values = null;
        if (isRoot) {
            values = terminal.split("=");
            node = values[1];
            node = node.substring(0, 1).toUpperCase() + node.substring(1);
        } else {
            String[] elements = (node = node.replaceAll("[-]", " ")).split(" ");
            if (elements.length > 1) {
                String newNode = "";
                for (String element : elements) {
                    newNode = newNode + element.substring(0, 1).toUpperCase() + element.substring(1) + " ";
                }
                node = newNode.trim();
            } else {
                node = node.substring(0, 1).toUpperCase() + node.substring(1);
            }
        }
        StringBuilder element = new StringBuilder();
        this.doIndent(indent, element);
        element.append("<service name=\"" + node + "\"\n");
        this.doIndent(indent + 9, element);
        element.append("discovery=\"SubsystemDiscovery\"\n");
        this.doIndent(indent + 9, element);
        element.append("class=\"BaseComponent\">\n");
        if (values != null && values[0].equals("subsystem")) {
            element.append("\n");
            this.doIndent(childIndent, element);
            element.append("<runs-inside>\n");
            this.doIndent(childIndent + 2, element);
            element.append("<parent-resource-type name=\"Profile\" plugin=\"JBossAS7\"/>\n");
            this.doIndent(childIndent + 2, element);
            element.append("<parent-resource-type name=\"JBossAS7 Standalone Server\" plugin=\"JBossAS7\"/>\n");
            this.doIndent(childIndent, element);
            element.append("</runs-inside>\n");
        }
        element.append("\n");
        this.doIndent(childIndent, element);
        element.append("<plugin-configuration>\n");
        this.doIndent(childIndent + 2, element);
        element.append("<c:simple-property name=\"path\" readOnly=\"true\" default=\"" + terminal + "\"/>\n");
        this.doIndent(childIndent, element);
        element.append("</plugin-configuration>\n");
        return element;
    }

    private boolean isExcludedOperation(String operation) {
        boolean excluded = false;
        if (operation.startsWith("read-attribute")) {
            excluded = true;
        } else if (operation.startsWith("read-children")) {
            excluded = true;
        } else if (operation.startsWith("read-operation")) {
            excluded = true;
        } else if (operation.startsWith("read-resource")) {
            excluded = true;
        } else if (operation.equals("write-attribute")) {
            excluded = true;
        } else if (operation.equals("whoami")) {
            excluded = true;
        } else if (operation.equals("undefine-attribute")) {
            excluded = true;
        }
        return excluded;
    }

    private void listPropertiesAndChildren(int indent, Map<String, Object> metaDataNode) {
        Object childrenType;
        if (metaDataNode == null) {
            return;
        }
        Map cOperationMap = (Map)metaDataNode.get("operations");
        if (!this.descriptorSegment) {
            if (cOperationMap != null) {
                Object[] ckeys = cOperationMap.keySet().toArray(new String[cOperationMap.size()]);
                Arrays.sort(ckeys);
                for (Object ckey : ckeys) {
                    if (this.isExcludedOperation((String)ckey)) continue;
                    StringBuilder sbc = new StringBuilder();
                    this.doIndent(indent + 2, sbc);
                    sbc.append("+ " + (String)ckey + "{..}");
                    System.out.println(sbc);
                }
                StringBuilder sbc = new StringBuilder();
                this.doIndent(indent + 2, sbc);
                sbc.append("------------------");
                System.out.println(sbc);
            }
        } else {
            Set strings = cOperationMap.keySet();
            Object[] keys = strings.toArray(new String[strings.size()]);
            Arrays.sort(keys);
            for (Object key : keys) {
                if (this.isExcludedOperation((String)key)) continue;
                Map value = (Map)cOperationMap.get(key);
                this.createOperation((String)key, value, indent);
            }
        }
        Map cAttributeMap = (Map)metaDataNode.get("attributes");
        if (!this.descriptorSegment) {
            if (cAttributeMap != null) {
                Object[] ckeys = cAttributeMap.keySet().toArray(new String[cAttributeMap.size()]);
                Arrays.sort(ckeys);
                for (Object ckey : ckeys) {
                    StringBuilder sbc = new StringBuilder();
                    this.doIndent(indent + 2, sbc);
                    Object attribute = cAttributeMap.get(ckey);
                    String accessType = (String)((Map)attribute).get("access-type");
                    boolean required = this.isRequired(attribute);
                    String pre = null;
                    if (accessType.equalsIgnoreCase("metric")) {
                        pre = "-M ";
                        if (required) {
                            pre = "-*M";
                        }
                        sbc.append(pre + (String)ckey);
                    } else {
                        pre = "- ";
                        if (required) {
                            pre = "-* ";
                        }
                        sbc.append(pre + (String)ckey);
                    }
                    System.out.println(sbc);
                }
            }
        } else if (cAttributeMap != null && cAttributeMap.size() > 0) {
            StringBuilder resCfg = new StringBuilder();
            this.doIndent(indent, resCfg);
            resCfg.append("<resource-configuration>\n");
            System.out.print(resCfg);
            this.createProperties(D2DMode.PROPERTIES, cAttributeMap, indent + 2, true);
            resCfg = new StringBuilder();
            this.doIndent(indent, resCfg);
            resCfg.append("</resource-configuration>\n");
            System.out.println(resCfg);
            this.createProperties(D2DMode.METRICS, cAttributeMap, indent + 2, true);
        }
        if ((childrenType = metaDataNode.get("children")) != null) {
            Map childrenMap = (Map)childrenType;
            Object[] childKeys = childrenMap.keySet().toArray(new String[childrenMap.size()]);
            Arrays.sort(childKeys);
            for (Object ckey : childKeys) {
                StringBuilder sb2 = new StringBuilder();
                this.doIndent(indent + 2, sb2);
                sb2.append("[" + (String)ckey + "]");
                if (!this.descriptorSegment) {
                    System.out.println(sb2);
                } else {
                    System.out.println(this.generateService((String)ckey, indent + 2, false));
                }
                Map child = (Map)childrenMap.get(ckey);
                Map<String, Object> retrievedType = this.locateMetaDataNodeFromMap(child);
                this.listPropertiesAndChildren(indent + 4, retrievedType);
                StringBuilder serviceClose = new StringBuilder();
                this.doIndent(indent + 2, serviceClose);
                if (!this.descriptorSegment) continue;
                serviceClose.append("</service><!-- End of " + (String)ckey + " service -->\n");
                System.out.println(serviceClose);
            }
        }
    }

    private boolean isRequired(Object attribute) {
        if (!(attribute instanceof Map)) {
            throw new IllegalArgumentException("Attribute object passed in cannot be null and must be of type Map.");
        }
        Object isRequired = ((Map)attribute).get("required");
        Object nillable = ((Map)attribute).get("nillable");
        boolean required = isRequired != null && ("" + isRequired).equals("true") || nillable != null && ("" + nillable).equals("false");
        return required;
    }

    private Map<String, Object> locateMetaDataNodeFromMap(Map<String, Object> child) {
        Object modelDescription;
        Map retrieved = null;
        if (child != null && (modelDescription = child.get("model-description")) != null) {
            Object starMap = ((Map)modelDescription).get("*");
            if (starMap != null) {
                retrieved = (Map)starMap;
            } else {
                Object classic = ((Map)modelDescription).get("classic");
                retrieved = (Map)classic;
            }
        }
        return retrieved;
    }

    private void createProperties(D2DMode mode, Map<String, Object> attributesMap, int indent, boolean simpleProperty) {
        if (attributesMap == null) {
            return;
        }
        Object[] keys = attributesMap.keySet().toArray(new String[attributesMap.size()]);
        Arrays.sort(keys);
        for (Object key : keys) {
            Object entry = attributesMap.get(key);
            Map props = (Map)entry;
            Type ptype = this.getTypeFromProps(props);
            if (ptype == Type.OBJECT && mode != D2DMode.METRICS) {
                StringBuilder requiredStatus = new StringBuilder();
                boolean required = this.isRequired(props);
                if (required) {
                    requiredStatus.append(" required=\"true\"");
                } else {
                    requiredStatus.append(" required=\"false\"");
                }
                StringBuilder sb1 = new StringBuilder();
                this.doIndent(indent, sb1);
                if (!simpleProperty) {
                    sb1.append("<c:map-property name=\"" + (String)key + "\"" + requiredStatus + " description=\"" + props.get("description") + "\" ");
                } else {
                    sb1.append("<c:simple-property name=\"" + (String)key + "\"" + requiredStatus + " description=\"" + props.get("description") + "\" ");
                }
                sb1.append(this.useAvailableOptionsList(indent, props, null));
                System.out.println(sb1);
                Map attributesMap1 = (Map)props.get("attributes");
                Map valueTypes = (Map)props.get("value-type");
                if (attributesMap1 != null) {
                    this.createProperties(mode, attributesMap1, indent + 4, false);
                } else if (valueTypes != null) {
                    for (Map.Entry<String, Object> entry2 : valueTypes.entrySet()) {
                        if (!(entry2 instanceof Map)) continue;
                        this.createSimpleProp(indent + 4, entry2);
                    }
                } else {
                    for (Map.Entry entry3 : props.entrySet()) {
                        String emapKey = (String)entry3.getKey();
                        if (emapKey.equals("type") || emapKey.equals("description") || emapKey.equals("required")) continue;
                        if (entry3.getValue() instanceof Map) {
                            Map emapEntryValue = (Map)entry3.getValue();
                            Type ts = this.getTypeFromProps(emapEntryValue);
                            StringBuilder sb = this.generateProperty(indent, emapEntryValue, ts, (String)entry3.getKey(), this.getAccessType(emapEntryValue));
                            System.out.println(sb.toString());
                            continue;
                        }
                        System.out.println(entry3.getValue());
                    }
                }
                sb1 = new StringBuilder();
                this.doIndent(indent, sb1);
                if (!simpleProperty) {
                    sb1.append("</c:map-property>");
                }
                System.out.println(sb1);
                continue;
            }
            if (ptype == Type.LIST && mode != D2DMode.METRICS) {
                StringBuilder sb = new StringBuilder();
                this.doIndent(indent, sb);
                sb.append("<c:list-property name=\"");
                sb.append((String)key);
                sb.append("\"");
                boolean required = this.isRequired(props);
                if (required) {
                    sb.append(" required=\"true\"");
                } else {
                    sb.append(" required=\"false\"");
                }
                String description = (String)props.get("description");
                this.appendDescription(sb, description, null);
                sb.append(" >\n");
                if (!props.containsKey("attributes")) {
                    this.doIndent(indent, sb);
                    sb.append("    <c:simple-property name=\"").append((String)key).append("\" />\n");
                } else {
                    this.doIndent(indent, sb);
                    sb.append("<c:map-property name=\"").append((String)key).append("\">\n");
                    System.out.println(sb.toString());
                    this.createProperties(mode, (Map)props.get("attributes"), indent + 4, false);
                    sb = new StringBuilder();
                    this.doIndent(indent, sb);
                    sb.append("</c:map-property>\n");
                }
                this.doIndent(indent, sb);
                sb.append("</c:list-property>");
                System.out.println(sb.toString());
                continue;
            }
            String accessType = this.getAccessType(props);
            if (mode == D2DMode.METRICS) {
                if (ptype == Type.OBJECT) {
                    HashMap myMap = (HashMap)props.get("value-type");
                    if (!accessType.equals("metric")) continue;
                    for (Map.Entry myEntry : myMap.entrySet()) {
                        if (myEntry.getValue() instanceof String && myEntry.getValue().equals("STRING")) {
                            this.createMetricEntry(indent, props, (String)key + ":" + (String)myEntry.getKey(), this.getTypeFromProps(myMap));
                            continue;
                        }
                        if (!(myEntry.getValue() instanceof Map)) continue;
                        this.createMetricEntry(indent, (Map)myEntry.getValue(), (String)key + ":" + (String)myEntry.getKey(), this.getTypeFromProps(myMap));
                    }
                    continue;
                }
                if (!accessType.equals("metric")) continue;
                this.createMetricEntry(indent, props, (String)key, ptype);
                continue;
            }
            if (accessType.equals("metric")) continue;
            StringBuilder sb = this.generateProperty(indent, props, ptype, (String)key, accessType);
            System.out.println(sb.toString());
        }
    }

    private boolean noMapEntriesLocated(Map<String, Object> valueTypes) {
        int located = 0;
        for (Map.Entry<String, Object> myEntry : valueTypes.entrySet()) {
            if (!(myEntry instanceof Map)) continue;
            ++located;
        }
        return located > 0;
    }

    private void createMetricEntry(int indent, Map<String, Object> props, String entryName, Type ptype) {
        StringBuilder sb = new StringBuilder();
        this.doIndent(indent, sb);
        sb.append("<metric property=\"");
        sb.append(entryName).append('\"');
        if (ptype == Type.STRING) {
            sb.append(" dataType=\"trait\"");
        }
        String description = (String)props.get("description");
        this.appendDescription(sb, description, null);
        sb.append("/>");
        System.out.println(sb.toString());
    }

    private void createSimpleProp(int indent, Map.Entry<String, Object> emapEntry) {
        StringBuilder sb;
        if (emapEntry.getValue() instanceof Map) {
            Map emapEntryValue = (Map)emapEntry.getValue();
            sb = this.generateProperty(indent, emapEntryValue, this.getTypeFromProps(emapEntryValue), emapEntry.getKey(), this.getAccessType(emapEntryValue));
        } else {
            sb = new StringBuilder();
            this.doIndent(indent, sb);
            sb.append(emapEntry.getValue().toString());
        }
        System.out.println(sb.toString());
    }

    private void createOperation(String name, Map<String, Object> operationMap) {
        this.createOperation(name, operationMap, 0);
    }

    private void createOperation(String name, Map<String, Object> operationMap, int indent) {
        if (name == null && operationMap == null) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        this.doIndent(indent, builder);
        builder.append("<operation name=\"");
        builder.append(name).append('\"');
        String description = (String)operationMap.get("description");
        this.appendDescription(builder, description, null);
        builder.append(">\n");
        this.doIndent(indent, builder);
        Map reqMap = (Map)operationMap.get("request-properties");
        if (reqMap != null && !reqMap.isEmpty()) {
            builder.append("  <parameters>\n");
            this.generatePropertiesForMap(builder, reqMap, indent + 4);
            this.doIndent(indent, builder);
            builder.append("  </parameters>\n");
            this.doIndent(indent, builder);
        }
        Map replyMap = (Map)operationMap.get("reply-properties");
        builder.append("  <results>\n");
        this.doIndent(indent, builder);
        if (replyMap != null && !replyMap.isEmpty()) {
            this.generatePropertiesForMap(builder, replyMap, indent + 4);
        } else {
            builder.append("     <c:simple-property name=\"operationResult\" description=\"" + description + "\" />\n");
            this.doIndent(indent, builder);
        }
        builder.append("  </results>\n");
        this.doIndent(indent, builder);
        builder.append("</operation>\n");
        System.out.println(builder.toString());
    }

    private void appendDescription(StringBuilder builder, String description, String defaultValueText) {
        if (description != null && !description.isEmpty()) {
            if (builder.length() > 120) {
                builder.append("\n        ");
            }
            builder.append(" description=\"");
            if (defaultValueText != null) {
                if (description.charAt(description.length() - 1) != '.') {
                    description = description + ".";
                }
                defaultValueText = this.escapeHtmlCharacters(defaultValueText + "");
                description = description + " " + defaultValueText;
            }
            description = this.escapeHtmlCharacters(description);
            builder.append(description);
            builder.append('\"');
        }
    }

    private String escapeHtmlCharacters(String description) {
        description = description.replace("<", "&lt;");
        description = description.replace(">", "&gt;");
        description = description.replace("\"", "'");
        description = description.replace("'", "&apos;");
        description = description.replace("%", "&#37;");
        description = description.replace(":", "&#58;");
        description = description.replace("[", "&#91;");
        description = description.replace("]", "&#93;");
        description = description.replace("^", "&#94;");
        description = description.replace("$", "&#36;");
        description = description.replace("?", "&#63;");
        description = description.replace("+", "&#43;");
        description = description.replace("-", "&#45;");
        return description;
    }

    private void generatePropertiesForMap(StringBuilder builder, Map<String, Object> map) {
        this.generatePropertiesForMap(builder, map, 0);
    }

    private void generatePropertiesForMap(StringBuilder builder, Map<String, Object> map, int indent) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Object o = entry.getValue();
            if (o instanceof Map) {
                Map entryValue = (Map)o;
                String entryKey = entry.getKey();
                Type type = Type.STRING;
                if (entryValue != null) {
                    try {
                        type = this.getTypeFromProps(entryValue);
                    }
                    catch (Exception e) {
                        builder.append("<!-- Type ").append(entryValue).append(" NOT FOUND!!!-->\n");
                    }
                }
                builder.append((CharSequence)this.generateProperty(indent, entryValue, type, entryKey, null));
                builder.append('\n');
                continue;
            }
            this.doIndent(indent, builder);
            builder.append("<!--").append(entry.getKey()).append("..").append(entry.getValue().toString()).append("-->\n");
        }
    }

    private String getAccessType(Map<String, Object> props) {
        String accessType = (String)props.get("access-type");
        if (accessType == null) {
            accessType = "read-only";
        }
        return accessType;
    }

    private StringBuilder generateProperty(int indent, Map<String, Object> props, Type type, String entryName, String accessType) {
        boolean expressionsAllowed = false;
        Boolean tmp = (Boolean)props.get("expressions-allowed");
        if (tmp != null && tmp.booleanValue()) {
            expressionsAllowed = true;
        }
        StringBuilder sb = new StringBuilder();
        this.doIndent(indent, sb);
        sb.append("<c:simple-property name=\"");
        sb.append(entryName);
        if (expressionsAllowed && type.isNumeric()) {
            sb.append(":expr");
        }
        sb.append('\"');
        boolean required = this.isRequired(props);
        if (required) {
            sb.append(" required=\"true\"");
        } else {
            sb.append(" required=\"false\"");
        }
        sb.append(" type=\"");
        if (expressionsAllowed && type.isNumeric()) {
            sb.append("string");
        } else if (type.rhqName.equalsIgnoreCase("-option-list-") || this.mode == D2DMode.OPERATION && type.rhqName.equalsIgnoreCase("-object-")) {
            sb.append("string");
        } else if (type.rhqName.equalsIgnoreCase("-object-") || type.rhqName.equalsIgnoreCase("-list-")) {
            sb.append("string");
        } else {
            sb.append(type.rhqName);
        }
        sb.append("\"");
        sb.append(" readOnly=\"");
        if (accessType != null && accessType.equals("read-only")) {
            sb.append("true");
        } else {
            sb.append("false");
        }
        sb.append('\"');
        Object defVal = props.get("default");
        String defaultValueDescription = null;
        if (defVal != null) {
            sb.append(" defaultValue=\"").append(this.escapeHtmlCharacters(defVal + "")).append('\"');
            defaultValueDescription = "The default value is " + this.escapeHtmlCharacters(defVal + "") + ".";
        }
        String description = (String)props.get("description");
        this.appendDescription(sb, description, defaultValueDescription);
        if (type.rhqName.equalsIgnoreCase("-option-list-")) {
            sb.append(this.generateOptionList(indent, this.properties, this.properties[7]));
        } else if ((this.mode == D2DMode.OPERATION || this.mode == D2DMode.PROPERTIES) && (type.rhqName.equalsIgnoreCase("-object-") || type.rhqName.equalsIgnoreCase("string"))) {
            if (props.get("allowed") == null && props.get("value-type") != null) {
                StringBuilder mb = new StringBuilder();
                this.doIndent(indent, mb);
                mb.append("<c:map-property name=\"");
                mb.append(entryName);
                mb.append('\"');
                if (required) {
                    mb.append(" required=\"true\"");
                } else {
                    mb.append(" required=\"false\"");
                }
                this.appendDescription(mb, description, defaultValueDescription);
                mb.append(">\n");
                Map mapType = (Map)props.get("value-type");
                if (mapType != null) {
                    for (Map.Entry entry : mapType.entrySet()) {
                        Object o = entry.getValue();
                        if (o instanceof String && o.equals("STRING")) {
                            mb.append((CharSequence)this.generateProperty(indent + 4, mapType, this.getTypeFromProps(mapType), (String)entry.getKey(), null));
                            continue;
                        }
                        if (!(o instanceof Map)) continue;
                        Map entryValue = (Map)o;
                        String entryKey = (String)entry.getKey();
                        Type childType = this.getTypeFromProps(entryValue);
                        mb.append((CharSequence)this.generateProperty(indent + 4, entryValue, childType, entryKey, null));
                        mb.append("\n");
                    }
                    this.doIndent(indent, mb);
                    mb.append("</c:map-property>");
                    return mb;
                }
            } else {
                sb.append(this.useAvailableOptionsList(indent, props, null));
            }
        } else {
            sb.append("/>");
        }
        return sb;
    }

    private String useAvailableOptionsList(int indent, Map<String, Object> props, String defaultSelection) {
        ArrayList options;
        StringBuilder optionList = new StringBuilder();
        if (defaultSelection != null && !defaultSelection.trim().isEmpty()) {
            defaultSelection = this.escapeHtmlCharacters(defaultSelection + "");
            optionList.append(" defaultValue=\"" + defaultSelection + "\" ");
        }
        if ((options = (ArrayList)props.get("allowed")) != null && !options.isEmpty()) {
            Collections.sort(options);
            optionList.append(">\n");
            this.doIndent(indent + 1, optionList);
            optionList.append("<c:property-options>\n");
            for (String prop : options) {
                this.doIndent(indent + 2, optionList);
                optionList.append("<c:option value=\"" + prop + "\" name=\"" + prop + "\"/>\n");
            }
            this.doIndent(indent + 1, optionList);
            optionList.append("</c:property-options>\n");
            this.doIndent(indent, optionList);
            optionList.append("</c:simple-property>");
        } else {
            optionList.append("/>\n");
        }
        return optionList.toString();
    }

    private String generateOptionList(int indent, String[] properties, String defaultSelection) {
        StringBuilder optionList = new StringBuilder();
        if (defaultSelection != null && !defaultSelection.trim().isEmpty()) {
            defaultSelection = this.escapeHtmlCharacters(defaultSelection + "");
            optionList.append(" defaultValue=\"" + defaultSelection + "\" >\n");
        } else {
            optionList.append(">\n");
        }
        this.doIndent(indent + 1, optionList);
        optionList.append("<c:property-options>\n");
        for (String prop : properties) {
            this.doIndent(indent + 2, optionList);
            optionList.append("<c:option value=\"" + prop + "\" name=\"" + prop + "\"/>\n");
        }
        this.doIndent(indent + 1, optionList);
        optionList.append("</c:property-options>\n");
        this.doIndent(indent, optionList);
        optionList.append("</c:simple-property>");
        return optionList.toString();
    }

    public static String convertAs7JsonToValidJson(String forConversion) {
        forConversion = forConversion.replaceAll(" => ", ":");
        forConversion = forConversion.replaceAll("STRING", "\"STRING\"");
        forConversion = forConversion.replaceAll("LIST", "\"LIST\"");
        forConversion = forConversion.replaceAll("OBJECT", "\"OBJECT\"");
        forConversion = forConversion.replaceAll("BOOLEAN", "\"BOOLEAN\"");
        forConversion = forConversion.replaceAll("INT", "\"INT\"");
        forConversion = forConversion.replaceAll("L,", ",");
        return forConversion;
    }

    private void doIndent(int indent, StringBuilder sb) {
        for (int i = 0; i < indent; ++i) {
            sb.append("  ");
        }
    }

    private Type getTypeFromProps(Map<String, Object> props) {
        Map tMap = (Map)props.get("type");
        if (tMap == null) {
            return Type.OBJECT;
        }
        String type = (String)tMap.get("TYPE_MODEL_VALUE");
        Type ret = Type.valueOf(type);
        return ret;
    }

    private static void usage() {
        System.out.println("Domain2Properties [-U<user>:<pass>] [-p|-m|-o|-r|-rd] path type");
        System.out.println("   path is of kind 'key=value[,key=value]+");
        System.out.println(" -p create properties (default)");
        System.out.println(" -m create metrics");
        System.out.println(" -o create operations");
        System.out.println(" -r recurse node and list children, properties and operations.");
        System.out.println(" -rd recurse node and descriptor segment.");
        System.out.println(" -U<user>:<pass>  - supply credentials to talk to AS7");
    }

    private static enum D2DMode {
        METRICS,
        PROPERTIES,
        OPERATION,
        RECURSIVE;

    }

    public static enum Type {
        STRING(false, "string"),
        INT(true, "integer"),
        BOOLEAN(false, "boolean"),
        LONG(true, "long"),
        BIG_DECIMAL(true, "long"),
        OBJECT(false, "-object-"),
        LIST(false, "-list-"),
        DOUBLE(true, "long"),
        PROPERTY(false, "-option-list-");

        private boolean numeric;
        private String rhqName;

        private Type(boolean numeric, String rhqName) {
            this.numeric = numeric;
            this.rhqName = rhqName;
        }

        public boolean isNumeric() {
            return this.numeric;
        }
    }
}

