/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.modules.plugins.jbossas7.BaseComponent;
import org.rhq.modules.plugins.jbossas7.ConfigurationLoadDelegate;
import org.rhq.modules.plugins.jbossas7.DatasourcesComponent;
import org.rhq.modules.plugins.jbossas7.JBossProductType;
import org.rhq.modules.plugins.jbossas7.json.Address;
import org.rhq.modules.plugins.jbossas7.json.ComplexResult;
import org.rhq.modules.plugins.jbossas7.json.CompositeOperation;
import org.rhq.modules.plugins.jbossas7.json.Operation;
import org.rhq.modules.plugins.jbossas7.json.ReadResource;
import org.rhq.modules.plugins.jbossas7.json.Result;
import org.rhq.modules.plugins.jbossas7.json.WriteAttribute;

public class DatasourceComponent
extends BaseComponent<DatasourcesComponent> {
    private static final String ALLOW_MULTIPLE_USERS_ATTRIBUTE = "allow-multiple-users";
    private static final String TRACK_STATEMENTS_ATTRIBUTE = "track-statements";
    private static final String MAX_POOL_SIZE_ATTRIBUTE = "max-pool-size";
    private static final String MIN_POOL_SIZE_ATTRIBUTE = "min-pool-size";
    private static final Set<String> EXPRESSION_METRICS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("max-pool-size", "min-pool-size")));
    private static final Set<String> UNSET_FORBIDDEN_ATTRIBUTES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("max-pool-size", "min-pool-size", "pool-prefill", "pool-use-strict-min", "blocking-timeout-wait-millis", "idle-timeout-minutes", "background-validation-millis", "background-validation")));
    static final String ENABLED_ATTRIBUTE = "enabled";
    static final String ENABLE_OPERATION = "enable";
    static final String DISABLE_OPERATION = "disable";
    static final String CONNECTION_PROPERTIES_ATTRIBUTE = "*1";
    static final String XA_DATASOURCE_PROPERTIES_ATTRIBUTE = "*2";

    @Override
    public OperationResult invokeOperation(String name, Configuration parameters) throws Exception {
        if (name.equals(ENABLE_OPERATION)) {
            Operation operation = new Operation(ENABLE_OPERATION, this.getAddress());
            Boolean persistent = Boolean.valueOf(parameters.getSimpleValue("persistent", Boolean.TRUE.toString()));
            operation.addAdditionalProperty("persistent", persistent);
            Result res = this.getASConnection().execute(operation);
            if (res.isSuccess()) {
                return new OperationResult();
            }
            OperationResult operationResult = new OperationResult();
            operationResult.setErrorMessage(res.getFailureDescription());
            return operationResult;
        }
        if (name.equals(DISABLE_OPERATION)) {
            Result res;
            Operation operation = new Operation(DISABLE_OPERATION, this.getAddress());
            boolean allowResourceServiceRestart = Boolean.parseBoolean(parameters.getSimpleValue("allow-resource-service-restart", Boolean.FALSE.toString()));
            if (allowResourceServiceRestart) {
                operation.allowResourceServiceRestart();
            }
            if ((res = this.getASConnection().execute(operation)).isSuccess()) {
                return new OperationResult();
            }
            OperationResult operationResult = new OperationResult();
            operationResult.setErrorMessage(res.getFailureDescription());
            return operationResult;
        }
        return super.invokeOperation(name, parameters);
    }

    @Override
    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> requests) throws Exception {
        HashSet<MeasurementScheduleRequest> metrics = new HashSet<MeasurementScheduleRequest>(requests.size());
        for (MeasurementScheduleRequest request : requests) {
            if (request.getName().equals("connectionAvailable")) {
                report.addData(this.getConnectionAvailable(request));
                continue;
            }
            if (request.getName().equals(MAX_POOL_SIZE_ATTRIBUTE)) {
                this.getRCAsMetric(report, request);
                continue;
            }
            if (request.getName().equals(MIN_POOL_SIZE_ATTRIBUTE)) {
                this.getRCAsMetric(report, request);
                continue;
            }
            metrics.add(request);
        }
        ReadResource op = new ReadResource(this.address);
        op.includeRuntime(true);
        op.recursive(true);
        ComplexResult res = this.getASConnection().executeComplex(op);
        if (!res.isSuccess()) {
            return;
        }
        HashMap results = new HashMap();
        Map statistics = (Map)res.getResult().get("statistics");
        if (statistics != null) {
            results.putAll((Map)statistics.get("pool"));
            results.putAll((Map)statistics.get("jdbc"));
            for (MeasurementScheduleRequest metric : metrics) {
                String name = metric.getName();
                Object o = results.get(name);
                if (o == null) continue;
                String tmp = (String)o;
                Double val = Double.valueOf(tmp);
                MeasurementDataNumeric data = new MeasurementDataNumeric(metric, val);
                report.addData(data);
            }
        }
    }

    @Override
    public void updateResourceConfiguration(ConfigurationUpdateReport configurationUpdateReport) {
        String keyName;
        String connPropPluginConfigPropertyName;
        String connPropAttributeNameOnServer;
        Configuration currentConfig;
        ResourceType resourceType = this.context.getResourceType();
        ConfigurationDefinition configDef = resourceType.getResourceConfigurationDefinition();
        Configuration newConfig = configurationUpdateReport.getConfiguration();
        newConfig.remove("__OOB");
        ConfigurationLoadDelegate readDelegate = new ConfigurationLoadDelegate(configDef, this.getASConnection(), this.address, this.includeRuntime);
        try {
            currentConfig = readDelegate.loadResourceConfiguration();
        }
        catch (Exception e) {
            DatasourceComponent.getLog().error((Object)"Could not read current configuration before update", (Throwable)e);
            configurationUpdateReport.setStatus(ConfigurationUpdateStatus.FAILURE);
            configurationUpdateReport.setErrorMessage("Could not read current configuration before update: " + ThrowableUtil.getRootMessage((Throwable)e));
            return;
        }
        CompositeOperation updateOperation = new CompositeOperation();
        Map newConfigSimpleProperties = newConfig.getSimpleProperties();
        Map currentConfigSimpleProperties = currentConfig.getSimpleProperties();
        HashSet allSimplePropertyNames = new HashSet(newConfigSimpleProperties.size() + currentConfigSimpleProperties.size());
        allSimplePropertyNames.addAll(newConfigSimpleProperties.keySet());
        allSimplePropertyNames.addAll(currentConfigSimpleProperties.keySet());
        allSimplePropertyNames.remove(ENABLED_ATTRIBUTE);
        if (this.getServerComponent().getServerPluginConfiguration().getProductType() == JBossProductType.AS) {
            allSimplePropertyNames.remove(ALLOW_MULTIPLE_USERS_ATTRIBUTE);
            allSimplePropertyNames.remove(TRACK_STATEMENTS_ATTRIBUTE);
        }
        for (String simplePropertyName : allSimplePropertyNames) {
            boolean canUnset;
            PropertySimple newConfigPropertySimple = (PropertySimple)newConfigSimpleProperties.get(simplePropertyName);
            String newConfigPropertySimpleValue = newConfigPropertySimple == null ? null : newConfigPropertySimple.getStringValue();
            PropertySimple currentConfigPropertySimple = (PropertySimple)currentConfigSimpleProperties.get(simplePropertyName);
            String currentConfigPropertySimpleValue = currentConfigPropertySimple == null ? null : currentConfigPropertySimple.getStringValue();
            boolean bl = canUnset = !UNSET_FORBIDDEN_ATTRIBUTES.contains(simplePropertyName);
            if (newConfigPropertySimpleValue == null) {
                if (currentConfigPropertySimpleValue == null) continue;
                String val = canUnset ? null : configDef.getPropertyDefinitionSimple(simplePropertyName).getDefaultValue();
                updateOperation.addStep(new WriteAttribute(this.getAddress(), simplePropertyName, (Object)val));
                continue;
            }
            if (newConfigPropertySimpleValue.equals(currentConfigPropertySimpleValue)) continue;
            updateOperation.addStep(new WriteAttribute(this.getAddress(), simplePropertyName, (Object)newConfigPropertySimpleValue));
        }
        if (DatasourceComponent.isXADatasourceResource(resourceType)) {
            connPropAttributeNameOnServer = "xa-datasource-properties";
            connPropPluginConfigPropertyName = XA_DATASOURCE_PROPERTIES_ATTRIBUTE;
            keyName = "key";
        } else {
            connPropAttributeNameOnServer = "connection-properties";
            connPropPluginConfigPropertyName = CONNECTION_PROPERTIES_ATTRIBUTE;
            keyName = "pname";
        }
        Map<String, String> newConfigConnectionProperties = DatasourceComponent.getConnectionPropertiesAsMap(newConfig.getList(connPropPluginConfigPropertyName), keyName);
        Map<String, String> currentConfigConnectionProperties = DatasourceComponent.getConnectionPropertiesAsMap(currentConfig.getList(connPropPluginConfigPropertyName), keyName);
        HashSet<String> allConnectionPropertyNames = new HashSet<String>(newConfigConnectionProperties.size() + currentConfigConnectionProperties.size());
        allConnectionPropertyNames.addAll(newConfigConnectionProperties.keySet());
        allConnectionPropertyNames.addAll(currentConfigConnectionProperties.keySet());
        for (String connectionPropertyName : allConnectionPropertyNames) {
            Operation addOperation;
            Address propertyAddress = new Address(this.getAddress());
            propertyAddress.add(connPropAttributeNameOnServer, connectionPropertyName);
            String newConfigConnectionPropertyValue = newConfigConnectionProperties.get(connectionPropertyName);
            String currentConfigConnectionPropertyValue = currentConfigConnectionProperties.get(connectionPropertyName);
            if (newConfigConnectionPropertyValue == null) {
                updateOperation.addStep(new Operation("remove", propertyAddress));
                continue;
            }
            if (currentConfigConnectionPropertyValue == null) {
                addOperation = new Operation("add", propertyAddress);
                addOperation.addAdditionalProperty("value", newConfigConnectionPropertyValue);
                updateOperation.addStep(addOperation);
                continue;
            }
            if (newConfigConnectionPropertyValue.equals(currentConfigConnectionPropertyValue)) continue;
            updateOperation.addStep(new Operation("remove", propertyAddress));
            addOperation = new Operation("add", propertyAddress);
            addOperation.addAdditionalProperty("value", newConfigConnectionPropertyValue);
            updateOperation.addStep(addOperation);
        }
        if (updateOperation.numberOfSteps() > 0) {
            Result res = this.getASConnection().execute(updateOperation);
            if (res.isSuccess()) {
                configurationUpdateReport.setStatus(ConfigurationUpdateStatus.SUCCESS);
            } else {
                configurationUpdateReport.setStatus(ConfigurationUpdateStatus.FAILURE);
                configurationUpdateReport.setErrorMessage(res.getFailureDescription());
            }
        } else {
            configurationUpdateReport.setStatus(ConfigurationUpdateStatus.NOCHANGE);
        }
    }

    private void getRCAsMetric(MeasurementReport report, MeasurementScheduleRequest request) {
        BaseComponent.ReadMetricResult result = this.getMetricValue(report, request, EXPRESSION_METRICS);
        if (result.equals((Object)BaseComponent.ReadMetricResult.Null)) {
            Double val = -1.0;
            if (request.getName().equals(MAX_POOL_SIZE_ATTRIBUTE)) {
                val = 20.0;
            } else if (request.getName().equals(MIN_POOL_SIZE_ATTRIBUTE)) {
                val = 0.0;
            }
            MeasurementDataNumeric data = new MeasurementDataNumeric(request, val);
            report.addData(data);
        }
    }

    private MeasurementDataTrait getConnectionAvailable(MeasurementScheduleRequest request) {
        Result res = this.getASConnection().execute(new Operation("test-connection-in-pool", this.getAddress()));
        return new MeasurementDataTrait(request, String.valueOf(res.isSuccess()));
    }

    static boolean isXADatasourceResource(ResourceType resourceType) {
        return resourceType.getName().toLowerCase().contains("xa");
    }

    static Map<String, String> getConnectionPropertiesAsMap(PropertyList listPropertyWrapper, String keyName) {
        if (listPropertyWrapper == null) {
            return Collections.emptyMap();
        }
        List propertyList = listPropertyWrapper.getList();
        if (propertyList.size() == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, String> result = new HashMap<String, String>(propertyList.size());
        for (Property p : propertyList) {
            PropertyMap map = (PropertyMap)p;
            String key = map.getSimpleValue(keyName, null);
            String value = map.getSimpleValue("value", null);
            if (key == null || value == null) continue;
            result.put(key, value);
        }
        return result;
    }
}

