/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7;

import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.pluginapi.configuration.ConfigurationFacet;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.modules.plugins.jbossas7.ASConnection;
import org.rhq.modules.plugins.jbossas7.ConfigurationLoadDelegate;
import org.rhq.modules.plugins.jbossas7.ConfigurationWriteDelegate;
import org.rhq.modules.plugins.jbossas7.json.Address;

public class ConfigurationReadWriteDelegate
implements ConfigurationFacet {
    final Log log = LogFactory.getLog(this.getClass());
    private final Address address;
    private final ASConnection connection;
    private final ConfigurationDefinition configurationDefinition;

    public ConfigurationReadWriteDelegate(ConfigurationDefinition configDef, ASConnection connection, Address address) {
        this.configurationDefinition = configDef;
        this.connection = connection;
        this.address = address;
    }

    public Configuration loadResourceConfiguration() throws Exception {
        ConfigurationLoadDelegate cle = new ConfigurationLoadDelegate(this.configurationDefinition, this.connection, this.address);
        return cle.loadResourceConfiguration();
    }

    public void updateResourceConfiguration(ConfigurationUpdateReport report) {
        try {
            Configuration config = this.loadResourceConfiguration();
            ConfigurationDefinition configDefCopy = ConfigurationReadWriteDelegate.copyConfigurationDefinition(this.configurationDefinition);
            for (Property prop : report.getConfiguration().getAllProperties().values()) {
                if (!(prop instanceof PropertySimple)) continue;
                PropertySimple propSimple = (PropertySimple)prop;
                String val1 = propSimple.getStringValue();
                String val2 = config.getSimpleValue(propSimple.getName());
                if (val1 == null && val2 == null) {
                    configDefCopy.getPropertyDefinitions().remove(propSimple.getName());
                }
                if (val1 != null) {
                    if (!val1.equals(val2)) continue;
                    configDefCopy.getPropertyDefinitions().remove(propSimple.getName());
                    continue;
                }
                if (val2 == null || !val2.equals(val1)) continue;
                configDefCopy.getPropertyDefinitions().remove(propSimple.getName());
            }
            ConfigurationWriteDelegate delegate = new ConfigurationWriteDelegate(configDefCopy, this.connection, this.address);
            delegate.updateResourceConfiguration(report);
        }
        catch (Exception e) {
            this.log.error((Object)"Unable to update configuration", (Throwable)e);
            report.setStatus(ConfigurationUpdateStatus.FAILURE);
            report.setErrorMessage(e.getMessage());
        }
    }

    static ConfigurationDefinition copyConfigurationDefinition(ConfigurationDefinition configurationDefinition) {
        ConfigurationDefinition configDefCopy = new ConfigurationDefinition(configurationDefinition.getName(), configurationDefinition.getDescription());
        configDefCopy.setConfigurationFormat(configurationDefinition.getConfigurationFormat());
        configDefCopy.setPropertyDefinitions(new HashMap(configurationDefinition.getPropertyDefinitions()));
        return configDefCopy;
    }
}

